/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;
import com.badlogic.gdx.utils.Align;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Layout;

public class TextraLabel
extends Widget {
    public Layout layout;
    public Font font;
    public int align = 8;
    public boolean wrap = false;
    public String storedText;
    public Label.LabelStyle style;

    public TextraLabel() {
        this.layout = (Layout)Layout.POOL.obtain();
        this.font = new Font(new BitmapFont(), Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, false);
    }

    public TextraLabel(String text, Skin skin) {
        this(text, (Label.LabelStyle)skin.get(Label.LabelStyle.class));
    }

    public TextraLabel(String text, Skin skin, boolean makeGridGlyphs) {
        this(text, (Label.LabelStyle)skin.get(Label.LabelStyle.class), makeGridGlyphs);
    }

    public TextraLabel(String text, Skin skin, String styleName) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class));
    }

    public TextraLabel(String text, Skin skin, String styleName, boolean makeGridGlyphs) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class), makeGridGlyphs);
    }

    public TextraLabel(String text, Skin skin, String styleName, Color color) {
        this(text, new Font(((Label.LabelStyle)skin.get((String)styleName, Label.LabelStyle.class)).font, Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f), color);
    }

    public TextraLabel(String text, Skin skin, String styleName, String colorName) {
        this(text, new Font(((Label.LabelStyle)skin.get((String)styleName, Label.LabelStyle.class)).font, Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f), (Color)skin.get(colorName, Color.class));
    }

    public TextraLabel(String text, Label.LabelStyle style) {
        this(text, style, false);
    }

    public TextraLabel(String text, Label.LabelStyle style, boolean makeGridGlyphs) {
        this.font = new Font(style.font, Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, makeGridGlyphs);
        this.layout = (Layout)Layout.POOL.obtain();
        if (style.fontColor != null) {
            this.layout.setBaseColor(style.fontColor);
        }
        this.style = style;
        this.storedText = text;
        this.font.markup(text, this.layout);
    }

    public TextraLabel(String text, Label.LabelStyle style, Font replacementFont) {
        this.font = replacementFont;
        this.layout = (Layout)Layout.POOL.obtain();
        if (style.fontColor != null) {
            this.layout.setBaseColor(style.fontColor);
        }
        this.style = style;
        this.storedText = text;
        this.font.markup(text, this.layout);
    }

    public TextraLabel(String text, Font font) {
        this.font = font;
        this.layout = (Layout)Layout.POOL.obtain();
        this.storedText = text;
        font.markup(text, this.layout);
    }

    public TextraLabel(String text, Font font, Color color) {
        this.font = font;
        this.layout = (Layout)Layout.POOL.obtain();
        if (color != null) {
            this.layout.setBaseColor(color);
        }
        this.storedText = text;
        font.markup(text, this.layout);
    }

    public void draw(Batch batch, float parentAlpha) {
        boolean resetShader;
        super.draw(batch, parentAlpha);
        float baseX = 0.0f;
        float baseY = 0.0f;
        float rot = this.getRotation();
        float sn = MathUtils.sinDeg((float)rot);
        float cs = MathUtils.cosDeg((float)rot);
        float height = this.layout.getHeight();
        if (Align.isBottom((int)this.align)) {
            baseX -= sn * height;
            baseY += cs * height;
        } else if (Align.isCenterVertical((int)this.align)) {
            baseX -= sn * height * 0.5f;
            baseY += cs * height * 0.5f;
        }
        float width = this.getWidth();
        height = this.getHeight();
        if (Align.isRight((int)this.align)) {
            baseX += cs * width;
            baseY += sn * width;
        } else if (Align.isCenterHorizontal((int)this.align)) {
            baseX += cs * width * 0.5f;
            baseY += sn * width * 0.5f;
        }
        if (Align.isTop((int)this.align)) {
            baseX -= sn * height;
            baseY += cs * height;
        } else if (Align.isCenterVertical((int)this.align)) {
            baseX -= sn * height * 0.5f;
            baseY += cs * height * 0.5f;
        }
        if (this.style != null && this.style.background != null) {
            Drawable background = this.style.background;
            batch.setColor(this.getColor());
            if (Align.isLeft((int)this.align)) {
                baseX += cs * background.getLeftWidth();
                baseY += sn * background.getLeftWidth();
            } else if (Align.isRight((int)this.align)) {
                baseX -= cs * background.getRightWidth();
                baseY -= sn * background.getRightWidth();
            } else {
                baseX += cs * (background.getLeftWidth() - background.getRightWidth()) * 0.5f;
                baseY += sn * (background.getLeftWidth() - background.getRightWidth()) * 0.5f;
            }
            if (Align.isBottom((int)this.align)) {
                baseX -= sn * background.getBottomHeight();
                baseY += cs * background.getBottomHeight();
            } else if (Align.isTop((int)this.align)) {
                baseX += sn * background.getTopHeight();
                baseY -= cs * background.getTopHeight();
            } else {
                baseX -= sn * (background.getBottomHeight() - background.getTopHeight()) * 0.5f;
                baseY += cs * (background.getBottomHeight() - background.getTopHeight()) * 0.5f;
            }
            ((TransformDrawable)background).draw(batch, this.getX(), this.getY(), this.getOriginX(), this.getOriginY(), this.getWidth(), this.getHeight(), 1.0f, 1.0f, rot);
        }
        batch.setColor(1.0f, 1.0f, 1.0f, parentAlpha);
        if (this.layout.lines.isEmpty()) {
            return;
        }
        boolean bl = resetShader = this.font.distanceField != Font.DistanceFieldType.STANDARD && batch.getShader() != this.font.shader;
        if (resetShader) {
            this.font.enableShader(batch);
        }
        this.font.drawGlyphs(batch, this.layout, this.getX() + (baseX -= 0.5f * this.font.cellWidth), this.getY() + (baseY -= 0.5f * this.font.cellHeight), this.align, rot, this.getOriginX(), this.getOriginY());
        if (resetShader) {
            batch.setShader(null);
        }
    }

    public float getPrefWidth() {
        if (this.wrap) {
            return 0.0f;
        }
        float width = this.layout.getWidth();
        if (this.style != null && this.style.background != null) {
            width = Math.max(width + this.style.background.getLeftWidth() + this.style.background.getRightWidth(), this.style.background.getMinWidth());
        }
        return width;
    }

    public float getPrefHeight() {
        float height = this.layout.getHeight();
        if (this.style != null && this.style.background != null) {
            height = Math.max(height + this.style.background.getBottomHeight() + this.style.background.getTopHeight(), this.style.background.getMinHeight());
        }
        return height;
    }

    public TextraLabel useIntegerPositions(boolean integer) {
        this.font.integerPosition = integer;
        return this;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
        if (this.wrap != this.wrap) {
            this.invalidateHierarchy();
        }
    }

    public void setSize(float width, float height) {
        super.setSize(width, height);
    }

    public void layout() {
        float width = this.getWidth();
        if (this.style != null && this.style.background != null) {
            this.layout.targetWidth = width - (this.style.background.getLeftWidth() + this.style.background.getRightWidth());
        }
        if (this.wrap && this.layout.getTargetWidth() != width) {
            this.layout.setTargetWidth(width);
            this.font.regenerateLayout(this.layout);
            this.invalidateHierarchy();
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int alignment) {
        this.align = alignment;
    }

    public void setText(String markupText) {
        this.storedText = markupText;
        this.layout.setTargetWidth(this.getMaxWidth());
        this.font.markup(markupText, this.layout.clear());
        this.setWidth(this.layout.getWidth() + (this.style != null && this.style.background != null ? this.style.background.getLeftWidth() + this.style.background.getRightWidth() : 0.0f));
    }
}

