/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class ScaleEffect
extends Effect {
    private float sizeX = 1.0f;
    private float sizeY = 1.0f;

    public ScaleEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.sizeX = this.paramAsFloat(params[0], 100.0f) * 0.01f;
            this.sizeY = this.paramAsFloat(params[0], 100.0f) * 0.01f;
        }
        if (params.length > 1) {
            this.sizeY = this.paramAsFloat(params[1], 100.0f) * 0.01f;
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        this.label.sizing.incr(globalIndex << 1, this.sizeX - 1.0f);
        this.label.sizing.incr(globalIndex << 1 | 1, this.sizeY - 1.0f);
    }
}

