/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.LongArray;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Layout;
import com.github.tommyettinger.textra.Line;
import com.github.tommyettinger.textra.Parser;
import com.github.tommyettinger.textra.TextraLabel;
import com.github.tommyettinger.textra.TokenCategory;
import com.github.tommyettinger.textra.TokenEntry;
import com.github.tommyettinger.textra.TypingConfig;
import com.github.tommyettinger.textra.TypingListener;
import java.util.Arrays;
import java.util.Map;

public class TypingLabel
extends TextraLabel {
    private final ObjectMap<String, String> variables;
    protected final Array<TokenEntry> tokenEntries;
    private final Color clearColor;
    private TypingListener listener;
    private final StringBuilder originalText;
    private final StringBuilder intermediateText;
    protected final Layout workingLayout;
    public final FloatArray offsets;
    public final FloatArray sizing;
    public final FloatArray rotations;
    protected final Array<Effect> activeEffects;
    private float textSpeed;
    private float charCooldown;
    private int rawCharIndex;
    private int glyphCharIndex;
    private int glyphCharCompensation;
    private int cachedGlyphCharIndex;
    private boolean parsed;
    private boolean paused;
    private boolean ended;
    private boolean skipping;
    private boolean ignoringEvents;
    private boolean ignoringEffects;
    private String defaultToken;

    public TypingLabel() {
        this.variables = new ObjectMap();
        this.tokenEntries = new Array();
        this.clearColor = new Color(TypingConfig.DEFAULT_CLEAR_COLOR);
        this.listener = null;
        this.originalText = new StringBuilder();
        this.intermediateText = new StringBuilder();
        this.workingLayout = (Layout)Layout.POOL.obtain();
        this.offsets = new FloatArray();
        this.sizing = new FloatArray();
        this.rotations = new FloatArray();
        this.activeEffects = new Array();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.defaultToken = "";
        this.workingLayout.font(this.font);
        this.saveOriginalText("");
    }

    public TypingLabel(String text, Skin skin) {
        this(text, (Label.LabelStyle)skin.get(Label.LabelStyle.class));
    }

    public TypingLabel(String text, Skin skin, Font replacementFont) {
        this(text, (Label.LabelStyle)skin.get(Label.LabelStyle.class), replacementFont);
    }

    public TypingLabel(String text, Skin skin, String styleName) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class));
    }

    public TypingLabel(String text, Skin skin, String styleName, Font replacementFont) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class), replacementFont);
    }

    public TypingLabel(String text, Label.LabelStyle style) {
        text = Parser.preprocess(text);
        super(text, style);
        this.variables = new ObjectMap();
        this.tokenEntries = new Array();
        this.clearColor = new Color(TypingConfig.DEFAULT_CLEAR_COLOR);
        this.listener = null;
        this.originalText = new StringBuilder();
        this.intermediateText = new StringBuilder();
        this.workingLayout = (Layout)Layout.POOL.obtain();
        this.offsets = new FloatArray();
        this.sizing = new FloatArray();
        this.rotations = new FloatArray();
        this.activeEffects = new Array();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.defaultToken = "";
        this.workingLayout.font(this.font);
        this.workingLayout.setBaseColor(this.layout.baseColor);
        this.saveOriginalText(text);
    }

    public TypingLabel(String text, Label.LabelStyle style, Font replacementFont) {
        text = Parser.preprocess(text);
        super(text, style, replacementFont);
        this.variables = new ObjectMap();
        this.tokenEntries = new Array();
        this.clearColor = new Color(TypingConfig.DEFAULT_CLEAR_COLOR);
        this.listener = null;
        this.originalText = new StringBuilder();
        this.intermediateText = new StringBuilder();
        this.workingLayout = (Layout)Layout.POOL.obtain();
        this.offsets = new FloatArray();
        this.sizing = new FloatArray();
        this.rotations = new FloatArray();
        this.activeEffects = new Array();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.defaultToken = "";
        this.workingLayout.font(this.font);
        this.workingLayout.setBaseColor(this.layout.baseColor);
        this.saveOriginalText(text);
    }

    public TypingLabel(String text, Font font) {
        text = Parser.preprocess(text);
        super(text, font);
        this.variables = new ObjectMap();
        this.tokenEntries = new Array();
        this.clearColor = new Color(TypingConfig.DEFAULT_CLEAR_COLOR);
        this.listener = null;
        this.originalText = new StringBuilder();
        this.intermediateText = new StringBuilder();
        this.workingLayout = (Layout)Layout.POOL.obtain();
        this.offsets = new FloatArray();
        this.sizing = new FloatArray();
        this.rotations = new FloatArray();
        this.activeEffects = new Array();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.defaultToken = "";
        this.workingLayout.font(font);
        this.saveOriginalText(text);
    }

    public TypingLabel(String text, Font font, Color color) {
        text = Parser.preprocess(text);
        super(text, font, color);
        this.variables = new ObjectMap();
        this.tokenEntries = new Array();
        this.clearColor = new Color(TypingConfig.DEFAULT_CLEAR_COLOR);
        this.listener = null;
        this.originalText = new StringBuilder();
        this.intermediateText = new StringBuilder();
        this.workingLayout = (Layout)Layout.POOL.obtain();
        this.offsets = new FloatArray();
        this.sizing = new FloatArray();
        this.rotations = new FloatArray();
        this.activeEffects = new Array();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.defaultToken = "";
        this.workingLayout.font(font);
        this.workingLayout.setBaseColor(this.layout.baseColor);
        this.saveOriginalText(text);
    }

    @Override
    public void setText(String newText) {
        this.setText(newText, true);
    }

    protected void setText(String newText, boolean modifyOriginalText) {
        if (modifyOriginalText) {
            newText = Parser.preprocess(newText);
        }
        this.setText(newText, modifyOriginalText, true);
    }

    protected void setText(String newText, boolean modifyOriginalText, boolean restart) {
        boolean hasEnded = this.hasEnded();
        this.font.markup(newText, this.layout.clear());
        float actualWidth = this.layout.getWidth();
        this.workingLayout.setTargetWidth(actualWidth);
        this.font.markup(newText, this.workingLayout.clear());
        this.setWidth(actualWidth + (this.style != null && this.style.background != null ? this.style.background.getLeftWidth() + this.style.background.getRightWidth() : 0.0f));
        if (modifyOriginalText) {
            this.saveOriginalText(newText);
        }
        if (restart) {
            this.restart();
        }
        if (hasEnded) {
            this.skipToTheEnd(true, false);
        }
    }

    public StringBuilder getOriginalText() {
        return this.originalText;
    }

    protected void saveOriginalText(CharSequence text) {
        if (text != this.originalText) {
            this.originalText.setLength(0);
            this.originalText.append(text);
        }
        this.originalText.trimToSize();
    }

    protected void restoreOriginalText() {
        super.setText(this.originalText.toString());
        this.parsed = false;
    }

    public TypingListener getTypingListener() {
        return this.listener;
    }

    public void setTypingListener(TypingListener listener) {
        this.listener = listener;
    }

    public Color getClearColor() {
        return this.clearColor;
    }

    public String getDefaultToken() {
        return this.defaultToken;
    }

    public void setDefaultToken(String defaultToken) {
        this.defaultToken = defaultToken == null ? "" : defaultToken;
        this.parsed = false;
    }

    public void parseTokens() {
        this.setText(Parser.preprocess("{NORMAL}" + this.getDefaultToken() + this.originalText), false, false);
        Parser.parseTokens(this);
        this.parsed = true;
    }

    public void skipToTheEnd() {
        this.skipToTheEnd(true);
    }

    public void skipToTheEnd(boolean ignoreEvents) {
        this.skipToTheEnd(ignoreEvents, false);
    }

    public void skipToTheEnd(boolean ignoreEvents, boolean ignoreEffects) {
        this.skipping = true;
        this.ignoringEvents = ignoreEvents;
        this.ignoringEffects = ignoreEffects;
    }

    public void cancelSkipping() {
        if (this.skipping) {
            this.skipping = false;
            this.ignoringEvents = false;
            this.ignoringEffects = false;
        }
    }

    public boolean isSkipping() {
        return this.skipping;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public boolean hasEnded() {
        return this.ended;
    }

    public void restart() {
        this.restart(this.getOriginalText().toString());
    }

    public void restart(String newText) {
        this.workingLayout.baseColor = Color.WHITE_FLOAT_BITS;
        this.workingLayout.maxLines = Integer.MAX_VALUE;
        this.workingLayout.atLimit = false;
        this.workingLayout.ellipsis = null;
        Line.POOL.freeAll(this.workingLayout.lines);
        this.workingLayout.lines.clear();
        this.workingLayout.lines.add(Line.POOL.obtain());
        this.offsets.clear();
        this.sizing.clear();
        this.rotations.clear();
        this.activeEffects.clear();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.invalidate();
        this.saveOriginalText(newText);
        this.tokenEntries.clear();
        this.parseTokens();
    }

    public ObjectMap<String, String> getVariables() {
        return this.variables;
    }

    public void setVariable(String var, String value) {
        this.variables.put((Object)var.toUpperCase(), (Object)value);
    }

    public void setVariables(ObjectMap<String, String> variableMap) {
        this.variables.clear();
        for (ObjectMap.Entry entry : variableMap.entries()) {
            this.variables.put((Object)((String)entry.key).toUpperCase(), entry.value);
        }
    }

    public void setVariables(Map<String, String> variableMap) {
        this.variables.clear();
        for (Map.Entry<String, String> entry : variableMap.entrySet()) {
            this.variables.put((Object)entry.getKey().toUpperCase(), (Object)entry.getValue());
        }
    }

    public void clearVariables() {
        this.variables.clear();
    }

    public void act(float delta) {
        block8: {
            block9: {
                float f;
                super.act(delta);
                if (!this.parsed) {
                    this.parseTokens();
                }
                if (!this.skipping && (this.ended || this.paused)) break block8;
                if (this.skipping) break block9;
                this.charCooldown -= delta;
                if (!(f < 0.0f)) break block8;
            }
            this.processCharProgression();
        }
        this.font.calculateSize(this.workingLayout);
        int glyphCount = this.getLayoutSize(this.layout);
        this.offsets.setSize(glyphCount + glyphCount);
        Arrays.fill(this.offsets.items, 0, glyphCount + glyphCount, 0.0f);
        this.sizing.setSize(glyphCount + glyphCount);
        Arrays.fill(this.sizing.items, 0, glyphCount + glyphCount, 1.0f);
        this.rotations.setSize(glyphCount);
        Arrays.fill(this.rotations.items, 0, glyphCount, 0.0f);
        if (!this.ignoringEffects) {
            int workingLayoutSize = this.getLayoutSize(this.workingLayout);
            for (int i = this.activeEffects.size - 1; i >= 0; --i) {
                long glyph;
                int end;
                Effect effect = (Effect)this.activeEffects.get(i);
                effect.update(delta);
                int start = effect.indexStart;
                int n = end = effect.indexEnd >= 0 ? effect.indexEnd : this.glyphCharIndex;
                if (effect.isFinished()) {
                    this.activeEffects.removeIndex(i);
                    continue;
                }
                for (int j = Math.max(0, start); j <= this.glyphCharIndex && j <= end && j < workingLayoutSize && (glyph = this.getInLayout(this.workingLayout, j)) != 0xFFFFFFL; ++j) {
                    effect.apply(glyph, j, delta);
                }
            }
        }
    }

    private void processCharProgression() {
        int charCounter = 0;
        block6: while (this.skipping || this.charCooldown < 0.0f) {
            if (this.glyphCharCompensation != 0) {
                if (this.glyphCharCompensation > 0) {
                    ++this.glyphCharIndex;
                    --this.glyphCharCompensation;
                } else {
                    --this.glyphCharIndex;
                    ++this.glyphCharCompensation;
                }
                this.charCooldown += this.textSpeed;
                continue;
            }
            ++this.rawCharIndex;
            int layoutSize = this.getLayoutSize(this.layout);
            if (layoutSize == 0 || this.glyphCharIndex >= layoutSize) {
                if (this.ended) break;
                this.ended = true;
                this.skipping = false;
                if (this.listener == null) break;
                this.listener.end();
                break;
            }
            if (this.tokenEntries.size > 0 && ((TokenEntry)this.tokenEntries.peek()).index == this.rawCharIndex) {
                TokenEntry entry = (TokenEntry)this.tokenEntries.pop();
                String token = entry.token;
                TokenCategory category = entry.category;
                this.rawCharIndex = entry.endIndex - 1;
                switch (category) {
                    case SPEED: {
                        this.textSpeed = entry.floatValue;
                        continue block6;
                    }
                    case WAIT: {
                        this.charCooldown += entry.floatValue;
                        continue block6;
                    }
                    case EVENT: {
                        if (this.listener == null || this.ignoringEvents) continue block6;
                        this.listener.event(entry.stringValue);
                        continue block6;
                    }
                    case EFFECT_START: 
                    case EFFECT_END: {
                        boolean isStart = category == TokenCategory.EFFECT_START;
                        Class effectClass = isStart ? (Class)TypingConfig.EFFECT_START_TOKENS.get((Object)token) : (Class)TypingConfig.EFFECT_END_TOKENS.get((Object)token);
                        for (int i = 0; i < this.activeEffects.size; ++i) {
                            Effect effect = (Effect)this.activeEffects.get(i);
                            if (effect.indexEnd >= 0 || !ClassReflection.isAssignableFrom((Class)effectClass, effect.getClass())) continue;
                            effect.indexEnd = this.glyphCharIndex;
                        }
                        if (!isStart) continue block6;
                        entry.effect.indexStart = this.glyphCharIndex + 1;
                        this.activeEffects.add((Object)entry.effect);
                        continue block6;
                    }
                }
                break;
            }
            int safeIndex = MathUtils.clamp((int)(this.glyphCharIndex + 1), (int)0, (int)(layoutSize - 1));
            if (layoutSize > 0) {
                long baseChar = this.getInLayout(this.layout, safeIndex);
                float intervalMultiplier = TypingConfig.INTERVAL_MULTIPLIERS_BY_CHAR.get((Object)Character.valueOf((char)baseChar), 1.0f);
                this.charCooldown += this.textSpeed * intervalMultiplier;
            }
            ++charCounter;
            if (this.rawCharIndex > 0) {
                ++this.glyphCharIndex;
            }
            if (this.glyphCharIndex >= 0 && this.glyphCharIndex < layoutSize && this.rawCharIndex >= 0 && this.listener != null) {
                this.listener.onChar(this.getInLayout(this.layout, this.glyphCharIndex));
            }
            if (this.glyphCharIndex == 0) {
                this.charCooldown = this.textSpeed;
                break;
            }
            int charLimit = TypingConfig.CHAR_LIMIT_PER_FRAME;
            if (this.skipping || charLimit <= 0 || ++charCounter <= charLimit) continue;
            this.charCooldown = Math.max(this.charCooldown, this.textSpeed);
            break;
        }
        if (this.wrap) {
            this.setText(this.intermediateText.toString(), false, false);
        } else {
            this.font.calculateSize(this.workingLayout);
        }
        this.invalidateHierarchy();
    }

    private int getLayoutSize(Layout layout) {
        int layoutSize = 0;
        int n = layout.lines();
        for (int i = 0; i < n; ++i) {
            layoutSize += layout.getLine((int)i).glyphs.size;
        }
        return layoutSize;
    }

    public boolean remove() {
        Layout.POOL.free((Object)this.workingLayout);
        Layout.POOL.free((Object)this.layout);
        return super.remove();
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        if (this.wrap) {
            this.workingLayout.setTargetWidth(width);
        }
    }

    @Override
    public void layout() {
        super.layout();
        if (this.wrap && this.workingLayout.getTargetWidth() != this.getWidth()) {
            this.font.regenerateLayout(this.workingLayout);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        boolean resetShader;
        super.validate();
        float rot = this.getRotation();
        float originX = this.getOriginX();
        float originY = this.getOriginY();
        float sn = MathUtils.sinDeg((float)rot);
        float cs = MathUtils.cosDeg((float)rot);
        batch.getColor().set((Color)this.getColor()).a *= parentAlpha;
        batch.setColor(batch.getColor());
        int lines = this.workingLayout.lines();
        float baseX = this.getX();
        float baseY = this.getY();
        float height = this.workingLayout.getHeight();
        if (Align.isBottom((int)this.align)) {
            baseX -= sn * height;
            baseY += cs * height;
        } else if (Align.isCenterVertical((int)this.align)) {
            baseX -= sn * height * 0.5f;
            baseY += cs * height * 0.5f;
        }
        float width = this.getWidth();
        height = this.getHeight();
        if (Align.isRight((int)this.align)) {
            baseX += cs * width;
            baseY += sn * width;
        } else if (Align.isCenterHorizontal((int)this.align)) {
            baseX += cs * width * 0.5f;
            baseY += sn * width * 0.5f;
        }
        if (Align.isTop((int)this.align)) {
            baseX -= sn * height;
            baseY += cs * height;
        } else if (Align.isCenterVertical((int)this.align)) {
            baseX -= sn * height * 0.5f;
            baseY += cs * height * 0.5f;
        }
        if (this.style != null && this.style.background != null) {
            Drawable background = this.style.background;
            if (Align.isLeft((int)this.align)) {
                baseX += cs * background.getLeftWidth();
                baseY += sn * background.getLeftWidth();
            } else if (Align.isRight((int)this.align)) {
                baseX -= cs * background.getRightWidth();
                baseY -= sn * background.getRightWidth();
            } else {
                baseX += cs * (background.getLeftWidth() - background.getRightWidth()) * 0.5f;
                baseY += sn * (background.getLeftWidth() - background.getRightWidth()) * 0.5f;
            }
            if (Align.isBottom((int)this.align)) {
                baseX -= sn * background.getBottomHeight();
                baseY += cs * background.getBottomHeight();
            } else if (Align.isTop((int)this.align)) {
                baseX += sn * background.getTopHeight();
                baseY -= cs * background.getTopHeight();
            } else {
                baseX -= sn * (background.getBottomHeight() - background.getTopHeight()) * 0.5f;
                baseY += cs * (background.getBottomHeight() - background.getTopHeight()) * 0.5f;
            }
            ((TransformDrawable)background).draw(batch, this.getX(), this.getY(), originX, originY, this.getWidth(), this.getHeight(), 1.0f, 1.0f, rot);
        }
        if (this.layout.lines.isEmpty()) {
            return;
        }
        int o = 0;
        int s = 0;
        int r = 0;
        int gi = 0;
        boolean bl = resetShader = this.font.distanceField != Font.DistanceFieldType.STANDARD && batch.getShader() != this.font.shader;
        if (resetShader) {
            this.font.enableShader(batch);
        }
        baseX -= 0.5f * this.font.cellWidth;
        baseY -= 0.5f * this.font.cellHeight;
        baseX += cs * 0.5f * this.font.cellWidth;
        baseY += sn * 0.5f * this.font.cellWidth;
        baseX -= sn * 0.5f * this.font.cellHeight;
        baseY += cs * 0.5f * this.font.cellHeight;
        block0: for (int ln = 0; ln < lines; ++ln) {
            Line glyphs = this.workingLayout.getLine(ln);
            baseX += sn * glyphs.height;
            baseY -= cs * glyphs.height;
            if (glyphs.glyphs.size == 0) continue;
            float x = baseX;
            float y = baseY;
            float worldOriginX = x + originX;
            float worldOriginY = y + originY;
            float fx = -originX;
            float fy = -originY;
            x = cs * fx - sn * fy + worldOriginX;
            y = sn * fx + cs * fy + worldOriginY;
            float xChange = 0.0f;
            float yChange = 0.0f;
            if (Align.isCenterHorizontal((int)this.align)) {
                x -= cs * (glyphs.width * 0.5f);
                y -= sn * (glyphs.width * 0.5f);
            } else if (Align.isRight((int)this.align)) {
                x -= cs * glyphs.width;
                y -= sn * glyphs.width;
            }
            Font f = null;
            int kern = -1;
            int i = 0;
            int n = glyphs.glyphs.size;
            int end = this.glyphCharIndex;
            int lim = Math.min(Math.min(this.rotations.size, this.offsets.size >> 1), this.sizing.size >> 1);
            while (i < n && r < lim) {
                Font.GlyphRegion reg;
                if (gi > end) break block0;
                long glyph = glyphs.glyphs.get(i);
                if (this.font.family != null) {
                    f = this.font.family.connected[(int)(glyph >>> 16 & 0xFL)];
                }
                if (f == null) {
                    f = this.font;
                }
                if (f.kerning != null) {
                    glyph = glyphs.glyphs.get(i);
                    kern = kern << 16 | (int)(glyph & 0xFFFFL);
                    float amt = (float)f.kerning.get(kern, 0) * f.scaleX * (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
                    xChange += cs * amt;
                    yChange += sn * amt;
                } else {
                    kern = -1;
                }
                if (i == 0 && (reg = (Font.GlyphRegion)((Object)this.font.mapping.get((int)((char)glyph)))) != null && reg.offsetX < 0.0f) {
                    float ox = reg.offsetX * f.scaleX * (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
                    xChange -= cs * ox;
                    yChange -= sn * ox;
                }
                float single = f.drawGlyph(batch, glyph, x + xChange + this.offsets.get(o++), y + yChange + this.offsets.get(o++), this.rotations.get(r++) + rot, this.sizing.get(s++), this.sizing.get(s++));
                xChange += cs * single;
                yChange += sn * single;
                ++i;
                ++gi;
            }
        }
        this.invalidateHierarchy();
        if (resetShader) {
            batch.setShader(null);
        }
    }

    public String toString() {
        return this.workingLayout.toString();
    }

    public void setIntermediateText(CharSequence text, boolean modifyOriginalText, boolean restart) {
        boolean hasEnded = this.hasEnded();
        if (text != this.intermediateText) {
            this.intermediateText.setLength(0);
            this.intermediateText.append(text);
        }
        this.intermediateText.trimToSize();
        if (modifyOriginalText) {
            this.saveOriginalText(text);
        }
        if (restart) {
            this.restart();
        }
        if (hasEnded) {
            this.skipToTheEnd(true, false);
        }
    }

    public StringBuilder getIntermediateText() {
        return this.intermediateText;
    }

    public long getInLayout(Layout layout, int index) {
        LongArray glyphs;
        int n = layout.lines();
        for (int i = 0; i < n && index >= 0; index -= glyphs.size, ++i) {
            glyphs = layout.getLine((int)i).glyphs;
            if (index >= glyphs.size) continue;
            return glyphs.get(index);
        }
        return 0xFFFFFFL;
    }

    public Line getLineInLayout(Layout layout, int index) {
        LongArray glyphs;
        int n = layout.lines();
        for (int i = 0; i < n && index >= 0; index -= glyphs.size, ++i) {
            glyphs = layout.getLine((int)i).glyphs;
            if (index >= glyphs.size) continue;
            return layout.getLine(i);
        }
        return null;
    }

    public float getLineHeight(int index) {
        LongArray glyphs;
        int n = this.workingLayout.lines();
        for (int i = 0; i < n && index >= 0; index -= glyphs.size, ++i) {
            glyphs = this.workingLayout.getLine((int)i).glyphs;
            if (index >= glyphs.size) continue;
            return this.workingLayout.getLine((int)i).height;
        }
        return this.font.cellHeight;
    }

    public long getFromIntermediate(int index) {
        if (index >= 0 && this.intermediateText.length() > index) {
            return this.intermediateText.charAt(index);
        }
        return 0xFFFFFFL;
    }

    public void setInLayout(Layout layout, int index, long newGlyph) {
        LongArray glyphs;
        int n = layout.lines();
        for (int i = 0; i < n && index >= 0; index -= glyphs.size, ++i) {
            glyphs = layout.getLine((int)i).glyphs;
            if (index >= glyphs.size) continue;
            glyphs.set(index, newGlyph);
            return;
        }
    }

    public void setInWorkingLayout(int index, long newGlyph) {
        LongArray glyphs;
        int n = this.layout.lines();
        for (int i = 0; i < n && index >= 0; index -= glyphs.size, ++i) {
            glyphs = this.workingLayout.getLine((int)i).glyphs;
            if (i >= this.workingLayout.lines() || index >= glyphs.size) continue;
            glyphs.set(index, newGlyph);
            return;
        }
    }
}

