/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;

public class ColorUtils {
    public static int hsl2rgb(float h, float s, float l, float a) {
        float x = Math.min(Math.max(Math.abs(h * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        float y = h + 0.6666667f;
        float z = h + 0.33333334f;
        y -= (float)((int)y);
        z -= (float)((int)z);
        y = Math.min(Math.max(Math.abs(y * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        z = Math.min(Math.max(Math.abs(z * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        float v = l + s * Math.min(l, 1.0f - l);
        float d = 2.0f * (1.0f - l / (v + 1.0E-10f));
        return Color.rgba8888((float)(v * MathUtils.lerp((float)1.0f, (float)x, (float)d)), (float)(v * MathUtils.lerp((float)1.0f, (float)y, (float)d)), (float)(v * MathUtils.lerp((float)1.0f, (float)z, (float)d)), (float)a);
    }

    public static int rgb2hsl(float r, float g, float b, float a) {
        float w;
        float z;
        float y;
        float x;
        if (g < b) {
            x = b;
            y = g;
            z = -1.0f;
            w = 0.6666667f;
        } else {
            x = g;
            y = b;
            z = 0.0f;
            w = -0.33333334f;
        }
        if (r < x) {
            z = w;
            w = r;
        } else {
            w = x;
            x = r;
        }
        float d = x - Math.min(w, y);
        float l = x * (1.0f - 0.5f * d / (x + 1.0E-10f));
        return Color.rgba8888((float)Math.abs(z + (w - y) / (6.0f * d + 1.0E-10f)), (float)((x - l) / (Math.min(l, 1.0f - l) + 1.0E-10f)), (float)l, (float)a);
    }

    public static int hsb2rgb(float h, float s, float b, float a) {
        float x = Math.min(Math.max(Math.abs(h * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        float y = h + 0.6666667f;
        float z = h + 0.33333334f;
        y -= (float)((int)y);
        z -= (float)((int)z);
        y = Math.min(Math.max(Math.abs(y * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        z = Math.min(Math.max(Math.abs(z * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        return Color.rgba8888((float)(b * MathUtils.lerp((float)1.0f, (float)x, (float)s)), (float)(b * MathUtils.lerp((float)1.0f, (float)y, (float)s)), (float)(b * MathUtils.lerp((float)1.0f, (float)z, (float)s)), (float)a);
    }

    public static int rgb2hsb(float r, float g, float b, float a) {
        float n;
        float v = Math.max(Math.max(r, g), b);
        float c = v - (n = Math.min(Math.min(r, g), b));
        float h = c == 0.0f ? 0.0f : (v == r ? (g - b) / c / 6.0f : (v == g ? ((b - r) / c + 2.0f) / 6.0f : ((r - g) / c + 4.0f) / 6.0f));
        return Color.rgba8888((float)h, (float)(v == 0.0f ? 0.0f : c / v), (float)v, (float)a);
    }

    public static float channel(int color, int channel) {
        return (float)(color >>> 24 - ((channel & 3) << 3) & 0xFF) / 255.0f;
    }

    public static float channelInt(int color, int channel) {
        return color >>> 24 - ((channel & 3) << 3) & 0xFF;
    }

    public static int lerpColors(int s, int e, float change) {
        int sR = s & 0xFF;
        int sG = s >>> 8 & 0xFF;
        int sB = s >>> 16 & 0xFF;
        int sA = s >>> 24 & 0xFF;
        int eR = e & 0xFF;
        int eG = e >>> 8 & 0xFF;
        int eB = e >>> 16 & 0xFF;
        int eA = e >>> 24 & 0xFF;
        return (int)((float)sR + change * (float)(eR - sR)) & 0xFF | ((int)((float)sG + change * (float)(eG - sG)) & 0xFF) << 8 | ((int)((float)sB + change * (float)(eB - sB)) & 0xFF) << 16 | ((int)((float)sA + change * (float)(eA - sA)) & 0xFF) << 24;
    }

    public static int multiplyAlpha(int color, float multiplier) {
        return color & 0xFFFFFF00 | Math.min(Math.max((int)((float)(color & 0xFF) * multiplier), 0), 255);
    }

    public static int[][] multiplyAllAlpha(int[][] colors, float multiplier) {
        for (int x = 0; x < colors.length; ++x) {
            for (int y = 0; y < colors[x].length; ++y) {
                colors[x][y] = ColorUtils.multiplyAlpha(colors[x][y], multiplier);
            }
        }
        return colors;
    }
}

