/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.DistanceFieldFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.CharArray;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.IntIntMap;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.LongArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedMap;
import com.github.tommyettinger.textra.ColorLookup;
import com.github.tommyettinger.textra.Layout;
import com.github.tommyettinger.textra.Line;
import com.github.tommyettinger.textra.utils.BlockUtils;
import com.github.tommyettinger.textra.utils.CaseInsensitiveIntMap;
import java.util.Arrays;
import regexodus.Category;

public class Font
implements Disposable {
    public IntMap<GlyphRegion> mapping;
    public CaseInsensitiveIntMap nameLookup;
    public GlyphRegion defaultValue;
    public Array<TextureRegion> parents;
    public DistanceFieldType distanceField;
    public boolean isMono;
    public IntIntMap kerning;
    public float actualCrispness = 1.0f;
    public float distanceFieldCrispness = 1.0f;
    public float cellWidth = 1.0f;
    public float cellHeight = 1.0f;
    public float originalCellWidth = 1.0f;
    public float originalCellHeight = 1.0f;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float descent = 0.0f;
    public char solidBlock = '\u0000';
    public FontFamily family;
    public ColorLookup colorLookup = ColorLookup.DESCRIPTIVE;
    public boolean integerPosition = false;
    public String name = "Unnamed Font";
    public static final long BOLD = 0x40000000L;
    public static final long OBLIQUE = 0x20000000L;
    public static final long UNDERLINE = 0x10000000L;
    public static final long STRIKETHROUGH = 0x8000000L;
    public static final long SUBSCRIPT = 0x2000000L;
    public static final long MIDSCRIPT = 0x4000000L;
    public static final long SUPERSCRIPT = 0x6000000L;
    private final float[] vertices = new float[20];
    private final Layout tempLayout = (Layout)Layout.POOL.obtain();
    private final LongArray glyphBuffer = new LongArray(128);
    private final CharArray breakChars = CharArray.with((char[])new char[]{'\t', '\r', ' ', '-', '\u00ad', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u200b', '\u2010', '\u2012', '\u2013', '\u2014', '\u2027'});
    private final CharArray spaceChars = CharArray.with((char[])new char[]{'\t', '\r', ' ', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u200b'});
    public static final String vertexShader = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tv_color = a_color;\n\tv_color.a = v_color.a * (255.0/254.0);\n\tv_texCoords = a_texCoord0;\n\tgl_Position =  u_projTrans * a_position;\n}\n";
    public static final String msdfFragmentShader = "#ifdef GL_ES\n\tprecision mediump float;\n\tprecision mediump int;\n#endif\n\nuniform sampler2D u_texture;\nuniform float u_smoothing;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n  vec3 sdf = texture2D(u_texture, v_texCoords).rgb;\n  gl_FragColor = vec4(v_color.rgb, clamp((max(min(sdf.r, sdf.g), min(max(sdf.r, sdf.g), sdf.b)) - 0.5) * u_smoothing + 0.5, 0.0, 1.0) * v_color.a);\n}\n";
    public ShaderProgram shader = null;
    private static final int[] hexCodes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    public static long longFromHex(CharSequence cs, int start, int end) {
        int h;
        int len;
        int lim = 16;
        if (cs == null || start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0L;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            len = -1;
            h = 0;
            lim = 17;
        } else if (c == '+') {
            len = 1;
            h = 0;
            lim = 17;
        } else {
            if (c > 'f' || (h = hexCodes[c]) < 0) {
                return 0L;
            }
            len = 1;
        }
        long data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (c > 'f' || (h = hexCodes[c]) < 0) {
                return data * (long)len;
            }
            data <<= 4;
            data |= (long)h;
        }
        return data * (long)len;
    }

    public static int intFromHex(CharSequence cs, int start, int end) {
        int h;
        int len;
        int lim = 8;
        if (cs == null || start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            len = -1;
            h = 0;
            lim = 9;
        } else if (c == '+') {
            len = 1;
            h = 0;
            lim = 9;
        } else {
            if (c > 'f' || (h = hexCodes[c]) < 0) {
                return 0;
            }
            len = 1;
        }
        int data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (c > 'f' || (h = hexCodes[c]) < 0) {
                return data * len;
            }
            data <<= 4;
            data |= h;
        }
        return data * len;
    }

    public static int intFromDec(CharSequence cs, int start, int end) {
        int h;
        int len;
        int lim = 10;
        if (cs == null || start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            len = -1;
            lim = 11;
            h = 0;
        } else if (c == '+') {
            len = 1;
            lim = 11;
            h = 0;
        } else {
            if (c > 'f' || (h = hexCodes[c]) < 0 || h > 9) {
                return 0;
            }
            len = 1;
        }
        int data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (c > 'f' || (h = hexCodes[c]) < 0 || h > 9) {
                return data * len;
            }
            data = data * 10 + h;
        }
        return data * len;
    }

    private static int indexAfter(String text, String search, int from) {
        return (from = text.indexOf(search, from)) < 0 ? text.length() : from + search.length();
    }

    public static String safeSubstring(String source, int beginIndex, int endIndex) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0 || endIndex > source.length()) {
            endIndex = source.length();
        }
        if (beginIndex >= endIndex) {
            return "";
        }
        return source.substring(beginIndex, endIndex);
    }

    public static boolean isLowerCase(char c) {
        return Category.Ll.contains(c);
    }

    public static boolean isUpperCase(char c) {
        return Category.Lu.contains(c);
    }

    public ColorLookup getColorLookup() {
        return this.colorLookup;
    }

    public Font setColorLookup(ColorLookup lookup) {
        if (lookup != null) {
            this.colorLookup = lookup;
        }
        return this;
    }

    public Font(String fntName) {
        this(fntName, DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, DistanceFieldType distanceField) {
        this(fntName, distanceField, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, String textureName) {
        this(fntName, textureName, DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, String textureName, DistanceFieldType distanceField) {
        this(fntName, textureName, distanceField, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(Font toCopy) {
        this.distanceField = toCopy.distanceField;
        this.isMono = toCopy.isMono;
        this.actualCrispness = toCopy.actualCrispness;
        this.distanceFieldCrispness = toCopy.distanceFieldCrispness;
        this.parents = new Array(toCopy.parents);
        this.cellWidth = toCopy.cellWidth;
        this.cellHeight = toCopy.cellHeight;
        this.scaleX = toCopy.scaleX;
        this.scaleY = toCopy.scaleY;
        this.originalCellWidth = toCopy.originalCellWidth;
        this.originalCellHeight = toCopy.originalCellHeight;
        this.descent = toCopy.descent;
        this.mapping = new IntMap(toCopy.mapping.size);
        for (IntMap.Entry e : toCopy.mapping) {
            if (e.value == null) continue;
            this.mapping.put(e.key, (Object)new GlyphRegion((GlyphRegion)((Object)e.value)));
        }
        if (toCopy.nameLookup != null) {
            this.nameLookup = new CaseInsensitiveIntMap(toCopy.nameLookup);
        }
        this.defaultValue = toCopy.defaultValue;
        this.kerning = toCopy.kerning == null ? null : new IntIntMap(toCopy.kerning);
        this.solidBlock = toCopy.solidBlock;
        this.name = toCopy.name;
        this.integerPosition = toCopy.integerPosition;
        if (toCopy.family != null) {
            this.family = new FontFamily(toCopy.family);
        }
        if (toCopy.shader != null) {
            this.shader = toCopy.shader;
        }
        if (toCopy.colorLookup != null) {
            this.colorLookup = toCopy.colorLookup;
        }
    }

    public Font(String fntName, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = DistanceFieldFont.createDistanceFieldShader();
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(String fntName, String textureName, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureName, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, String textureName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureName, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, String textureName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        FileHandle textureHandle;
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = DistanceFieldFont.createDistanceFieldShader();
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        if ((textureHandle = Gdx.files.internal(textureName)).exists() || (textureHandle = Gdx.files.local(textureName)).exists()) {
            this.parents = Array.with((Object[])new TextureRegion[]{new TextureRegion(new Texture(textureHandle))});
            if (distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) {
                ((TextureRegion)this.parents.first()).getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        } else {
            throw new RuntimeException("Missing texture file: " + textureName);
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(String fntName, TextureRegion textureRegion, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegion, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, TextureRegion textureRegion, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegion, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, TextureRegion textureRegion, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = DistanceFieldFont.createDistanceFieldShader();
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.parents = Array.with((Object[])new TextureRegion[]{textureRegion});
        if (distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) {
            textureRegion.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(String fntName, Array<TextureRegion> textureRegions, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegions, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, Array<TextureRegion> textureRegions, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegions, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, Array<TextureRegion> textureRegions, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = DistanceFieldFont.createDistanceFieldShader();
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.parents = textureRegions;
        if ((distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) && textureRegions != null) {
            for (TextureRegion parent : textureRegions) {
                parent.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(BitmapFont bmFont) {
        this(bmFont, DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, false);
    }

    public Font(BitmapFont bmFont, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(bmFont, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(BitmapFont bmFont, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(bmFont, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(BitmapFont bmFont, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        GlyphRegion block;
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = DistanceFieldFont.createDistanceFieldShader();
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.parents = bmFont.getRegions();
        if ((distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) && this.parents != null) {
            for (TextureRegion parent : this.parents) {
                parent.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        }
        BitmapFont.BitmapFontData data = bmFont.getData();
        this.mapping = new IntMap(128);
        int minWidth = Integer.MAX_VALUE;
        yAdjust += bmFont.getDescent();
        for (BitmapFont.Glyph[] page : data.glyphs) {
            if (page == null) continue;
            for (BitmapFont.Glyph glyph : page) {
                byte k;
                int i;
                byte[] kern;
                int b;
                if (glyph == null) continue;
                int x = glyph.srcX;
                int y = glyph.srcY;
                int w = glyph.width;
                int h = glyph.height;
                int a = glyph.xadvance;
                a = (int)((float)a + widthAdjust);
                h = (int)((float)h + heightAdjust);
                minWidth = Math.min(minWidth, a);
                this.cellWidth = Math.max((float)a, this.cellWidth);
                this.cellHeight = Math.max((float)h, this.cellHeight);
                GlyphRegion gr = new GlyphRegion(bmFont.getRegion(glyph.page), x, y, w, h);
                if (glyph.id == 10) {
                    a = 0;
                    gr.offsetX = 0.0f;
                } else {
                    gr.offsetX = makeGridGlyphs && BlockUtils.isBlockGlyph(glyph.id) ? Float.NaN : (float)glyph.xoffset + xAdjust;
                }
                gr.offsetY = (float)(-h - glyph.yoffset) + yAdjust;
                gr.xAdvance = a;
                this.mapping.put(glyph.id & 0xFFFF, (Object)gr);
                if (glyph.kerning != null) {
                    if (this.kerning == null) {
                        this.kerning = new IntIntMap(128);
                    }
                    for (b = 0; b < glyph.kerning.length; ++b) {
                        kern = glyph.kerning[b];
                        if (kern == null) continue;
                        for (i = 0; i < 512; ++i) {
                            k = kern[i];
                            if (k != 0) {
                                this.kerning.put(glyph.id << 16 | (b << 9 | i), (int)k);
                            }
                            if ((b << 9 | i) != 91) continue;
                            this.kerning.put(glyph.id << 16 | 2, (int)k);
                        }
                    }
                }
                if ((glyph.id & 0xFFFF) != 91) continue;
                this.mapping.put(2, (Object)gr);
                if (glyph.kerning == null) continue;
                for (b = 0; b < glyph.kerning.length; ++b) {
                    kern = glyph.kerning[b];
                    if (kern == null) continue;
                    for (i = 0; i < 512; ++i) {
                        k = kern[i];
                        if (k == 0) continue;
                        this.kerning.put(0x20000 | (b << 9 | i), (int)k);
                    }
                }
            }
        }
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = (GlyphRegion)((Object)this.mapping.get(10));
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
        }
        if (this.mapping.containsKey(32)) {
            this.mapping.put(13, this.mapping.get(32));
        }
        int n = this.mapping.containsKey(0) ? 0 : (this.solidBlock = this.mapping.containsKey(9608) ? 9608 : 65535);
        if (makeGridGlyphs && (block = (GlyphRegion)((Object)this.mapping.get((int)this.solidBlock, null))) != null) {
            for (int i = 9472; i < 9472 + BlockUtils.BOX_DRAWING.length; ++i) {
                GlyphRegion gr = new GlyphRegion(block);
                gr.offsetX = Float.NaN;
                gr.xAdvance = this.cellWidth;
                gr.offsetY = this.cellHeight;
                this.mapping.put(i, (Object)gr);
            }
        }
        this.defaultValue = (GlyphRegion)((Object)this.mapping.get(data.missingGlyph == null ? 32 : data.missingGlyph.id, this.mapping.get(32, this.mapping.values().next())));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        this.isMono = (float)minWidth == this.cellWidth && this.kerning == null;
        this.integerPosition = bmFont.usesIntegerPositions();
        this.scale(bmFont.getScaleX(), bmFont.getScaleY());
    }

    public Font(String prefix, String fntName, boolean ignoredSadConsoleFlag) {
        this.distanceField = DistanceFieldType.STANDARD;
        this.loadSad(prefix == null ? "" : prefix, fntName);
    }

    protected void loadFNT(String fntName, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        GlyphRegion block;
        int i;
        int idx;
        FileHandle fntHandle = Gdx.files.internal(fntName);
        if (!fntHandle.exists() && !(fntHandle = Gdx.files.local(fntName)).exists()) {
            throw new RuntimeException("Missing font file: " + fntName);
        }
        String fnt = fntHandle.readString("UTF8");
        int n = idx = Font.indexAfter(fnt, "lineHeight=", 0);
        idx = Font.indexAfter(fnt, "base=", idx);
        int rawLineHeight = Font.intFromDec(fnt, n, idx);
        int n2 = idx;
        idx = Font.indexAfter(fnt, "pages=", idx);
        int baseline = Font.intFromDec(fnt, n2, idx);
        this.descent = baseline - rawLineHeight;
        if (this.distanceField == DistanceFieldType.STANDARD) {
            yAdjust += this.descent;
        }
        int n3 = idx;
        idx = Font.indexAfter(fnt, "\npage id=", idx);
        int pages = Font.intFromDec(fnt, n3, idx);
        if (this.parents == null || this.parents.size < pages) {
            if (this.parents == null) {
                this.parents = new Array(true, pages, TextureRegion.class);
            } else {
                this.parents.clear();
            }
            for (int i2 = 0; i2 < pages; ++i2) {
                idx = Font.indexAfter(fnt, "file=\"", idx);
                String textureName = fnt.substring(idx, idx = fnt.indexOf(34, idx));
                FileHandle textureHandle = Gdx.files.internal(textureName);
                if (textureHandle.exists() || (textureHandle = Gdx.files.local(textureName)).exists()) {
                    this.parents.add((Object)new TextureRegion(new Texture(textureHandle)));
                    if (this.distanceField != DistanceFieldType.SDF && this.distanceField != DistanceFieldType.MSDF) continue;
                    ((TextureRegion)this.parents.peek()).getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                    continue;
                }
                throw new RuntimeException("Missing texture file: " + textureName);
            }
        }
        int n4 = Font.indexAfter(fnt, "\nchars count=", idx);
        idx = n4;
        idx = Font.indexAfter(fnt, "\nchar id=", idx);
        int size = Font.intFromDec(fnt, n4, idx);
        this.mapping = new IntMap(size);
        int minWidth = Integer.MAX_VALUE;
        for (int i3 = 0; i3 < size && idx != fnt.length(); ++i3) {
            int n5 = idx;
            idx = Font.indexAfter(fnt, " x=", idx);
            int c = Font.intFromDec(fnt, n5, idx);
            int n6 = idx;
            idx = Font.indexAfter(fnt, " y=", idx);
            int x = Font.intFromDec(fnt, n6, idx);
            int n7 = idx;
            idx = Font.indexAfter(fnt, " width=", idx);
            int y = Font.intFromDec(fnt, n7, idx);
            int n8 = idx;
            idx = Font.indexAfter(fnt, " height=", idx);
            int w = Font.intFromDec(fnt, n8, idx);
            int n9 = idx;
            idx = Font.indexAfter(fnt, " xoffset=", idx);
            int h = Font.intFromDec(fnt, n9, idx);
            int n10 = idx;
            idx = Font.indexAfter(fnt, " yoffset=", idx);
            int xo = Font.intFromDec(fnt, n10, idx);
            int n11 = idx;
            idx = Font.indexAfter(fnt, " xadvance=", idx);
            int yo = Font.intFromDec(fnt, n11, idx);
            int n12 = idx;
            idx = Font.indexAfter(fnt, " page=", idx);
            int a = Font.intFromDec(fnt, n12, idx);
            int n13 = idx;
            idx = Font.indexAfter(fnt, "\nchar id=", idx);
            int p = Font.intFromDec(fnt, n13, idx);
            a = (int)((float)a + widthAdjust);
            h = (int)((float)h + heightAdjust);
            if (c != 9608) {
                minWidth = Math.min(minWidth, a);
            }
            GlyphRegion gr = new GlyphRegion((TextureRegion)this.parents.get(p), x, y, w, h);
            if (c == 10) {
                a = 0;
                gr.offsetX = 0.0f;
            } else {
                gr.offsetX = makeGridGlyphs && BlockUtils.isBlockGlyph(c) ? Float.NaN : (float)xo + xAdjust;
            }
            gr.offsetY = (float)yo + yAdjust;
            gr.xAdvance = a;
            this.cellWidth = Math.max((float)a, this.cellWidth);
            this.cellHeight = Math.max((float)h, this.cellHeight);
            this.mapping.put(c, (Object)gr);
            if (c != 91) continue;
            this.mapping.put(2, (Object)gr);
        }
        idx = Font.indexAfter(fnt, "\nkernings count=", 0);
        if (idx < fnt.length()) {
            int n14 = idx;
            idx = Font.indexAfter(fnt, "\nkerning first=", idx);
            int kernings = Font.intFromDec(fnt, n14, idx);
            this.kerning = new IntIntMap(kernings);
            for (i = 0; i < kernings; ++i) {
                int n15 = idx;
                idx = Font.indexAfter(fnt, " second=", idx);
                int first = Font.intFromDec(fnt, n15, idx);
                int n16 = idx;
                idx = Font.indexAfter(fnt, " amount=", idx);
                int second = Font.intFromDec(fnt, n16, idx);
                int n17 = idx;
                idx = Font.indexAfter(fnt, "\nkerning first=", idx);
                int amount = Font.intFromDec(fnt, n17, idx);
                this.kerning.put(first << 16 | second, amount);
                if (first == 91) {
                    this.kerning.put(0x20000 | second, amount);
                }
                if (second != 91) continue;
                this.kerning.put(first << 16 | 2, amount);
            }
        }
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = (GlyphRegion)((Object)this.mapping.get(10));
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
            gr.xAdvance = 0.0f;
        }
        if (this.mapping.containsKey(32)) {
            this.mapping.put(13, this.mapping.get(32));
        }
        this.solidBlock = (char)(this.mapping.containsKey(9608) ? 9608 : 65535);
        if (makeGridGlyphs && (block = (GlyphRegion)((Object)this.mapping.get((int)this.solidBlock, null))) != null) {
            for (i = 9472; i < 9472 + BlockUtils.BOX_DRAWING.length; ++i) {
                GlyphRegion gr = new GlyphRegion(block);
                gr.offsetX = Float.NaN;
                gr.xAdvance = this.cellWidth;
                gr.offsetY = this.cellHeight;
                this.mapping.put(i, (Object)gr);
            }
        }
        this.defaultValue = (GlyphRegion)((Object)this.mapping.get(32, this.mapping.get(0)));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        this.isMono = (float)minWidth == this.cellWidth && this.kerning == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadSad(String prefix, String fntName) {
        TextureRegion parent;
        JsonReader reader = new JsonReader();
        FileHandle fntHandle = Gdx.files.internal(prefix + fntName);
        if (!fntHandle.exists() && !(fntHandle = Gdx.files.local(prefix + fntName)).exists()) {
            throw new RuntimeException("Missing font file: " + prefix + fntName);
        }
        JsonValue fnt = reader.parse(fntHandle);
        int pages = 1;
        if (this.parents == null || this.parents.size == 0) {
            if (this.parents == null) {
                this.parents = new Array(true, pages, TextureRegion.class);
            }
            String textureName = fnt.getString("FilePath");
            FileHandle textureHandle = Gdx.files.internal(prefix + textureName);
            if (!textureHandle.exists() && !(textureHandle = Gdx.files.local(prefix + textureName)).exists()) throw new RuntimeException("Missing texture file: " + prefix + textureName);
            parent = new TextureRegion(new Texture(textureHandle));
            this.parents.add((Object)parent);
        } else {
            parent = (TextureRegion)this.parents.first();
        }
        int columns = fnt.getInt("Columns");
        int padding = fnt.getInt("GlyphPadding");
        this.cellHeight = fnt.getInt("GlyphHeight");
        this.cellWidth = fnt.getInt("GlyphWidth");
        int rows = (parent.getRegionHeight() - padding) / ((int)this.cellHeight + padding);
        int size = rows * columns;
        this.mapping = new IntMap(size + 1);
        int c = 0;
        for (int y = 0; y < rows; ++y) {
            int x = 0;
            while (x < columns) {
                GlyphRegion gr = new GlyphRegion(parent, x * ((int)this.cellWidth + padding) + padding, y * ((int)this.cellHeight + padding) + padding, (int)this.cellWidth, (int)this.cellHeight);
                gr.offsetX = 0.0f;
                gr.offsetY = 0.0f;
                gr.xAdvance = c == 10 ? 0.0f : this.cellWidth;
                this.mapping.put(c, (Object)gr);
                if (c == 91) {
                    if (this.mapping.containsKey(2)) {
                        this.mapping.put(size, this.mapping.get(2));
                    }
                    this.mapping.put(2, (Object)gr);
                }
                ++x;
                ++c;
            }
        }
        this.solidBlock = (char)fnt.getInt("SolidGlyphIndex");
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = (GlyphRegion)((Object)this.mapping.get(10));
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
            gr.xAdvance = 0.0f;
        }
        if (this.mapping.containsKey(32)) {
            this.mapping.put(13, this.mapping.get(32));
        }
        this.defaultValue = (GlyphRegion)((Object)this.mapping.get(32, this.mapping.get(0)));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        this.isMono = true;
    }

    public int kerningPair(char first, char second) {
        return first << 16 | second & 0xFFFF;
    }

    public Font scale(float horizontal, float vertical) {
        this.scaleX *= horizontal;
        this.scaleY *= vertical;
        this.cellWidth *= horizontal;
        this.cellHeight *= vertical;
        return this;
    }

    public Font scaleTo(float width, float height) {
        this.scaleX = width / this.originalCellWidth;
        this.scaleY = height / this.originalCellHeight;
        this.cellWidth = width;
        this.cellHeight = height;
        return this;
    }

    public Font adjustLineHeight(float multiplier) {
        this.cellHeight *= multiplier;
        this.originalCellHeight *= multiplier;
        return this;
    }

    public Font adjustCellWidth(float multiplier) {
        this.cellWidth *= multiplier;
        this.originalCellWidth *= multiplier;
        return this;
    }

    public Font fitCell(float width, float height, boolean center) {
        this.cellWidth = width;
        this.cellHeight = height;
        float wsx = width / this.scaleX;
        IntMap.Values vs = this.mapping.values();
        if (center) {
            while (vs.hasNext) {
                GlyphRegion g = (GlyphRegion)((Object)vs.next());
                g.offsetX += (wsx - g.xAdvance) * 0.5f;
                g.xAdvance = wsx;
            }
        } else {
            while (vs.hasNext) {
                ((GlyphRegion)((Object)vs.next())).xAdvance = wsx;
            }
        }
        this.isMono = true;
        this.kerning = null;
        return this;
    }

    public Font setTextureFilter() {
        return this.setTextureFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
    }

    public Font setTextureFilter(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        for (TextureRegion parent : this.parents) {
            parent.getTexture().setFilter(minFilter, magFilter);
        }
        return this;
    }

    public Font useIntegerPositions(boolean integer) {
        this.integerPosition = integer;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Font setName(String name) {
        this.name = name;
        return this;
    }

    public float getCrispness() {
        return this.distanceFieldCrispness;
    }

    public Font setCrispness(float crispness) {
        this.distanceFieldCrispness = crispness;
        return this;
    }

    public Font multiplyCrispness(float multiplier) {
        this.distanceFieldCrispness *= multiplier;
        return this;
    }

    public Font addImage(String character, TextureRegion region, float offsetX, float offsetY, float xAdvance) {
        if (character != null && !character.isEmpty()) {
            this.mapping.put((int)character.charAt(character.length() - 1), (Object)new GlyphRegion(region, offsetX, offsetY, xAdvance));
        }
        return this;
    }

    public Font addImage(String character, TextureRegion region) {
        if (character != null && !character.isEmpty()) {
            this.mapping.put((int)character.charAt(character.length() - 1), (Object)new GlyphRegion(region));
        }
        return this;
    }

    public Font addAtlas(TextureAtlas atlas) {
        Array regions = atlas.getRegions();
        if (this.nameLookup == null) {
            this.nameLookup = new CaseInsensitiveIntMap(regions.size, 0.6f);
        } else {
            this.nameLookup.ensureCapacity(regions.size);
        }
        TextureAtlas.AtlasRegion previous = (TextureAtlas.AtlasRegion)regions.first();
        this.mapping.put(57344, (Object)new GlyphRegion(previous));
        this.nameLookup.put(previous.name, 57344);
        int i = 57344;
        for (int a = 1; i < 63488 && a < regions.size; ++a) {
            TextureAtlas.AtlasRegion region = (TextureAtlas.AtlasRegion)regions.get(a);
            if (previous.getRegionX() == region.getRegionX() && previous.getRegionY() == region.getRegionY()) {
                this.nameLookup.put(region.name, i);
                continue;
            }
            previous = region;
            GlyphRegion gr = new GlyphRegion(region);
            this.mapping.put(++i, (Object)gr);
            this.nameLookup.put(region.name, i);
        }
        return this;
    }

    public void enableShader(Batch batch) {
        if (this.distanceField == DistanceFieldType.MSDF) {
            if (batch.getShader() != this.shader) {
                batch.setShader(this.shader);
                this.shader.setUniformf("u_smoothing", 7.0f * this.actualCrispness * Math.max(this.cellHeight / this.originalCellHeight, this.cellWidth / this.originalCellWidth));
            }
        } else if (this.distanceField == DistanceFieldType.SDF) {
            if (batch.getShader() != this.shader) {
                batch.setShader(this.shader);
                float scale = Math.max(this.cellHeight / this.originalCellHeight, this.cellWidth / this.originalCellWidth) * 0.5f + 0.125f;
                this.shader.setUniformf("u_smoothing", this.actualCrispness / scale);
            }
        } else {
            batch.setShader(null);
        }
        batch.setPackedColor(Color.WHITE_FLOAT_BITS);
    }

    public void drawText(Batch batch, CharSequence text, float x, float y) {
        this.drawText(batch, text, x, y, -2);
    }

    public void drawText(Batch batch, CharSequence text, float x, float y, int color) {
        batch.setPackedColor(NumberUtils.intToFloatColor((int)Integer.reverseBytes(color)));
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            GlyphRegion current = (GlyphRegion)((Object)this.mapping.get((int)text.charAt(i)));
            batch.draw((TextureRegion)current, x + current.offsetX, y + current.offsetY, (float)current.getRegionWidth(), (float)current.getRegionHeight());
            x += (float)current.getRegionWidth();
        }
    }

    public void drawBlocks(Batch batch, int[][] colors, float x, float y) {
        this.drawBlocks(batch, this.solidBlock, colors, x, y);
    }

    public void drawBlocks(Batch batch, char blockChar, int[][] colors, float x, float y) {
        TextureRegion block = (TextureRegion)this.mapping.get((int)blockChar);
        if (block == null) {
            return;
        }
        Texture parent = block.getTexture();
        float ipw = 1.0f / (float)parent.getWidth();
        float iph = 1.0f / (float)parent.getHeight();
        float u = block.getU();
        float v = block.getV();
        float u2 = block.getU() + ipw;
        float v2 = block.getV() + iph;
        this.vertices[0] = x += 0.00390625f;
        this.vertices[1] = y += 0.00390625f;
        this.vertices[3] = u;
        this.vertices[4] = v;
        this.vertices[5] = x;
        this.vertices[6] = y + this.cellHeight;
        this.vertices[8] = u;
        this.vertices[9] = v2;
        this.vertices[10] = x + this.cellWidth;
        this.vertices[11] = y + this.cellHeight;
        this.vertices[13] = u2;
        this.vertices[14] = v2;
        this.vertices[15] = x + this.cellWidth;
        this.vertices[16] = y;
        this.vertices[18] = u2;
        this.vertices[19] = v;
        int xn = colors.length;
        int yn = colors[0].length;
        for (int xi = 0; xi < xn; ++xi) {
            for (int yi = 0; yi < yn; ++yi) {
                if ((colors[xi][yi] & 0xFE) != 0) {
                    this.vertices[12] = this.vertices[17] = NumberUtils.intBitsToFloat((int)Integer.reverseBytes(colors[xi][yi] & 0xFFFFFFFE));
                    this.vertices[7] = this.vertices[17];
                    this.vertices[2] = this.vertices[17];
                    batch.draw(parent, this.vertices, 0, 20);
                }
                this.vertices[1] = this.vertices[16] = this.vertices[16] + this.cellHeight;
                this.vertices[6] = this.vertices[11] = this.vertices[11] + this.cellHeight;
            }
            this.vertices[0] = this.vertices[5] = this.vertices[5] + this.cellWidth;
            this.vertices[10] = this.vertices[15] = this.vertices[15] + this.cellWidth;
            this.vertices[1] = this.vertices[16] = y;
            this.vertices[6] = this.vertices[11] = y + this.cellHeight;
        }
    }

    protected void drawBlockSequence(Batch batch, float[] sequence, TextureRegion block, float color, float x, float y) {
        this.drawBlockSequence(batch, sequence, block, color, x, y, this.cellWidth, this.cellHeight);
    }

    protected void drawBlockSequence(Batch batch, float[] sequence, TextureRegion block, float color, float x, float y, float width, float height) {
        Texture parent = block.getTexture();
        float ipw = 1.0f / (float)parent.getWidth();
        float iph = 1.0f / (float)parent.getHeight();
        float u = block.getU();
        float v = block.getV();
        float u2 = u + ipw;
        float v2 = v - iph;
        for (int b = 0; b < sequence.length; b += 4) {
            float startX = x + sequence[b] * width;
            float startY = y + sequence[b + 1] * height;
            float sizeX = sequence[b + 2] * width;
            float sizeY = sequence[b + 3] * height;
            this.vertices[0] = startX;
            this.vertices[1] = startY;
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[5] = startX;
            this.vertices[6] = startY + sizeY;
            this.vertices[7] = color;
            this.vertices[8] = u;
            this.vertices[9] = v2;
            this.vertices[10] = startX + sizeX;
            this.vertices[11] = startY + sizeY;
            this.vertices[12] = color;
            this.vertices[13] = u2;
            this.vertices[14] = v2;
            this.vertices[15] = startX + sizeX;
            this.vertices[16] = startY;
            this.vertices[17] = color;
            this.vertices[18] = u2;
            this.vertices[19] = v;
            batch.draw(parent, this.vertices, 0, 20);
        }
    }

    protected void drawBlockSequence(Batch batch, float[] sequence, TextureRegion block, float color, float x, float y, float width, float height, float rotation) {
        Texture parent = block.getTexture();
        float ipw = 1.0f / (float)parent.getWidth();
        float iph = 1.0f / (float)parent.getHeight();
        float u = block.getU();
        float v = block.getV();
        float u2 = u + ipw;
        float v2 = v - iph;
        float sn = MathUtils.sinDeg((float)rotation);
        float cs = MathUtils.cosDeg((float)rotation);
        float xc = 0.0f;
        float yt = 0.0f;
        for (int b = 0; b < sequence.length; b += 4) {
            float startX = sequence[b] * width;
            float startY = sequence[b + 1] * height;
            float sizeX = sequence[b + 2] * width;
            float sizeY = sequence[b + 3] * height;
            float p0x = xc + startX;
            float p0y = yt + startY + sizeY;
            float p1x = xc + startX;
            float p1y = yt + startY;
            float p2x = xc + startX + sizeX;
            float p2y = yt + startY;
            this.vertices[0] = x + cs * p0x - sn * p0y;
            this.vertices[5] = x + cs * p1x - sn * p1y;
            this.vertices[10] = x + cs * p2x - sn * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sn * p0x + cs * p0y;
            this.vertices[6] = y + sn * p1x + cs * p1y;
            this.vertices[11] = y + sn * p2x + cs * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[7] = color;
            this.vertices[8] = u;
            this.vertices[9] = v2;
            this.vertices[12] = color;
            this.vertices[13] = u2;
            this.vertices[14] = v2;
            this.vertices[17] = color;
            this.vertices[18] = u2;
            this.vertices[19] = v;
            batch.draw(parent, this.vertices, 0, 20);
        }
    }

    public int drawMarkupText(Batch batch, String text, float x, float y) {
        Layout layout = this.tempLayout;
        layout.clear();
        this.markup(text, this.tempLayout);
        int lines = layout.lines();
        int drawn = 0;
        for (int ln = 0; ln < lines; ++ln) {
            Line line = layout.getLine(ln);
            int n = line.glyphs.size;
            drawn += n;
            if (this.kerning != null) {
                int kern = -1;
                for (int i = 0; i < n; ++i) {
                    long glyph = line.glyphs.get(i);
                    kern = kern << 16 | (int)(glyph & 0xFFFFL);
                    int amt = this.kerning.get(kern, 0);
                    x += this.drawGlyph(batch, glyph, x + (float)amt, y) + (float)amt;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    x += this.drawGlyph(batch, line.glyphs.get(i), x, y);
                }
            }
            y -= this.cellHeight;
        }
        return drawn;
    }

    public float drawGlyphs(Batch batch, Layout glyphs, float x, float y) {
        return this.drawGlyphs(batch, glyphs, x, y, 8);
    }

    public float drawGlyphs(Batch batch, Layout glyphs, float x, float y, int align) {
        float drawn = 0.0f;
        int lines = glyphs.lines();
        for (int ln = 0; ln < lines; ++ln) {
            Line l = glyphs.getLine(ln);
            drawn += this.drawGlyphs(batch, l, x, y -= l.height, align);
        }
        return drawn;
    }

    public float drawGlyphs(Batch batch, Layout glyphs, float x, float y, int align, float rotation, float originX, float originY) {
        float drawn = 0.0f;
        float sn = MathUtils.sinDeg((float)rotation);
        float cs = MathUtils.cosDeg((float)rotation);
        int lines = glyphs.lines();
        x -= sn * 0.5f * this.cellHeight;
        y += cs * 0.5f * this.cellHeight;
        x += cs * 0.5f * this.cellWidth;
        y += sn * 0.5f * this.cellWidth;
        for (int ln = 0; ln < lines; ++ln) {
            Line l = glyphs.getLine(ln);
            drawn += this.drawGlyphs(batch, l, x += sn * l.height, y -= cs * l.height, align, rotation, originX, originY);
        }
        return drawn;
    }

    public float drawGlyphs(Batch batch, Line glyphs, float x, float y) {
        if (glyphs == null) {
            return 0.0f;
        }
        return this.drawGlyphs(batch, glyphs, x, y, 8);
    }

    public float drawGlyphs(Batch batch, Line glyphs, float x, float y, int align) {
        float originX;
        float f = Align.isRight((int)align) ? glyphs.width : (originX = Align.isCenterHorizontal((int)align) ? glyphs.width * 0.5f : 0.0f);
        float originY = Align.isTop((int)align) ? glyphs.height : (Align.isCenterVertical((int)align) ? glyphs.height * 0.5f : 0.0f);
        return this.drawGlyphs(batch, glyphs, x, y, align, 0.0f, originX, originY);
    }

    public float drawGlyphs(Batch batch, Line glyphs, float x, float y, int align, float rotation, float originX, float originY) {
        if (glyphs == null || glyphs.glyphs.size == 0) {
            return 0.0f;
        }
        float drawn = 0.0f;
        float cs = MathUtils.cosDeg((float)rotation);
        float sn = MathUtils.sinDeg((float)rotation);
        float worldOriginX = x + originX;
        float worldOriginY = y + originY;
        float fx = -originX;
        float fy = -originY;
        x = cs * fx - sn * fy + worldOriginX;
        y = sn * fx + cs * fy + worldOriginY;
        if (Align.isCenterHorizontal((int)align)) {
            x -= cs * (glyphs.width * 0.5f);
            y -= sn * (glyphs.width * 0.5f);
        } else if (Align.isRight((int)align)) {
            x -= cs * glyphs.width;
            y -= sn * glyphs.width;
        }
        int kern = -1;
        float xChange = 0.0f;
        float yChange = 0.0f;
        boolean curly = false;
        boolean initial = true;
        int n = glyphs.glyphs.size;
        for (int i = 0; i < n; ++i) {
            long glyph = glyphs.glyphs.get(i);
            char ch = (char)glyph;
            if (curly) {
                if (ch == '}') {
                    curly = false;
                    continue;
                }
                if (ch != '{') continue;
                curly = false;
            } else if (ch == '{') {
                curly = true;
                continue;
            }
            Font font = null;
            if (this.family != null) {
                font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
            }
            if (font == null) {
                font = this;
            }
            if (font.kerning != null) {
                kern = kern << 16 | (int)(glyph & 0xFFFFL);
                float amt = (float)font.kerning.get(kern, 0) * font.scaleX * (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
                xChange += cs * amt;
                yChange += sn * amt;
            }
            if (initial) {
                float ox = ((GlyphRegion)((Object)font.mapping.get((int)((int)(glyph & 0xFFFFL)), (Object)((Object)font.defaultValue)))).offsetX * font.scaleX * (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
                if (ox < 0.0f) {
                    xChange -= cs * ox;
                    yChange -= sn * ox;
                }
                initial = false;
            }
            float single = this.drawGlyph(batch, glyph, x + xChange, y + yChange, rotation);
            xChange += cs * single;
            yChange += sn * single;
            drawn += single;
        }
        return drawn;
    }

    public static float xAdvance(Font font, float scale, long glyph) {
        if (glyph >>> 32 == 0L) {
            return 0.0f;
        }
        GlyphRegion tr = (GlyphRegion)((Object)font.mapping.get((int)((char)glyph)));
        if (tr == null) {
            return 0.0f;
        }
        float changedW = tr.xAdvance * scale;
        if (!font.isMono && (glyph & 0x6000000L) != 0L) {
            changedW *= 0.5f;
        }
        return changedW;
    }

    public float xAdvance(long glyph) {
        if (glyph >>> 32 == 0L) {
            return 0.0f;
        }
        GlyphRegion tr = (GlyphRegion)((Object)this.mapping.get((int)((char)glyph)));
        if (tr == null) {
            return 0.0f;
        }
        float scale = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f * this.cellHeight / (tr.xAdvance * 1.25f) : this.scaleX * (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
        float changedW = tr.xAdvance * scale;
        if (!this.isMono) {
            changedW += tr.offsetX * scale;
            if ((glyph & 0x6000000L) != 0L) {
                changedW *= 0.5f;
            }
        }
        return changedW;
    }

    public float measureWidth(Line line) {
        float drawn = 0.0f;
        LongArray glyphs = line.glyphs;
        boolean curly = false;
        boolean initial = true;
        int kern = -1;
        int n = glyphs.size;
        for (int i = 0; i < n; ++i) {
            float ox;
            float changedW;
            float scaleX;
            float scale;
            GlyphRegion tr;
            long glyph = glyphs.get(i);
            char ch = (char)glyph;
            if (curly) {
                if (ch == '}') {
                    curly = false;
                    continue;
                }
                if (ch != '{') continue;
                curly = false;
            } else if (ch == '{') {
                curly = true;
                continue;
            }
            Font font = null;
            if (this.family != null) {
                font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
            }
            if (font == null) {
                font = this;
            }
            if ((tr = (GlyphRegion)((Object)font.mapping.get((int)ch))) == null) continue;
            if (font.kerning != null) {
                kern = kern << 16 | ch;
                scale = (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
                scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / (tr.xAdvance * 1.25f) : font.scaleX * scale * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63));
                float amt = (float)font.kerning.get(kern, 0) * scaleX;
                changedW = tr.xAdvance * scaleX;
                if (initial) {
                    ox = ((GlyphRegion)((Object)font.mapping.get((int)((int)(glyph & 0xFFFFL)), (Object)((Object)font.defaultValue)))).offsetX * scaleX;
                    if (ox < 0.0f) {
                        changedW -= ox;
                    }
                    initial = false;
                }
                drawn += changedW + amt;
                continue;
            }
            scale = (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
            scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / (tr.xAdvance * 1.25f) : font.scaleX * scale * ((glyph & 0x6000000L) != 0L && !font.isMono ? 0.5f : 1.0f);
            changedW = tr.xAdvance * scaleX;
            if (font.isMono) {
                changedW += tr.offsetX * scaleX;
            } else if (initial) {
                ox = ((GlyphRegion)((Object)font.mapping.get((int)((int)(glyph & 0xFFFFL)), (Object)((Object)font.defaultValue)))).offsetX * scaleX;
                if (ox < 0.0f) {
                    changedW -= ox;
                }
                initial = false;
            }
            drawn += changedW;
        }
        return drawn;
    }

    public float calculateSize(Line line) {
        float drawn = 0.0f;
        LongArray glyphs = line.glyphs;
        boolean curly = false;
        boolean initial = true;
        int kern = -1;
        line.height = 0.0f;
        int n = glyphs.size;
        for (int i = 0; i < n; ++i) {
            float ox;
            float changedW;
            float scaleX;
            float scale;
            GlyphRegion tr;
            long glyph = glyphs.get(i);
            char ch = (char)glyph;
            if (curly) {
                if (ch == '}') {
                    curly = false;
                    continue;
                }
                if (ch != '{') continue;
                curly = false;
            } else if (ch == '{') {
                curly = true;
                continue;
            }
            Font font = null;
            if (this.family != null) {
                font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
            }
            if (font == null) {
                font = this;
            }
            if ((tr = (GlyphRegion)((Object)font.mapping.get((int)ch))) == null) continue;
            if (font.kerning != null) {
                kern = kern << 16 | ch;
                scale = (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
                scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / (tr.xAdvance * 1.25f) : font.scaleX * scale * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63));
                line.height = Math.max(line.height, font.cellHeight * scale);
                float amt = (float)font.kerning.get(kern, 0) * scaleX;
                changedW = tr.xAdvance * scaleX;
                if (initial) {
                    ox = ((GlyphRegion)((Object)font.mapping.get((int)((int)(glyph & 0xFFFFL)), (Object)((Object)font.defaultValue)))).offsetX * scaleX;
                    if (ox < 0.0f) {
                        changedW -= ox;
                    }
                    initial = false;
                }
                drawn += changedW + amt;
                continue;
            }
            scale = (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
            line.height = Math.max(line.height, font.cellHeight * scale);
            scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / (tr.xAdvance * 1.25f) : font.scaleX * scale * ((glyph & 0x6000000L) != 0L && !font.isMono ? 0.5f : 1.0f);
            changedW = tr.xAdvance * scaleX;
            if (font.isMono) {
                changedW += tr.offsetX * scaleX;
            } else if (initial) {
                ox = ((GlyphRegion)((Object)font.mapping.get((int)((int)(glyph & 0xFFFFL)), (Object)((Object)font.defaultValue)))).offsetX * scaleX;
                if (ox < 0.0f) {
                    changedW -= ox;
                }
                initial = false;
            }
            drawn += changedW;
        }
        line.width = drawn;
        return drawn;
    }

    public float calculateSize(Layout layout) {
        float w = 0.0f;
        float currentHeight = 0.0f;
        for (int ln = 0; ln < layout.lines(); ++ln) {
            float drawn = 0.0f;
            Line line = layout.getLine(ln);
            LongArray glyphs = line.glyphs;
            boolean curly = false;
            boolean initial = true;
            int kern = -1;
            line.height = currentHeight;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                float ox;
                float changedW;
                float scaleX;
                float scale;
                GlyphRegion tr;
                long glyph = glyphs.get(i);
                char ch = (char)glyph;
                if (curly) {
                    if (ch == '}') {
                        curly = false;
                        continue;
                    }
                    if (ch != '{') continue;
                    curly = false;
                } else if (ch == '{') {
                    curly = true;
                    continue;
                }
                Font font = null;
                if (this.family != null) {
                    font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
                }
                if (font == null) {
                    font = this;
                }
                if ((tr = (GlyphRegion)((Object)font.mapping.get((int)ch))) == null) continue;
                if (font.kerning != null) {
                    kern = kern << 16 | ch;
                    scale = (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
                    scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / (tr.xAdvance * 1.25f) : font.scaleX * scale * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63));
                    currentHeight = font.cellHeight * scale;
                    line.height = Math.max(line.height, currentHeight);
                    float amt = (float)font.kerning.get(kern, 0) * scaleX;
                    changedW = tr.xAdvance * scaleX;
                    if (initial) {
                        ox = ((GlyphRegion)((Object)font.mapping.get((int)((int)(glyph & 0xFFFFL)), (Object)((Object)font.defaultValue)))).offsetX * scaleX;
                        if (ox < 0.0f) {
                            changedW -= ox;
                        }
                        initial = false;
                    }
                    drawn += changedW + amt;
                    continue;
                }
                scale = (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
                currentHeight = font.cellHeight * scale;
                line.height = Math.max(line.height, currentHeight);
                scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / (tr.xAdvance * 1.25f) : font.scaleX * scale * ((glyph & 0x6000000L) != 0L && !font.isMono ? 0.5f : 1.0f);
                changedW = tr.xAdvance * scaleX;
                if (font.isMono) {
                    changedW += tr.offsetX * scaleX;
                } else if (initial) {
                    ox = ((GlyphRegion)((Object)font.mapping.get((int)((int)(glyph & 0xFFFFL)), (Object)((Object)font.defaultValue)))).offsetX * scaleX;
                    if (ox < 0.0f) {
                        changedW -= ox;
                    }
                    initial = false;
                }
                drawn += changedW;
            }
            line.width = drawn;
            w = Math.max(w, drawn);
        }
        return w;
    }

    protected float handleIntegerPosition(float p) {
        return this.integerPosition ? (float)MathUtils.round((float)p) : p;
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y) {
        return this.drawGlyph(batch, glyph, x, y, 0.0f, 1.0f, 1.0f);
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y, float rotation) {
        return this.drawGlyph(batch, glyph, x, y, rotation, 1.0f, 1.0f);
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y, float rotation, float sizingX, float sizingY) {
        float scaleX;
        float scaleY;
        char c;
        GlyphRegion tr;
        float sin = MathUtils.sinDeg((float)rotation);
        float cos = MathUtils.cosDeg((float)rotation);
        Font font = null;
        if (this.family != null) {
            font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
        }
        if (font == null) {
            font = this;
        }
        if ((tr = (GlyphRegion)((Object)font.mapping.get((int)(c = (char)glyph)))) == null) {
            return 0.0f;
        }
        float color = NumberUtils.intBitsToFloat((int)((int)(batch.getColor().a * (float)(glyph >>> 33 & 0x7FL)) << 25 | (int)(batch.getColor().r * (float)(glyph >>> 56)) | (int)(batch.getColor().g * (float)(glyph >>> 48 & 0xFFL)) << 8 | (int)(batch.getColor().b * (float)(glyph >>> 40 & 0xFFL)) << 16));
        float scale = (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
        if (c >= '\ue000' && c < '\uf800') {
            scaleX = scaleY = scale * font.cellHeight / (tr.xAdvance * 1.25f);
        } else {
            scaleX = font.scaleX * scale;
            scaleY = font.scaleY * scale;
        }
        float centerX = font.cellWidth * scaleX * 0.5f;
        float centerY = font.cellHeight * scaleY * 0.5f;
        if (tr.offsetX != tr.offsetX) {
            float[] boxes = BlockUtils.BOX_DRAWING[c - 9472];
            this.drawBlockSequence(batch, boxes, (TextureRegion)font.mapping.get((int)this.solidBlock, (Object)tr), color, x - this.cellWidth * (sizingX - 1.0f) + centerX, y - this.cellHeight * (sizingY - 1.0f) + centerY, this.cellWidth * sizingX, this.cellHeight * sizingY, rotation);
            return this.cellWidth;
        }
        Texture tex = tr.getTexture();
        float x0 = 0.0f;
        float x1 = 0.0f;
        float x2 = 0.0f;
        float y0 = 0.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        float iw = 1.0f / (float)tex.getWidth();
        float u = tr.getU();
        float v = tr.getV();
        float u2 = tr.getU2();
        float v2 = tr.getV2();
        float w = (float)tr.getRegionWidth() * scaleX * sizingX;
        float changedW = tr.xAdvance * scaleX;
        float h = (float)tr.getRegionHeight() * scaleY * sizingY;
        float xc = tr.offsetX * scaleX - centerX * sizingX;
        float yt = font.cellHeight * scale - centerY - ((float)tr.getRegionHeight() + tr.offsetY) * scaleY;
        x = font.handleIntegerPosition(x + centerX);
        y = font.handleIntegerPosition(y + centerY);
        if ((glyph & 0x20000000L) != 0L) {
            x0 += h * 0.2f;
            x1 -= h * 0.2f;
            x2 -= h * 0.2f;
        }
        long script = glyph & 0x6000000L;
        float scaledHeight = font.cellHeight * scale * sizingY;
        if (script == 0x6000000L) {
            w *= 0.5f;
            yt = scaledHeight * 0.625f - (h *= 0.5f) - tr.offsetY * scaleY * 0.5f - centerY * scale * sizingY;
            y1 += scaledHeight * 0.375f;
            y2 += scaledHeight * 0.375f;
            y0 += scaledHeight * 0.375f;
            if (!font.isMono) {
                changedW *= 0.5f;
            }
        } else if (script == 0x2000000L) {
            w *= 0.5f;
            yt = scaledHeight * 0.625f - (h *= 0.5f) - tr.offsetY * scaleY * 0.5f - centerY * scale * sizingY;
            y1 -= scaledHeight * 0.125f;
            y2 -= scaledHeight * 0.125f;
            y0 -= scaledHeight * 0.125f;
            if (!font.isMono) {
                changedW *= 0.5f;
            }
        } else if (script == 0x4000000L) {
            w *= 0.5f;
            yt = scaledHeight * 0.625f - (h *= 0.5f) - tr.offsetY * scaleY * 0.5f - centerY * scale * sizingY;
            y0 += scaledHeight * 0.125f;
            y1 += scaledHeight * 0.125f;
            y2 += scaledHeight * 0.125f;
            if (!font.isMono) {
                changedW *= 0.5f;
            }
        }
        this.vertices[2] = color;
        this.vertices[3] = u;
        this.vertices[4] = v;
        this.vertices[7] = color;
        this.vertices[8] = u;
        this.vertices[9] = v2;
        this.vertices[12] = color;
        this.vertices[13] = u2;
        this.vertices[14] = v2;
        this.vertices[17] = color;
        this.vertices[18] = u2;
        this.vertices[19] = v;
        float p0x = xc + x0;
        float p0y = yt + y0 + h;
        float p1x = xc + x1;
        float p1y = yt + y1;
        float p2x = xc + x2 + w;
        float p2y = yt + y2;
        this.vertices[0] = x + cos * p0x - sin * p0y;
        this.vertices[5] = x + cos * p1x - sin * p1y;
        this.vertices[10] = x + cos * p2x - sin * p2y;
        this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
        this.vertices[1] = y + sin * p0x + cos * p0y;
        this.vertices[6] = y + sin * p1x + cos * p1y;
        this.vertices[11] = y + sin * p2x + cos * p2y;
        this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
        batch.draw(tex, this.vertices, 0, 20);
        if ((glyph & 0x40000000L) != 0L) {
            this.vertices[0] = x + cos * (p0x += 1.0f) - sin * p0y;
            this.vertices[5] = x + cos * (p1x += 1.0f) - sin * p1y;
            this.vertices[10] = x + cos * (p2x += 1.0f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sin * p0x + cos * p0y;
            this.vertices[6] = y + sin * p1x + cos * p1y;
            this.vertices[11] = y + sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            batch.draw(tex, this.vertices, 0, 20);
            this.vertices[0] = x + cos * (p0x -= 2.0f) - sin * p0y;
            this.vertices[5] = x + cos * (p1x -= 2.0f) - sin * p1y;
            this.vertices[10] = x + cos * (p2x -= 2.0f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sin * p0x + cos * p0y;
            this.vertices[6] = y + sin * p1x + cos * p1y;
            this.vertices[11] = y + sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            batch.draw(tex, this.vertices, 0, 20);
            this.vertices[0] = x + cos * (p0x += 0.5f) - sin * p0y;
            this.vertices[5] = x + cos * (p1x += 0.5f) - sin * p1y;
            this.vertices[10] = x + cos * (p2x += 0.5f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sin * p0x + cos * p0y;
            this.vertices[6] = y + sin * p1x + cos * p1y;
            this.vertices[11] = y + sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            batch.draw(tex, this.vertices, 0, 20);
            this.vertices[0] = x + cos * (p0x += 1.0f) - sin * p0y;
            this.vertices[5] = x + cos * (p1x += 1.0f) - sin * p1y;
            this.vertices[10] = x + cos * (p2x += 1.0f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sin * p0x + cos * p0y;
            this.vertices[6] = y + sin * p1x + cos * p1y;
            this.vertices[11] = y + sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            batch.draw(tex, this.vertices, 0, 20);
        }
        if ((glyph & 0x10000000L) != 0L) {
            GlyphRegion under = (GlyphRegion)((Object)font.mapping.get(9472));
            if (under != null && under.offsetX != under.offsetX) {
                p0x = -centerX;
                p0y = -this.cellHeight * 0.375f;
                this.drawBlockSequence(batch, BlockUtils.BOX_DRAWING[0], (TextureRegion)font.mapping.get((int)this.solidBlock, (Object)tr), color, x + cos * p0x - sin * p0y, y + (sin * p0x + cos * p0y), tr.xAdvance * scaleX + 2.0f, this.cellHeight * 0.75f, rotation);
            } else {
                under = (GlyphRegion)((Object)font.mapping.get(95));
                if (under != null) {
                    float underU = under.getU() + (under.xAdvance - under.offsetX) * iw * 0.5f;
                    float underV = under.getV();
                    float underU2 = underU + iw;
                    float underV2 = under.getV2();
                    float hu = (float)under.getRegionHeight() * scaleY;
                    float yu = font.cellHeight * scale - hu - under.offsetY * scaleY - centerY;
                    xc = under.offsetX * scaleX - centerX * scale;
                    x0 = -scaleX * under.offsetX - scale;
                    this.vertices[2] = color;
                    this.vertices[3] = underU;
                    this.vertices[4] = underV;
                    this.vertices[7] = color;
                    this.vertices[8] = underU;
                    this.vertices[9] = underV2;
                    this.vertices[12] = color;
                    this.vertices[13] = underU2;
                    this.vertices[14] = underV2;
                    this.vertices[17] = color;
                    this.vertices[18] = underU2;
                    this.vertices[19] = underV;
                    p0x = xc + x0 - scale;
                    p0y = yu + hu;
                    p1x = xc + x0 - scale;
                    p1y = yu;
                    p2x = xc + x0 + changedW + scale;
                    p2y = yu;
                    this.vertices[0] = x + cos * p0x - sin * p0y;
                    this.vertices[5] = x + cos * p1x - sin * p1y;
                    this.vertices[10] = x + cos * p2x - sin * p2y;
                    this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                    this.vertices[1] = y + sin * p0x + cos * p0y;
                    this.vertices[6] = y + sin * p1x + cos * p1y;
                    this.vertices[11] = y + sin * p2x + cos * p2y;
                    this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                    batch.draw(under.getTexture(), this.vertices, 0, 20);
                }
            }
        }
        if ((glyph & 0x8000000L) != 0L) {
            GlyphRegion dash = (GlyphRegion)((Object)font.mapping.get(9472));
            if (dash != null && dash.offsetX != dash.offsetX) {
                p0x = -centerX;
                p0y = centerY - font.cellHeight * 0.125f;
                this.drawBlockSequence(batch, BlockUtils.BOX_DRAWING[0], (TextureRegion)font.mapping.get((int)this.solidBlock, (Object)tr), color, x + cos * p0x - sin * p0y, y + (sin * p0x + cos * p0y), tr.xAdvance * scaleX + 2.0f, this.cellHeight * 0.75f, rotation);
            } else {
                dash = (GlyphRegion)((Object)font.mapping.get(45));
                if (dash != null) {
                    float dashU = dash.getU() + (dash.xAdvance - dash.offsetX) * iw * 0.5f;
                    float dashV = dash.getV();
                    float dashU2 = dashU + iw;
                    float dashV2 = dash.getV2();
                    float hd = (float)dash.getRegionHeight() * scaleY;
                    float yd = font.cellHeight * scale - hd - dash.offsetY * scaleY - centerY;
                    xc = dash.offsetX * scaleX - centerX * scale;
                    x0 = -scaleX * dash.offsetX - scale;
                    this.vertices[2] = color;
                    this.vertices[3] = dashU;
                    this.vertices[4] = dashV;
                    this.vertices[7] = color;
                    this.vertices[8] = dashU;
                    this.vertices[9] = dashV2;
                    this.vertices[12] = color;
                    this.vertices[13] = dashU2;
                    this.vertices[14] = dashV2;
                    this.vertices[17] = color;
                    this.vertices[18] = dashU2;
                    this.vertices[19] = dashV;
                    p0x = xc + x0 - scale;
                    p0y = yd + hd;
                    p1x = xc + x0 - scale;
                    p1y = yd;
                    p2x = xc + x0 + changedW + scale;
                    p2y = yd;
                    this.vertices[0] = x + cos * p0x - sin * p0y;
                    this.vertices[5] = x + cos * p1x - sin * p1y;
                    this.vertices[10] = x + cos * p2x - sin * p2y;
                    this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                    this.vertices[1] = y + sin * p0x + cos * p0y;
                    this.vertices[6] = y + sin * p1x + cos * p1y;
                    this.vertices[11] = y + sin * p2x + cos * p2y;
                    this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                    batch.draw(dash.getTexture(), this.vertices, 0, 20);
                }
            }
        }
        return changedW;
    }

    public Layout markup(String text, Layout appendTo) {
        long baseColor;
        long color;
        boolean capitalize = false;
        boolean previousWasLetter = false;
        boolean capsLock = false;
        boolean lowerCase = false;
        boolean initial = true;
        int scale = 3;
        int fontIndex = -1;
        Font font = this;
        long COLOR_MASK = -4294967296L;
        long current = color = (baseColor = Long.reverseBytes(NumberUtils.floatToIntBits((float)appendTo.getBaseColor())) & 0xFFFFFFFE00000000L);
        if (appendTo.font == null || !appendTo.font.equals(this)) {
            appendTo.clear();
            appendTo.font(this);
        }
        appendTo.peekLine().height = 0.0f;
        float targetWidth = appendTo.getTargetWidth();
        int kern = -1;
        int n = text.length();
        block21: for (int i = 0; i < n; ++i) {
            float w;
            int e;
            int k;
            int j;
            int c;
            float scaleX = font.scaleX * (float)(scale + 1) * 0.25f;
            if (text.charAt(i) == '{' && i + 1 < n && text.charAt(i + 1) != '{') {
                char after;
                int start = i;
                int sizeChange = -1;
                int fontChange = -1;
                int end = text.indexOf(125, i);
                if (end == -1) {
                    end = text.length();
                }
                int eq = end;
                while (i < n && i <= end) {
                    c = text.charAt(i);
                    appendTo.add(current | (long)c);
                    if (c == 64) {
                        fontChange = i;
                    } else if (c == 37) {
                        sizeChange = i;
                    } else if (c == 61) {
                        eq = Math.min(eq, i);
                    }
                    ++i;
                }
                char c2 = after = eq + 1 >= end ? (char)'\u0000' : text.charAt(eq + 1);
                if (start + 1 == end || "RESET".equalsIgnoreCase(Font.safeSubstring(text, start + 1, end))) {
                    scale = 3;
                    font = this;
                    fontIndex = 0;
                    current &= 0xFFFFFFFFF9FFFFFFL;
                } else if (after == '^' || after == '=' || after == '.') {
                    switch (after) {
                        case '^': {
                            if ((current & 0x6000000L) == 0x6000000L) {
                                current &= 0xFFFFFFFFF9FFFFFFL;
                                break;
                            }
                            current |= 0x6000000L;
                            break;
                        }
                        case '.': {
                            if ((current & 0x6000000L) == 0x2000000L) {
                                current &= 0xFFFFFFFFFDFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                            break;
                        }
                        case '=': {
                            if ((current & 0x6000000L) == 0x4000000L) {
                                current &= 0xFFFFFFFFFBFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                        }
                    }
                } else if (fontChange >= 0 && this.family != null) {
                    fontIndex = this.family.fontAliases.get(Font.safeSubstring(text, fontChange + 1, end), -1);
                    if (fontIndex == -1) {
                        font = this;
                        fontIndex = 0;
                    } else {
                        font = this.family.connected[fontIndex];
                        if (font == null) {
                            font = this;
                            fontIndex = 0;
                        }
                    }
                } else if (sizeChange >= 0) {
                    scale = sizeChange + 1 == end ? (eq + 1 == sizeChange ? 3 : (Font.intFromDec(text, eq + 1, sizeChange) - 24) / 25 & 0xF) : (Font.intFromDec(text, sizeChange + 1, end) - 24) / 25 & 0xF;
                }
                current = current & 0xFFFFFFFFFF00FFFFL | (long)((scale - 3 & 0xF) << 20) | (long)((fontIndex & 0xF) << 16);
                --i;
                continue;
            }
            if (text.charAt(i) == '[') {
                float w2;
                int len;
                c = 91;
                if (++i < n) {
                    char c3 = text.charAt(i);
                    c = c3;
                    if (c3 != '[' && c != 43) {
                        if (c == 93) {
                            color = baseColor;
                            current = color & 0xFFFFFFFFF9FFFFFFL;
                            scale = 3;
                            font = this;
                            capitalize = false;
                            capsLock = false;
                            lowerCase = false;
                            continue;
                        }
                        int len2 = text.indexOf(93, i) - i;
                        if (len2 < 0) break;
                        switch (c) {
                            case 42: {
                                current ^= 0x40000000L;
                                break;
                            }
                            case 47: {
                                current ^= 0x20000000L;
                                break;
                            }
                            case 94: {
                                if ((current & 0x6000000L) == 0x6000000L) {
                                    current &= 0xFFFFFFFFF9FFFFFFL;
                                    break;
                                }
                                current |= 0x6000000L;
                                break;
                            }
                            case 46: {
                                if ((current & 0x6000000L) == 0x2000000L) {
                                    current &= 0xFFFFFFFFFDFFFFFFL;
                                    break;
                                }
                                current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                                break;
                            }
                            case 61: {
                                if ((current & 0x6000000L) == 0x4000000L) {
                                    current &= 0xFFFFFFFFFBFFFFFFL;
                                    break;
                                }
                                current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                                break;
                            }
                            case 95: {
                                current ^= 0x10000000L;
                                break;
                            }
                            case 126: {
                                current ^= 0x8000000L;
                                break;
                            }
                            case 59: {
                                capitalize = !capitalize;
                                capsLock = false;
                                lowerCase = false;
                                break;
                            }
                            case 33: {
                                capsLock = !capsLock;
                                capitalize = false;
                                lowerCase = false;
                                break;
                            }
                            case 44: {
                                lowerCase = !lowerCase;
                                capitalize = false;
                                capsLock = false;
                                break;
                            }
                            case 37: {
                                if (len2 >= 2) {
                                    scale = (Font.intFromDec(text, i + 1, i + len2) - 24) / 25 & 0xF;
                                    current = current & 0xFFFFFFFFFF0FFFFFL | (long)((scale - 3 & 0xF) << 20);
                                    break;
                                }
                                current &= 0xFFFFFFFFFF0FFFFFL;
                                scale = 3;
                                break;
                            }
                            case 35: {
                                color = len2 >= 7 && len2 < 9 ? Font.longFromHex(text, i + 1, i + 7) << 40 | 0xFE00000000L : (len2 >= 9 ? Font.longFromHex(text, i + 1, i + 9) << 32 & 0xFFFFFFFE00000000L : baseColor);
                                current = current & 0xFFFFFFFFL | color;
                                break;
                            }
                            case 64: {
                                if (this.family == null) {
                                    font = this;
                                    fontIndex = 0;
                                    break;
                                }
                                fontIndex = this.family.fontAliases.get(Font.safeSubstring(text, i + 1, i + len2), 0);
                                current = current & 0xFFFFFFFFFFF0FFFFL | ((long)fontIndex & 0xFL) << 16;
                                font = this.family.connected[fontIndex & 0xF];
                                if (font != null) break;
                                font = this;
                                break;
                            }
                            case 124: {
                                int lookupColor = this.colorLookup.getRgba(Font.safeSubstring(text, i + 1, i + len2)) & 0xFFFFFFFE;
                                color = lookupColor == 256 ? baseColor : (long)lookupColor << 32;
                                current = current & 0xFFFFFFFFL | color;
                                break;
                            }
                            default: {
                                int gdxColor = this.colorLookup.getRgba(Font.safeSubstring(text, i, i + len2)) & 0xFFFFFFFE;
                                color = gdxColor == 256 ? baseColor : (long)gdxColor << 32;
                                current = current & 0xFFFFFFFFL | color;
                            }
                        }
                        i += len2;
                        continue;
                    }
                }
                if (c == 43 && this.nameLookup != null && (len = text.indexOf(93, i) - i) >= 0) {
                    c = this.nameLookup.get(Font.safeSubstring(text, i + 1, i + len), 43);
                    i += len;
                    scaleX = (float)(scale + 1) * 0.25f * this.cellHeight / (((GlyphRegion)((Object)font.mapping.get((int)c, (Object)((Object)font.defaultValue)))).xAdvance * 1.25f);
                }
                if (font.kerning == null) {
                    w2 = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)c);
                    if (initial) {
                        float ox = ((GlyphRegion)((Object)font.mapping.get((int)c, (Object)((Object)font.defaultValue)))).offsetX * scaleX;
                        if (ox < 0.0f) {
                            w2 = appendTo.peekLine().width -= ox;
                        }
                        initial = false;
                    }
                } else {
                    kern = kern << 16 | c;
                    w2 = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)c) + (float)font.kerning.get(kern, 0) * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                    if (initial) {
                        float ox = ((GlyphRegion)((Object)font.mapping.get((int)c, (Object)((Object)font.defaultValue)))).offsetX * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                        if (ox < 0.0f) {
                            w2 = appendTo.peekLine().width -= ox;
                        }
                        initial = false;
                    }
                }
                if (c == 91) {
                    appendTo.add(current | 2L);
                } else {
                    appendTo.add(current | (long)c);
                }
                if (targetWidth > 0.0f && w2 > targetWidth) {
                    float changeNext;
                    Line earlier = appendTo.peekLine();
                    Line later = appendTo.pushLine();
                    if (later == null) {
                        String ellipsis = appendTo.ellipsis == null ? "" : appendTo.ellipsis;
                        for (j = earlier.glyphs.size - 1; j >= 0; --j) {
                            int e2;
                            long curr;
                            while (j > 0 && ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) < 0)) {
                                --j;
                            }
                            while (j > 0 && ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0)) {
                                --j;
                            }
                            float change = 0.0f;
                            changeNext = 0.0f;
                            if (font.kerning == null) {
                                k = j + 1;
                                for (e = 0; e < ellipsis.length(); ++e) {
                                    if (k < earlier.glyphs.size) {
                                        change += Font.xAdvance(font, scaleX, earlier.glyphs.get(k));
                                    }
                                    changeNext += Font.xAdvance(font, scaleX, current | (long)ellipsis.charAt(e));
                                    ++k;
                                }
                            } else {
                                int k2 = (int)earlier.glyphs.get(j) & 0xFFFF;
                                int k2e = 65535;
                                int k3 = j + 1;
                                for (int e3 = 0; e3 < ellipsis.length(); ++e3) {
                                    if (k3 < earlier.glyphs.size) {
                                        curr = earlier.glyphs.get(k3);
                                        k2 = k2 << 16 | (char)curr;
                                        change += Font.xAdvance(font, scaleX, curr) + (float)font.kerning.get(k2, 0) * scaleX * (1.0f + 0.5f * (float)(-(curr & 0x6000000L) >> 63));
                                    }
                                    long currE = current | (long)ellipsis.charAt(e3);
                                    k2e = k2e << 16 | (char)currE;
                                    changeNext += Font.xAdvance(font, scaleX, currE) + (float)font.kerning.get(k2e, 0) * scaleX * (1.0f + 0.5f * (float)(-(currE & 0x6000000L) >> 63));
                                    ++k3;
                                }
                            }
                            if (earlier.width + changeNext < appendTo.getTargetWidth()) {
                                for (e2 = 0; e2 < ellipsis.length(); ++e2) {
                                    earlier.glyphs.add(current | (long)ellipsis.charAt(e2));
                                }
                                earlier.width += changeNext;
                                return appendTo;
                            }
                            if (!(earlier.width - change + changeNext < appendTo.getTargetWidth())) continue;
                            earlier.glyphs.truncate(j + 1);
                            for (e2 = 0; e2 < ellipsis.length(); ++e2) {
                                earlier.glyphs.add(current | (long)ellipsis.charAt(e2));
                            }
                            earlier.width = earlier.width - change + changeNext;
                            return appendTo;
                        }
                        continue;
                    }
                    for (int j2 = earlier.glyphs.size - 2; j2 >= 0; --j2) {
                        long curr = earlier.glyphs.get(j2);
                        if (curr >>> 32 != 0L && Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)curr) < 0) continue;
                        int leading = 0;
                        while (j2 > 0 && ((curr = earlier.glyphs.get(j2)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0)) {
                            ++leading;
                            --j2;
                        }
                        this.glyphBuffer.clear();
                        float change = 0.0f;
                        changeNext = 0.0f;
                        if (font.kerning == null) {
                            boolean curly = false;
                            for (int k4 = j2 + 1; k4 < earlier.glyphs.size; ++k4) {
                                curr = earlier.glyphs.get(k4);
                                if (curly) {
                                    this.glyphBuffer.add(curr);
                                    if ((char)curr == '{') {
                                        curly = false;
                                    } else {
                                        if ((char)curr != '}') continue;
                                        curly = false;
                                        continue;
                                    }
                                }
                                if ((char)curr == '{') {
                                    this.glyphBuffer.add(curr);
                                    curly = true;
                                    continue;
                                }
                                float adv = Font.xAdvance(font, scaleX, curr);
                                change += adv;
                                if (--leading >= 0) continue;
                                this.glyphBuffer.add(curr);
                                changeNext += adv;
                                if (appendTo.peekLine().glyphs.size != 1) continue;
                                float ox = ((GlyphRegion)((Object)font.mapping.get((int)((char)((int)curr)), (Object)((Object)font.defaultValue)))).offsetX * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                                if (ox < 0.0f) {
                                    changeNext -= ox;
                                }
                                initial = false;
                            }
                        } else {
                            int k2 = (int)earlier.glyphs.get(j2);
                            int k3 = -1;
                            boolean curly = false;
                            for (int k5 = j2 + 1; k5 < earlier.glyphs.size; ++k5) {
                                curr = earlier.glyphs.get(k5);
                                if (curly) {
                                    this.glyphBuffer.add(curr);
                                    if ((char)curr == '{') {
                                        curly = false;
                                    } else {
                                        if ((char)curr != '}') continue;
                                        curly = false;
                                        continue;
                                    }
                                }
                                if ((char)curr == '{') {
                                    this.glyphBuffer.add(curr);
                                    curly = true;
                                    continue;
                                }
                                k2 = k2 << 16 | (char)curr;
                                float adv = Font.xAdvance(font, scaleX, curr);
                                change += adv + (float)font.kerning.get(k2, 0) * scaleX * (1.0f + 0.5f * (float)(-(curr & 0x6000000L) >> 63));
                                if (--leading >= 0) continue;
                                k3 = k3 << 16 | (char)curr;
                                changeNext += adv + (float)font.kerning.get(k3, 0) * scaleX * (1.0f + 0.5f * (float)(-(curr & 0x6000000L) >> 63));
                                this.glyphBuffer.add(curr);
                                if (appendTo.peekLine().glyphs.size != 1) continue;
                                float ox = ((GlyphRegion)((Object)font.mapping.get((int)((char)((int)curr)), (Object)((Object)font.defaultValue)))).offsetX * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                                if (ox < 0.0f) {
                                    changeNext -= ox;
                                }
                                initial = false;
                            }
                        }
                        if (earlier.width - change > targetWidth) continue;
                        earlier.glyphs.truncate(j2 + 1);
                        earlier.glyphs.add(10L);
                        later.width = changeNext;
                        earlier.width -= change;
                        later.glyphs.addAll(this.glyphBuffer);
                        later.height = Math.max(later.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                        continue block21;
                    }
                    continue;
                }
                appendTo.peekLine().height = Math.max(appendTo.peekLine().height, font.cellHeight * (float)(scale + 1) * 0.25f);
                continue;
            }
            char ch = text.charAt(i);
            if (Font.isLowerCase(ch)) {
                if (capitalize && !previousWasLetter || capsLock) {
                    ch = Category.caseUp((char)ch);
                }
                previousWasLetter = true;
            } else if (Font.isUpperCase(ch)) {
                if (capitalize && previousWasLetter || lowerCase) {
                    ch = Category.caseDown((char)ch);
                }
                previousWasLetter = true;
            } else {
                previousWasLetter = false;
            }
            if (ch >= '\ue000' && ch < '\uf800') {
                scaleX = (float)(scale + 1) * 0.25f * this.cellHeight / (((GlyphRegion)((Object)font.mapping.get((int)ch, (Object)((Object)font.defaultValue)))).xAdvance * 1.25f);
            }
            if (font.kerning == null) {
                w = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)ch);
                if (initial) {
                    float ox = ((GlyphRegion)((Object)font.mapping.get((int)ch, (Object)((Object)font.defaultValue)))).offsetX * scaleX;
                    if (ox < 0.0f) {
                        w = appendTo.peekLine().width -= ox;
                    }
                    initial = false;
                }
            } else {
                kern = kern << 16 | ch;
                w = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)ch) + (float)font.kerning.get(kern, 0) * scaleX * (1.0f + 0.5f * (float)(-((current | (long)ch) & 0x6000000L) >> 63));
                if (initial) {
                    float ox = ((GlyphRegion)((Object)font.mapping.get((int)ch, (Object)((Object)font.defaultValue)))).offsetX * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                    if (ox < 0.0f) {
                        w = appendTo.peekLine().width -= ox;
                    }
                    initial = false;
                }
            }
            if (ch == '\n') {
                appendTo.peekLine().height = Math.max(appendTo.peekLine().height, font.cellHeight * (float)(scale + 1) * 0.25f);
                initial = true;
            }
            appendTo.add(current | (long)ch);
            if (targetWidth > 0.0f && w > targetWidth || appendTo.atLimit) {
                float change;
                Line later;
                Line earlier = appendTo.peekLine();
                if (appendTo.lines.size >= appendTo.maxLines) {
                    later = null;
                } else {
                    later = (Line)Line.POOL.obtain();
                    later.height = 0.0f;
                    appendTo.lines.add((Object)later);
                    initial = true;
                }
                if (later == null) {
                    String ellipsis = appendTo.ellipsis == null ? "" : appendTo.ellipsis;
                    for (int j3 = earlier.glyphs.size - 1; j3 >= 0; --j3) {
                        long curr;
                        while (j3 > 0 && ((curr = earlier.glyphs.get(j3)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) < 0)) {
                            --j3;
                        }
                        while (j3 > 0 && ((curr = earlier.glyphs.get(j3)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0)) {
                            --j3;
                        }
                        change = 0.0f;
                        float changeNext = 0.0f;
                        if (font.kerning == null) {
                            int k6 = j3 + 1;
                            for (int e4 = 0; e4 < ellipsis.length(); ++e4) {
                                if (k6 < earlier.glyphs.size) {
                                    change += Font.xAdvance(font, scaleX, earlier.glyphs.get(k6));
                                }
                                changeNext += Font.xAdvance(font, scaleX, current | (long)ellipsis.charAt(e4));
                                ++k6;
                            }
                        } else {
                            int k2 = (int)earlier.glyphs.get(j3) & 0xFFFF;
                            int k2e = 65535;
                            int k7 = j3 + 1;
                            for (int e5 = 0; e5 < ellipsis.length(); ++e5) {
                                if (k7 < earlier.glyphs.size) {
                                    curr = earlier.glyphs.get(k7);
                                    k2 = k2 << 16 | (char)curr;
                                    change += Font.xAdvance(font, scaleX, curr) + (float)font.kerning.get(k2, 0) * scaleX * (1.0f + 0.5f * (float)(-(curr & 0x6000000L) >> 63));
                                }
                                long currE = current | (long)ellipsis.charAt(e5);
                                k2e = k2e << 16 | (char)currE;
                                changeNext += Font.xAdvance(font, scaleX, currE) + (float)font.kerning.get(k2e, 0) * scaleX * (1.0f + 0.5f * (float)(-(currE & 0x6000000L) >> 63));
                                ++k7;
                            }
                        }
                        if (earlier.width + changeNext < appendTo.getTargetWidth()) {
                            for (e = 0; e < ellipsis.length(); ++e) {
                                earlier.glyphs.add(current | (long)ellipsis.charAt(e));
                            }
                            earlier.width += changeNext;
                            return appendTo;
                        }
                        if (!(earlier.width - change + changeNext < appendTo.getTargetWidth())) continue;
                        earlier.glyphs.truncate(j3 + 1);
                        for (e = 0; e < ellipsis.length(); ++e) {
                            earlier.glyphs.add(current | (long)ellipsis.charAt(e));
                        }
                        earlier.width = earlier.width - change + changeNext;
                        return appendTo;
                    }
                    continue;
                }
                for (j = earlier.glyphs.size - 2; j >= 0; --j) {
                    long curr = earlier.glyphs.get(j);
                    if (curr >>> 32 != 0L && Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)curr) < 0) continue;
                    int leading = 0;
                    while (j > 0 && ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0)) {
                        ++leading;
                        --j;
                    }
                    this.glyphBuffer.clear();
                    change = 0.0f;
                    float changeNext = 0.0f;
                    if (font.kerning == null) {
                        boolean curly = false;
                        for (k = j + 1; k < earlier.glyphs.size; ++k) {
                            curr = earlier.glyphs.get(k);
                            if (curly) {
                                this.glyphBuffer.add(curr);
                                if ((char)curr == '{') {
                                    curly = false;
                                } else {
                                    if ((char)curr != '}') continue;
                                    curly = false;
                                    continue;
                                }
                            }
                            if ((char)curr == '{') {
                                this.glyphBuffer.add(curr);
                                curly = true;
                                continue;
                            }
                            float adv = Font.xAdvance(font, scaleX, curr);
                            change += adv;
                            if (--leading >= 0) continue;
                            this.glyphBuffer.add(curr);
                            changeNext += adv;
                            if (appendTo.peekLine().glyphs.size != 1) continue;
                            float ox = ((GlyphRegion)((Object)font.mapping.get((int)((char)((int)curr)), (Object)((Object)font.defaultValue)))).offsetX * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                            if (ox < 0.0f) {
                                changeNext -= ox;
                            }
                            initial = false;
                        }
                    } else {
                        int k2 = (int)earlier.glyphs.get(j);
                        int k3 = -1;
                        boolean curly = false;
                        for (int k8 = j + 1; k8 < earlier.glyphs.size; ++k8) {
                            curr = earlier.glyphs.get(k8);
                            if (curly) {
                                this.glyphBuffer.add(curr);
                                if ((char)curr == '{') {
                                    curly = false;
                                } else {
                                    if ((char)curr != '}') continue;
                                    curly = false;
                                    continue;
                                }
                            }
                            if ((char)curr == '{') {
                                this.glyphBuffer.add(curr);
                                curly = true;
                                continue;
                            }
                            k2 = k2 << 16 | (char)curr;
                            float adv = Font.xAdvance(font, scaleX, curr);
                            change += adv + (float)font.kerning.get(k2, 0) * scaleX * (1.0f + 0.5f * (float)(-(curr & 0x6000000L) >> 63));
                            if (--leading >= 0) continue;
                            k3 = k3 << 16 | (char)curr;
                            changeNext += adv + (float)font.kerning.get(k3, 0) * scaleX * (1.0f + 0.5f * (float)(-(curr & 0x6000000L) >> 63));
                            this.glyphBuffer.add(curr);
                            if (appendTo.peekLine().glyphs.size != 1) continue;
                            float ox = ((GlyphRegion)((Object)font.mapping.get((int)((char)((int)curr)), (Object)((Object)font.defaultValue)))).offsetX * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                            if (ox < 0.0f) {
                                changeNext -= ox;
                            }
                            initial = false;
                        }
                    }
                    if (earlier.width - change > targetWidth) continue;
                    earlier.glyphs.truncate(j + 1);
                    earlier.glyphs.add(10L);
                    later.width = changeNext;
                    earlier.width -= change;
                    later.glyphs.addAll(this.glyphBuffer);
                    later.height = Math.max(later.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                    continue block21;
                }
                continue;
            }
            appendTo.peekLine().height = Math.max(appendTo.peekLine().height, font.cellHeight * (float)(scale + 1) * 0.25f);
        }
        return appendTo;
    }

    public long markupGlyph(char chr, String markup) {
        return Font.markupGlyph(chr, markup, this.colorLookup, this.family);
    }

    public static long markupGlyph(char chr, String markup, ColorLookup colorLookup) {
        return Font.markupGlyph(chr, markup, colorLookup, null);
    }

    public static long markupGlyph(char chr, String markup, ColorLookup colorLookup, FontFamily family) {
        long baseColor;
        long color;
        boolean capsLock = false;
        boolean lowerCase = false;
        long COLOR_MASK = -4294967296L;
        long current = color = (baseColor = 0xFFFFFFFE00000000L | (long)chr);
        int n = markup.length();
        block15: for (int i = 0; i < n; ++i) {
            char c;
            if (markup.charAt(i) != '[' || ++i >= n || (c = markup.charAt(i)) == '[') continue;
            if (c == ']') {
                current = color = baseColor;
                capsLock = false;
                lowerCase = false;
                continue;
            }
            int len = markup.indexOf(93, i) - i;
            if (len < 0) break;
            switch (c) {
                case '*': {
                    current ^= 0x40000000L;
                    continue block15;
                }
                case '/': {
                    current ^= 0x20000000L;
                    continue block15;
                }
                case '^': {
                    if ((current & 0x6000000L) == 0x6000000L) {
                        current &= 0xFFFFFFFFF9FFFFFFL;
                        continue block15;
                    }
                    current |= 0x6000000L;
                    continue block15;
                }
                case '.': {
                    if ((current & 0x6000000L) == 0x2000000L) {
                        current &= 0xFFFFFFFFFDFFFFFFL;
                        continue block15;
                    }
                    current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                    continue block15;
                }
                case '=': {
                    if ((current & 0x6000000L) == 0x4000000L) {
                        current &= 0xFFFFFFFFFBFFFFFFL;
                        continue block15;
                    }
                    current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                    continue block15;
                }
                case '_': {
                    current ^= 0x10000000L;
                    continue block15;
                }
                case '~': {
                    current ^= 0x8000000L;
                    continue block15;
                }
                case '!': 
                case ';': {
                    capsLock = !capsLock;
                    lowerCase = false;
                    continue block15;
                }
                case ',': {
                    lowerCase = !lowerCase;
                    capsLock = false;
                    continue block15;
                }
                case '%': {
                    if (len >= 2) {
                        current = current & 0xFFFFFFFFFF0FFFFFL | (long)((((Font.intFromDec(markup, i + 1, i + len) - 24) / 25 & 0xF) - 3 & 0xF) << 20);
                        continue block15;
                    }
                    current &= 0xFFFFFFFFFF0FFFFFL;
                    continue block15;
                }
                case '@': {
                    if (family == null) continue block15;
                    int fontIndex = family.fontAliases.get(Font.safeSubstring(markup, i + 1, i + len), 0);
                    current = current & 0xFFFFFFFFFFF0FFFFL | ((long)fontIndex & 0xFL) << 16;
                    continue block15;
                }
                case '#': {
                    color = len >= 7 && len < 9 ? Font.longFromHex(markup, i + 1, i + 7) << 40 | 0xFE00000000L : (len >= 9 ? Font.longFromHex(markup, i + 1, i + 9) << 32 & 0xFFFFFFFE00000000L : baseColor);
                    current = current & 0xFFFFFFFFL | color;
                    continue block15;
                }
                case '|': {
                    int lookupColor = colorLookup.getRgba(Font.safeSubstring(markup, i + 1, i + len)) & 0xFFFFFFFE;
                    color = lookupColor == 256 ? baseColor : (long)lookupColor << 32;
                    current = current & 0xFFFFFFFFL | color;
                    continue block15;
                }
                default: {
                    int gdxColor = colorLookup.getRgba(Font.safeSubstring(markup, i, i + len)) & 0xFFFFFFFE;
                    color = gdxColor == 256 ? baseColor : (long)gdxColor << 32;
                    current = current & 0xFFFFFFFFL | color;
                }
            }
        }
        return current;
    }

    public Layout regenerateLayout(Layout changing) {
        if (changing.font == null || !changing.font.equals(this)) {
            return changing;
        }
        Font font = null;
        float targetWidth = changing.getTargetWidth();
        int oldLength = changing.lines.size;
        Line firstLine = changing.getLine(0);
        for (int i = 1; i < oldLength; ++i) {
            firstLine.glyphs.addAll(changing.getLine((int)i).glyphs);
            Line.POOL.free((Object)changing.getLine(i));
        }
        changing.lines.truncate(1);
        for (int ln = 0; ln < changing.lines(); ++ln) {
            Line line = changing.getLine(ln);
            line.height = 0.0f;
            float drawn = 0.0f;
            int breakPoint = -2;
            int spacingPoint = -2;
            int spacingSpan = 0;
            LongArray glyphs = line.glyphs;
            boolean hasMultipleGaps = false;
            int kern = -1;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                long[] arr;
                int nextSize;
                int cutoff;
                float ox;
                float changedW;
                GlyphRegion tr;
                Line next;
                float scaleX;
                int scale;
                long glyph = glyphs.get(i);
                if (this.family != null) {
                    font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
                }
                if (font == null) {
                    font = this;
                }
                if ((glyph & 0xFFFFL) == 10L) {
                    glyphs.set(i, glyph ^= 7L);
                }
                if (font.kerning == null) {
                    scale = (int)(glyph + 0x300000L >>> 20 & 0xFL);
                    line.height = Math.max(line.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                    scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? (float)(scale + 1) * 0.25f * font.cellHeight / (((GlyphRegion)((Object)font.mapping.get((int)((char)((int)glyph)), (Object)((Object)font.defaultValue)))).xAdvance * 1.25f) : font.scaleX * (float)(scale + 1) * 0.25f;
                    if ((char)glyph == '\r') {
                        next = changing.pushLine();
                        glyphs.pop();
                        if (next == null) break;
                        next.height = Math.max(next.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                        long[] arr2 = next.glyphs.setSize(glyphs.size - i - 1);
                        System.arraycopy(glyphs.items, i + 1, arr2, 0, glyphs.size - i - 1);
                        glyphs.truncate(i);
                        glyphs.add(10L);
                        break;
                    }
                    tr = (GlyphRegion)((Object)font.mapping.get((int)((char)glyph)));
                    if (tr == null) continue;
                    changedW = tr.xAdvance * scaleX;
                    if (i == 0 && (ox = tr.offsetX * scaleX) < 0.0f) {
                        changedW -= ox;
                    }
                    if (!font.isMono && (glyph & 0x6000000L) != 0L) {
                        changedW *= 0.5f;
                    }
                    if (glyph >>> 32 == 0L) {
                        hasMultipleGaps = breakPoint >= 0;
                        breakPoint = i;
                        spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                        spacingPoint = i;
                    } else if (Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)glyph) >= 0) {
                        hasMultipleGaps = breakPoint >= 0;
                        breakPoint = i;
                        if (Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)glyph) >= 0) {
                            spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                            spacingPoint = i;
                        }
                    }
                    if (hasMultipleGaps && drawn + changedW > targetWidth) {
                        Line next2;
                        cutoff = breakPoint - spacingSpan + 1;
                        if (changing.lines() == ln + 1) {
                            next2 = changing.pushLine();
                            glyphs.pop();
                        } else {
                            next2 = changing.getLine(ln + 1);
                        }
                        if (next2 == null) {
                            glyphs.truncate(cutoff);
                            break;
                        }
                        next2.height = Math.max(next2.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                        nextSize = next2.glyphs.size;
                        arr = next2.glyphs.setSize(nextSize + glyphs.size - cutoff);
                        System.arraycopy(arr, 0, arr, glyphs.size - cutoff, nextSize);
                        System.arraycopy(glyphs.items, cutoff, arr, 0, glyphs.size - cutoff);
                        glyphs.truncate(cutoff);
                        break;
                    }
                    drawn += changedW;
                    continue;
                }
                scale = (int)(glyph + 0x300000L >>> 20 & 0xFL);
                line.height = Math.max(line.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? (float)(scale + 1) * 0.25f * font.cellHeight / (((GlyphRegion)((Object)font.mapping.get((int)((char)((int)glyph)), (Object)((Object)font.defaultValue)))).xAdvance * 1.25f) : font.scaleX * (float)(scale + 1) * 0.25f;
                kern = kern << 16 | (int)(glyph & 0xFFFFL);
                float amt = (float)font.kerning.get(kern, 0) * scaleX;
                if ((char)glyph == '\r') {
                    next = changing.pushLine();
                    glyphs.pop();
                    if (next == null) break;
                    next.height = Math.max(next.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                    long[] arr3 = next.glyphs.setSize(glyphs.size - i - 1);
                    System.arraycopy(glyphs.items, i + 1, arr3, 0, glyphs.size - i - 1);
                    glyphs.truncate(i);
                    glyphs.add(10L);
                    break;
                }
                tr = (GlyphRegion)((Object)font.mapping.get((int)((char)glyph)));
                if (tr == null) continue;
                changedW = tr.xAdvance * scaleX;
                if (i == 0 && (ox = tr.offsetX * scaleX) < 0.0f) {
                    changedW -= ox;
                }
                if (!font.isMono && (glyph & 0x6000000L) != 0L) {
                    changedW *= 0.5f;
                }
                if (glyph >>> 32 == 0L) {
                    hasMultipleGaps = breakPoint >= 0;
                    breakPoint = i;
                    spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                    spacingPoint = i;
                }
                if (Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)glyph) >= 0) {
                    hasMultipleGaps = breakPoint >= 0;
                    breakPoint = i;
                    if (Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)glyph) >= 0) {
                        spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                        spacingPoint = i;
                    }
                }
                if (hasMultipleGaps && drawn + changedW + amt > targetWidth) {
                    Line next3;
                    cutoff = breakPoint - spacingSpan + 1;
                    if (changing.lines() == ln + 1) {
                        next3 = changing.pushLine();
                        glyphs.pop();
                    } else {
                        next3 = changing.getLine(ln + 1);
                    }
                    if (next3 == null) {
                        glyphs.truncate(cutoff);
                        break;
                    }
                    next3.height = Math.max(next3.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                    nextSize = next3.glyphs.size;
                    arr = next3.glyphs.setSize(nextSize + glyphs.size - cutoff);
                    System.arraycopy(arr, 0, arr, glyphs.size - cutoff, nextSize);
                    System.arraycopy(glyphs.items, cutoff, arr, 0, glyphs.size - cutoff);
                    glyphs.truncate(cutoff);
                    break;
                }
                drawn += changedW + amt;
            }
            line.width = drawn;
        }
        return changing;
    }

    public Font setFamily(FontFamily family) {
        this.family = family;
        return this;
    }

    public void resizeDistanceField(int width, int height) {
        if (this.distanceField == DistanceFieldType.SDF) {
            this.actualCrispness = Gdx.graphics.getBackBufferWidth() == 0 || Gdx.graphics.getBackBufferHeight() == 0 ? this.distanceFieldCrispness : this.distanceFieldCrispness * (float)Math.pow(4.0, Math.max((float)width / (float)Gdx.graphics.getBackBufferWidth(), (float)height / (float)Gdx.graphics.getBackBufferHeight()) * 1.9f - 2.0f + this.cellHeight * 0.005f);
        } else if (this.distanceField == DistanceFieldType.MSDF) {
            this.actualCrispness = Gdx.graphics.getBackBufferWidth() == 0 || Gdx.graphics.getBackBufferHeight() == 0 ? this.distanceFieldCrispness : this.distanceFieldCrispness * (float)Math.pow(8.0, Math.max((float)width / (float)Gdx.graphics.getBackBufferWidth(), (float)height / (float)Gdx.graphics.getBackBufferHeight()) * 1.9f - 2.15f + this.cellHeight * 0.01f);
        }
    }

    public static int extractColor(long glyph) {
        return (int)(glyph >>> 32);
    }

    public static long applyColor(long glyph, int color) {
        return glyph & 0xFFFFFFFFL | (long)color << 32 & 0xFFFFFFFE00000000L;
    }

    public static long extractStyle(long glyph) {
        return glyph & 0x7E000000L;
    }

    public static long applyStyle(long glyph, long style) {
        return glyph & 0xFFFFFFFF81FFFFFFL | style & 0x7E000000L;
    }

    public static float extractScale(long glyph) {
        return (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
    }

    public static long applyScale(long glyph, float scale) {
        return glyph & 0xFFFFFFFFFF0FFFFFL | ((long)Math.floor((double)scale * 4.0 - 4.0) & 0xFL) << 20;
    }

    public static char extractChar(long glyph) {
        char c = (char)glyph;
        return c == '\u0002' ? (char)'[' : (char)c;
    }

    public static long applyChar(long glyph, char c) {
        return glyph & 0xFFFFFFFFFFFF0000L | (long)c;
    }

    public void dispose() {
        Layout.POOL.free((Object)this.tempLayout);
        if (this.shader != null) {
            this.shader.dispose();
        }
    }

    public String toString() {
        return "Font '" + this.name + "' at scale " + this.scaleX + " by " + this.scaleY;
    }

    public static enum DistanceFieldType {
        STANDARD,
        SDF,
        MSDF;

    }

    public static class FontFamily {
        public final Font[] connected = new Font[16];
        public final CaseInsensitiveIntMap fontAliases = new CaseInsensitiveIntMap(48);

        public FontFamily() {
        }

        public FontFamily(Font[] fonts) {
            this(fonts, 0, fonts.length);
        }

        public FontFamily(Font[] fonts, int offset, int length) {
            if (fonts == null || fonts.length == 0) {
                return;
            }
            int i = offset;
            int a = 0;
            while (i < length && i < fonts.length) {
                if (fonts[i] != null) {
                    this.connected[a & 0xF] = fonts[i];
                    if (fonts[i].name != null) {
                        this.fontAliases.put(fonts[i].name, a & 0xF);
                    }
                    this.fontAliases.put(String.valueOf(a & 0xF), a & 0xF);
                }
                ++i;
                ++a;
            }
        }

        public FontFamily(String[] aliases, Font[] fonts) {
            this(aliases, fonts, 0, Math.min(aliases.length, fonts.length));
        }

        public FontFamily(String[] aliases, Font[] fonts, int offset, int length) {
            if (aliases == null || fonts == null || (aliases.length & fonts.length) == 0) {
                return;
            }
            int i = offset;
            int a = 0;
            while (i < length && i < aliases.length && i < fonts.length) {
                if (fonts[i] != null) {
                    this.connected[a & 0xF] = fonts[i];
                    this.fontAliases.put(aliases[i], a & 0xF);
                    if (fonts[i].name != null) {
                        this.fontAliases.put(fonts[i].name, a & 0xF);
                    }
                    this.fontAliases.put(String.valueOf(a & 0xF), a & 0xF);
                }
                ++i;
                ++a;
            }
        }

        public FontFamily(OrderedMap<String, Font> map) {
            Array ks = map.orderedKeys();
            for (int i = 0; i < map.size && i < 16; ++i) {
                String name = (String)ks.get(i);
                this.connected[i] = (Font)map.get((Object)name);
                if (this.connected[i] == null) continue;
                this.fontAliases.put(name, i);
                this.fontAliases.put(this.connected[i].name, i);
                this.fontAliases.put(String.valueOf(i), i);
            }
        }

        public FontFamily(Skin skin) {
            ObjectMap map = skin.getAll(BitmapFont.class);
            Array keys = map.keys().toArray();
            for (int i = 0; i < map.size && i < 16; ++i) {
                String name = (String)keys.get(i);
                Font font = new Font((BitmapFont)map.get((Object)name));
                font.name = name;
                font.family = this;
                this.connected[i] = font;
                this.fontAliases.put(name, i);
                this.fontAliases.put(this.connected[i].name, i);
                this.fontAliases.put(String.valueOf(i), i);
            }
        }

        public FontFamily(FontFamily other) {
            System.arraycopy(other.connected, 0, this.connected, 0, 16);
            this.fontAliases.putAll(other.fontAliases);
        }

        public Font get(String name) {
            if (name == null) {
                return null;
            }
            return this.connected[this.fontAliases.get(name, 0) & 0xF];
        }
    }

    public static class GlyphRegion
    extends TextureRegion {
        public float offsetX;
        public float offsetY;
        public float xAdvance;

        public GlyphRegion(TextureRegion textureRegion) {
            this(textureRegion, 0.0f, 0.0f, textureRegion.getRegionWidth());
        }

        public GlyphRegion(TextureAtlas.AtlasRegion atlasRegion) {
            this((TextureRegion)atlasRegion, atlasRegion.offsetX, atlasRegion.offsetY, atlasRegion.originalHeight);
        }

        public GlyphRegion(TextureRegion textureRegion, float offsetX, float offsetY, float xAdvance) {
            super(textureRegion);
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.xAdvance = xAdvance;
        }

        public GlyphRegion(TextureRegion textureRegion, int x, int y, int width, int height) {
            super(textureRegion, x, y, width, height);
            this.offsetX = 0.0f;
            this.offsetY = 0.0f;
            this.xAdvance = width;
        }

        public GlyphRegion(GlyphRegion other) {
            super((TextureRegion)other);
            this.offsetX = other.offsetX;
            this.offsetY = other.offsetY;
            this.xAdvance = other.xAdvance;
        }

        public void flip(boolean x, boolean y) {
            super.flip(x, y);
            if (x) {
                this.offsetX = -this.offsetX;
                this.xAdvance = -this.xAdvance;
            }
            if (y) {
                this.offsetY = -this.offsetY;
            }
        }
    }
}

