/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Scaling;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TextraLabel;

public class ImageTextraButton
extends Button {
    private final Image image;
    private TextraLabel label;
    private ImageTextButton.ImageTextButtonStyle style;

    public ImageTextraButton(@Null String text, Skin skin) {
        this(text, (ImageTextButton.ImageTextButtonStyle)skin.get(ImageTextButton.ImageTextButtonStyle.class));
        this.setSkin(skin);
    }

    public ImageTextraButton(@Null String text, Skin skin, String styleName) {
        this(text, (ImageTextButton.ImageTextButtonStyle)skin.get(styleName, ImageTextButton.ImageTextButtonStyle.class));
        this.setSkin(skin);
    }

    public ImageTextraButton(@Null String text, ImageTextButton.ImageTextButtonStyle style) {
        super((Button.ButtonStyle)style);
        this.style = style;
        this.defaults().space(3.0f);
        this.image = this.newImage();
        this.label = this.newLabel(text, new Label.LabelStyle(style.font, style.fontColor));
        this.label.setAlignment(1);
        this.add((Actor)this.image);
        this.add((Actor)this.label);
        this.setStyle((Button.ButtonStyle)style);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public ImageTextraButton(@Null String text, Skin skin, Font replacementFont) {
        this(text, (ImageTextButton.ImageTextButtonStyle)skin.get(ImageTextButton.ImageTextButtonStyle.class), replacementFont);
        this.setSkin(skin);
    }

    public ImageTextraButton(@Null String text, Skin skin, String styleName, Font replacementFont) {
        this(text, (ImageTextButton.ImageTextButtonStyle)skin.get(styleName, ImageTextButton.ImageTextButtonStyle.class), replacementFont);
        this.setSkin(skin);
    }

    public ImageTextraButton(@Null String text, ImageTextButton.ImageTextButtonStyle style, Font replacementFont) {
        super((Button.ButtonStyle)style);
        this.style = style;
        this.defaults().space(3.0f);
        this.image = this.newImage();
        this.label = this.newLabel(text, replacementFont, style.fontColor);
        this.label.setAlignment(1);
        this.add((Actor)this.image);
        this.add((Actor)this.label);
        this.setStyle((Button.ButtonStyle)style, replacementFont);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    protected Image newImage() {
        return new Image(null, Scaling.fit);
    }

    protected TextraLabel newLabel(String text, Label.LabelStyle style) {
        return new TextraLabel(text, style);
    }

    protected TextraLabel newLabel(String text, Font font, Color color) {
        return new TextraLabel(text, font, color);
    }

    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof ImageTextButton.ImageTextButtonStyle)) {
            throw new IllegalArgumentException("style must be a ImageTextButtonStyle.");
        }
        this.style = (ImageTextButton.ImageTextButtonStyle)style;
        super.setStyle(style);
        if (this.image != null) {
            this.updateImage();
        }
        if (this.label != null) {
            ImageTextButton.ImageTextButtonStyle textButtonStyle = (ImageTextButton.ImageTextButtonStyle)style;
            this.label.font = new Font(textButtonStyle.font);
            Color c = this.getFontColor();
            if (c != null) {
                this.label.setColor(c);
            }
        }
    }

    public void setStyle(Button.ButtonStyle style, boolean makeGridGlyphs) {
        if (!(style instanceof ImageTextButton.ImageTextButtonStyle)) {
            throw new IllegalArgumentException("style must be a ImageTextButtonStyle.");
        }
        this.style = (ImageTextButton.ImageTextButtonStyle)style;
        super.setStyle(style);
        if (this.image != null) {
            this.updateImage();
        }
        if (this.label != null) {
            ImageTextButton.ImageTextButtonStyle textButtonStyle = (ImageTextButton.ImageTextButtonStyle)style;
            this.label.font = new Font(textButtonStyle.font, Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, makeGridGlyphs);
            Color c = this.getFontColor();
            if (c != null) {
                this.label.setColor(c);
            }
        }
    }

    public void setStyle(Button.ButtonStyle style, Font font) {
        if (!(style instanceof ImageTextButton.ImageTextButtonStyle)) {
            throw new IllegalArgumentException("style must be a ImageTextButtonStyle.");
        }
        this.style = (ImageTextButton.ImageTextButtonStyle)style;
        super.setStyle(style);
        if (this.image != null) {
            this.updateImage();
        }
        if (this.label != null) {
            this.label.font = font;
            Color c = this.getFontColor();
            if (c != null) {
                this.label.setColor(c);
            }
        }
    }

    public ImageTextButton.ImageTextButtonStyle getStyle() {
        return this.style;
    }

    @Null
    protected Drawable getImageDrawable() {
        if (this.isDisabled() && this.style.imageDisabled != null) {
            return this.style.imageDisabled;
        }
        if (this.isPressed()) {
            if (this.isChecked() && this.style.imageCheckedDown != null) {
                return this.style.imageCheckedDown;
            }
            if (this.style.imageDown != null) {
                return this.style.imageDown;
            }
        }
        if (this.isOver()) {
            if (this.isChecked()) {
                if (this.style.imageCheckedOver != null) {
                    return this.style.imageCheckedOver;
                }
            } else if (this.style.imageOver != null) {
                return this.style.imageOver;
            }
        }
        if (this.isChecked()) {
            if (this.style.imageChecked != null) {
                return this.style.imageChecked;
            }
            if (this.isOver() && this.style.imageOver != null) {
                return this.style.imageOver;
            }
        }
        return this.style.imageUp;
    }

    protected void updateImage() {
        this.image.setDrawable(this.getImageDrawable());
    }

    @Null
    protected Color getFontColor() {
        if (this.isDisabled() && this.style.disabledFontColor != null) {
            return this.style.disabledFontColor;
        }
        if (this.isPressed()) {
            if (this.isChecked() && this.style.checkedDownFontColor != null) {
                return this.style.checkedDownFontColor;
            }
            if (this.style.downFontColor != null) {
                return this.style.downFontColor;
            }
        }
        if (this.isOver()) {
            if (this.isChecked()) {
                if (this.style.checkedOverFontColor != null) {
                    return this.style.checkedOverFontColor;
                }
            } else if (this.style.overFontColor != null) {
                return this.style.overFontColor;
            }
        }
        boolean focused = this.hasKeyboardFocus();
        if (this.isChecked()) {
            if (focused && this.style.checkedFocusedFontColor != null) {
                return this.style.checkedFocusedFontColor;
            }
            if (this.style.checkedFontColor != null) {
                return this.style.checkedFontColor;
            }
            if (this.isOver() && this.style.overFontColor != null) {
                return this.style.overFontColor;
            }
        }
        if (focused && this.style.focusedFontColor != null) {
            return this.style.focusedFontColor;
        }
        return this.style.fontColor;
    }

    public void draw(Batch batch, float parentAlpha) {
        this.updateImage();
        Color c = this.getFontColor();
        if (c != null) {
            this.label.setColor(c);
        }
        super.draw(batch, parentAlpha);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell<?> getImageCell() {
        return this.getCell((Actor)this.image);
    }

    public void setLabel(TextraLabel label) {
        this.getLabelCell().setActor((Actor)label);
        this.label = label;
    }

    public TextraLabel getLabel() {
        return this.label;
    }

    public Cell<?> getLabelCell() {
        return this.getCell((Actor)this.label);
    }

    public void setText(CharSequence text) {
        this.label.setText(text.toString());
    }

    public String getText() {
        return this.label.toString();
    }

    public String toString() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        String className = ((Object)((Object)this)).getClass().getName();
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex != -1) {
            className = className.substring(dotIndex + 1);
        }
        return (className.indexOf(36) != -1 ? "ImageTextraButton " : "") + className + ": " + this.image.getDrawable() + " " + this.label.toString();
    }
}

