/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import regexodus.Category;

public class CaseInsensitiveIntMap
implements Iterable<Entry> {
    public int size;
    protected String[] keyTable;
    protected int[] valueTable;
    protected float loadFactor;
    protected int threshold;
    protected int shift;
    protected int mask;
    protected long hashMultiplier = -7046029254386353131L;
    protected transient Entries entries1;
    protected transient Entries entries2;
    protected transient Values values1;
    protected transient Values values2;
    protected transient Keys keys1;
    protected transient Keys keys2;

    public static int tableSize(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity must be >= 0: " + capacity);
        }
        int tableSize = 1 << -Integer.numberOfLeadingZeros(Math.max(2, (int)Math.ceil((float)capacity / loadFactor)) - 1);
        if (tableSize > 0x40000000 || tableSize < 0) {
            throw new IllegalArgumentException("The required capacity is too large: " + capacity);
        }
        return tableSize;
    }

    public CaseInsensitiveIntMap() {
        this(51, 0.6f);
    }

    public CaseInsensitiveIntMap(int initialCapacity) {
        this(initialCapacity, 0.6f);
    }

    public CaseInsensitiveIntMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = CaseInsensitiveIntMap.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new String[tableSize];
        this.valueTable = new int[tableSize];
    }

    public CaseInsensitiveIntMap(CaseInsensitiveIntMap map) {
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.size = map.size;
    }

    protected int place(String item) {
        int n;
        int h = n = item.length();
        for (int i = 0; i < n; ++i) {
            h = 1003 * h ^ Category.caseFold((char)item.charAt(i));
        }
        return (int)((long)h * this.hashMultiplier >>> this.shift);
    }

    int locateKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        String[] keyTable = this.keyTable;
        int i = this.place(key);
        String other;
        while ((other = keyTable[i]) != null) {
            if (other.equalsIgnoreCase(key)) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return ~i;
    }

    public void put(String key, int value) {
        int i = this.locateKey(key);
        if (i >= 0) {
            this.valueTable[i] = value;
            return;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
    }

    public int put(String key, int value, int defaultValue) {
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public void putAll(CaseInsensitiveIntMap map) {
        this.ensureCapacity(map.size);
        String[] keyTable = map.keyTable;
        int[] valueTable = map.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            String key = keyTable[i];
            if (key == null) continue;
            this.put(key, valueTable[i]);
        }
    }

    private void putResize(String key, int value) {
        String[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == null) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    public int get(String key, int defaultValue) {
        int i = this.locateKey(key);
        return i < 0 ? defaultValue : this.valueTable[i];
    }

    public int getAndIncrement(String key, int defaultValue, int increment) {
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            int n = i;
            this.valueTable[n] = this.valueTable[n] + increment;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = defaultValue + increment;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public int remove(String key, int defaultValue) {
        int i = this.locateKey(key);
        if (i < 0) {
            return defaultValue;
        }
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((key = keyTable[next]) != null) {
            int placement = this.place(key);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = key;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = null;
        --this.size;
        return oldValue;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = CaseInsensitiveIntMap.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = CaseInsensitiveIntMap.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
    }

    public boolean containsValue(int value) {
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            if (keyTable[i] == null || valueTable[i] != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String key) {
        return this.locateKey(key) >= 0;
    }

    public String findKey(int value) {
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            String key = keyTable[i];
            if (key == null || valueTable[i] != value) continue;
            return key;
        }
        return null;
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = CaseInsensitiveIntMap.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.hashMultiplier *= (long)(this.size + this.size) ^ 0xF1357AEA2E62A9C5L;
        String[] oldKeyTable = this.keyTable;
        int[] oldValueTable = this.valueTable;
        this.keyTable = new String[newSize];
        this.valueTable = new int[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                String key = oldKeyTable[i];
                if (key == null) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    public int hashCode() {
        int h = this.size;
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            String key = keyTable[i];
            if (key == null) continue;
            h += key.hashCode() + valueTable[i];
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CaseInsensitiveIntMap)) {
            return false;
        }
        CaseInsensitiveIntMap other = (CaseInsensitiveIntMap)obj;
        if (other.size != this.size) {
            return false;
        }
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            String key = keyTable[i];
            if (key == null) continue;
            int otherValue = other.get(key, 0);
            if (otherValue == 0 && !other.containsKey(key)) {
                return false;
            }
            if (otherValue == valueTable[i]) continue;
            return false;
        }
        return true;
    }

    public String toString(String separator) {
        return this.toString(separator, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    private String toString(String separator, boolean braces) {
        String key;
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int i = keyTable.length;
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
            break;
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            buffer.append(separator);
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    public Entries iterator() {
        return this.entries();
    }

    public Entries entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values values() {
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    public static class Keys
    extends MapIterator
    implements Iterable<String>,
    Iterator<String> {
        public Keys(CaseInsensitiveIntMap map) {
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public String next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            String key = this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        public Keys iterator() {
            return this;
        }

        public Array<String> toArray() {
            return this.toArray((Array<String>)new Array(true, this.map.size, String.class));
        }

        public Array<String> toArray(Array<String> array) {
            while (this.hasNext) {
                array.add((Object)this.next());
            }
            return array;
        }
    }

    public static class Values
    extends MapIterator {
        public Values(CaseInsensitiveIntMap map) {
            super(map);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return value;
        }

        public Values iterator() {
            return this;
        }

        public IntArray toArray() {
            IntArray array = new IntArray(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public IntArray toArray(IntArray array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }

    public static class Entries
    extends MapIterator
    implements Iterable<Entry>,
    Iterator<Entry> {
        Entry entry = new Entry();

        public Entries(CaseInsensitiveIntMap map) {
            super(map);
        }

        @Override
        public Entry next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            String[] keyTable = this.map.keyTable;
            this.entry.key = keyTable[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public Entries iterator() {
            return this;
        }
    }

    private static class MapIterator {
        public boolean hasNext;
        final CaseInsensitiveIntMap map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(CaseInsensitiveIntMap map) {
            this.map = map;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            String[] keyTable = this.map.keyTable;
            int n = keyTable.length;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == null) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        public void remove() {
            String key;
            int i = this.currentIndex;
            if (i < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            String[] keyTable = this.map.keyTable;
            int[] valueTable = this.map.valueTable;
            int mask = this.map.mask;
            int next = i + 1 & mask;
            while ((key = keyTable[next]) != null) {
                int placement = this.map.place(key);
                if ((next - placement & mask) > (i - placement & mask)) {
                    keyTable[i] = key;
                    valueTable[i] = valueTable[next];
                    i = next;
                }
                next = next + 1 & mask;
            }
            keyTable[i] = null;
            --this.map.size;
            if (i != this.currentIndex) {
                --this.nextIndex;
            }
            this.currentIndex = -1;
        }
    }

    public static class Entry {
        public String key;
        public int value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

