/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntArray;
import com.github.tommyettinger.textra.utils.Palette;

public class ColorUtils {
    private static final IntArray mixing = new IntArray(4);

    public static int hsl2rgb(float h, float s, float l, float a) {
        float x = Math.min(Math.max(Math.abs(h * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        float y = h + 0.6666667f;
        float z = h + 0.33333334f;
        y -= (float)((int)y);
        z -= (float)((int)z);
        y = Math.min(Math.max(Math.abs(y * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        z = Math.min(Math.max(Math.abs(z * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        float v = l + s * Math.min(l, 1.0f - l);
        float d = 2.0f * (1.0f - l / (v + 1.0E-10f));
        return Color.rgba8888((float)(v * MathUtils.lerp((float)1.0f, (float)x, (float)d)), (float)(v * MathUtils.lerp((float)1.0f, (float)y, (float)d)), (float)(v * MathUtils.lerp((float)1.0f, (float)z, (float)d)), (float)a);
    }

    public static int rgb2hsl(float r, float g, float b, float a) {
        float w;
        float z;
        float y;
        float x;
        if (g < b) {
            x = b;
            y = g;
            z = -1.0f;
            w = 0.6666667f;
        } else {
            x = g;
            y = b;
            z = 0.0f;
            w = -0.33333334f;
        }
        if (r < x) {
            z = w;
            w = r;
        } else {
            w = x;
            x = r;
        }
        float d = x - Math.min(w, y);
        float l = x * (1.0f - 0.5f * d / (x + 1.0E-10f));
        return Color.rgba8888((float)Math.abs(z + (w - y) / (6.0f * d + 1.0E-10f)), (float)((x - l) / (Math.min(l, 1.0f - l) + 1.0E-10f)), (float)l, (float)a);
    }

    public static int hsb2rgb(float h, float s, float b, float a) {
        float x = Math.min(Math.max(Math.abs(h * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        float y = h + 0.6666667f;
        float z = h + 0.33333334f;
        y -= (float)((int)y);
        z -= (float)((int)z);
        y = Math.min(Math.max(Math.abs(y * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        z = Math.min(Math.max(Math.abs(z * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        return Color.rgba8888((float)(b * MathUtils.lerp((float)1.0f, (float)x, (float)s)), (float)(b * MathUtils.lerp((float)1.0f, (float)y, (float)s)), (float)(b * MathUtils.lerp((float)1.0f, (float)z, (float)s)), (float)a);
    }

    public static int rgb2hsb(float r, float g, float b, float a) {
        float n;
        float v = Math.max(Math.max(r, g), b);
        float c = v - (n = Math.min(Math.min(r, g), b));
        float h = c == 0.0f ? 0.0f : (v == r ? (g - b) / c / 6.0f : (v == g ? ((b - r) / c + 2.0f) / 6.0f : ((r - g) / c + 4.0f) / 6.0f));
        return Color.rgba8888((float)h, (float)(v == 0.0f ? 0.0f : c / v), (float)v, (float)a);
    }

    public static float channel(int color, int channel) {
        return (float)(color >>> 24 - ((channel & 3) << 3) & 0xFF) / 255.0f;
    }

    public static float channelInt(int color, int channel) {
        return color >>> 24 - ((channel & 3) << 3) & 0xFF;
    }

    public static int lerpColors(int s, int e, float change) {
        int sR = s & 0xFF;
        int sG = s >>> 8 & 0xFF;
        int sB = s >>> 16 & 0xFF;
        int sA = s >>> 25 & 0x7F;
        int eR = e & 0xFF;
        int eG = e >>> 8 & 0xFF;
        int eB = e >>> 16 & 0xFF;
        int eA = e >>> 25 & 0x7F;
        return (int)((float)sR + change * (float)(eR - sR)) & 0xFF | ((int)((float)sG + change * (float)(eG - sG)) & 0xFF) << 8 | ((int)((float)sB + change * (float)(eB - sB)) & 0xFF) << 16 | ((int)((float)sA + change * (float)(eA - sA)) & 0x7F) << 25;
    }

    public static int mix(int[] colors, int offset, int size) {
        if (colors == null || colors.length < offset + size || offset < 0 || size <= 0) {
            return 256;
        }
        int result = colors[offset];
        int i = offset + 1;
        int o = offset + size;
        int denom = 2;
        while (i < o) {
            result = ColorUtils.lerpColors(result, colors[i], 1.0f / (float)denom);
            ++i;
            ++denom;
        }
        return result;
    }

    public static int lighten(int start, float change) {
        int r = start >>> 24;
        int g = start >>> 16 & 0xFF;
        int b = start >>> 8 & 0xFF;
        int a = start & 0xFE;
        return ((int)((float)r + (float)(255 - r) * change) & 0xFF) << 24 | ((int)((float)g + (float)(255 - g) * change) & 0xFF) << 16 | ((int)((float)b + (float)(255 - b) * change) & 0xFF) << 8 | a;
    }

    public static int darken(int start, float change) {
        int r = start >>> 24;
        int g = start >>> 16 & 0xFF;
        int b = start >>> 8 & 0xFF;
        int a = start & 0xFE;
        float ch = 1.0f - change;
        return ((int)((float)r * ch) & 0xFF) << 24 | ((int)((float)g * ch) & 0xFF) << 16 | ((int)((float)b * ch) & 0xFF) << 8 | a;
    }

    public static int dullen(int start, float change) {
        float rc = 0.32627f;
        float gc = 0.3678f;
        float bc = 0.30593002f;
        int r = start >>> 24;
        int g = start >>> 16 & 0xFF;
        int b = start >>> 8 & 0xFF;
        int a = start & 0xFE;
        float ch = 1.0f - change;
        float rw = change * 0.32627f;
        float gw = change * 0.3678f;
        float bw = change * 0.30593002f;
        return (int)Math.min(Math.max((float)r * (rw + ch) + (float)g * rw + (float)b * rw, 0.0f), 255.0f) << 24 | (int)Math.min(Math.max((float)r * gw + (float)g * (gw + ch) + (float)b * gw, 0.0f), 255.0f) << 16 | (int)Math.min(Math.max((float)r * bw + (float)g * bw + (float)b * (bw + ch), 0.0f), 255.0f) << 8 | a;
    }

    public static int enrich(int start, float change) {
        float rc = -0.32627f;
        float gc = -0.3678f;
        float bc = -0.30593002f;
        int r = start >>> 24;
        int g = start >>> 16 & 0xFF;
        int b = start >>> 8 & 0xFF;
        int a = start & 0xFE;
        float ch = 1.0f + change;
        float rw = change * -0.32627f;
        float gw = change * -0.3678f;
        float bw = change * -0.30593002f;
        return (int)Math.min(Math.max((float)r * (rw + ch) + (float)g * rw + (float)b * rw, 0.0f), 255.0f) << 24 | (int)Math.min(Math.max((float)r * gw + (float)g * (gw + ch) + (float)b * gw, 0.0f), 255.0f) << 16 | (int)Math.min(Math.max((float)r * bw + (float)g * bw + (float)b * (bw + ch), 0.0f), 255.0f) << 8 | a;
    }

    public static int multiplyAlpha(int color, float multiplier) {
        return color & 0xFFFFFF00 | Math.min(Math.max((int)((float)(color & 0xFF) * multiplier), 0), 255);
    }

    public static int[][] multiplyAllAlpha(int[][] colors, float multiplier) {
        for (int x = 0; x < colors.length; ++x) {
            for (int y = 0; y < colors[x].length; ++y) {
                colors[x][y] = ColorUtils.multiplyAlpha(colors[x][y], multiplier);
            }
        }
        return colors;
    }

    public static int describe(String description) {
        float lightness = 0.0f;
        float saturation = 0.0f;
        String[] terms = description.split("[^a-zA-Z_]+");
        mixing.clear();
        block29: for (String term : terms) {
            if (term == null || term.isEmpty()) continue;
            int len = term.length();
            switch (term.charAt(0)) {
                case 'L': 
                case 'l': {
                    if (len > 2 && (term.charAt(2) == 'g' || term.charAt(2) == 'G')) {
                        switch (len) {
                            case 9: {
                                lightness += 0.2f;
                            }
                            case 8: {
                                lightness += 0.2f;
                            }
                            case 7: {
                                lightness += 0.2f;
                            }
                            case 5: {
                                lightness += 0.2f;
                            }
                        }
                        continue block29;
                    }
                    mixing.add(Palette.NAMED.get((Object)term, 256));
                    continue block29;
                }
                case 'R': 
                case 'r': {
                    if (len > 1 && (term.charAt(1) == 'i' || term.charAt(1) == 'I')) {
                        switch (len) {
                            case 8: {
                                saturation += 0.2f;
                            }
                            case 7: {
                                saturation += 0.2f;
                            }
                            case 6: {
                                saturation += 0.2f;
                            }
                            case 4: {
                                saturation += 0.2f;
                            }
                        }
                        continue block29;
                    }
                    mixing.add(Palette.NAMED.get((Object)term, 256));
                    continue block29;
                }
                case 'D': 
                case 'd': {
                    if (len > 1 && (term.charAt(1) == 'a' || term.charAt(1) == 'A')) {
                        switch (len) {
                            case 8: {
                                lightness -= 0.2f;
                            }
                            case 7: {
                                lightness -= 0.2f;
                            }
                            case 6: {
                                lightness -= 0.2f;
                            }
                            case 4: {
                                lightness -= 0.2f;
                            }
                        }
                        continue block29;
                    }
                    if (len > 1 && (term.charAt(1) == 'u' || term.charAt(1) == 'U')) {
                        switch (len) {
                            case 8: {
                                saturation -= 0.2f;
                            }
                            case 7: {
                                saturation -= 0.2f;
                            }
                            case 6: {
                                saturation -= 0.2f;
                            }
                            case 4: {
                                saturation -= 0.2f;
                            }
                        }
                        continue block29;
                    }
                    mixing.add(Palette.NAMED.get((Object)term, 256));
                    continue block29;
                }
                default: {
                    mixing.add(Palette.NAMED.get((Object)term, 256));
                }
            }
        }
        int result = ColorUtils.mix(ColorUtils.mixing.items, 0, ColorUtils.mixing.size);
        if (result == 256) {
            return result;
        }
        if (lightness > 0.0f) {
            result = ColorUtils.lighten(result, lightness);
        } else if (lightness < 0.0f) {
            result = ColorUtils.darken(result, -lightness);
        }
        if (saturation > 0.0f) {
            result = ColorUtils.enrich(result, saturation);
        } else if (saturation < 0.0f) {
            result = ColorUtils.dullen(result, -saturation);
        }
        return result;
    }
}

