/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import com.badlogic.gdx.utils.Null;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TextraLabel;

public class TextraTooltip
extends Tooltip<TextraLabel> {
    public TextraTooltip(@Null String text, Skin skin) {
        this(text, TooltipManager.getInstance(), (TextTooltip.TextTooltipStyle)skin.get(TextTooltip.TextTooltipStyle.class));
    }

    public TextraTooltip(@Null String text, Skin skin, String styleName) {
        this(text, TooltipManager.getInstance(), (TextTooltip.TextTooltipStyle)skin.get(styleName, TextTooltip.TextTooltipStyle.class));
    }

    public TextraTooltip(@Null String text, TextTooltip.TextTooltipStyle style) {
        this(text, TooltipManager.getInstance(), style);
    }

    public TextraTooltip(@Null String text, TooltipManager manager, Skin skin) {
        this(text, manager, (TextTooltip.TextTooltipStyle)skin.get(TextTooltip.TextTooltipStyle.class));
    }

    public TextraTooltip(@Null String text, TooltipManager manager, Skin skin, String styleName) {
        this(text, manager, (TextTooltip.TextTooltipStyle)skin.get(styleName, TextTooltip.TextTooltipStyle.class));
    }

    public TextraTooltip(@Null String text, TooltipManager manager, TextTooltip.TextTooltipStyle style) {
        super(null, manager);
        TextraLabel label = this.newLabel(text, style.label);
        label.setAlignment(1);
        label.setWrap(true);
        label.layout.setTargetWidth(style.wrapWidth);
        this.getContainer().setActor((Actor)label);
        this.getContainer().width(style.wrapWidth);
        this.setStyle(style);
        label.setText(text);
    }

    public TextraTooltip(@Null String text, Skin skin, Font replacementFont) {
        this(text, TooltipManager.getInstance(), (TextTooltip.TextTooltipStyle)skin.get(TextTooltip.TextTooltipStyle.class), replacementFont);
    }

    public TextraTooltip(@Null String text, Skin skin, String styleName, Font replacementFont) {
        this(text, TooltipManager.getInstance(), (TextTooltip.TextTooltipStyle)skin.get(styleName, TextTooltip.TextTooltipStyle.class), replacementFont);
    }

    public TextraTooltip(@Null String text, TextTooltip.TextTooltipStyle style, Font replacementFont) {
        this(text, TooltipManager.getInstance(), style, replacementFont);
    }

    public TextraTooltip(@Null String text, TooltipManager manager, Skin skin, Font replacementFont) {
        this(text, manager, (TextTooltip.TextTooltipStyle)skin.get(TextTooltip.TextTooltipStyle.class), replacementFont);
    }

    public TextraTooltip(@Null String text, TooltipManager manager, Skin skin, String styleName, Font replacementFont) {
        this(text, manager, (TextTooltip.TextTooltipStyle)skin.get(styleName, TextTooltip.TextTooltipStyle.class), replacementFont);
    }

    public TextraTooltip(@Null String text, TooltipManager manager, TextTooltip.TextTooltipStyle style, Font replacementFont) {
        super(null, manager);
        TextraLabel label = this.newLabel(text, replacementFont, style.label.fontColor);
        label.setAlignment(1);
        label.setWrap(true);
        label.layout.setTargetWidth(style.wrapWidth);
        this.getContainer().setActor((Actor)label);
        this.getContainer().width(style.wrapWidth);
        this.setStyle(style, replacementFont);
        label.setText(text);
    }

    protected TextraLabel newLabel(String text, Label.LabelStyle style) {
        return new TextraLabel(text, style);
    }

    protected TextraLabel newLabel(String text, Font font) {
        return new TextraLabel(text, font);
    }

    protected TextraLabel newLabel(String text, Font font, Color color) {
        return color == null ? new TextraLabel(text, font) : new TextraLabel(text, font, color);
    }

    public void setStyle(TextTooltip.TextTooltipStyle style) {
        this.setStyle(style, false);
    }

    public void setStyle(TextTooltip.TextTooltipStyle style, boolean makeGridGlyphs) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        Container container = this.getContainer();
        ((TextraLabel)container.getActor()).font = new Font(style.label.font, Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, makeGridGlyphs);
        ((TextraLabel)container.getActor()).layout.targetWidth = style.wrapWidth;
        if (style.label.fontColor != null) {
            ((TextraLabel)container.getActor()).setColor(style.label.fontColor);
        }
        ((TextraLabel)container.getActor()).font.regenerateLayout(((TextraLabel)container.getActor()).layout);
        ((TextraLabel)container.getActor()).font.calculateSize(((TextraLabel)container.getActor()).layout);
        ((TextraLabel)container.getActor()).setWidth(((TextraLabel)container.getActor()).layout.getWidth());
        container.setBackground(style.background);
        container.maxWidth(style.wrapWidth);
    }

    public void setStyle(TextTooltip.TextTooltipStyle style, Font font) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        Container container = this.getContainer();
        ((TextraLabel)container.getActor()).font = font;
        ((TextraLabel)container.getActor()).layout.targetWidth = style.wrapWidth;
        if (style.label.fontColor != null) {
            ((TextraLabel)container.getActor()).setColor(style.label.fontColor);
        }
        font.regenerateLayout(((TextraLabel)container.getActor()).layout);
        font.calculateSize(((TextraLabel)container.getActor()).layout);
        ((TextraLabel)container.getActor()).setWidth(((TextraLabel)container.getActor()).layout.getWidth());
        container.setBackground(style.background);
        container.maxWidth(style.wrapWidth);
    }

    public void skipToTheEnd() {
        ((TextraLabel)this.getContainer().getActor()).skipToTheEnd();
    }
}

