/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.IntFloatMap;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.effects.AttentionEffect;
import com.github.tommyettinger.textra.effects.BlinkEffect;
import com.github.tommyettinger.textra.effects.CarouselEffect;
import com.github.tommyettinger.textra.effects.CrowdEffect;
import com.github.tommyettinger.textra.effects.EaseEffect;
import com.github.tommyettinger.textra.effects.EmergeEffect;
import com.github.tommyettinger.textra.effects.FadeEffect;
import com.github.tommyettinger.textra.effects.GradientEffect;
import com.github.tommyettinger.textra.effects.HangEffect;
import com.github.tommyettinger.textra.effects.HeartbeatEffect;
import com.github.tommyettinger.textra.effects.HighlightEffect;
import com.github.tommyettinger.textra.effects.JoltEffect;
import com.github.tommyettinger.textra.effects.JumpEffect;
import com.github.tommyettinger.textra.effects.LinkEffect;
import com.github.tommyettinger.textra.effects.RainbowEffect;
import com.github.tommyettinger.textra.effects.RotateEffect;
import com.github.tommyettinger.textra.effects.ScaleEffect;
import com.github.tommyettinger.textra.effects.ShakeEffect;
import com.github.tommyettinger.textra.effects.ShrinkEffect;
import com.github.tommyettinger.textra.effects.SickEffect;
import com.github.tommyettinger.textra.effects.SlideEffect;
import com.github.tommyettinger.textra.effects.SpinEffect;
import com.github.tommyettinger.textra.effects.SpiralEffect;
import com.github.tommyettinger.textra.effects.SquashEffect;
import com.github.tommyettinger.textra.effects.TriggerEffect;
import com.github.tommyettinger.textra.effects.WaveEffect;
import com.github.tommyettinger.textra.effects.WindEffect;

public class TypingConfig {
    public static float DEFAULT_WAIT_VALUE = 0.25f;
    public static float DEFAULT_SPEED_PER_CHAR = 0.035f;
    public static float MIN_SPEED_MODIFIER = 0.001f;
    public static float MAX_SPEED_MODIFIER = 100.0f;
    public static int CHAR_LIMIT_PER_FRAME = -1;
    public static Color DEFAULT_CLEAR_COLOR = new Color(Color.WHITE);
    public static IntFloatMap INTERVAL_MULTIPLIERS_BY_CHAR = new IntFloatMap();
    public static final ObjectMap<String, String> GLOBAL_VARS = new ObjectMap();
    static final OrderedMap<String, Class<? extends Effect>> EFFECT_START_TOKENS = new OrderedMap();
    static final OrderedMap<String, Class<? extends Effect>> EFFECT_END_TOKENS = new OrderedMap();
    static boolean dirtyEffectMaps = true;

    public static void registerEffect(String startTokenName, String endTokenName, Class<? extends Effect> effectClass) {
        EFFECT_START_TOKENS.put((Object)startTokenName.toUpperCase(), effectClass);
        EFFECT_END_TOKENS.put((Object)endTokenName.toUpperCase(), effectClass);
        dirtyEffectMaps = true;
    }

    public static void unregisterEffect(String startTokenName, String endTokenName) {
        EFFECT_START_TOKENS.remove((Object)startTokenName.toUpperCase());
        EFFECT_END_TOKENS.remove((Object)endTokenName.toUpperCase());
        dirtyEffectMaps = true;
    }

    static {
        INTERVAL_MULTIPLIERS_BY_CHAR.put(32, 0.0f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(58, 1.5f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(44, 2.5f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(46, 2.5f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(33, 5.0f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(63, 5.0f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(10, 2.5f);
        TypingConfig.registerEffect("EASE", "ENDEASE", EaseEffect.class);
        TypingConfig.registerEffect("HANG", "ENDHANG", HangEffect.class);
        TypingConfig.registerEffect("JUMP", "ENDJUMP", JumpEffect.class);
        TypingConfig.registerEffect("SHAKE", "ENDSHAKE", ShakeEffect.class);
        TypingConfig.registerEffect("SICK", "ENDSICK", SickEffect.class);
        TypingConfig.registerEffect("SLIDE", "ENDSLIDE", SlideEffect.class);
        TypingConfig.registerEffect("WAVE", "ENDWAVE", WaveEffect.class);
        TypingConfig.registerEffect("WIND", "ENDWIND", WindEffect.class);
        TypingConfig.registerEffect("RAINBOW", "ENDRAINBOW", RainbowEffect.class);
        TypingConfig.registerEffect("GRADIENT", "ENDGRADIENT", GradientEffect.class);
        TypingConfig.registerEffect("FADE", "ENDFADE", FadeEffect.class);
        TypingConfig.registerEffect("BLINK", "ENDBLINK", BlinkEffect.class);
        TypingConfig.registerEffect("JOLT", "ENDJOLT", JoltEffect.class);
        TypingConfig.registerEffect("SPIRAL", "ENDSPIRAL", SpiralEffect.class);
        TypingConfig.registerEffect("SPIN", "ENDSPIN", SpinEffect.class);
        TypingConfig.registerEffect("CROWD", "ENDCROWD", CrowdEffect.class);
        TypingConfig.registerEffect("SHRINK", "ENDSHRINK", ShrinkEffect.class);
        TypingConfig.registerEffect("EMERGE", "ENDEMERGE", EmergeEffect.class);
        TypingConfig.registerEffect("HEARTBEAT", "ENDHEARTBEAT", HeartbeatEffect.class);
        TypingConfig.registerEffect("CAROUSEL", "ENDCAROUSEL", CarouselEffect.class);
        TypingConfig.registerEffect("SQUASH", "ENDSQUASH", SquashEffect.class);
        TypingConfig.registerEffect("SCALE", "ENDSCALE", ScaleEffect.class);
        TypingConfig.registerEffect("ROTATE", "ENDROTATE", RotateEffect.class);
        TypingConfig.registerEffect("HIGHLIGHT", "ENDHIGHLIGHT", HighlightEffect.class);
        TypingConfig.registerEffect("LINK", "ENDLINK", LinkEffect.class);
        TypingConfig.registerEffect("TRIGGER", "ENDTRIGGER", TriggerEffect.class);
        TypingConfig.registerEffect("ATTENTION", "ENDATTENTION", AttentionEffect.class);
    }
}

