/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.utils;

import com.badlogic.gdx.math.MathUtils;
import java.util.Random;

public final class StringUtils {
    private StringUtils() {
    }

    public static String join(CharSequence delimiter, CharSequence ... items) {
        if (items == null || items.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(items[0]);
        for (int i = 1; i < items.length; ++i) {
            sb.append(delimiter).append(items[i]);
        }
        return sb.toString();
    }

    public static String shuffleWords(String text) {
        return StringUtils.shuffleWords(text, MathUtils.random);
    }

    public static String shuffleWords(String text, Random generator) {
        CharSequence[] items = text.split("\\s+");
        int length = items.length;
        for (int i = length - 1; i > 0; --i) {
            int ii = generator.nextInt(i + 1);
            CharSequence temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
        return StringUtils.join(" ", items);
    }
}

