/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.github.tommyettinger.textra.ColorLookup;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.InternalToken;
import com.github.tommyettinger.textra.TokenCategory;
import com.github.tommyettinger.textra.TokenEntry;
import com.github.tommyettinger.textra.TypingConfig;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.CaseInsensitiveIntMap;
import com.github.tommyettinger.textra.utils.Palette;
import regexodus.Matcher;
import regexodus.Pattern;
import regexodus.Replacer;

class Parser {
    private static final Pattern PATTERN_MARKUP_STRIP = Pattern.compile((String)"((?<!\\[)\\[[^\\[\\]]*(\\]|$))");
    private static final Replacer MARKUP_TO_TAG = new Replacer(Pattern.compile((String)"(?<!\\[)\\[([^\\[\\]\\+][^\\[\\]]*)(\\]|$)"), "{STYLE=$1}");
    private static final Pattern PATTERN_COLOR_HEX_NO_HASH = Pattern.compile((String)"[A-Fa-f0-9]{6,8}");
    private static final CaseInsensitiveIntMap BOOLEAN_TRUE = new CaseInsensitiveIntMap(new String[]{"true", "yes", "t", "y", "on", "1"}, new int[6]);
    private static final int INDEX_TOKEN = 1;
    private static final int INDEX_PARAM = 2;
    private static Pattern PATTERN_TOKEN_STRIP;
    private static String RESET_REPLACEMENT;

    Parser() {
    }

    static String preprocess(CharSequence text) {
        return MARKUP_TO_TAG.replace(text).replace("[]", "{RESET}");
    }

    static void parseTokens(TypingLabel label) {
        if (PATTERN_TOKEN_STRIP == null || TypingConfig.dirtyEffectMaps) {
            PATTERN_TOKEN_STRIP = Parser.compileTokenPattern();
        }
        if (RESET_REPLACEMENT == null || TypingConfig.dirtyEffectMaps) {
            RESET_REPLACEMENT = Parser.getResetReplacement();
        }
        label.tokenEntries.clear();
        Parser.parseReplacements(label);
        Parser.parseRegularTokens(label);
        label.setText(label.getIntermediateText().toString(), false, false);
        label.tokenEntries.sort();
    }

    private static void parseReplacements(TypingLabel label) {
        CharSequence text = label.workingLayout.appendIntoDirect(new StringBuilder());
        StringBuilder sb = new StringBuilder(text.length());
        Matcher m = PATTERN_TOKEN_STRIP.matcher(text);
        int matcherIndexOffset = 0;
        block10: while (true) {
            String replacement;
            sb.setLength(0);
            m.setTarget(text);
            m.setPosition(matcherIndexOffset);
            if (!m.find()) break;
            InternalToken internalToken = InternalToken.fromName(m.group(1));
            String param = m.group(2);
            if (internalToken == null) {
                ++matcherIndexOffset;
                continue;
            }
            switch (internalToken) {
                case COLOR: {
                    replacement = Parser.stringToColorMarkup(param);
                    break;
                }
                case STYLE: 
                case SIZE: {
                    replacement = Parser.stringToStyleMarkup(param);
                    break;
                }
                case FONT: {
                    replacement = "[@" + param + ']';
                    break;
                }
                case ENDCOLOR: 
                case CLEARCOLOR: {
                    replacement = "[#" + label.getClearColor().toString() + ']';
                    break;
                }
                case CLEARSIZE: {
                    replacement = "[%]";
                    break;
                }
                case CLEARFONT: {
                    replacement = "[@]";
                    break;
                }
                case VAR: {
                    replacement = null;
                    if (label.getTypingListener() != null) {
                        replacement = label.getTypingListener().replaceVariable(param);
                    }
                    if (replacement == null) {
                        replacement = (String)label.getVariables().get((Object)param.toUpperCase());
                    }
                    if (replacement == null) {
                        replacement = (String)TypingConfig.GLOBAL_VARS.get((Object)param.toUpperCase());
                    }
                    if (replacement != null) break;
                    replacement = param.toUpperCase();
                    break;
                }
                case RESET: {
                    replacement = RESET_REPLACEMENT + label.getDefaultToken();
                    break;
                }
                default: {
                    ++matcherIndexOffset;
                    continue block10;
                }
            }
            m.setPosition(m.start());
            text = m.replaceFirst(replacement);
        }
        label.setIntermediateText(text, false, false);
    }

    private static void parseRegularTokens(TypingLabel label) {
        String text = PATTERN_MARKUP_STRIP.matcher((CharSequence)label.getIntermediateText()).replaceAll("");
        CharSequence text2 = label.getIntermediateText();
        Matcher m = PATTERN_TOKEN_STRIP.matcher((CharSequence)text);
        Matcher m2 = PATTERN_TOKEN_STRIP.matcher(text2);
        int matcherIndexOffset = 0;
        int m2IndexOffset = 0;
        while (true) {
            m.setTarget((CharSequence)text);
            m2.setTarget(text2);
            m2.setPosition(m2IndexOffset);
            m.setPosition(matcherIndexOffset);
            if (!m.find()) break;
            m2.find();
            String tokenName = m.group(1).toUpperCase();
            TokenCategory tokenCategory = null;
            InternalToken tmpToken = InternalToken.fromName(tokenName);
            if (tmpToken == null) {
                if (TypingConfig.EFFECT_START_TOKENS.containsKey((Object)tokenName)) {
                    tokenCategory = TokenCategory.EFFECT_START;
                } else if (TypingConfig.EFFECT_END_TOKENS.containsKey((Object)tokenName)) {
                    tokenCategory = TokenCategory.EFFECT_END;
                }
            } else {
                tokenCategory = tmpToken.category;
            }
            int groupCount = m.groupCount();
            String paramsString = groupCount == 2 ? m.group(2) : null;
            String[] params = paramsString == null ? new String[]{} : paramsString.split(";");
            String firstParam = params.length > 0 ? params[0] : null;
            int index = m.start(0);
            int indexOffset = 0;
            if (tokenCategory == null) {
                ++matcherIndexOffset;
                continue;
            }
            float floatValue = 0.0f;
            String stringValue = null;
            Effect effect = null;
            block1 : switch (tokenCategory) {
                case WAIT: {
                    floatValue = Parser.stringToFloat(firstParam, TypingConfig.DEFAULT_WAIT_VALUE);
                    break;
                }
                case EVENT: {
                    stringValue = paramsString;
                    break;
                }
                case SPEED: {
                    switch (tokenName) {
                        case "SPEED": {
                            float minModifier = TypingConfig.MIN_SPEED_MODIFIER;
                            float maxModifier = TypingConfig.MAX_SPEED_MODIFIER;
                            float modifier = MathUtils.clamp((float)Parser.stringToFloat(firstParam, 1.0f), (float)minModifier, (float)maxModifier);
                            floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR / modifier;
                            break block1;
                        }
                        case "SLOWER": {
                            floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR / 0.5f;
                            break block1;
                        }
                        case "SLOW": {
                            floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR / 0.667f;
                            break block1;
                        }
                        case "NORMAL": {
                            floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR;
                            break block1;
                        }
                        case "FAST": {
                            floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR / 2.0f;
                            break block1;
                        }
                        case "FASTER": {
                            floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR / 4.0f;
                            break block1;
                        }
                        case "NATURAL": {
                            float minModifier = TypingConfig.MIN_SPEED_MODIFIER;
                            float maxModifier = TypingConfig.MAX_SPEED_MODIFIER;
                            float modifier = MathUtils.clamp((float)Parser.stringToFloat(firstParam, 1.0f), (float)minModifier, (float)maxModifier);
                            floatValue = -TypingConfig.DEFAULT_SPEED_PER_CHAR / modifier;
                            break block1;
                        }
                    }
                    break;
                }
                case EFFECT_START: {
                    Class clazz = (Class)TypingConfig.EFFECT_START_TOKENS.get((Object)tokenName.toUpperCase());
                    try {
                        if (clazz == null) break;
                        Constructor constructor = ClassReflection.getConstructors((Class)clazz)[0];
                        int constructorParamCount = constructor.getParameterTypes().length;
                        if (constructorParamCount >= 2) {
                            effect = (Effect)constructor.newInstance(new Object[]{label, params});
                            break;
                        }
                        effect = (Effect)constructor.newInstance(new Object[]{label});
                        break;
                    }
                    catch (ReflectionException e) {
                        String message = "Failed to initialize " + tokenName + " effect token. Make sure the associated class (" + clazz + ") has only one constructor with TypingLabel as first parameter and optionally String[] as second.";
                        throw new IllegalStateException(message, e);
                    }
                }
            }
            TokenEntry entry = new TokenEntry(tokenName, tokenCategory, index + indexOffset, m.end(0), floatValue, stringValue);
            entry.effect = effect;
            label.tokenEntries.add((Object)entry);
            matcherIndexOffset = m.end();
            m2.setPosition(0);
            text2 = m2.replaceFirst("");
        }
        label.setIntermediateText(text2, false, false);
    }

    private static void parseColorMarkups(TypingLabel label) {
        StringBuilder text = label.getOriginalText();
        Matcher m = PATTERN_MARKUP_STRIP.matcher((CharSequence)text);
        while (m.find()) {
            String tag = m.group(0);
            int index = m.start(0);
            label.tokenEntries.add((Object)new TokenEntry("SKIP", TokenCategory.SKIP, index, m.end(0), 0.0f, tag));
        }
    }

    static float stringToFloat(String str, float defaultValue) {
        if (str != null) {
            try {
                return Float.parseFloat(str.replaceAll("[^\\d.\\-+]", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    static boolean stringToBoolean(String str) {
        if (str != null) {
            return BOOLEAN_TRUE.containsKey(str);
        }
        return false;
    }

    static int stringToColor(TypingLabel label, String str) {
        if (str != null) {
            int namedColor;
            ColorLookup lookup = label.getFont().getColorLookup();
            if (lookup != null && (namedColor = lookup.getRgba(str)) != 256) {
                return namedColor;
            }
            if (str.length() >= 6) {
                try {
                    if (str.startsWith("#")) {
                        str = str.substring(1);
                    }
                    if (str.length() >= 8) {
                        return Font.intFromHex(str, 0, 8);
                    }
                    if (str.length() >= 6) {
                        return Font.intFromHex(str, 0, 6) << 8 | 0xFF;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return 256;
    }

    private static String stringToColorMarkup(String str) {
        if (str != null && str.length() >= 6 && !Palette.NAMED.containsKey((Object)str) && PATTERN_COLOR_HEX_NO_HASH.matches(str)) {
            return "[#" + str + "]";
        }
        return "[" + str + "]";
    }

    private static String stringToStyleMarkup(String str) {
        if (str != null) {
            if (str.isEmpty()) {
                return "[]";
            }
            if (str.equals("*") || str.equalsIgnoreCase("B") || str.equalsIgnoreCase("BOLD") || str.equalsIgnoreCase("STRONG")) {
                return "[*]";
            }
            if (str.equals("/") || str.equalsIgnoreCase("I") || str.equalsIgnoreCase("OBLIQUE") || str.equalsIgnoreCase("ITALIC")) {
                return "[/]";
            }
            if (str.equals("_") || str.equalsIgnoreCase("U") || str.equalsIgnoreCase("UNDER") || str.equalsIgnoreCase("UNDERLINE")) {
                return "[_]";
            }
            if (str.equals("~") || str.equalsIgnoreCase("STRIKE") || str.equalsIgnoreCase("STRIKETHROUGH")) {
                return "[~]";
            }
            if (str.equals(".") || str.equalsIgnoreCase("SUB") || str.equalsIgnoreCase("SUBSCRIPT")) {
                return "[.]";
            }
            if (str.equals("=") || str.equalsIgnoreCase("MID") || str.equalsIgnoreCase("MIDSCRIPT")) {
                return "[=]";
            }
            if (str.equals("^") || str.equalsIgnoreCase("SUPER") || str.equalsIgnoreCase("SUPERSCRIPT")) {
                return "[^]";
            }
            if (str.equals("!") || str.equalsIgnoreCase("UP") || str.equalsIgnoreCase("UPPER")) {
                return "[!]";
            }
            if (str.equals(",") || str.equalsIgnoreCase("LOW") || str.equalsIgnoreCase("LOWER")) {
                return "[,]";
            }
            if (str.equals(";") || str.equalsIgnoreCase("EACH") || str.equalsIgnoreCase("TITLE")) {
                return "[;]";
            }
            if (str.equals("@") || str.equalsIgnoreCase("NOFONT") || str.equalsIgnoreCase("ENDFONT")) {
                return "[@]";
            }
            if (str.equalsIgnoreCase("JOSTLE") || str.equalsIgnoreCase("WOBBLE") || str.equalsIgnoreCase("SCATTER")) {
                return "[%?]";
            }
            if (str.equalsIgnoreCase("BLACK OUTLINE") || str.equalsIgnoreCase("BLACKEN")) {
                return "[%?black outline]";
            }
            if (str.equalsIgnoreCase("WHITE OUTLINE") || str.equalsIgnoreCase("WHITEN")) {
                return "[%?white outline]";
            }
            if (str.equalsIgnoreCase("SHINY") || str.equalsIgnoreCase("SHINE") || str.equalsIgnoreCase("GLOSSY")) {
                return "[%?shiny]";
            }
            if (str.equalsIgnoreCase("SHADOW") || str.equalsIgnoreCase("DROPSHADOW") || str.equalsIgnoreCase("DROP SHADOW")) {
                return "[%?shadow]";
            }
            if (str.equalsIgnoreCase("ERROR") || str.equalsIgnoreCase("REDLINE") || str.equalsIgnoreCase("RED LINE")) {
                return "[%?error]";
            }
            if (str.equalsIgnoreCase("WARN") || str.equalsIgnoreCase("YELLOWLINE") || str.equalsIgnoreCase("YELLOW LINE")) {
                return "[%?warn]";
            }
            if (str.equalsIgnoreCase("NOTE") || str.equalsIgnoreCase("INFO") || str.equalsIgnoreCase("BLUELINE") || str.equalsIgnoreCase("BLUE LINE")) {
                return "[%?note]";
            }
            if (str.equalsIgnoreCase("SMALLCAPS") || str.equalsIgnoreCase("SMALL CAPS")) {
                return "[%^]";
            }
            if (str.equals("%") || str.equalsIgnoreCase("NOSCALE") || str.equalsIgnoreCase("ENDSCALE") || str.equalsIgnoreCase("NOMODE") || str.equalsIgnoreCase("ENDMODE")) {
                return "[%]";
            }
            if (str.startsWith("@")) {
                return "[@" + str.substring(1) + "]";
            }
            if (str.endsWith("%")) {
                return "[%" + str.substring(0, str.length() - 1) + "]";
            }
            if (str.startsWith("%")) {
                return "[%" + str.substring(1) + "]";
            }
            if (str.length() >= 6 && !Colors.getColors().containsKey((Object)str) && PATTERN_COLOR_HEX_NO_HASH.matches(str)) {
                return "[#" + str + "]";
            }
        }
        return "[" + str + "]";
    }

    private static Pattern compileTokenPattern() {
        StringBuilder sb = new StringBuilder();
        sb.append("\\{(");
        Array tokens = new Array();
        TypingConfig.EFFECT_START_TOKENS.keys().toArray(tokens);
        TypingConfig.EFFECT_END_TOKENS.keys().toArray(tokens);
        for (InternalToken token : InternalToken.values()) {
            tokens.add((Object)token.name);
        }
        for (int i = 0; i < tokens.size; ++i) {
            sb.append((String)tokens.get(i));
            if (i + 1 >= tokens.size) continue;
            sb.append('|');
        }
        sb.append(")(?:\\=([^\\{\\}]+))?\\}");
        return Pattern.compile((String)sb.toString(), (int)1);
    }

    private static String getResetReplacement() {
        Array tokens = new Array();
        TypingConfig.EFFECT_END_TOKENS.keys().toArray(tokens);
        tokens.add((Object)"NORMAL");
        StringBuilder sb = new StringBuilder("[]");
        for (String token : tokens) {
            sb.append('{').append(token).append('}');
        }
        TypingConfig.dirtyEffectMaps = false;
        return sb.toString();
    }
}

