/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;
import com.badlogic.gdx.utils.Align;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Layout;
import com.github.tommyettinger.textra.Line;

public class TextraLabel
extends Widget {
    public Layout layout;
    protected Font font;
    public int align = 8;
    public boolean wrap = false;
    public String storedText;
    public Label.LabelStyle style;

    public TextraLabel() {
        this.layout = (Layout)Layout.POOL.obtain();
        this.font = new Font();
    }

    public TextraLabel(String text, Skin skin) {
        this(text, (Label.LabelStyle)skin.get(Label.LabelStyle.class));
    }

    public TextraLabel(String text, Skin skin, boolean makeGridGlyphs) {
        this(text, (Label.LabelStyle)skin.get(Label.LabelStyle.class), makeGridGlyphs);
    }

    public TextraLabel(String text, Skin skin, String styleName) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class));
    }

    public TextraLabel(String text, Skin skin, String styleName, boolean makeGridGlyphs) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class), makeGridGlyphs);
    }

    public TextraLabel(String text, Skin skin, String styleName, Color color) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class));
        if (color != null) {
            this.layout.setBaseColor(color);
        }
    }

    public TextraLabel(String text, Skin skin, String styleName, String colorName) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class));
        Color color = (Color)skin.get(colorName, Color.class);
        if (color != null) {
            this.layout.setBaseColor(color);
        }
    }

    public TextraLabel(String text, Label.LabelStyle style) {
        this(text, style, false);
    }

    public TextraLabel(String text, Label.LabelStyle style, boolean makeGridGlyphs) {
        this(text, style, new Font(style.font, Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, makeGridGlyphs));
    }

    public TextraLabel(String text, Skin skin, Font replacementFont) {
        this(text, (Label.LabelStyle)skin.get(Label.LabelStyle.class), replacementFont);
    }

    public TextraLabel(String text, Skin skin, String styleName, Font replacementFont) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class), replacementFont);
    }

    public TextraLabel(String text, Skin skin, String styleName, Font replacementFont, Color color) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class), replacementFont);
        if (color != null) {
            this.layout.setBaseColor(color);
        }
    }

    public TextraLabel(String text, Label.LabelStyle style, Font replacementFont) {
        this.font = replacementFont;
        this.layout = (Layout)Layout.POOL.obtain();
        if (style.fontColor != null) {
            this.layout.setBaseColor(style.fontColor);
        }
        this.style = style;
        this.storedText = text;
        this.font.markup(text, this.layout);
    }

    public TextraLabel(String text, Font font) {
        this.font = font;
        this.layout = (Layout)Layout.POOL.obtain();
        this.storedText = text;
        font.markup(text, this.layout);
    }

    public TextraLabel(String text, Font font, Color color) {
        this.font = font;
        this.layout = (Layout)Layout.POOL.obtain();
        if (color != null) {
            this.layout.setBaseColor(color);
        }
        this.storedText = text;
        font.markup(text, this.layout);
    }

    public void draw(Batch batch, float parentAlpha) {
        boolean resetShader;
        super.validate();
        float rot = this.getRotation();
        float originX = this.getOriginX();
        float originY = this.getOriginY();
        float sn = MathUtils.sinDeg((float)rot);
        float cs = MathUtils.cosDeg((float)rot);
        batch.getColor().set((Color)this.getColor()).a *= parentAlpha;
        batch.setColor(batch.getColor());
        int lines = this.layout.lines();
        float baseX = this.getX();
        float baseY = this.getY();
        float height = this.layout.getHeight();
        if (Align.isBottom((int)this.align)) {
            baseX -= sn * height;
            baseY += cs * height;
        } else if (Align.isCenterVertical((int)this.align)) {
            baseX -= sn * height * 0.5f;
            baseY += cs * height * 0.5f;
        }
        float width = this.getWidth();
        height = this.getHeight();
        if (Align.isRight((int)this.align)) {
            baseX += cs * width;
            baseY += sn * width;
        } else if (Align.isCenterHorizontal((int)this.align)) {
            baseX += cs * width * 0.5f;
            baseY += sn * width * 0.5f;
        }
        if (Align.isTop((int)this.align)) {
            baseX -= sn * height;
            baseY += cs * height;
        } else if (Align.isCenterVertical((int)this.align)) {
            baseX -= sn * height * 0.5f;
            baseY += cs * height * 0.5f;
        }
        if (this.style != null && this.style.background != null) {
            Drawable background = this.style.background;
            if (Align.isLeft((int)this.align)) {
                baseX += cs * background.getLeftWidth();
                baseY += sn * background.getLeftWidth();
            } else if (Align.isRight((int)this.align)) {
                baseX -= cs * background.getRightWidth();
                baseY -= sn * background.getRightWidth();
            } else {
                baseX += cs * (background.getLeftWidth() - background.getRightWidth()) * 0.5f;
                baseY += sn * (background.getLeftWidth() - background.getRightWidth()) * 0.5f;
            }
            if (Align.isBottom((int)this.align)) {
                baseX -= sn * background.getBottomHeight();
                baseY += cs * background.getBottomHeight();
            } else if (Align.isTop((int)this.align)) {
                baseX += sn * background.getTopHeight();
                baseY -= cs * background.getTopHeight();
            } else {
                baseX -= sn * (background.getBottomHeight() - background.getTopHeight()) * 0.5f;
                baseY += cs * (background.getBottomHeight() - background.getTopHeight()) * 0.5f;
            }
            ((TransformDrawable)background).draw(batch, this.getX(), this.getY(), originX, originY, this.getWidth(), this.getHeight(), 1.0f, 1.0f, rot);
        }
        if (this.layout.lines.isEmpty()) {
            return;
        }
        boolean bl = resetShader = this.font.distanceField != Font.DistanceFieldType.STANDARD && batch.getShader() != this.font.shader;
        if (resetShader) {
            this.font.enableShader(batch);
        }
        baseX -= 0.5f * this.font.cellWidth;
        baseX += cs * 0.5f * this.font.cellWidth;
        baseY += sn * 0.5f * this.font.cellWidth;
        baseX -= sn * 0.5f * this.font.cellHeight;
        baseY += cs * 0.5f * this.font.cellHeight;
        for (int ln = 0; ln < lines; ++ln) {
            Line glyphs = this.layout.getLine(ln);
            baseX += sn * glyphs.height;
            baseY -= cs * glyphs.height;
            if (glyphs.glyphs.size == 0) continue;
            float x = baseX;
            float y = baseY;
            float worldOriginX = x + originX;
            float worldOriginY = y + originY;
            float fx = -originX;
            float fy = -originY;
            x = cs * fx - sn * fy + worldOriginX;
            y = sn * fx + cs * fy + worldOriginY;
            float xChange = 0.0f;
            float yChange = 0.0f;
            if (Align.isCenterHorizontal((int)this.align)) {
                x -= cs * (glyphs.width * 0.5f);
                y -= sn * (glyphs.width * 0.5f);
            } else if (Align.isRight((int)this.align)) {
                x -= cs * glyphs.width;
                y -= sn * glyphs.width;
            }
            Font f = null;
            int kern = -1;
            int n = glyphs.glyphs.size;
            for (int i = 0; i < n; ++i) {
                Font.GlyphRegion reg;
                long glyph = glyphs.glyphs.get(i);
                if (this.font.family != null) {
                    f = this.font.family.connected[(int)(glyph >>> 16 & 0xFL)];
                }
                if (f == null) {
                    f = this.font;
                }
                if (f.kerning != null) {
                    glyph = glyphs.glyphs.get(i);
                    kern = kern << 16 | (int)(glyph & 0xFFFFL);
                    float amt = (float)f.kerning.get(kern, 0) * f.scaleX * ((glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f);
                    xChange += cs * amt;
                    yChange += sn * amt;
                } else {
                    kern = -1;
                }
                if (i == 0 && (reg = (Font.GlyphRegion)((Object)this.font.mapping.get((int)((char)glyph)))) != null && reg.offsetX < 0.0f) {
                    float ox = reg.offsetX * f.scaleX * ((glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f);
                    xChange -= cs * ox;
                    yChange -= sn * ox;
                }
                int bgc = 0;
                float xx = x + xChange;
                float yy = y + yChange;
                float single = f.drawGlyph(batch, glyph, xx, yy, rot, 1.0f, 1.0f, bgc);
                xChange += cs * single;
                yChange += sn * single;
            }
        }
        if (resetShader) {
            batch.setShader(null);
        }
    }

    public float getPrefWidth() {
        if (this.wrap) {
            return 0.0f;
        }
        float width = this.layout.getWidth();
        if (this.style != null && this.style.background != null) {
            width = Math.max(width + this.style.background.getLeftWidth() + this.style.background.getRightWidth(), this.style.background.getMinWidth());
        }
        return width;
    }

    public float getPrefHeight() {
        float height = this.layout.getHeight();
        if (this.style != null && this.style.background != null) {
            height = Math.max(height + this.style.background.getBottomHeight() + this.style.background.getTopHeight(), this.style.background.getMinHeight());
        }
        return height;
    }

    public TextraLabel useIntegerPositions(boolean integer) {
        this.font.integerPosition = integer;
        return this;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public TextraLabel setWrap(boolean wrap) {
        this.wrap = wrap;
        if (this.wrap != this.wrap) {
            this.invalidateHierarchy();
        }
        return this;
    }

    public void setSize(float width, float height) {
        super.setSize(width, height);
        if (this.wrap) {
            this.layout.setTargetWidth(width);
            float actualWidth = this.getWidth();
            this.layout.setTargetWidth(actualWidth);
            this.font.calculateSize(this.layout);
            this.invalidateHierarchy();
        }
    }

    public void layout() {
        float width = this.getWidth();
        if (this.style != null && this.style.background != null) {
            width -= this.style.background.getLeftWidth() + this.style.background.getRightWidth();
        }
        if (this.wrap && this.layout.getTargetWidth() != width) {
            this.layout.setTargetWidth(width);
            this.font.regenerateLayout(this.layout);
            this.invalidateHierarchy();
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int alignment) {
        this.align = alignment;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        if (!this.font.equals(this.font)) {
            font.regenerateLayout(this.layout);
        }
    }

    public void setFont(Font font, boolean regenerate) {
        this.font = font;
        if (!this.font.equals(this.font) && regenerate) {
            font.regenerateLayout(this.layout);
        }
    }

    public void setText(String markupText) {
        this.storedText = markupText;
        this.layout.setTargetWidth(this.getWidth());
        this.font.markup(markupText, this.layout.clear());
        this.setWidth(this.layout.getWidth() + (this.style != null && this.style.background != null ? this.style.background.getLeftWidth() + this.style.background.getRightWidth() : 0.0f));
    }

    public void skipToTheEnd() {
    }

    public boolean remove() {
        Layout.POOL.free((Object)this.layout);
        return super.remove();
    }

    public void setStage(Stage stage) {
        super.setStage(stage);
    }

    protected void setParent(Group parent) {
        super.setParent(parent);
    }
}

