/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.MathUtils;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class BlinkEffect
extends Effect {
    private static final float DEFAULT_FREQUENCY = 1.0f;
    private int color1 = 256;
    private int color2 = 256;
    private float alpha1 = 1.0f;
    private float alpha2 = 0.0f;
    private float frequency = 1.0f;
    private float threshold = 0.5f;

    public BlinkEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.color1 = this.paramAsColor(params[0]);
            if (this.color1 == 256) {
                this.alpha1 = this.paramAsFloat(params[0], 0.0f);
            }
        }
        if (params.length > 1) {
            this.color2 = this.paramAsColor(params[1]);
            if (this.color2 == 256) {
                this.alpha2 = this.paramAsFloat(params[1], 1.0f);
            }
        }
        if (params.length > 2) {
            this.frequency = this.paramAsFloat(params[2], 1.0f);
        }
        if (params.length > 3) {
            this.threshold = this.paramAsFloat(params[3], 0.5f);
        }
        this.threshold = MathUtils.clamp((float)this.threshold, (float)0.0f, (float)1.0f);
        this.alpha1 = MathUtils.clamp((float)this.alpha1, (float)0.0f, (float)1.0f);
        this.alpha2 = MathUtils.clamp((float)this.alpha2, (float)0.0f, (float)1.0f);
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float frequencyMod = 1.0f / this.frequency * 1.0f;
        float progress = this.calculateProgress(frequencyMod);
        if (progress <= this.threshold) {
            if (this.color1 == 256) {
                this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFF00FFFFFFFFL | (long)(this.alpha1 * 255.0f) << 32);
            } else {
                this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)this.color1 << 32);
            }
        } else if (this.color1 == 256) {
            this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFF00FFFFFFFFL | (long)(this.alpha2 * 255.0f) << 32);
        } else {
            this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)this.color2 << 32);
        }
    }
}

