/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class JumpEffect
extends Effect {
    private static final float DEFAULT_FREQUENCY = 50.0f;
    private static final float DEFAULT_DISTANCE = 1.33f;
    private static final float DEFAULT_INTENSITY = 1.0f;
    private float distance = 1.0f;
    private float frequency = 1.0f;
    private float intensity = 1.0f;

    public JumpEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.frequency = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.intensity = this.paramAsFloat(params[2], 1.0f);
        }
        if (params.length > 3) {
            this.duration = this.paramAsFloat(params[3], Float.POSITIVE_INFINITY);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float split;
        float progressModifier = 1.0f / this.intensity * 1.0f;
        float normalFrequency = 1.0f / this.frequency * 50.0f;
        float progressOffset = (float)localIndex / normalFrequency;
        float progress = this.calculateProgress(progressModifier, -progressOffset, false);
        float interpolation = progress < (split = 0.2f) ? Interpolation.pow2Out.apply(0.0f, 1.0f, progress / split) : Interpolation.bounceOut.apply(1.0f, 0.0f, (progress - split) / (1.0f - split));
        float y = this.label.getLineHeight(globalIndex) * this.distance * interpolation * 1.33f;
        float fadeout = this.calculateFadeout();
        this.label.offsets.incr(globalIndex << 1 | 1, y *= fadeout);
    }
}

