/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.TypingWindow;

public class TypingDialog
extends TypingWindow {
    Table contentTable;
    Table buttonTable;
    @Null
    private Skin skin;
    ObjectMap<Actor, Object> values = new ObjectMap();
    boolean cancelHide;
    Actor previousKeyboardFocus;
    Actor previousScrollFocus;
    FocusListener focusListener;
    protected InputListener ignoreTouchDown = new InputListener(){

        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            event.cancel();
            return false;
        }
    };

    public TypingDialog(String title, Skin skin) {
        super(title, (Window.WindowStyle)skin.get(Window.WindowStyle.class));
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public TypingDialog(String title, Skin skin, String windowStyleName) {
        super(title, (Window.WindowStyle)skin.get(windowStyleName, Window.WindowStyle.class));
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public TypingDialog(String title, Window.WindowStyle windowStyle) {
        super(title, windowStyle);
        this.initialize();
    }

    public TypingDialog(String title, Skin skin, Font replacementFont) {
        super(title, (Window.WindowStyle)skin.get(Window.WindowStyle.class), replacementFont);
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public TypingDialog(String title, Skin skin, String windowStyleName, Font replacementFont) {
        super(title, (Window.WindowStyle)skin.get(windowStyleName, Window.WindowStyle.class), replacementFont);
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public TypingDialog(String title, Window.WindowStyle windowStyle, Font replacementFont) {
        super(title, windowStyle, replacementFont);
        this.initialize();
    }

    @Override
    protected TextraLabel newLabel(String text, Label.LabelStyle style) {
        return new TextraLabel(text, style);
    }

    @Override
    protected TextraLabel newLabel(String text, Font font, Color color) {
        return new TextraLabel(text, font, color);
    }

    protected TypingLabel newTypingLabel(String text, Label.LabelStyle style) {
        return new TypingLabel(text, style);
    }

    protected TypingLabel newTypingLabel(String text, Font font, Color color) {
        return new TypingLabel(text, font, color);
    }

    private void initialize() {
        this.setModal(true);
        this.defaults().space(6.0f);
        this.contentTable = new Table(this.skin);
        this.add((Actor)this.contentTable).expand().fill();
        this.row();
        this.buttonTable = new Table(this.skin);
        this.add((Actor)this.buttonTable).fillX();
        this.contentTable.defaults().space(6.0f);
        this.buttonTable.defaults().space(6.0f);
        this.buttonTable.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!TypingDialog.this.values.containsKey((Object)actor)) {
                    return;
                }
                while (actor.getParent() != TypingDialog.this.buttonTable) {
                    actor = actor.getParent();
                }
                TypingDialog.this.result(TypingDialog.this.values.get((Object)actor));
                if (!TypingDialog.this.cancelHide) {
                    TypingDialog.this.hide();
                }
                TypingDialog.this.cancelHide = false;
            }
        });
        this.focusListener = new FocusListener(){

            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    this.focusChanged(event);
                }
            }

            public void scrollFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    this.focusChanged(event);
                }
            }

            private void focusChanged(FocusListener.FocusEvent event) {
                Actor newFocusedActor;
                Stage stage = TypingDialog.this.getStage();
                if (TypingDialog.this.isModal() && stage != null && stage.getRoot().getChildren().size > 0 && stage.getRoot().getChildren().peek() == TypingDialog.this && (newFocusedActor = event.getRelatedActor()) != null && !newFocusedActor.isDescendantOf((Actor)TypingDialog.this) && !newFocusedActor.equals(TypingDialog.this.previousKeyboardFocus) && !newFocusedActor.equals(TypingDialog.this.previousScrollFocus)) {
                    event.cancel();
                }
            }
        };
    }

    protected void setStage(Stage stage) {
        if (stage == null) {
            this.addListener((EventListener)this.focusListener);
        } else {
            this.removeListener((EventListener)this.focusListener);
        }
        super.setStage(stage);
    }

    public Table getContentTable() {
        return this.contentTable;
    }

    public Table getButtonTable() {
        return this.buttonTable;
    }

    public TypingDialog text(@Null String text) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.text(text, (Label.LabelStyle)this.skin.get(Label.LabelStyle.class));
    }

    public TypingDialog text(@Null String text, Label.LabelStyle labelStyle) {
        return this.text(this.newLabel(text, labelStyle));
    }

    public TypingDialog text(@Null String text, Font font) {
        return this.text(this.newLabel(text, font, Color.WHITE));
    }

    public TypingDialog text(@Null String text, Font font, Color color) {
        return this.text(this.newLabel(text, font, color));
    }

    public TypingDialog text(TextraLabel label) {
        this.contentTable.add((Actor)label);
        return this;
    }

    public TypingDialog typing(@Null String text) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.typing(text, (Label.LabelStyle)this.skin.get(Label.LabelStyle.class));
    }

    public TypingDialog typing(@Null String text, Label.LabelStyle labelStyle) {
        return this.typing(this.newTypingLabel(text, labelStyle));
    }

    public TypingDialog typing(@Null String text, Font font) {
        return this.typing(this.newTypingLabel(text, font, Color.WHITE));
    }

    public TypingDialog typing(@Null String text, Font font, Color color) {
        return this.typing(this.newTypingLabel(text, font, color));
    }

    public TypingDialog typing(TypingLabel label) {
        this.contentTable.add((Actor)label);
        return this;
    }

    public TypingDialog button(@Null String text) {
        return this.button(text, null);
    }

    public TypingDialog button(@Null String text, @Null Object object) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.button(text, object, (TextButton.TextButtonStyle)this.skin.get(TextButton.TextButtonStyle.class));
    }

    public TypingDialog button(@Null String text, @Null Object object, TextButton.TextButtonStyle buttonStyle) {
        return this.button(this.font == null ? new TextraButton(text, buttonStyle) : new TextraButton(text, buttonStyle, this.font), object);
    }

    public TypingDialog button(Button button) {
        return this.button(button, null);
    }

    public TypingDialog button(Button button, @Null Object object) {
        this.buttonTable.add((Actor)button);
        this.setObject((Actor)button, object);
        return this;
    }

    public TypingDialog show(Stage stage, @Null Action action) {
        this.clearActions();
        this.removeCaptureListener((EventListener)this.ignoreTouchDown);
        this.previousKeyboardFocus = null;
        Actor actor = stage.getKeyboardFocus();
        if (actor != null && !actor.isDescendantOf((Actor)this)) {
            this.previousKeyboardFocus = actor;
        }
        this.previousScrollFocus = null;
        actor = stage.getScrollFocus();
        if (actor != null && !actor.isDescendantOf((Actor)this)) {
            this.previousScrollFocus = actor;
        }
        stage.addActor((Actor)this);
        this.pack();
        stage.cancelTouchFocus();
        stage.setKeyboardFocus((Actor)this);
        stage.setScrollFocus((Actor)this);
        if (action != null) {
            this.addAction(action);
        }
        return this;
    }

    public TypingDialog show(Stage stage) {
        this.show(stage, (Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)0.4f, (Interpolation)Interpolation.fade)));
        this.setPosition(Math.round((stage.getWidth() - this.getWidth()) / 2.0f), Math.round((stage.getHeight() - this.getHeight()) / 2.0f));
        return this;
    }

    public void hide(@Null Action action) {
        Stage stage = this.getStage();
        if (stage != null) {
            Actor actor;
            this.removeListener((EventListener)this.focusListener);
            if (this.previousKeyboardFocus != null && this.previousKeyboardFocus.getStage() == null) {
                this.previousKeyboardFocus = null;
            }
            if ((actor = stage.getKeyboardFocus()) == null || actor.isDescendantOf((Actor)this)) {
                stage.setKeyboardFocus(this.previousKeyboardFocus);
            }
            if (this.previousScrollFocus != null && this.previousScrollFocus.getStage() == null) {
                this.previousScrollFocus = null;
            }
            if ((actor = stage.getScrollFocus()) == null || actor.isDescendantOf((Actor)this)) {
                stage.setScrollFocus(this.previousScrollFocus);
            }
        }
        if (action != null) {
            this.addCaptureListener((EventListener)this.ignoreTouchDown);
            this.addAction((Action)Actions.sequence((Action)action, (Action)Actions.removeListener((EventListener)this.ignoreTouchDown, (boolean)true), (Action)Actions.removeActor()));
        } else {
            this.remove();
        }
    }

    public void hide() {
        this.hide((Action)Actions.fadeOut((float)0.4f, (Interpolation)Interpolation.fade));
    }

    public void setObject(Actor actor, @Null Object object) {
        this.values.put((Object)actor, object);
    }

    public TypingDialog key(final int keycode, final @Null Object object) {
        this.addListener((EventListener)new InputListener(){

            public boolean keyDown(InputEvent event, int keycode2) {
                if (keycode == keycode2) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            TypingDialog.this.result(object);
                            if (!TypingDialog.this.cancelHide) {
                                TypingDialog.this.hide();
                            }
                            TypingDialog.this.cancelHide = false;
                        }
                    });
                }
                return false;
            }
        });
        return this;
    }

    protected void result(@Null Object object) {
    }

    public void cancel() {
        this.cancelHide = true;
    }
}

