/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.utils.IntArray;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class SickEffect
extends Effect {
    private static final float DEFAULT_FREQUENCY = 50.0f;
    private static final float DEFAULT_DISTANCE = 0.125f;
    private static final float DEFAULT_INTENSITY = 1.0f;
    public float distance = 1.0f;
    public float intensity = 1.0f;
    private final IntArray indices = new IntArray();

    public SickEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.intensity = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.duration = this.paramAsFloat(params[2], Float.POSITIVE_INFINITY);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float progressModifier = 1.0f / this.intensity * 1.0f;
        float progressOffset = (float)localIndex / 50.0f;
        float progress = this.calculateProgress(progressModifier, -progressOffset, false);
        if (progress < 0.01f && Math.random() > 0.25 && !this.indices.contains(localIndex)) {
            this.indices.add(localIndex);
        }
        if (progress > 0.95f) {
            this.indices.removeValue(localIndex);
        }
        if (!(this.indices.contains(localIndex) || this.indices.contains(localIndex - 1) || this.indices.contains(localIndex - 2) || this.indices.contains(localIndex + 2) || this.indices.contains(localIndex + 1))) {
            return;
        }
        float split = 0.5f;
        float interpolation = progress < split ? Interpolation.pow2Out.apply(0.0f, 1.0f, progress / split) : Interpolation.pow2In.apply(1.0f, 0.0f, (progress - split) / (1.0f - split));
        float y = this.label.getLineHeight(globalIndex) * this.distance * interpolation * 0.125f;
        if (this.indices.contains(localIndex)) {
            y *= 2.15f;
        }
        if (this.indices.contains(localIndex - 1) || this.indices.contains(localIndex + 1)) {
            y *= 1.35f;
        }
        float fadeout = this.calculateFadeout();
        this.label.offsets.incr(globalIndex << 1 | 1, -(y *= fadeout));
    }
}

