/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class StylistEffect
extends Effect {
    private long effects = 0L;
    private boolean all = false;

    public StylistEffect(TypingLabel label, String[] params) {
        super(label);
        label.trackingInput = true;
        if (params.length > 0 && this.paramAsBoolean(params[0])) {
            this.effects |= 0x40000000L;
        }
        if (params.length > 1 && this.paramAsBoolean(params[1])) {
            this.effects |= 0x20000000L;
        }
        if (params.length > 2 && this.paramAsBoolean(params[2])) {
            this.effects |= 0x10000000L;
        }
        if (params.length > 3 && this.paramAsBoolean(params[3])) {
            this.effects |= 0x8000000L;
        }
        if (params.length > 4) {
            this.effects |= ((long)this.paramAsFloat(params[4], 0.0f) & 3L) << 25;
        }
        if (params.length > 5) {
            this.all = this.paramAsBoolean(params[5]);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        if (this.all) {
            if (this.label.overIndex < this.indexStart || this.label.overIndex > this.indexEnd) {
                this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFF01FFFFFFL);
                return;
            }
        } else if (this.label.overIndex != globalIndex) {
            this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFF01FFFFFFL);
            return;
        }
        this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFF01FFFFFFL | this.effects);
    }
}

