/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedSet;
import com.badlogic.gdx.utils.StreamUtils;
import com.github.tommyettinger.textra.Font;
import java.io.BufferedReader;
import java.io.Closeable;
import java.util.Comparator;

public final class KnownFonts
implements LifecycleListener {
    private static KnownFonts instance;
    private String prefix = "";
    private final ObjectMap<String, Font> loaded = new ObjectMap(32);
    public static final String A_STARRY = "A-Starry";
    public static final String BITTER = "Bitter";
    public static final String CANADA1500 = "Canada1500";
    public static final String CASCADIA_MONO = "Cascadia-Mono";
    public static final String CAVEAT = "Caveat";
    public static final String DEJAVU_SANS_CONDENSED = "DejaVu-Sans-Condensed";
    public static final String DEJAVU_SANS_MONO = "DejaVu-Sans-Mono";
    public static final String DEJAVU_SANS = "DejaVu-Sans";
    public static final String DEJAVU_SERIF_CONDENSED = "DejaVu-Serif-Condensed";
    public static final String DEJAVU_SERIF = "DejaVu-Serif";
    public static final String GENTIUM = "Gentium";
    public static final String GENTIUM_UN_ITALIC = "Gentium-Un-Italic";
    public static final String GLACIAL_INDIFFERENCE = "Glacial-Indifference";
    public static final String GO_NOTO_UNIVERSAL = "Go-Noto-Universal";
    public static final String GRENZE = "Grenze";
    public static final String INCONSOLATA_LGC = "Inconsolata-LGC";
    public static final String IOSEVKA = "Iosevka";
    public static final String IOSEVKA_SLAB = "Iosevka-Slab";
    public static final String KINGTHINGS_FOUNDATION = "Kingthings-Foundation";
    public static final String KINGTHINGS_PETROCK = "Kingthings-Petrock";
    public static final String LIBERTINUS_SERIF = "Libertinus-Serif";
    public static final String LIBERTINUS_SERIF_SEMIBOLD = "Libertinus-Serif-Semibold";
    public static final String NOW_ALT = "Now-Alt";
    public static final String OPEN_SANS = "Open-Sans";
    public static final String OSTRICH_BLACK = "Ostrich-Black";
    public static final String OXANIUM = "Oxanium";
    public static final String ROBOTO_CONDENSED = "Roboto-Condensed";
    public static final String TANGERINE = "Tangerine";
    public static final String YANONE_KAFFEESATZ = "Yanone-Kaffeesatz";
    public static final String YATAGHAN = "Yataghan";
    public static final String COZETTE = "Cozette";
    public static final String HANAZONO = "Hanazono";
    public static final String LANAPIXEL = "LanaPixel";
    public static final String QUANPIXEL = "QuanPixel";
    public static final String IBM_8X16 = "IBM-8x16";
    public static final OrderedSet<String> JSON_NAMES;
    public static final OrderedSet<String> FNT_NAMES;
    public static final OrderedSet<String> SAD_NAMES;
    public static final OrderedSet<String> STANDARD_NAMES;
    public static final OrderedSet<String> SDF_NAMES;
    public static final OrderedSet<String> MSDF_NAMES;
    private TextureAtlas twemoji;
    private TextureAtlas openMojiColor;
    private TextureAtlas openMojiWhite;
    private TextureAtlas notoEmoji;
    private TextureAtlas gameIcons;
    private Font gameIconsFont;

    private KnownFonts() {
        if (Gdx.app == null) {
            throw new IllegalStateException("Gdx.app cannot be null; initialize KnownFonts in create() or later.");
        }
        Gdx.app.addLifecycleListener((LifecycleListener)this);
    }

    private static void initialize() {
        if (instance == null) {
            instance = new KnownFonts();
        }
    }

    public static void setAssetPrefix(String prefix) {
        KnownFonts.initialize();
        if (prefix != null) {
            KnownFonts.instance.prefix = prefix;
        }
    }

    public static Font getFont(String baseName) {
        return KnownFonts.getFont(baseName, Font.DistanceFieldType.STANDARD);
    }

    public static Font getFont(String baseName, Font.DistanceFieldType distanceField) {
        if (baseName == null) {
            throw new RuntimeException("Font name cannot be null.");
        }
        if (distanceField == null) {
            distanceField = Font.DistanceFieldType.STANDARD;
        }
        KnownFonts.initialize();
        String rootName = baseName + distanceField.filePart;
        Font known = (Font)KnownFonts.instance.loaded.get((Object)rootName);
        if (known == null) {
            if (JSON_NAMES.contains((Object)baseName)) {
                known = new Font(KnownFonts.instance.prefix + rootName + ".dat", true).scaleHeightTo(32.0f);
            } else if (FNT_NAMES.contains((Object)baseName)) {
                known = new Font(KnownFonts.instance.prefix + rootName + ".fnt", distanceField);
            } else if (distanceField == Font.DistanceFieldType.STANDARD && SAD_NAMES.contains((Object)baseName)) {
                known = new Font(KnownFonts.instance.prefix, rootName + ".font", true);
            } else {
                throw new RuntimeException("Unknown font name/distance field: " + baseName + "/" + distanceField.name());
            }
            KnownFonts.instance.loaded.put((Object)rootName, (Object)known);
        }
        return new Font(known).setName(baseName + distanceField.namePart).setDistanceField(distanceField);
    }

    private static Font loadFont(String baseName, Font.DistanceFieldType distanceField) {
        if (baseName == null) {
            throw new RuntimeException("Font name cannot be null.");
        }
        if (distanceField == null) {
            distanceField = Font.DistanceFieldType.STANDARD;
        }
        KnownFonts.initialize();
        String rootName = baseName + distanceField.filePart;
        Font known = (Font)KnownFonts.instance.loaded.get((Object)rootName);
        if (known == null) {
            if (JSON_NAMES.contains((Object)baseName)) {
                known = new Font(KnownFonts.instance.prefix + rootName + ".dat", true).scaleHeightTo(32.0f);
            } else if (FNT_NAMES.contains((Object)baseName)) {
                known = new Font(KnownFonts.instance.prefix + rootName + ".fnt", distanceField);
            } else if (distanceField == Font.DistanceFieldType.STANDARD && SAD_NAMES.contains((Object)baseName)) {
                known = new Font(KnownFonts.instance.prefix, rootName + ".font", true);
            } else {
                throw new RuntimeException("Unknown font name/distance field: " + baseName + "/" + distanceField.name());
            }
            KnownFonts.instance.loaded.put((Object)rootName, (Object)known);
        }
        return known;
    }

    public static Font getAStarry() {
        return KnownFonts.getFont(A_STARRY, Font.DistanceFieldType.STANDARD);
    }

    public static Font getAStarry(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(A_STARRY, dft);
    }

    public static Font getAStarryMSDF() {
        return KnownFonts.getFont(A_STARRY, Font.DistanceFieldType.MSDF);
    }

    public static Font getAStarryTall() {
        return KnownFonts.getAStarryTall(Font.DistanceFieldType.STANDARD);
    }

    public static Font getAStarryTall(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(A_STARRY, dft).scale(0.5f, 1.0f).setName("A-Starry-Tall" + dft.namePart);
    }

    public static Font getBitter() {
        return KnownFonts.getFont(BITTER, Font.DistanceFieldType.STANDARD);
    }

    public static Font getBitter(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(BITTER, dft);
    }

    public static Font getCanada() {
        return KnownFonts.getFont(CANADA1500, Font.DistanceFieldType.STANDARD);
    }

    public static Font getCanada(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(CANADA1500, dft);
    }

    public static Font getCascadiaMono() {
        return KnownFonts.getFont(CASCADIA_MONO, Font.DistanceFieldType.STANDARD);
    }

    public static Font getCascadiaMono(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(CASCADIA_MONO, dft);
    }

    public static Font getCascadiaMonoMSDF() {
        return KnownFonts.getFont(CASCADIA_MONO, Font.DistanceFieldType.MSDF);
    }

    public static Font getCaveat() {
        return KnownFonts.getFont(CAVEAT, Font.DistanceFieldType.STANDARD);
    }

    public static Font getCaveat(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(CAVEAT, dft);
    }

    public static Font getCozette() {
        KnownFonts.initialize();
        String baseName = COZETTE;
        Font.DistanceFieldType distanceField = Font.DistanceFieldType.STANDARD;
        String rootName = COZETTE + distanceField.filePart;
        Font found = (Font)KnownFonts.instance.loaded.get((Object)rootName);
        if (found == null) {
            found = new Font(KnownFonts.instance.prefix + rootName + ".fnt", distanceField, 1.0f, 5.0f, 0.0f, 0.0f, false);
            found.useIntegerPositions(true).setDescent(-3.0f).setUnderlinePosition(0.0f, -0.125f).setStrikethroughPosition(0.0f, 0.0f).setInlineImageMetrics(-32.0f, 4.0f, 8.0f).setName(COZETTE + Font.DistanceFieldType.STANDARD.namePart);
            KnownFonts.instance.loaded.put((Object)rootName, (Object)found);
        }
        return new Font(found);
    }

    public static Font getDejaVuSans() {
        return KnownFonts.getFont(DEJAVU_SANS, Font.DistanceFieldType.STANDARD);
    }

    public static Font getDejaVuSans(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(DEJAVU_SANS, dft);
    }

    public static Font getDejaVuSansCondensed() {
        return KnownFonts.getFont(DEJAVU_SANS_CONDENSED, Font.DistanceFieldType.STANDARD);
    }

    public static Font getDejaVuSansCondensed(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(DEJAVU_SANS_CONDENSED, dft);
    }

    public static Font getDejaVuSansMono() {
        return KnownFonts.getFont(DEJAVU_SANS_MONO, Font.DistanceFieldType.MSDF);
    }

    public static Font getDejaVuSansMono(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(DEJAVU_SANS_MONO, dft);
    }

    public static Font getDejaVuSerif() {
        return KnownFonts.getFont(DEJAVU_SERIF, Font.DistanceFieldType.STANDARD);
    }

    public static Font getDejaVuSerif(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(DEJAVU_SERIF, dft);
    }

    public static Font getDejaVuSerifCondensed() {
        return KnownFonts.getFont(DEJAVU_SERIF_CONDENSED, Font.DistanceFieldType.STANDARD);
    }

    public static Font getDejaVuSerifCondensed(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(DEJAVU_SERIF_CONDENSED, dft);
    }

    public static Font getGentium() {
        return KnownFonts.getFont(GENTIUM, Font.DistanceFieldType.STANDARD);
    }

    public static Font getGentiumMSDF() {
        return KnownFonts.getFont(GENTIUM, Font.DistanceFieldType.MSDF);
    }

    public static Font getGentiumSDF() {
        return KnownFonts.getFont(GENTIUM, Font.DistanceFieldType.SDF);
    }

    public static Font getGentium(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(GENTIUM, dft);
    }

    public static Font getGentiumUnItalic() {
        return KnownFonts.getFont(GENTIUM_UN_ITALIC, Font.DistanceFieldType.STANDARD);
    }

    public static Font getGentiumUnItalic(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(GENTIUM_UN_ITALIC, dft);
    }

    public static Font getGlacialIndifference() {
        return KnownFonts.getFont(GLACIAL_INDIFFERENCE, Font.DistanceFieldType.STANDARD);
    }

    public static Font getGlacialIndifference(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(GLACIAL_INDIFFERENCE, dft);
    }

    public static Font getGoNotoUniversal() {
        return KnownFonts.getFont(GO_NOTO_UNIVERSAL, Font.DistanceFieldType.STANDARD);
    }

    public static Font getGoNotoUniversalSDF() {
        return KnownFonts.getFont(GO_NOTO_UNIVERSAL, Font.DistanceFieldType.SDF);
    }

    public static Font getGoNotoUniversal(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(GO_NOTO_UNIVERSAL, dft);
    }

    public static Font getGrenze() {
        return KnownFonts.getFont(GRENZE, Font.DistanceFieldType.STANDARD);
    }

    public static Font getGrenze(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(GRENZE, dft);
    }

    public static Font getHanazono() {
        KnownFonts.initialize();
        String baseName = HANAZONO;
        Font.DistanceFieldType distanceField = Font.DistanceFieldType.STANDARD;
        String rootName = HANAZONO + distanceField.filePart;
        Font found = (Font)KnownFonts.instance.loaded.get((Object)rootName);
        if (found == null) {
            found = new Font(KnownFonts.instance.prefix + rootName + ".fnt", distanceField, 1.0f, 5.0f, 0.0f, 0.0f, false);
            found.setDescent(-6.0f).scaleTo(16.0f, 20.0f).setFancyLinePosition(-0.5f, 0.125f).setLineMetrics(-0.25f, 0.0f, 0.0f, -0.5f).setInlineImageMetrics(-16.0f, -4.0f, 0.0f).setTextureFilter().setName(HANAZONO + distanceField.namePart);
            KnownFonts.instance.loaded.put((Object)rootName, (Object)found);
        }
        return new Font(found);
    }

    public static Font getIBM8x16() {
        KnownFonts.initialize();
        String baseName = IBM_8X16;
        Font.DistanceFieldType distanceField = Font.DistanceFieldType.STANDARD;
        String rootName = IBM_8X16 + distanceField.filePart;
        Font found = (Font)KnownFonts.instance.loaded.get((Object)rootName);
        if (found == null) {
            found = new Font(KnownFonts.instance.prefix, rootName + ".font", true);
            found.setBoldStrength(0.5f).setLineMetrics(-0.25f, 0.0f, 0.0f, 0.0f).setInlineImageMetrics(-40.0f, 0.0f, 0.0f).fitCell(8.0f, 16.0f, false).setDescent(-6.0f).setName(IBM_8X16 + distanceField.namePart);
            KnownFonts.instance.loaded.put((Object)rootName, (Object)found);
        }
        return new Font(found);
    }

    public static Font getInconsolata() {
        return KnownFonts.getFont(INCONSOLATA_LGC, Font.DistanceFieldType.STANDARD);
    }

    public static Font getInconsolataMSDF() {
        return KnownFonts.getFont(INCONSOLATA_LGC, Font.DistanceFieldType.MSDF);
    }

    public static Font getInconsolata(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(INCONSOLATA_LGC, dft);
    }

    public static Font getIosevka() {
        return KnownFonts.getFont(IOSEVKA, Font.DistanceFieldType.STANDARD);
    }

    public static Font getIosevkaMSDF() {
        return KnownFonts.getFont(IOSEVKA, Font.DistanceFieldType.MSDF);
    }

    public static Font getIosevkaSDF() {
        return KnownFonts.getFont(IOSEVKA, Font.DistanceFieldType.SDF);
    }

    public static Font getIosevka(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(IOSEVKA, dft);
    }

    public static Font getIosevkaSlab() {
        return KnownFonts.getFont(IOSEVKA_SLAB, Font.DistanceFieldType.STANDARD);
    }

    public static Font getIosevkaSlabMSDF() {
        return KnownFonts.getFont(IOSEVKA_SLAB, Font.DistanceFieldType.MSDF);
    }

    public static Font getIosevkaSlabSDF() {
        return KnownFonts.getFont(IOSEVKA_SLAB, Font.DistanceFieldType.SDF);
    }

    public static Font getIosevkaSlab(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(IOSEVKA_SLAB, dft);
    }

    public static Font getKingthingsFoundation() {
        return KnownFonts.getFont(KINGTHINGS_FOUNDATION, Font.DistanceFieldType.STANDARD);
    }

    public static Font getKingthingsFoundation(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(KINGTHINGS_FOUNDATION, dft);
    }

    public static Font getKingthingsPetrock() {
        return KnownFonts.getFont(KINGTHINGS_PETROCK, Font.DistanceFieldType.STANDARD);
    }

    public static Font getKingthingsPetrock(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(KINGTHINGS_PETROCK, dft);
    }

    public static Font getLanaPixel() {
        KnownFonts.initialize();
        String baseName = LANAPIXEL;
        Font.DistanceFieldType distanceField = Font.DistanceFieldType.STANDARD;
        String rootName = LANAPIXEL + distanceField.filePart;
        Font found = (Font)KnownFonts.instance.loaded.get((Object)rootName);
        if (found == null) {
            found = new Font(KnownFonts.instance.prefix + rootName + ".fnt", distanceField, 0.0f, 0.0f, 0.0f, 0.0f, false);
            found.setInlineImageMetrics(-64.0f, 0.0f, 16.0f).setFancyLinePosition(0.0f, 0.5f).useIntegerPositions(true).setBoldStrength(0.5f).setLineMetrics(0.0f, -0.0625f, 0.0f, 0.0f).setName(LANAPIXEL + distanceField.namePart);
            KnownFonts.instance.loaded.put((Object)rootName, (Object)found);
        }
        return new Font(found);
    }

    public static Font getLibertinusSerif() {
        return KnownFonts.getFont(LIBERTINUS_SERIF, Font.DistanceFieldType.STANDARD);
    }

    public static Font getLibertinusSerif(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(LIBERTINUS_SERIF, dft);
    }

    public static Font getLibertinusSerifSemibold() {
        return KnownFonts.getFont(LIBERTINUS_SERIF_SEMIBOLD, Font.DistanceFieldType.STANDARD);
    }

    public static Font getLibertinusSerifSemibold(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(LIBERTINUS_SERIF_SEMIBOLD, dft);
    }

    public static Font getNowAlt() {
        return KnownFonts.getFont(NOW_ALT, Font.DistanceFieldType.STANDARD);
    }

    public static Font getNowAlt(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(NOW_ALT, dft);
    }

    public static Font getOpenSans() {
        return KnownFonts.getFont(OPEN_SANS, Font.DistanceFieldType.STANDARD);
    }

    public static Font getOpenSans(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(OPEN_SANS, dft);
    }

    public static Font getOstrichBlack() {
        return KnownFonts.getFont(OSTRICH_BLACK, Font.DistanceFieldType.STANDARD);
    }

    public static Font getOstrichBlack(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(OSTRICH_BLACK, dft);
    }

    public static Font getOxanium() {
        return KnownFonts.getFont(OXANIUM, Font.DistanceFieldType.STANDARD);
    }

    public static Font getOxanium(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(OXANIUM, dft);
    }

    public static Font getQuanPixel() {
        KnownFonts.initialize();
        String baseName = QUANPIXEL;
        Font.DistanceFieldType distanceField = Font.DistanceFieldType.STANDARD;
        String rootName = QUANPIXEL + distanceField.filePart;
        Font found = (Font)KnownFonts.instance.loaded.get((Object)rootName);
        if (found == null) {
            found = new Font(KnownFonts.instance.prefix + rootName + ".fnt", distanceField, 0.0f, 2.0f, 0.0f, 2.0f, false);
            found.setLineMetrics(0.0625f, -0.0625f, -0.25f, 0.0f).setInlineImageMetrics(-40.0f, -4.0f, 0.0f).setFancyLinePosition(0.0f, 0.375f).useIntegerPositions(true).setDescent(-4.0f).setBoldStrength(0.5f).setName(QUANPIXEL + distanceField.namePart);
            KnownFonts.instance.loaded.put((Object)rootName, (Object)found);
        }
        return new Font(found);
    }

    public static Font getRobotoCondensed() {
        return KnownFonts.getFont(ROBOTO_CONDENSED, Font.DistanceFieldType.STANDARD);
    }

    public static Font getRobotoCondensed(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(ROBOTO_CONDENSED, dft);
    }

    public static Font getTangerine() {
        return KnownFonts.getFont(TANGERINE, Font.DistanceFieldType.STANDARD);
    }

    public static Font getTangerineSDF() {
        return KnownFonts.getFont(TANGERINE, Font.DistanceFieldType.SDF);
    }

    public static Font getTangerine(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(TANGERINE, dft);
    }

    public static Font getYanoneKaffeesatz() {
        return KnownFonts.getFont(YANONE_KAFFEESATZ, Font.DistanceFieldType.STANDARD);
    }

    public static Font getYanoneKaffeesatzMSDF() {
        return KnownFonts.getFont(YANONE_KAFFEESATZ, Font.DistanceFieldType.MSDF);
    }

    public static Font getYanoneKaffeesatz(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(YANONE_KAFFEESATZ, dft);
    }

    public static Font getYataghan() {
        return KnownFonts.getFont(YATAGHAN, Font.DistanceFieldType.STANDARD);
    }

    public static Font getYataghanMSDF() {
        return KnownFonts.getFont(YATAGHAN, Font.DistanceFieldType.MSDF);
    }

    public static Font getYataghan(Font.DistanceFieldType dft) {
        return KnownFonts.getFont(YATAGHAN, dft);
    }

    public static TextureAtlas loadUnicodeAtlas(FileHandle packFile, FileHandle imagesDir, boolean flip) {
        return new TextureAtlas(new TextureAtlas.TextureAtlasData(packFile, imagesDir, flip){

            private int readEntry(String[] entry, @Null String line) {
                if (line == null) {
                    return 0;
                }
                if ((line = line.trim()).isEmpty()) {
                    return 0;
                }
                int colon = line.indexOf(58);
                if (colon == -1) {
                    return 0;
                }
                entry[0] = line.substring(0, colon).trim();
                int i = 1;
                int lastMatch = colon + 1;
                while (true) {
                    int comma;
                    if ((comma = line.indexOf(44, lastMatch)) == -1) {
                        entry[i] = line.substring(lastMatch).trim();
                        return i;
                    }
                    entry[i] = line.substring(lastMatch, comma).trim();
                    lastMatch = comma + 1;
                    if (i == 4) {
                        return 4;
                    }
                    ++i;
                }
            }

            public void load(FileHandle packFile, FileHandle imagesDir, boolean flip) {
                BufferedReader reader;
                final String[] entry = new String[5];
                ObjectMap pageFields = new ObjectMap(15, 0.99f);
                pageFields.put((Object)"size", (Object)new Field<TextureAtlas.TextureAtlasData.Page>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Page page) {
                        page.width = Integer.parseInt(entry[1]);
                        page.height = Integer.parseInt(entry[2]);
                    }
                });
                pageFields.put((Object)"format", (Object)new Field<TextureAtlas.TextureAtlasData.Page>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Page page) {
                        page.format = Pixmap.Format.valueOf((String)entry[1]);
                    }
                });
                pageFields.put((Object)"filter", (Object)new Field<TextureAtlas.TextureAtlasData.Page>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Page page) {
                        page.minFilter = Texture.TextureFilter.valueOf((String)entry[1]);
                        page.magFilter = Texture.TextureFilter.valueOf((String)entry[2]);
                        page.useMipMaps = page.minFilter.isMipMap();
                    }
                });
                pageFields.put((Object)"repeat", (Object)new Field<TextureAtlas.TextureAtlasData.Page>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Page page) {
                        if (entry[1].indexOf(120) != -1) {
                            page.uWrap = Texture.TextureWrap.Repeat;
                        }
                        if (entry[1].indexOf(121) != -1) {
                            page.vWrap = Texture.TextureWrap.Repeat;
                        }
                    }
                });
                pageFields.put((Object)"pma", (Object)new Field<TextureAtlas.TextureAtlasData.Page>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Page page) {
                        page.pma = entry[1].equals("true");
                    }
                });
                final boolean[] hasIndexes = new boolean[]{false};
                ObjectMap regionFields = new ObjectMap(127, 0.99f);
                regionFields.put((Object)"xy", (Object)new Field<TextureAtlas.TextureAtlasData.Region>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Region region) {
                        region.left = Integer.parseInt(entry[1]);
                        region.top = Integer.parseInt(entry[2]);
                    }
                });
                regionFields.put((Object)"size", (Object)new Field<TextureAtlas.TextureAtlasData.Region>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Region region) {
                        region.width = Integer.parseInt(entry[1]);
                        region.height = Integer.parseInt(entry[2]);
                    }
                });
                regionFields.put((Object)"bounds", (Object)new Field<TextureAtlas.TextureAtlasData.Region>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Region region) {
                        region.left = Integer.parseInt(entry[1]);
                        region.top = Integer.parseInt(entry[2]);
                        region.width = Integer.parseInt(entry[3]);
                        region.height = Integer.parseInt(entry[4]);
                    }
                });
                regionFields.put((Object)"offset", (Object)new Field<TextureAtlas.TextureAtlasData.Region>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Region region) {
                        region.offsetX = Integer.parseInt(entry[1]);
                        region.offsetY = Integer.parseInt(entry[2]);
                    }
                });
                regionFields.put((Object)"orig", (Object)new Field<TextureAtlas.TextureAtlasData.Region>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Region region) {
                        region.originalWidth = Integer.parseInt(entry[1]);
                        region.originalHeight = Integer.parseInt(entry[2]);
                    }
                });
                regionFields.put((Object)"offsets", (Object)new Field<TextureAtlas.TextureAtlasData.Region>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Region region) {
                        region.offsetX = Integer.parseInt(entry[1]);
                        region.offsetY = Integer.parseInt(entry[2]);
                        region.originalWidth = Integer.parseInt(entry[3]);
                        region.originalHeight = Integer.parseInt(entry[4]);
                    }
                });
                regionFields.put((Object)"rotate", (Object)new Field<TextureAtlas.TextureAtlasData.Region>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Region region) {
                        String value = entry[1];
                        if (value.equals("true")) {
                            region.degrees = 90;
                        } else if (!value.equals("false")) {
                            region.degrees = Integer.parseInt(value);
                        }
                        region.rotate = region.degrees == 90;
                    }
                });
                regionFields.put((Object)"index", (Object)new Field<TextureAtlas.TextureAtlasData.Region>(){

                    @Override
                    public void parse(TextureAtlas.TextureAtlasData.Region region) {
                        region.index = Integer.parseInt(entry[1]);
                        if (region.index != -1) {
                            hasIndexes[0] = true;
                        }
                    }
                });
                try {
                    reader = new BufferedReader(packFile.reader("UTF-8"), 1024);
                }
                catch (IllegalArgumentException e) {
                    throw new GdxRuntimeException((Throwable)e);
                }
                try {
                    String line = reader.readLine();
                    while (line != null && line.trim().isEmpty()) {
                        line = reader.readLine();
                    }
                    while (line != null && !line.trim().isEmpty() && this.readEntry(entry, line) != 0) {
                        line = reader.readLine();
                    }
                    TextureAtlas.TextureAtlasData.Page page = null;
                    Array names = null;
                    Array values = null;
                    while (line != null) {
                        int count;
                        if (line.trim().isEmpty()) {
                            page = null;
                            line = reader.readLine();
                            continue;
                        }
                        if (page == null) {
                            page = new TextureAtlas.TextureAtlasData.Page();
                            page.textureFile = imagesDir.child(line);
                            while (this.readEntry(entry, line = reader.readLine()) != 0) {
                                Field field = (Field)pageFields.get((Object)entry[0]);
                                if (field == null) continue;
                                field.parse(page);
                            }
                            this.getPages().add((Object)page);
                            continue;
                        }
                        TextureAtlas.TextureAtlasData.Region region = new TextureAtlas.TextureAtlasData.Region();
                        region.page = page;
                        region.name = line.trim();
                        if (flip) {
                            region.flip = true;
                        }
                        while ((count = this.readEntry(entry, line = reader.readLine())) != 0) {
                            Field field = (Field)regionFields.get((Object)entry[0]);
                            if (field != null) {
                                field.parse(region);
                                continue;
                            }
                            if (names == null) {
                                names = new Array(8);
                                values = new Array(8);
                            }
                            names.add((Object)entry[0]);
                            int[] entryValues = new int[count];
                            for (int i = 0; i < count; ++i) {
                                try {
                                    entryValues[i] = Integer.parseInt(entry[i + 1]);
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            values.add((Object)entryValues);
                        }
                        if (region.originalWidth == 0 && region.originalHeight == 0) {
                            region.originalWidth = region.width;
                            region.originalHeight = region.height;
                        }
                        if (names != null && names.size > 0) {
                            region.names = (String[])names.toArray(String.class);
                            region.values = (int[][])values.toArray(int[].class);
                            names.clear();
                            values.clear();
                        }
                        this.getRegions().add((Object)region);
                    }
                }
                catch (Exception ex) {
                    throw new GdxRuntimeException("Error reading texture atlas file: " + packFile, (Throwable)ex);
                }
                finally {
                    StreamUtils.closeQuietly((Closeable)reader);
                }
                if (hasIndexes[0]) {
                    this.getRegions().sort((Comparator)new Comparator<TextureAtlas.TextureAtlasData.Region>(){

                        @Override
                        public int compare(TextureAtlas.TextureAtlasData.Region region1, TextureAtlas.TextureAtlasData.Region region2) {
                            return (region1.index & Integer.MAX_VALUE) - (region2.index & Integer.MAX_VALUE);
                        }
                    });
                }
            }
        });
    }

    public static Font addEmoji(Font changing) {
        return KnownFonts.addEmoji(changing, 0.0f, 0.0f, 0.0f);
    }

    public static Font addEmoji(Font changing, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        return KnownFonts.addEmoji(changing, "", "", offsetXChange, offsetYChange, xAdvanceChange);
    }

    public static Font addEmoji(Font changing, String prepend, String append, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        KnownFonts.initialize();
        if (KnownFonts.instance.twemoji == null) {
            try {
                FileHandle atlas = Gdx.files.internal(KnownFonts.instance.prefix + "Twemoji.atlas");
                if (!atlas.exists() && Gdx.files.isLocalStorageAvailable()) {
                    atlas = Gdx.files.local(KnownFonts.instance.prefix + "Twemoji.atlas");
                }
                if (Gdx.files.internal(KnownFonts.instance.prefix + "Twemoji.png").exists()) {
                    KnownFonts.instance.twemoji = KnownFonts.loadUnicodeAtlas(atlas, atlas.parent(), false);
                } else if (Gdx.files.isLocalStorageAvailable() && Gdx.files.local(KnownFonts.instance.prefix + "Twemoji.png").exists()) {
                    KnownFonts.instance.twemoji = KnownFonts.loadUnicodeAtlas(atlas, atlas.parent(), false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.twemoji != null) {
            return changing.addAtlas(KnownFonts.instance.twemoji, prepend, append, offsetXChange, offsetYChange, xAdvanceChange);
        }
        throw new RuntimeException("Assets 'Twemoji.atlas' and 'Twemoji.png' not found.");
    }

    public static Font addOpenMoji(Font changing, boolean color) {
        return KnownFonts.addOpenMoji(changing, color, 0.0f, 0.0f, 0.0f);
    }

    public static Font addOpenMoji(Font changing, boolean color, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        return KnownFonts.addOpenMoji(changing, color, "", "", offsetXChange, offsetYChange, xAdvanceChange);
    }

    public static Font addOpenMoji(Font changing, boolean color, String prepend, String append, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        KnownFonts.initialize();
        if (color) {
            String baseName = "OpenMoji-color";
            if (KnownFonts.instance.openMojiColor == null) {
                try {
                    FileHandle atlas = Gdx.files.internal(KnownFonts.instance.prefix + baseName + ".atlas");
                    if (!atlas.exists() && Gdx.files.isLocalStorageAvailable()) {
                        atlas = Gdx.files.local(KnownFonts.instance.prefix + baseName + ".atlas");
                    }
                    if (Gdx.files.internal(KnownFonts.instance.prefix + baseName + ".png").exists()) {
                        KnownFonts.instance.openMojiColor = KnownFonts.loadUnicodeAtlas(atlas, atlas.parent(), false);
                    } else if (Gdx.files.isLocalStorageAvailable() && Gdx.files.local(KnownFonts.instance.prefix + baseName + ".png").exists()) {
                        KnownFonts.instance.openMojiColor = KnownFonts.loadUnicodeAtlas(atlas, atlas.parent(), false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (KnownFonts.instance.openMojiColor != null) {
                return changing.addAtlas(KnownFonts.instance.openMojiColor, prepend, append, offsetXChange, offsetYChange, xAdvanceChange);
            }
            throw new RuntimeException("Assets '" + baseName + ".atlas' and '" + baseName + ".png' not found.");
        }
        String baseName = "OpenMoji-white";
        if (KnownFonts.instance.openMojiWhite == null) {
            try {
                FileHandle atlas = Gdx.files.internal(KnownFonts.instance.prefix + baseName + ".atlas");
                if (!atlas.exists() && Gdx.files.isLocalStorageAvailable()) {
                    atlas = Gdx.files.local(KnownFonts.instance.prefix + baseName + ".atlas");
                }
                if (Gdx.files.internal(KnownFonts.instance.prefix + baseName + ".png").exists()) {
                    KnownFonts.instance.openMojiWhite = KnownFonts.loadUnicodeAtlas(atlas, atlas.parent(), false);
                } else if (Gdx.files.isLocalStorageAvailable() && Gdx.files.local(KnownFonts.instance.prefix + baseName + ".png").exists()) {
                    KnownFonts.instance.openMojiWhite = KnownFonts.loadUnicodeAtlas(atlas, atlas.parent(), false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.openMojiWhite != null) {
            return changing.addAtlas(KnownFonts.instance.openMojiWhite, prepend, append, offsetXChange, offsetYChange, xAdvanceChange);
        }
        throw new RuntimeException("Assets '" + baseName + ".atlas' and '" + baseName + ".png' not found.");
    }

    public static Font addNotoEmoji(Font changing) {
        return KnownFonts.addNotoEmoji(changing, 0.0f, 0.0f, 0.0f);
    }

    public static Font addNotoEmoji(Font changing, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        return KnownFonts.addNotoEmoji(changing, "", "", offsetXChange, offsetYChange, xAdvanceChange);
    }

    public static Font addNotoEmoji(Font changing, String prepend, String append, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        KnownFonts.initialize();
        if (KnownFonts.instance.notoEmoji == null) {
            try {
                FileHandle atlas = Gdx.files.internal(KnownFonts.instance.prefix + "Noto-Emoji.atlas");
                if (!atlas.exists() && Gdx.files.isLocalStorageAvailable()) {
                    atlas = Gdx.files.local(KnownFonts.instance.prefix + "Noto-Emoji.atlas");
                }
                if (Gdx.files.internal(KnownFonts.instance.prefix + "Noto-Emoji.png").exists()) {
                    KnownFonts.instance.notoEmoji = KnownFonts.loadUnicodeAtlas(atlas, atlas.parent(), false);
                } else if (Gdx.files.isLocalStorageAvailable() && Gdx.files.local(KnownFonts.instance.prefix + "Noto-Emoji.png").exists()) {
                    KnownFonts.instance.notoEmoji = KnownFonts.loadUnicodeAtlas(atlas, atlas.parent(), false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.notoEmoji != null) {
            return changing.addAtlas(KnownFonts.instance.notoEmoji, prepend, append, offsetXChange, offsetYChange, xAdvanceChange);
        }
        throw new RuntimeException("Assets 'Noto-Emoji.atlas' and 'Noto-Emoji.png' not found.");
    }

    public static Font addGameIcons(Font changing) {
        return KnownFonts.addGameIcons(changing, 0.0f, 0.0f, 0.0f);
    }

    public static Font addGameIcons(Font changing, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        return KnownFonts.addGameIcons(changing, "", "", offsetXChange, offsetYChange, xAdvanceChange);
    }

    public static Font addGameIcons(Font changing, String prepend, String append, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        KnownFonts.initialize();
        if (KnownFonts.instance.gameIcons == null) {
            try {
                FileHandle atlas = Gdx.files.internal(KnownFonts.instance.prefix + "Game-Icons.atlas");
                if (!atlas.exists() && Gdx.files.isLocalStorageAvailable()) {
                    atlas = Gdx.files.local(KnownFonts.instance.prefix + "Game-Icons.atlas");
                }
                if (Gdx.files.internal(KnownFonts.instance.prefix + "Game-Icons.png").exists()) {
                    KnownFonts.instance.gameIcons = new TextureAtlas(atlas, atlas.parent(), false);
                } else if (Gdx.files.isLocalStorageAvailable() && Gdx.files.local(KnownFonts.instance.prefix + "Game-Icons.png").exists()) {
                    KnownFonts.instance.gameIcons = new TextureAtlas(atlas, atlas.parent(), false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.gameIcons != null) {
            return changing.addAtlas(KnownFonts.instance.gameIcons, prepend, append, offsetXChange - 20.0f, offsetYChange, xAdvanceChange);
        }
        throw new RuntimeException("Assets 'Game-Icons.atlas' and 'Game-Icons.png' not found.");
    }

    public static Font getGameIconsFont(float width, float height) {
        KnownFonts.initialize();
        if (KnownFonts.instance.gameIconsFont == null) {
            try {
                KnownFonts.instance.gameIconsFont = KnownFonts.addGameIcons(KnownFonts.getAStarry().scaleTo(width, height).setName("Icons"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.gameIconsFont != null) {
            return new Font(KnownFonts.instance.gameIconsFont);
        }
        throw new RuntimeException("Assets for getGameIconsFont() not found.");
    }

    public void pause() {
    }

    public void resume() {
    }

    public static Font[] getAll() {
        return new Font[]{KnownFonts.getAStarry(), KnownFonts.getAStarryMSDF(), KnownFonts.getAStarryTall(), KnownFonts.getBitter(), KnownFonts.getCanada(), KnownFonts.getCascadiaMono(), KnownFonts.getCascadiaMonoMSDF(), KnownFonts.getCaveat(), KnownFonts.getCozette(), KnownFonts.getDejaVuSans(), KnownFonts.getDejaVuSansCondensed(), KnownFonts.getDejaVuSansMono(), KnownFonts.getDejaVuSerif(), KnownFonts.getDejaVuSerifCondensed(), KnownFonts.getGentium(), KnownFonts.getGentiumMSDF(), KnownFonts.getGentiumSDF(), KnownFonts.getGentiumUnItalic(), KnownFonts.getGlacialIndifference(), KnownFonts.getGoNotoUniversal(), KnownFonts.getGoNotoUniversalSDF(), KnownFonts.getGrenze(), KnownFonts.getHanazono(), KnownFonts.getIBM8x16(), KnownFonts.getInconsolata(), KnownFonts.getInconsolataMSDF(), KnownFonts.getIosevka(), KnownFonts.getIosevkaMSDF(), KnownFonts.getIosevkaSDF(), KnownFonts.getIosevkaSlab(), KnownFonts.getIosevkaSlabMSDF(), KnownFonts.getIosevkaSlabSDF(), KnownFonts.getKingthingsFoundation(), KnownFonts.getKingthingsPetrock(), KnownFonts.getLanaPixel(), KnownFonts.getLibertinusSerif(), KnownFonts.getLibertinusSerifSemibold(), KnownFonts.getNowAlt(), KnownFonts.getOpenSans(), KnownFonts.getOstrichBlack(), KnownFonts.getOxanium(), KnownFonts.getQuanPixel(), KnownFonts.getRobotoCondensed(), KnownFonts.getTangerine(), KnownFonts.getTangerineSDF(), KnownFonts.getYanoneKaffeesatz(), KnownFonts.getYanoneKaffeesatzMSDF(), KnownFonts.getYataghan(), KnownFonts.getYataghanMSDF()};
    }

    public static Font[] getAllStandard() {
        Font[] found = new Font[KnownFonts.STANDARD_NAMES.size + 1];
        int i = 0;
        for (String name : JSON_NAMES) {
            found[i++] = KnownFonts.getFont(name, Font.DistanceFieldType.STANDARD);
        }
        found[i++] = KnownFonts.getAStarryTall();
        found[i++] = KnownFonts.getCozette();
        found[i++] = KnownFonts.getHanazono();
        found[i++] = KnownFonts.getLanaPixel();
        found[i++] = KnownFonts.getQuanPixel();
        found[i++] = KnownFonts.getIBM8x16();
        return found;
    }

    public static Font getStandardFamily() {
        Font.FontFamily family = new Font.FontFamily(new String[]{"Serif", "Sans", "Mono", "Condensed", "Humanist", "Retro", "Slab", "Handwriting", "Dark", COZETTE, IOSEVKA, "Medieval", "Future", "Console", "Code", "Geometric"}, new Font[]{KnownFonts.getGentium(), KnownFonts.getOpenSans(), KnownFonts.getInconsolata(), KnownFonts.getRobotoCondensed(), KnownFonts.getYanoneKaffeesatz(), KnownFonts.getIBM8x16(), KnownFonts.getIosevkaSlab(), KnownFonts.getCaveat(), KnownFonts.getGrenze(), KnownFonts.getCozette(), KnownFonts.getIosevka(), KnownFonts.getKingthingsFoundation(), KnownFonts.getOxanium(), KnownFonts.getAStarryTall(), KnownFonts.getCascadiaMono(), KnownFonts.getNowAlt()});
        family.fontAliases.put(BITTER, 0);
        family.fontAliases.put("Canada", 15);
        return family.connected[0].setFamily(family);
    }

    public static Font getFamily(Font.DistanceFieldType dft) {
        Font.FontFamily family = new Font.FontFamily(new String[]{"Serif", "Sans", "Mono", "Condensed", "Humanist", "Fantasy", "Slab", "Handwriting", "Dark", "Script", IOSEVKA, "Medieval", "Future", "Console", "Code", "Geometric"}, new Font[]{KnownFonts.getGentium(dft), KnownFonts.getOpenSans(dft), KnownFonts.getInconsolata(dft), KnownFonts.getRobotoCondensed(dft), KnownFonts.getYanoneKaffeesatz(dft), KnownFonts.getGentiumUnItalic(dft), KnownFonts.getIosevkaSlab(dft), KnownFonts.getCaveat(dft), KnownFonts.getGrenze(dft), KnownFonts.getTangerine(dft), KnownFonts.getIosevka(dft), KnownFonts.getKingthingsFoundation(dft), KnownFonts.getOxanium(dft), KnownFonts.getAStarryTall(dft), KnownFonts.getCascadiaMono(dft), KnownFonts.getNowAlt(dft)});
        family.fontAliases.put(BITTER, 0);
        family.fontAliases.put("Canada", 15);
        family.fontAliases.put("Retro", 13);
        family.fontAliases.put(COZETTE, 13);
        return family.connected[0].setFamily(family);
    }

    public static Font[] getAllSDF() {
        Font[] found = new Font[KnownFonts.SDF_NAMES.size + 1];
        int i = 0;
        for (String name : SDF_NAMES) {
            found[i++] = KnownFonts.getFont(name, Font.DistanceFieldType.SDF);
        }
        found[i++] = KnownFonts.getAStarryTall(Font.DistanceFieldType.SDF);
        return found;
    }

    public static Font[] getAllMSDF() {
        Font[] found = new Font[KnownFonts.MSDF_NAMES.size + 1];
        int i = 0;
        for (String name : MSDF_NAMES) {
            found[i++] = KnownFonts.getFont(name, Font.DistanceFieldType.MSDF);
        }
        found[i++] = KnownFonts.getAStarryTall(Font.DistanceFieldType.MSDF);
        return found;
    }

    public void dispose() {
        for (Font f : this.loaded.values()) {
            f.dispose();
        }
        this.loaded.clear();
        if (this.twemoji != null) {
            this.twemoji.dispose();
            this.twemoji = null;
        }
        if (this.gameIcons != null) {
            this.gameIcons.dispose();
            this.gameIcons = null;
        }
        if (this.openMojiColor != null) {
            this.openMojiColor.dispose();
            this.openMojiColor = null;
        }
        if (this.openMojiWhite != null) {
            this.openMojiWhite.dispose();
            this.openMojiWhite = null;
        }
        if (this.gameIconsFont != null) {
            this.gameIconsFont.dispose();
            this.gameIconsFont = null;
        }
    }

    static {
        JSON_NAMES = OrderedSet.with((Object[])new String[]{A_STARRY, BITTER, CANADA1500, CASCADIA_MONO, CAVEAT, DEJAVU_SANS_CONDENSED, DEJAVU_SANS_MONO, DEJAVU_SANS, DEJAVU_SERIF_CONDENSED, DEJAVU_SERIF, GENTIUM, GENTIUM_UN_ITALIC, GLACIAL_INDIFFERENCE, GO_NOTO_UNIVERSAL, GRENZE, INCONSOLATA_LGC, IOSEVKA, IOSEVKA_SLAB, KINGTHINGS_FOUNDATION, KINGTHINGS_PETROCK, LIBERTINUS_SERIF, LIBERTINUS_SERIF_SEMIBOLD, NOW_ALT, OPEN_SANS, OSTRICH_BLACK, OXANIUM, ROBOTO_CONDENSED, TANGERINE, YANONE_KAFFEESATZ, YATAGHAN});
        FNT_NAMES = OrderedSet.with((Object[])new String[]{COZETTE, HANAZONO, LANAPIXEL, QUANPIXEL});
        SAD_NAMES = OrderedSet.with((Object[])new String[]{IBM_8X16});
        STANDARD_NAMES = new OrderedSet(KnownFonts.JSON_NAMES.size + KnownFonts.FNT_NAMES.size + KnownFonts.SAD_NAMES.size);
        SDF_NAMES = new OrderedSet(JSON_NAMES);
        MSDF_NAMES = new OrderedSet(JSON_NAMES);
        STANDARD_NAMES.addAll(JSON_NAMES);
        STANDARD_NAMES.addAll(FNT_NAMES);
        STANDARD_NAMES.addAll(SAD_NAMES);
    }

    private static interface Field<T> {
        public void parse(T var1);
    }
}

