/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.ColorUtils;

public class FadeEffect
extends Effect {
    private int color1 = 256;
    private int color2 = 256;
    private float alpha1 = 0.0f;
    private float alpha2 = 1.0f;
    private float fadeDuration = 1.0f;
    private final IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public FadeEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.color1 = this.paramAsColor(params[0]);
            if (this.color1 == 256) {
                this.alpha1 = this.paramAsFloat(params[0], 0.0f);
            }
        }
        if (params.length > 1) {
            this.color2 = this.paramAsColor(params[1]);
            if (this.color2 == 256) {
                this.alpha2 = this.paramAsFloat(params[1], 1.0f);
            }
        }
        if (params.length > 2) {
            this.fadeDuration = this.paramAsFloat(params[2], 1.0f);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, 0.0f, delta);
        float progress = MathUtils.clamp((float)(timePassed / this.fadeDuration), (float)0.0f, (float)1.0f);
        if (this.color1 == 256) {
            glyph = glyph & 0xFFFFFF00FFFFFFFFL | (long)MathUtils.lerp((float)(glyph >>> 32 & 0xFFL), (float)(this.alpha1 * 255.0f), (float)(1.0f - progress)) << 32;
            this.label.setInWorkingLayout(globalIndex, glyph);
        } else {
            glyph = glyph & 0xFFFFFFFFL | (long)ColorUtils.lerpColors((int)(glyph >>> 32), this.color1, 1.0f - progress) << 32;
            this.label.setInWorkingLayout(globalIndex, glyph);
        }
        if (this.color2 == 256) {
            this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFF00FFFFFFFFL | (long)MathUtils.lerp((float)(glyph >>> 32 & 0xFFL), (float)(this.alpha2 * 255.0f), (float)progress) << 32);
        } else {
            this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)ColorUtils.lerpColors((int)(glyph >>> 32), this.color2, progress) << 32);
        }
    }
}

