/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.utils;

import com.badlogic.gdx.utils.ByteArray;
import java.util.ArrayList;

public final class LZBDecompression {
    private LZBDecompression() {
    }

    public static String decompressFromBytes(byte[] compressedBytes) {
        return LZBDecompression.decompressFromBytes(compressedBytes, 0, compressedBytes.length);
    }

    public static String decompressFromByteArray(ByteArray compressedBytes) {
        return LZBDecompression.decompressFromBytes(compressedBytes.items, 0, compressedBytes.size);
    }

    public static String decompressFromBytes(byte[] compressedBytes, int offset, int length) {
        String c;
        int resb;
        if (compressedBytes == null) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        int resetValue = 128;
        ArrayList<String> dictionary = new ArrayList<String>(256);
        int enlargeIn = 4;
        int dictSize = 4;
        int numBits = 3;
        int position = 128;
        int index = offset + 1;
        StringBuilder res = new StringBuilder(length);
        byte val = compressedBytes[offset];
        for (char i = '\u0000'; i < '\u0003'; i = (char)(i + '\u0001')) {
            dictionary.add(String.valueOf(i));
        }
        char bits = '\u0000';
        int maxpower = 2;
        int power = 0;
        while (power != maxpower) {
            resb = val & position;
            if ((position >>>= 1) == 0) {
                position = 128;
                val = compressedBytes[index++];
            }
            bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
        }
        switch (bits) {
            case '\u0000': {
                bits = '\u0000';
                maxpower = 8;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>>= 1) == 0) {
                        position = 128;
                        val = compressedBytes[index++];
                    }
                    bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                }
                c = String.valueOf(bits);
                break;
            }
            case '\u0001': {
                bits = '\u0000';
                maxpower = 16;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>>= 1) == 0) {
                        position = 128;
                        val = compressedBytes[index++];
                    }
                    bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                }
                c = String.valueOf(bits);
                break;
            }
            default: {
                return "";
            }
        }
        dictionary.add(c);
        String w = c;
        res.append(w);
        while (index - offset <= length) {
            String entry;
            int cc = 0;
            maxpower = numBits;
            power = 0;
            while (power != maxpower) {
                resb = val & position;
                if ((position >>>= 1) == 0) {
                    position = 128;
                    val = compressedBytes[index++];
                }
                cc |= (resb != 0 ? 1 : 0) << power++;
            }
            switch (cc) {
                case 0: {
                    bits = '\u0000';
                    maxpower = 8;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>>= 1) == 0) {
                            position = 128;
                            val = compressedBytes[index++];
                        }
                        bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                    }
                    dictionary.add(String.valueOf(bits));
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 1: {
                    bits = '\u0000';
                    maxpower = 16;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>>= 1) == 0) {
                            position = 128;
                            val = compressedBytes[index++];
                        }
                        bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                    }
                    dictionary.add(String.valueOf(bits));
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 2: {
                    return res.toString();
                }
            }
            if (enlargeIn == 0) {
                enlargeIn = 1 << numBits;
                ++numBits;
            }
            if (cc < dictionary.size() && dictionary.get(cc) != null) {
                entry = (String)dictionary.get(cc);
            } else if (cc == dictSize) {
                entry = w + w.charAt(0);
            } else {
                return "";
            }
            res.append(entry);
            dictionary.add(w + entry.charAt(0));
            ++dictSize;
            w = entry;
            if (--enlargeIn != 0) continue;
            enlargeIn = 1 << numBits;
            ++numBits;
        }
        return "";
    }
}

