/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.utils;

import com.badlogic.gdx.math.MathUtils;
import java.util.Random;
import regexodus.Category;

public final class StringUtils {
    private StringUtils() {
    }

    public static String join(CharSequence delimiter, CharSequence ... items) {
        if (items == null || items.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(items[0]);
        for (int i = 1; i < items.length; ++i) {
            sb.append(delimiter).append(items[i]);
        }
        return sb.toString();
    }

    public static String shuffleWords(String text) {
        return StringUtils.shuffleWords(text, MathUtils.random);
    }

    public static String shuffleWords(String text, Random generator) {
        CharSequence[] items = text.split("\\s+");
        int length = items.length;
        for (int i = length - 1; i > 0; --i) {
            int ii = generator.nextInt(i + 1);
            CharSequence temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
        return StringUtils.join(" ", items);
    }

    public static int hexCode(char c) {
        int h = c & 0x40;
        return (c & 0xF) + (h >>> 3) + (h >>> 6);
    }

    public static char hexChar(int number) {
        return (char)(number + 48 + (9 - number >>> -3));
    }

    public static char hexChar(long number) {
        return (char)(number + 48L + (9L - number >>> -3));
    }

    public static StringBuilder appendUnsignedHex(StringBuilder sb, int number) {
        for (int s = 28; s >= 0; s -= 4) {
            sb.append(StringUtils.hexChar(number >>> s & 0xF));
        }
        return sb;
    }

    public static StringBuilder appendUnsignedHex(StringBuilder sb, long number) {
        for (int i = 60; i >= 0; i -= 4) {
            sb.append(StringUtils.hexChar(number >>> i & 0xFL));
        }
        return sb;
    }

    public static char[] unsignedHexArray(int number) {
        char[] chars = new char[8];
        int i = 0;
        int s = 28;
        while (i < 8) {
            chars[i] = StringUtils.hexChar(number >>> s & 0xF);
            ++i;
            s -= 4;
        }
        return chars;
    }

    public static char[] unsignedHexArray(long number) {
        char[] chars = new char[16];
        int i = 0;
        int s = 60;
        while (i < 16) {
            chars[i] = StringUtils.hexChar(number >>> s & 0xFL);
            ++i;
            s -= 4;
        }
        return chars;
    }

    public static String unsignedHex(int number) {
        return String.valueOf(StringUtils.unsignedHexArray(number));
    }

    public static String unsignedHex(long number) {
        return String.valueOf(StringUtils.unsignedHexArray(number));
    }

    public static long longFromDec(CharSequence cs, int start, int end) {
        int lim;
        int h;
        int sign;
        if (cs == null || start < 0 || end <= 0 || (end = Math.min(end, cs.length())) - start <= 0) {
            return 0L;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            sign = -1;
            h = 0;
            lim = 21;
        } else if (c == '+') {
            sign = 1;
            h = 0;
            lim = 21;
        } else {
            if (c < '0' || c > '9') {
                return 0L;
            }
            sign = 1;
            lim = 20;
            h = c - 48;
        }
        long data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (c < '0' || c > '9') {
                return data * (long)sign;
            }
            data *= 10L;
            data += (long)(c - 48);
        }
        return data * (long)sign;
    }

    public static int intFromDec(CharSequence cs, int start, int end) {
        int lim;
        int h;
        int sign;
        if (cs == null || start < 0 || end <= 0 || (end = Math.min(end, cs.length())) - start <= 0) {
            return 0;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            sign = -1;
            h = 0;
            lim = 11;
        } else if (c == '+') {
            sign = 1;
            h = 0;
            lim = 11;
        } else {
            if (c < '0' || c > '9') {
                return 0;
            }
            sign = 1;
            lim = 10;
            h = c - 48;
        }
        int data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (c < '0' || c > '9') {
                return data * sign;
            }
            data *= 10;
            data += c - 48;
        }
        return data * sign;
    }

    public static int intFromHex(CharSequence cs, int start, int end) {
        int lim;
        int h;
        int sign;
        if (cs == null || start < 0 || end <= 0 || (end = Math.min(end, cs.length())) - start <= 0) {
            return 0;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            sign = -1;
            h = 0;
            lim = 9;
        } else if (c == '+') {
            sign = 1;
            h = 0;
            lim = 9;
        } else {
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                return 0;
            }
            sign = 1;
            lim = 8;
            h = StringUtils.hexCode(c);
        }
        int data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                return data * sign;
            }
            data <<= 4;
            data |= StringUtils.hexCode(c);
        }
        return data * sign;
    }

    public static long longFromHex(CharSequence cs, int start, int end) {
        int lim;
        int h;
        int sign;
        if (cs == null || start < 0 || end <= 0 || (end = Math.min(end, cs.length())) - start <= 0) {
            return 0L;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            sign = -1;
            h = 0;
            lim = 17;
        } else if (c == '+') {
            sign = 1;
            h = 0;
            lim = 17;
        } else {
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                return 0L;
            }
            sign = 1;
            lim = 16;
            h = StringUtils.hexCode(c);
        }
        long data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                return data * (long)sign;
            }
            data <<= 4;
            data |= (long)StringUtils.hexCode(c);
        }
        return data * (long)sign;
    }

    public static float floatFromDec(CharSequence cs, int start, int end) {
        int h;
        int len;
        float decimal = 1.0f;
        boolean foundPoint = false;
        if (cs == null || start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0.0f;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            len = -1;
            h = 0;
        } else if (c == '+') {
            len = 1;
            h = 0;
        } else {
            if (c < '0' || c > '9') {
                return 0.0f;
            }
            h = StringUtils.hexCode(c);
            len = 1;
        }
        int data = h;
        for (int i = start + 1; i < end; ++i) {
            c = cs.charAt(i);
            if (c == '.') {
                foundPoint = true;
                continue;
            }
            if (c < '0' || c > '9') {
                return (float)(data * len) / decimal;
            }
            h = StringUtils.hexCode(c);
            if (foundPoint) {
                decimal *= 10.0f;
            }
            data = data * 10 + h;
        }
        return (float)(data * len) / decimal;
    }

    public static int indexAfter(String text, String search, int from) {
        return (from = text.indexOf(search, from)) < 0 ? text.length() : from + search.length();
    }

    public static String safeSubstring(String source, int beginIndex, int endIndex) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0 || endIndex > source.length()) {
            endIndex = source.length();
        }
        if (beginIndex >= endIndex) {
            return "";
        }
        return source.substring(beginIndex, endIndex);
    }

    public static boolean isLowerCase(char c) {
        return Category.Ll.contains(c);
    }

    public static boolean isUpperCase(char c) {
        return Category.Lu.contains(c);
    }
}

