/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.CharArray;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntFloatMap;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.LongArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.ObjectLongMap;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedMap;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.UBJsonReader;
import com.badlogic.gdx.utils.compression.Lzma;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.github.tommyettinger.textra.ColorLookup;
import com.github.tommyettinger.textra.FWSkin;
import com.github.tommyettinger.textra.Layout;
import com.github.tommyettinger.textra.Line;
import com.github.tommyettinger.textra.TypingConfig;
import com.github.tommyettinger.textra.utils.BlockUtils;
import com.github.tommyettinger.textra.utils.CaseInsensitiveIntMap;
import com.github.tommyettinger.textra.utils.ColorUtils;
import com.github.tommyettinger.textra.utils.LZBDecompression;
import com.github.tommyettinger.textra.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.IdentityHashMap;
import regexodus.Category;
import regexodus.Pattern;
import regexodus.Replacer;

public class Font
implements Disposable {
    public static boolean canUseTextures = true;
    public boolean sharing = false;
    public IntMap<GlyphRegion> mapping;
    public CaseInsensitiveIntMap nameLookup;
    public IntMap<String> namesByCharCode;
    public GlyphRegion defaultValue;
    public Array<TextureRegion> parents;
    protected DistanceFieldType distanceField = DistanceFieldType.STANDARD;
    private static final IdentityHashMap<Batch, Float> smoothingValues = new IdentityHashMap(8);
    private static Texture latestTexture = null;
    public boolean isMono;
    public IntFloatMap kerning;
    public float actualCrispness = 1.0f;
    public float distanceFieldCrispness = 1.0f;
    public float cellWidth = 1.0f;
    public float cellHeight = 1.0f;
    public float originalCellWidth = 1.0f;
    public float originalCellHeight = 1.0f;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float descent = 0.0f;
    public char solidBlock = (char)9608;
    public FontFamily family;
    public ColorLookup colorLookup = ColorLookup.DESCRIPTIVE;
    public boolean integerPosition = false;
    public float obliqueStrength = 1.0f;
    public float boldStrength = 1.0f;
    public float outlineStrength = 1.0f;
    public float boxDrawingBreadth = 1.0f;
    public String name = "Unnamed Font";
    public Texture whiteBlock = null;
    public static final long BOLD = 0x40000000L;
    public static final long OBLIQUE = 0x20000000L;
    public static final long UNDERLINE = 0x10000000L;
    public static final long STRIKETHROUGH = 0x8000000L;
    public static final long SUBSCRIPT = 0x2000000L;
    public static final long MIDSCRIPT = 0x4000000L;
    public static final long SUPERSCRIPT = 0x6000000L;
    public static final long ALTERNATE = 0x1000000L;
    public static final long ALTERNATE_MODES_MASK = 0x1E00000L;
    public static final long SMALL_CAPS = 0x1100000L;
    public static final long JOSTLE = 0x1000000L;
    public static final long BLACK_OUTLINE = 0x1200000L;
    public static final long WHITE_OUTLINE = 0x1400000L;
    public static final long DROP_SHADOW = 0x1600000L;
    public static final long SHINY = 0x1800000L;
    public static final long ERROR = 0x1A00000L;
    public static final long WARN = 0x1C00000L;
    public static final long NOTE = 0x1E00000L;
    public float PACKED_BLACK = NumberUtils.intBitsToFloat((int)-33554432);
    public float PACKED_WHITE = Color.WHITE_FLOAT_BITS;
    public float PACKED_ERROR_COLOR = -4.253659E37f;
    public float PACKED_WARN_COLOR = -4.812999E37f;
    public float PACKED_NOTE_COLOR = -1.2264254E38f;
    public float PACKED_SHADOW_COLOR = 5.354443E37f;
    public float xAdjust;
    public float yAdjust;
    public float widthAdjust;
    public float heightAdjust;
    public float underX;
    public float underY;
    public float underLength;
    public float underBreadth;
    public float strikeX;
    public float strikeY;
    public float strikeLength;
    public float strikeBreadth;
    public float fancyX;
    public float fancyY;
    public float inlineImageOffsetX = 0.0f;
    public float inlineImageOffsetY = 0.0f;
    public float inlineImageXAdvance = 0.0f;
    public float inlineImageStretch = 1.0f;
    public boolean omitCurlyBraces = true;
    public boolean enableSquareBrackets = true;
    protected final transient float[] vertices = new float[20];
    protected final transient Layout tempLayout = new Layout();
    protected final transient LongArray glyphBuffer = new LongArray(128);
    protected final transient LongArray historyBuffer = new LongArray(64);
    protected final transient ObjectLongMap<String> labeledStates = new ObjectLongMap(16);
    protected final ObjectLongMap<String> storedStates = new ObjectLongMap(16);
    protected final CharArray breakChars = CharArray.with((char[])new char[]{'\t', '\r', ' ', '-', '\u00ad', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u200b', '\u2010', '\u2012', '\u2013', '\u2014', '\u2027'});
    private final CharArray spaceChars = CharArray.with((char[])new char[]{'\t', '\r', ' ', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u200b'});
    public static final Replacer CJK_SPACE_INSERTER = new Replacer(Pattern.compile((String)"([\u2e80-\u303f\u31c0-\u31ef\u3200-\u9fff\uf900-\ufaff\ufe30-\ufe4f])"), "$1\u200b");
    public static final String vertexShader = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tv_color = a_color;\n\tv_color.a = v_color.a * (255.0/254.0);\n\tv_texCoords = a_texCoord0;\n\tgl_Position =  u_projTrans * a_position;\n}\n";
    public static final String sdfFragmentShader = "#ifdef GL_ES\n\tprecision mediump float;\n\tprecision mediump int;\n#endif\n\nuniform sampler2D u_texture;\nuniform float u_smoothing;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tif (u_smoothing > 0.0) {\n\t\tfloat smoothing = 0.25 / u_smoothing;\n\t\tvec4 color = texture2D(u_texture, v_texCoords);\n\t\tfloat alpha = smoothstep(0.5 - smoothing, 0.5 + smoothing, color.a);\n\t\tgl_FragColor = vec4(v_color.rgb * color.rgb, alpha * v_color.a);\n  } else {\n\t    gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n  }\n}\n";
    public static final String sdfBlackOutlineFragmentShader = "#ifdef GL_ES\nprecision mediump float;\n#endif\nuniform sampler2D u_texture;\nuniform float u_smoothing;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\nconst float closeness = 0.015625; // Between 0 and 0.5, 0 = thick outline, 0.5 = no outline\nvoid main() {\n  if (u_smoothing > 0.0) {\n    float smoothing = 0.5 / u_smoothing;\n    vec4 image = texture2D(u_texture, v_texCoords);\n    float outlineFactor = smoothstep(0.5 - smoothing, 0.5 + smoothing, image.a);\n    vec3 color = image.rgb * v_color.rgb * outlineFactor;\n    float alpha = smoothstep(closeness, closeness + smoothing, image.a);\n    gl_FragColor = vec4(color, v_color.a * alpha);\n  } else {\n    gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n  }\n}";
    public static final String msdfFragmentShader = "#ifdef GL_ES\nprecision mediump float;\n#endif\n#if __VERSION__ >= 130\n#define TEXTURE texture\n#else\n#define TEXTURE texture2D\n#endif\nuniform sampler2D u_texture;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\nuniform float u_smoothing;\nfloat median(float r, float g, float b) {\n    return max(min(r, g), min(max(r, g), b));\n}\nvoid main() {\n  if (u_smoothing > 0.0) {\n    vec4 msdf = TEXTURE(u_texture, v_texCoords);\n    float distance = u_smoothing * (median(msdf.r, msdf.g, msdf.b) - 0.5);\n    float glyphAlpha = clamp(distance + 0.5, 0.0, 1.0);\n    gl_FragColor = vec4(v_color.rgb, glyphAlpha * v_color.a);\n  } else {\n    gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n  }\n}";
    public ShaderProgram shader = null;

    public static String getJsonExtension(String jsonName) {
        if (Gdx.files.internal(jsonName + ".ubj.lzma").exists()) {
            return jsonName + ".ubj.lzma";
        }
        if (Gdx.files.internal(jsonName + ".json.lzma").exists()) {
            return jsonName + ".json.lzma";
        }
        if (Gdx.files.internal(jsonName + ".ubj").exists()) {
            return jsonName + ".ubj";
        }
        if (Gdx.files.internal(jsonName + ".dat").exists()) {
            return jsonName + ".dat";
        }
        if (Gdx.files.internal(jsonName + ".json").exists()) {
            return jsonName + ".json";
        }
        throw new GdxRuntimeException("No file was found with an appropriate extension appended to " + jsonName);
    }

    public static String insertZeroWidthSpacesInCJK(CharSequence text) {
        return CJK_SPACE_INSERTER.replace(text);
    }

    public ColorLookup getColorLookup() {
        return this.colorLookup;
    }

    public Font setColorLookup(ColorLookup lookup) {
        if (lookup != null) {
            this.colorLookup = lookup;
        }
        return this;
    }

    public Font() {
        this(new BitmapFont(), 0.0f, 2.0f, 0.0f, 0.0f);
    }

    public Font(String fntName) {
        this(fntName, DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, DistanceFieldType distanceField) {
        this(fntName, distanceField, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, String textureName) {
        this(fntName, textureName, DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, String textureName, DistanceFieldType distanceField) {
        this(fntName, textureName, distanceField, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(Font toCopy) {
        this.distanceField = toCopy.distanceField;
        this.isMono = toCopy.isMono;
        this.actualCrispness = toCopy.actualCrispness;
        this.distanceFieldCrispness = toCopy.distanceFieldCrispness;
        this.cellWidth = toCopy.cellWidth;
        this.cellHeight = toCopy.cellHeight;
        this.scaleX = toCopy.scaleX;
        this.scaleY = toCopy.scaleY;
        this.originalCellWidth = toCopy.originalCellWidth;
        this.originalCellHeight = toCopy.originalCellHeight;
        this.descent = toCopy.descent;
        this.boldStrength = toCopy.boldStrength;
        this.obliqueStrength = toCopy.obliqueStrength;
        this.outlineStrength = toCopy.outlineStrength;
        this.underX = toCopy.underX;
        this.underY = toCopy.underY;
        this.underLength = toCopy.underLength;
        this.underBreadth = toCopy.underBreadth;
        this.strikeX = toCopy.strikeX;
        this.strikeY = toCopy.strikeY;
        this.strikeLength = toCopy.strikeLength;
        this.strikeBreadth = toCopy.strikeBreadth;
        this.fancyX = toCopy.fancyX;
        this.fancyY = toCopy.fancyY;
        this.boxDrawingBreadth = toCopy.boxDrawingBreadth;
        this.xAdjust = toCopy.xAdjust;
        this.yAdjust = toCopy.yAdjust;
        this.widthAdjust = toCopy.widthAdjust;
        this.heightAdjust = toCopy.heightAdjust;
        this.inlineImageOffsetX = toCopy.inlineImageOffsetX;
        this.inlineImageOffsetY = toCopy.inlineImageOffsetY;
        this.inlineImageXAdvance = toCopy.inlineImageXAdvance;
        this.inlineImageStretch = toCopy.inlineImageStretch;
        this.parents = new Array(toCopy.parents);
        this.mapping = new IntMap(toCopy.mapping.size);
        if (toCopy.sharing) {
            this.sharing = true;
            this.mapping = toCopy.mapping;
            this.nameLookup = toCopy.nameLookup;
            this.namesByCharCode = toCopy.namesByCharCode;
            this.kerning = toCopy.kerning;
        } else {
            for (IntMap.Entry e : toCopy.mapping) {
                if (e.value == null) continue;
                this.mapping.put(e.key, (Object)new GlyphRegion((GlyphRegion)((Object)e.value)));
            }
            if (toCopy.nameLookup != null) {
                this.nameLookup = new CaseInsensitiveIntMap(toCopy.nameLookup);
            }
            if (toCopy.namesByCharCode != null) {
                this.namesByCharCode = new IntMap(toCopy.namesByCharCode);
            }
            this.kerning = toCopy.kerning == null ? null : new IntFloatMap(toCopy.kerning);
        }
        this.defaultValue = toCopy.defaultValue;
        this.solidBlock = toCopy.solidBlock;
        this.name = toCopy.name;
        this.integerPosition = toCopy.integerPosition;
        this.omitCurlyBraces = toCopy.omitCurlyBraces;
        this.enableSquareBrackets = toCopy.enableSquareBrackets;
        this.whiteBlock = toCopy.whiteBlock;
        this.storedStates.putAll(toCopy.storedStates);
        if (toCopy.family != null) {
            int connect;
            this.family = new FontFamily(toCopy.family);
            Font[] connected = this.family.connected;
            for (int i = 0; i < connected.length; ++i) {
                Font f = connected[i];
                if (f != toCopy) continue;
                connected[i] = this;
                break;
            }
            if (toCopy.name != null && (connect = this.family.fontAliases.remove(toCopy.name, -1)) != -1 && this.name != null) {
                this.family.fontAliases.put(this.name, connect);
            }
        }
        this.PACKED_BLACK = toCopy.PACKED_BLACK;
        this.PACKED_WHITE = toCopy.PACKED_WHITE;
        this.PACKED_ERROR_COLOR = toCopy.PACKED_ERROR_COLOR;
        this.PACKED_WARN_COLOR = toCopy.PACKED_WARN_COLOR;
        this.PACKED_NOTE_COLOR = toCopy.PACKED_NOTE_COLOR;
        this.PACKED_SHADOW_COLOR = toCopy.PACKED_SHADOW_COLOR;
        if (toCopy.shader != null) {
            this.shader = toCopy.shader;
        }
        if (toCopy.colorLookup != null) {
            this.colorLookup = toCopy.colorLookup;
        }
    }

    public Font(String fntName, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.setDistanceField(distanceField);
        FileHandle fntHandle = Gdx.files.internal(fntName);
        if (!fntHandle.exists()) {
            throw new RuntimeException("Missing font file: " + fntName);
        }
        this.loadFNT(fntHandle, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(FileHandle fntHandle, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.setDistanceField(distanceField);
        if (!fntHandle.exists()) {
            throw new RuntimeException("Missing font file: " + fntHandle.name());
        }
        this.loadFNT(fntHandle, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(String fntName, String textureName, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureName, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, String textureName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureName, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, String textureName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.setDistanceField(distanceField);
        if (textureName == null) {
            this.parents = Array.of((boolean)true, (int)1, TextureRegion.class);
            this.parents.add((Object)new TexturelessRegion());
        } else {
            FileHandle textureHandle = Gdx.files.internal(textureName);
            if (textureHandle.exists()) {
                this.parents = Array.with((Object[])new TextureRegion[]{new TextureRegion(new Texture(textureHandle))});
                if (distanceField != DistanceFieldType.STANDARD) {
                    ((TextureRegion)this.parents.first()).getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                }
            } else {
                throw new RuntimeException("Missing texture file: " + textureName);
            }
        }
        FileHandle fntHandle = Gdx.files.internal(fntName);
        if (!fntHandle.exists()) {
            throw new RuntimeException("Missing font file: " + fntName);
        }
        this.loadFNT(fntHandle, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(String fntName, TextureRegion textureRegion, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegion, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, TextureRegion textureRegion, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegion, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, TextureRegion textureRegion, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        FileHandle fntHandle;
        this.setDistanceField(distanceField);
        this.parents = Array.with((Object[])new TextureRegion[]{textureRegion});
        if (textureRegion.getTexture() != null && distanceField != DistanceFieldType.STANDARD) {
            textureRegion.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
        if (!(fntHandle = Gdx.files.internal(fntName)).exists()) {
            throw new RuntimeException("Missing font file: " + fntName);
        }
        this.loadFNT(fntHandle, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(FileHandle fntHandle, TextureRegion textureRegion, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.setDistanceField(distanceField);
        this.parents = Array.with((Object[])new TextureRegion[]{textureRegion});
        if (textureRegion.getTexture() != null && distanceField != DistanceFieldType.STANDARD) {
            textureRegion.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
        if (!fntHandle.exists()) {
            throw new RuntimeException("Missing font file: " + fntHandle.name());
        }
        this.loadFNT(fntHandle, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(String fntName, Array<TextureRegion> textureRegions, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegions, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, Array<TextureRegion> textureRegions, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegions, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, Array<TextureRegion> textureRegions, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        FileHandle fntHandle;
        this.setDistanceField(distanceField);
        this.parents = textureRegions;
        if (distanceField != DistanceFieldType.STANDARD && textureRegions != null) {
            for (TextureRegion parent : textureRegions) {
                if (parent.getTexture() == null) continue;
                parent.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        }
        if (!(fntHandle = Gdx.files.internal(fntName)).exists()) {
            throw new RuntimeException("Missing font file: " + fntName);
        }
        this.loadFNT(fntHandle, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(FileHandle fntHandle, Array<TextureRegion> textureRegions, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.setDistanceField(distanceField);
        this.parents = textureRegions;
        if (distanceField != DistanceFieldType.STANDARD && textureRegions != null) {
            for (TextureRegion parent : textureRegions) {
                if (parent.getTexture() == null) continue;
                parent.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        }
        if (!fntHandle.exists()) {
            throw new RuntimeException("Missing font file: " + fntHandle.name());
        }
        this.loadFNT(fntHandle, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(BitmapFont bmFont) {
        this(bmFont, DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, false);
    }

    public Font(BitmapFont bmFont, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(bmFont, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(BitmapFont bmFont, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(bmFont, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(BitmapFont bmFont, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        TextureRegion parent2;
        this.setDistanceField(distanceField);
        this.parents = bmFont.getRegions();
        if (distanceField != DistanceFieldType.STANDARD && this.parents != null) {
            for (TextureRegion parent2 : this.parents) {
                if (parent2.getTexture() == null) continue;
                parent2.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        }
        float offsetY = 0.0f;
        if (this.parents != null && this.parents.notEmpty() && (parent2 = (TextureRegion)this.parents.first()) instanceof TextureAtlas.AtlasRegion) {
            offsetY = (float)(((TextureAtlas.AtlasRegion)parent2).originalHeight - ((TextureAtlas.AtlasRegion)parent2).packedHeight) - ((TextureAtlas.AtlasRegion)parent2).offsetY;
        }
        BitmapFont.BitmapFontData data = bmFont.getData();
        this.mapping = new IntMap(128);
        float minWidth = Float.MAX_VALUE;
        this.xAdjust = xAdjust;
        this.yAdjust = yAdjust;
        this.widthAdjust = widthAdjust;
        this.heightAdjust = heightAdjust;
        float size = data.lineHeight * 0.8f;
        this.descent = size * -0.25f;
        this.originalCellHeight = this.cellHeight = heightAdjust - this.descent + size;
        this.underY = 0.05f;
        this.strikeY = 0.15f;
        this.underBreadth = -0.375f;
        this.strikeBreadth = -0.375f;
        if (makeGridGlyphs) {
            this.strikeLength = 0.05f;
            this.underLength = 0.05f;
            this.strikeX = -0.05f;
            this.underX = -0.05f;
        } else {
            this.strikeLength = 0.0f;
            this.underLength = 0.0f;
            this.strikeX = 0.0f;
            this.underX = 0.0f;
        }
        this.fancyY = 2.0f;
        for (BitmapFont.Glyph[] page : data.glyphs) {
            if (page == null) continue;
            for (BitmapFont.Glyph glyph : page) {
                byte k;
                int i;
                if (glyph == null) continue;
                float x = (float)glyph.srcX + data.padLeft;
                float y = (float)glyph.srcY + data.padTop;
                float w = (float)glyph.width - data.padLeft;
                float h = (float)glyph.height - data.padTop;
                float a = glyph.xadvance;
                float yOffset = glyph.yoffset;
                if (offsetY > 0.0f) {
                    float regionHeight;
                    y -= offsetY;
                    float y2 = (y = Math.max(0.0f, y)) + h - offsetY;
                    if (y2 > (regionHeight = (float)bmFont.getRegion(glyph.page).getRegionHeight())) {
                        float amount = y2 - regionHeight;
                        h -= amount;
                        yOffset += amount;
                    }
                }
                if (glyph.id != 9608) {
                    minWidth = Math.min(minWidth, a);
                }
                this.cellWidth = Math.max(a, this.cellWidth);
                GlyphRegion gr = new GlyphRegion(bmFont.getRegion(glyph.page), x, y, w, h);
                if (glyph.id == 10) {
                    a = 0.0f;
                    gr.offsetX = 0.0f;
                } else {
                    gr.offsetX = makeGridGlyphs && BlockUtils.isBlockGlyph(glyph.id) ? Float.NaN : (float)glyph.xoffset + xAdjust;
                }
                gr.offsetY = yAdjust - h - yOffset;
                gr.xAdvance = a + widthAdjust;
                this.mapping.put(glyph.id & 0xFFFF, (Object)gr);
                if (glyph.kerning != null) {
                    if (this.kerning == null) {
                        this.kerning = new IntFloatMap(128);
                    }
                    for (int b = 0; b < glyph.kerning.length; ++b) {
                        byte[] kern = glyph.kerning[b];
                        if (kern == null) continue;
                        for (i = 0; i < 512; ++i) {
                            k = kern[i];
                            if (k != 0) {
                                this.kerning.put(glyph.id << 16 | (b << 9 | i), (float)k);
                            }
                            if ((b << 9 | i) != 91) continue;
                            this.kerning.put(glyph.id << 16 | 2, (float)k);
                        }
                    }
                }
                if ((glyph.id & 0xFFFF) != 91) continue;
                this.mapping.put(2, (Object)gr);
                if (glyph.kerning == null) continue;
                for (int b = 0; b < glyph.kerning.length; ++b) {
                    byte[] kern = glyph.kerning[b];
                    if (kern == null) continue;
                    for (i = 0; i < 512; ++i) {
                        k = kern[i];
                        if (k == 0) continue;
                        this.kerning.put(0x20000 | (b << 9 | i), (float)k);
                    }
                }
            }
        }
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = (GlyphRegion)((Object)this.mapping.get(10));
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
        }
        if (this.mapping.containsKey(32)) {
            this.mapping.put(13, (Object)((GlyphRegion)((Object)this.mapping.get(32))));
            this.mapping.put(8203, (Object)new GlyphRegion((TextureRegion)this.mapping.get(32), 0.0f, 0.0f, 0.0f));
        }
        this.solidBlock = (char)9608;
        if (makeGridGlyphs) {
            Pixmap temp = new Pixmap(3, 3, Pixmap.Format.RGBA8888);
            temp.setColor(Color.WHITE);
            temp.fill();
            this.whiteBlock = new Texture(3, 3, Pixmap.Format.RGBA8888);
            this.whiteBlock.draw(temp, 0, 0);
            GlyphRegion block = new GlyphRegion(new TextureRegion(this.whiteBlock, 1, 1, 1, 1));
            this.mapping.put((int)this.solidBlock, (Object)block);
            temp.dispose();
            for (int i = 9472; i < 9472 + BlockUtils.BOX_DRAWING.length; ++i) {
                if (!BlockUtils.isBlockGlyph(i)) continue;
                this.mapping.put(i, (Object)new GlyphRegion(block, Float.NaN, this.cellHeight, this.cellWidth));
            }
        }
        this.defaultValue = (GlyphRegion)((Object)this.mapping.get(data.missingGlyph == null ? 32 : data.missingGlyph.id, (Object)((GlyphRegion)((Object)this.mapping.get(32, (Object)((GlyphRegion)((Object)this.mapping.values().next())))))));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        this.isMono = minWidth == this.cellWidth && this.kerning == null;
        this.integerPosition = bmFont.usesIntegerPositions();
        this.inlineImageOffsetX = 0.0f;
        this.inlineImageOffsetY = 0.0f;
        this.inlineImageXAdvance = 0.0f;
        this.inlineImageStretch = 1.0f;
        this.scale(bmFont.getScaleX(), bmFont.getScaleY());
    }

    public Font(String prefix, String fontName, boolean ignoredSadConsoleFlag) {
        this.setDistanceField(DistanceFieldType.STANDARD);
        this.loadSad(prefix == null ? "" : prefix, fontName);
    }

    protected void loadFNT(FileHandle fntHandle, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        int kernings;
        int idx;
        String fnt = fntHandle.readString("UTF-8");
        this.xAdjust = xAdjust;
        this.yAdjust = yAdjust;
        this.widthAdjust = widthAdjust;
        this.heightAdjust = heightAdjust;
        int n = idx = StringUtils.indexAfter(fnt, "padding=", 0);
        idx = StringUtils.indexAfter(fnt, ",", idx + 1);
        int padTop = StringUtils.intFromDec(fnt, n, idx);
        int n2 = idx;
        idx = StringUtils.indexAfter(fnt, ",", idx + 1);
        int padRight = StringUtils.intFromDec(fnt, n2, idx);
        int n3 = idx;
        idx = StringUtils.indexAfter(fnt, ",", idx + 1);
        int padBottom = StringUtils.intFromDec(fnt, n3, idx);
        int n4 = idx;
        idx = StringUtils.indexAfter(fnt, "lineHeight=", idx + 1);
        int padLeft = StringUtils.intFromDec(fnt, n4, idx);
        int n5 = idx;
        idx = StringUtils.indexAfter(fnt, "base=", idx);
        float rawLineHeight = StringUtils.floatFromDec(fnt, n5, idx);
        int n6 = idx;
        idx = StringUtils.indexAfter(fnt, "pages=", idx);
        float baseline = StringUtils.floatFromDec(fnt, n6, idx);
        this.descent = 0.0f;
        int n7 = idx;
        idx = StringUtils.indexAfter(fnt, "\npage id=", idx);
        int pages = StringUtils.intFromDec(fnt, n7, idx);
        if (this.parents == null || this.parents.size < pages) {
            if (this.parents == null) {
                this.parents = new Array(true, pages, TextureRegion.class);
            } else {
                this.parents.clear();
            }
            for (int i = 0; i < pages; ++i) {
                int n8 = StringUtils.indexAfter(fnt, "file=\"", idx);
                idx = n8;
                idx = fnt.indexOf(34, idx);
                String textureName = fnt.substring(n8, idx);
                if (!canUseTextures) {
                    this.parents = Array.of((boolean)true, (int)1, TextureRegion.class);
                    this.parents.add((Object)new TexturelessRegion());
                    continue;
                }
                FileHandle textureHandle = Gdx.files.internal(textureName);
                if (textureHandle.exists()) {
                    this.parents.add((Object)new TextureRegion(new Texture(textureHandle)));
                    if (this.getDistanceField() == DistanceFieldType.STANDARD) continue;
                    ((TextureRegion)this.parents.peek()).getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                    continue;
                }
                throw new RuntimeException("Missing texture file: " + textureName);
            }
        }
        int n9 = StringUtils.indexAfter(fnt, "\nchars count=", idx);
        idx = n9;
        idx = StringUtils.indexAfter(fnt, "\nchar id=", idx);
        int size = StringUtils.intFromDec(fnt, n9, idx);
        this.mapping = new IntMap(size);
        float minWidth = 2.1474836E9f;
        for (int i = 0; i < size && idx != fnt.length(); ++i) {
            int n10 = idx;
            idx = StringUtils.indexAfter(fnt, " x=", idx);
            int c = StringUtils.intFromDec(fnt, n10, idx);
            int n11 = idx;
            idx = StringUtils.indexAfter(fnt, " y=", idx);
            float x = StringUtils.floatFromDec(fnt, n11, idx);
            int n12 = idx;
            idx = StringUtils.indexAfter(fnt, " width=", idx);
            float y = StringUtils.floatFromDec(fnt, n12, idx);
            int n13 = idx;
            idx = StringUtils.indexAfter(fnt, " height=", idx);
            float w = StringUtils.floatFromDec(fnt, n13, idx);
            int n14 = idx;
            idx = StringUtils.indexAfter(fnt, " xoffset=", idx);
            float h = StringUtils.floatFromDec(fnt, n14, idx);
            int n15 = idx;
            idx = StringUtils.indexAfter(fnt, " yoffset=", idx);
            float xo = StringUtils.floatFromDec(fnt, n15, idx);
            int n16 = idx;
            idx = StringUtils.indexAfter(fnt, " xadvance=", idx);
            float yo = StringUtils.floatFromDec(fnt, n16, idx);
            int n17 = idx;
            idx = StringUtils.indexAfter(fnt, " page=", idx);
            float a = StringUtils.floatFromDec(fnt, n17, idx);
            int n18 = idx;
            idx = StringUtils.indexAfter(fnt, "\nchar id=", idx);
            int p = StringUtils.intFromDec(fnt, n18, idx);
            if (c != 9608) {
                minWidth = Math.min(minWidth, a + widthAdjust);
            }
            GlyphRegion gr = new GlyphRegion((TextureRegion)this.parents.get(p), x, y, w, h);
            if (c == 10) {
                a = 0.0f;
                gr.offsetX = 0.0f;
            } else {
                gr.offsetX = makeGridGlyphs && BlockUtils.isBlockGlyph(c) ? Float.NaN : xo + xAdjust;
            }
            gr.offsetY = yo + yAdjust;
            gr.xAdvance = a + widthAdjust;
            this.cellWidth = Math.max(a + widthAdjust, this.cellWidth);
            this.cellHeight = Math.max(h + heightAdjust, this.cellHeight);
            if (w * h > 1.0f) {
                this.descent = Math.min(baseline - h - yo, this.descent);
            }
            this.mapping.put(c, (Object)gr);
            if (c != 91) continue;
            this.mapping.put(2, (Object)gr);
        }
        idx = StringUtils.indexAfter(fnt, "\nkernings count=", 0);
        if (idx < fnt.length() && (kernings = StringUtils.intFromDec(fnt, idx, idx = StringUtils.indexAfter(fnt, "\nkerning first=", idx))) >= 1) {
            this.kerning = new IntFloatMap(kernings);
            for (int i = 0; i < kernings; ++i) {
                int n19 = idx;
                idx = StringUtils.indexAfter(fnt, " second=", idx);
                int first = StringUtils.intFromDec(fnt, n19, idx);
                int n20 = idx;
                idx = StringUtils.indexAfter(fnt, " amount=", idx);
                int second = StringUtils.intFromDec(fnt, n20, idx);
                int n21 = idx;
                idx = StringUtils.indexAfter(fnt, "\nkerning first=", idx);
                float amount = StringUtils.floatFromDec(fnt, n21, idx);
                this.kerning.put(first << 16 | second, amount);
                if (first == 91) {
                    this.kerning.put(0x20000 | second, amount);
                }
                if (second != 91) continue;
                this.kerning.put(first << 16 | 2, amount);
            }
        }
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = (GlyphRegion)((Object)this.mapping.get(10));
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
            gr.xAdvance = 0.0f;
        }
        if (this.mapping.containsKey(32)) {
            this.mapping.put(13, (Object)((GlyphRegion)((Object)this.mapping.get(32))));
            this.mapping.put(8203, (Object)new GlyphRegion((TextureRegion)this.mapping.get(32), 0.0f, 0.0f, 0.0f));
        }
        this.solidBlock = (char)(this.mapping.containsKey(9608) ? 9608 : 65535);
        if (makeGridGlyphs) {
            GlyphRegion block = (GlyphRegion)((Object)this.mapping.get((int)this.solidBlock, null));
            if (block == null && canUseTextures) {
                Pixmap temp = new Pixmap(3, 3, Pixmap.Format.RGBA8888);
                temp.setColor(Color.WHITE);
                temp.fill();
                this.whiteBlock = new Texture(3, 3, Pixmap.Format.RGBA8888);
                this.whiteBlock.draw(temp, 0, 0);
                this.solidBlock = (char)9608;
                block = new GlyphRegion(new TextureRegion(this.whiteBlock, 1, 1, 1, 1));
                this.mapping.put((int)this.solidBlock, (Object)block);
                temp.dispose();
            }
            for (int i = 9472; i < 9472 + BlockUtils.BOX_DRAWING.length; ++i) {
                if (!BlockUtils.isBlockGlyph(i)) continue;
                GlyphRegion gr = new GlyphRegion(block);
                gr.offsetX = Float.NaN;
                gr.xAdvance = this.cellWidth;
                gr.offsetY = this.cellHeight;
                this.mapping.put(i, (Object)gr);
            }
        } else if (!canUseTextures) {
            this.solidBlock = (char)9608;
            this.mapping.put((int)this.solidBlock, (Object)new GlyphRegion(new TexturelessRegion()));
        } else if (!this.mapping.containsKey((int)this.solidBlock)) {
            Pixmap temp = new Pixmap(3, 3, Pixmap.Format.RGBA8888);
            temp.setColor(Color.WHITE);
            temp.fill();
            this.whiteBlock = new Texture(3, 3, Pixmap.Format.RGBA8888);
            this.whiteBlock.draw(temp, 0, 0);
            this.solidBlock = (char)9608;
            this.mapping.put((int)this.solidBlock, (Object)new GlyphRegion(new TextureRegion(this.whiteBlock, 1, 1, 1, 1)));
            temp.dispose();
        }
        this.defaultValue = (GlyphRegion)((Object)this.mapping.get(32, (Object)((GlyphRegion)((Object)this.mapping.get(0)))));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight -= this.descent * 0.25f;
        this.isMono = minWidth == this.cellWidth && this.kerning == null;
        this.inlineImageOffsetX = 0.0f;
        this.inlineImageOffsetY = 0.0f;
        this.inlineImageXAdvance = 0.0f;
        this.inlineImageStretch = 1.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadSad(String prefix, String fntName) {
        TextureRegion parent;
        JsonReader reader = new JsonReader();
        FileHandle fntHandle = Gdx.files.internal(prefix + fntName);
        if (!fntHandle.exists()) {
            throw new RuntimeException("Missing font file: " + prefix + fntName);
        }
        JsonValue fnt = reader.parse(fntHandle);
        int pages = 1;
        if (this.parents == null || this.parents.size == 0) {
            if (this.parents == null) {
                this.parents = new Array(true, pages, TextureRegion.class);
            }
            String textureName = fnt.getString("FilePath");
            if (!canUseTextures) {
                parent = new TextureRegion(null, 1, 1);
                this.parents.add((Object)parent);
            } else {
                FileHandle textureHandle = Gdx.files.internal(prefix + textureName);
                if (!textureHandle.exists()) throw new RuntimeException("Missing texture file: " + prefix + textureName);
                parent = new TextureRegion(new Texture(textureHandle));
                this.parents.add((Object)parent);
            }
        } else {
            parent = (TextureRegion)this.parents.first();
        }
        int columns = fnt.getInt("Columns");
        int padding = fnt.getInt("GlyphPadding");
        this.cellHeight = fnt.getInt("GlyphHeight");
        this.cellWidth = fnt.getInt("GlyphWidth");
        this.descent = Math.round(this.cellHeight * -0.25f);
        int rows = (parent.getRegionHeight() - padding) / ((int)this.cellHeight + padding);
        int size = rows * columns;
        this.mapping = new IntMap(size + 1);
        int c = 0;
        for (int y = 0; y < rows; ++y) {
            int x = 0;
            while (x < columns) {
                GlyphRegion gr = new GlyphRegion(parent, x * ((int)this.cellWidth + padding) + padding, y * ((int)this.cellHeight + padding) + padding, (int)this.cellWidth, (int)this.cellHeight);
                gr.offsetX = 0.0f;
                gr.offsetY = this.descent;
                gr.xAdvance = c == 10 ? 0.0f : this.cellWidth;
                this.mapping.put(c, (Object)gr);
                if (c == 91) {
                    if (this.mapping.containsKey(2)) {
                        this.mapping.put(size, (Object)((GlyphRegion)((Object)this.mapping.get(2))));
                    }
                    this.mapping.put(2, (Object)gr);
                }
                ++x;
                ++c;
            }
        }
        this.solidBlock = (char)fnt.getInt("SolidGlyphIndex");
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = (GlyphRegion)((Object)this.mapping.get(10));
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
            gr.xAdvance = 0.0f;
        }
        if (this.mapping.containsKey(32)) {
            this.mapping.put(13, (Object)((GlyphRegion)((Object)this.mapping.get(32))));
            this.mapping.put(8203, (Object)new GlyphRegion((TextureRegion)this.mapping.get(32), 0.0f, 0.0f, 0.0f));
        }
        this.defaultValue = (GlyphRegion)((Object)this.mapping.get(32, (Object)((GlyphRegion)((Object)this.mapping.get(0)))));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        this.integerPosition = true;
        this.isMono = true;
        this.underY += 0.375f;
        this.strikeY += 0.375f;
        this.inlineImageOffsetX = 0.0f;
        this.inlineImageOffsetY = 0.0f;
        this.inlineImageXAdvance = 0.0f;
        this.inlineImageStretch = 1.0f;
    }

    public Font(String jsonName, boolean ignoredStructuredJsonFlag) {
        this(jsonName, (TextureRegion)(!canUseTextures ? new TexturelessRegion((TextureRegion)null, 0, 0, 2048, 2048) : new TextureRegion(new Texture(Gdx.files.internal(jsonName.replaceFirst("\\..+$", ".png"))))), 0.0f, 0.0f, 0.0f, 0.0f, true, ignoredStructuredJsonFlag);
    }

    public Font(String jsonName, TextureRegion textureRegion, boolean makeGridGlyphs, boolean ignoredStructuredJsonFlag) {
        this(jsonName, textureRegion, 0.0f, 0.0f, 0.0f, 0.0f, makeGridGlyphs, ignoredStructuredJsonFlag);
    }

    public Font(String jsonName, TextureRegion textureRegion, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs, boolean ignoredStructuredJsonFlag) {
        FileHandle fntHandle = Gdx.files.internal(jsonName);
        if (!fntHandle.exists()) {
            throw new RuntimeException("Missing font file: " + jsonName);
        }
        this.loadJSON(fntHandle, textureRegion, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(FileHandle jsonHandle, TextureRegion textureRegion, boolean ignoredStructuredJsonFlag) {
        if (!jsonHandle.exists()) {
            throw new RuntimeException("Missing font file: " + jsonHandle);
        }
        this.loadJSON(jsonHandle, textureRegion, 0.0f, 0.0f, 0.0f, 0.0f, true);
    }

    public Font(FileHandle jsonHandle, TextureRegion textureRegion, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs, boolean ignoredStructuredJsonFlag) {
        if (!jsonHandle.exists()) {
            throw new RuntimeException("Missing font file: " + jsonHandle);
        }
        this.loadJSON(jsonHandle, textureRegion, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    protected void loadJSON(FileHandle jsonHandle, TextureRegion textureRegion, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        JsonValue fnt;
        this.parents = Array.with((Object[])new TextureRegion[]{textureRegion});
        this.xAdjust = xAdjust;
        this.yAdjust = yAdjust;
        this.widthAdjust = widthAdjust;
        this.heightAdjust = heightAdjust;
        if ("lzma".equalsIgnoreCase(jsonHandle.extension())) {
            BufferedInputStream bais = jsonHandle.read(4096);
            StreamUtils.OptimizedByteArrayOutputStream baos = new StreamUtils.OptimizedByteArrayOutputStream(4096);
            try {
                Lzma.decompress((InputStream)bais, (OutputStream)baos);
                if (jsonHandle.name().length() > 10 && ".json.lzma".equalsIgnoreCase(jsonHandle.name().substring(jsonHandle.name().length() - 10))) {
                    fnt = new JsonReader().parse(baos.toString("UTF-8"));
                }
                if (jsonHandle.name().length() > 9 && ".ubj.lzma".equalsIgnoreCase(jsonHandle.name().substring(jsonHandle.name().length() - 9))) {
                    StreamUtils.closeQuietly((Closeable)bais);
                    bais = new BufferedInputStream(new ByteArrayInputStream(baos.toByteArray()));
                    fnt = new UBJsonReader().parse((InputStream)bais);
                }
                throw new UnsupportedOperationException("Unsupported file type inside compressed file: " + jsonHandle.path());
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading compressed file: " + jsonHandle.path() + "\n" + e);
            }
            finally {
                StreamUtils.closeQuietly((Closeable)bais);
                StreamUtils.closeQuietly((Closeable)baos);
            }
        } else {
            fnt = jsonHandle.nameWithoutExtension().endsWith(".ubj") ? new UBJsonReader().parse(jsonHandle.read()) : ("dat".equalsIgnoreCase(jsonHandle.extension()) ? new JsonReader().parse(LZBDecompression.decompressFromBytes(jsonHandle.readBytes())) : new JsonReader().parse(jsonHandle));
        }
        this.name = jsonHandle.name().substring(0, jsonHandle.name().indexOf(46));
        JsonValue atlas = fnt.get("atlas");
        String dfType = atlas.getString("type", "");
        if ("msdf".equals(dfType) || "mtsdf".equals(dfType)) {
            this.setDistanceField(DistanceFieldType.MSDF);
            this.setCrispness(atlas.getFloat("distanceRange", 8.0f) * 0.2f);
        } else if ("sdf".equals(dfType) || "psdf".equals(dfType)) {
            this.setDistanceField(DistanceFieldType.SDF);
            this.setCrispness(atlas.getFloat("distanceRange", 8.0f) * 0.2f);
        } else {
            this.setDistanceField(DistanceFieldType.STANDARD);
        }
        float size = atlas.getFloat("size", 16.0f);
        this.descent = size * -0.25f;
        this.originalCellHeight = this.cellHeight = heightAdjust - this.descent + size;
        this.underY = 0.05f;
        this.strikeY = 0.15f;
        this.underBreadth = -0.375f;
        this.strikeBreadth = -0.375f;
        if (makeGridGlyphs) {
            this.strikeLength = 0.05f;
            this.underLength = 0.05f;
            this.strikeX = -0.05f;
            this.underX = -0.05f;
        } else {
            this.strikeLength = 0.0f;
            this.underLength = 0.0f;
            this.strikeX = 0.0f;
            this.underX = 0.0f;
        }
        this.fancyY = 2.0f;
        JsonValue glyphs = fnt.get("glyphs");
        int count = glyphs.size;
        this.mapping = new IntMap(count + 1);
        float minWidth = 2.1474836E9f;
        for (JsonValue current : glyphs) {
            float yo;
            float xo;
            float h;
            float y;
            float w;
            float x;
            int c = current.getInt("unicode", 65535);
            float a = current.getFloat("advance", 1.0f) * size;
            JsonValue planeBounds = current.get("planeBounds");
            JsonValue atlasBounds = current.get("atlasBounds");
            if (atlasBounds != null) {
                x = atlasBounds.getFloat("left", 0.0f);
                w = atlasBounds.getFloat("right", 0.0f) - x;
                y = (float)textureRegion.getRegionHeight() - atlasBounds.getFloat("top", 0.0f);
                h = (float)textureRegion.getRegionHeight() - atlasBounds.getFloat("bottom", 0.0f) - y;
            } else {
                h = 0.0f;
                w = 0.0f;
                y = 0.0f;
                x = 0.0f;
            }
            if (planeBounds != null) {
                xo = planeBounds.getFloat("left", 0.0f) * size;
                yo = size - planeBounds.getFloat("top", 0.0f) * size;
            } else {
                yo = 0.0f;
                xo = 0.0f;
            }
            if (c != 9608) {
                minWidth = Math.min(minWidth, a + widthAdjust);
            }
            GlyphRegion gr = new GlyphRegion(textureRegion, x, y, w, h);
            if (c == 10) {
                a = 0.0f;
                gr.offsetX = 0.0f;
            } else {
                gr.offsetX = makeGridGlyphs && BlockUtils.isBlockGlyph(c) ? Float.NaN : xo + xAdjust;
            }
            gr.offsetY = yo + yAdjust;
            gr.xAdvance = a + widthAdjust;
            this.cellWidth = Math.max(a + widthAdjust, this.cellWidth);
            this.mapping.put(c, (Object)gr);
            if (c != 91) continue;
            this.mapping.put(2, (Object)gr);
        }
        JsonValue kern = fnt.get("kerning");
        if (kern == null || kern.isEmpty()) {
            this.kerning = null;
        } else {
            this.kerning = new IntFloatMap(kern.size);
            for (JsonValue current : kern) {
                int first = current.getInt("unicode1", 65535);
                int second = current.getInt("unicode2", 65535);
                float amount = current.getFloat("advance", 0.0f);
                this.kerning.put(first << 16 | second, amount);
                if (first == 91) {
                    this.kerning.put(0x20000 | second, amount);
                }
                if (second != 91) continue;
                this.kerning.put(first << 16 | 2, amount);
            }
        }
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = (GlyphRegion)((Object)this.mapping.get(10));
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
            gr.xAdvance = 0.0f;
        }
        if (this.mapping.containsKey(32)) {
            this.mapping.put(13, (Object)((GlyphRegion)((Object)this.mapping.get(32))));
            this.mapping.put(8203, (Object)new GlyphRegion((TextureRegion)this.mapping.get(32), 0.0f, 0.0f, 0.0f));
        }
        this.solidBlock = (char)9608;
        if (makeGridGlyphs) {
            GlyphRegion block = new GlyphRegion((TextureRegion)(canUseTextures ? new TextureRegion(textureRegion, textureRegion.getRegionWidth() - 2, textureRegion.getRegionHeight() - 2, 1, 1) : new TexturelessRegion(textureRegion, textureRegion.getRegionWidth() - 2, textureRegion.getRegionHeight() - 2, 1, 1)), 0.0f, this.cellHeight, this.cellWidth);
            this.mapping.put((int)this.solidBlock, (Object)block);
            for (int i = 9472; i < 9472 + BlockUtils.BOX_DRAWING.length; ++i) {
                if (!BlockUtils.isBlockGlyph(i)) continue;
                this.mapping.put(i, (Object)new GlyphRegion(block, Float.NaN, this.cellHeight, this.cellWidth));
            }
        } else if (!this.mapping.containsKey((int)this.solidBlock)) {
            this.mapping.put((int)this.solidBlock, (Object)new GlyphRegion((TextureRegion)(canUseTextures ? new TextureRegion(textureRegion, textureRegion.getRegionWidth() - 2, textureRegion.getRegionHeight() - 2, 1, 1) : new TexturelessRegion(textureRegion, textureRegion.getRegionWidth() - 2, textureRegion.getRegionHeight() - 2, 1, 1)), 0.0f, this.cellHeight, this.cellWidth));
        }
        this.defaultValue = (GlyphRegion)((Object)this.mapping.get(32, (Object)((GlyphRegion)((Object)this.mapping.values().next()))));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        if (textureRegion.getTexture() != null) {
            textureRegion.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
        this.isMono = minWidth == this.cellWidth && this.kerning == null;
        this.integerPosition = false;
        this.inlineImageOffsetX = 0.0f;
        this.inlineImageOffsetY = 0.0f;
        this.inlineImageXAdvance = 0.0f;
        this.inlineImageStretch = 1.0f;
    }

    public Font setSharing(boolean share) {
        if (this.sharing && !share) {
            IntMap<GlyphRegion> sharedMapping = this.mapping;
            this.mapping = new IntMap(sharedMapping.size);
            for (IntMap.Entry e : sharedMapping) {
                if (e.value == null) continue;
                this.mapping.put(e.key, (Object)new GlyphRegion((GlyphRegion)((Object)e.value)));
            }
            if (this.nameLookup != null) {
                this.nameLookup = new CaseInsensitiveIntMap(this.nameLookup);
            }
            if (this.namesByCharCode != null) {
                this.namesByCharCode = new IntMap(this.namesByCharCode);
            }
            this.kerning = this.kerning == null ? null : new IntFloatMap(this.kerning);
        }
        this.sharing = share;
        return this;
    }

    public DistanceFieldType getDistanceField() {
        return this.distanceField;
    }

    public Font setDistanceField(DistanceFieldType distanceField) {
        if (!canUseTextures) {
            return this;
        }
        DistanceFieldType distanceFieldType = this.distanceField = distanceField == null ? DistanceFieldType.STANDARD : distanceField;
        if (this.distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (this.distanceField == DistanceFieldType.SDF) {
            this.shader = new ShaderProgram(vertexShader, sdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (this.distanceField == DistanceFieldType.SDF_OUTLINE) {
            this.shader = new ShaderProgram(vertexShader, sdfBlackOutlineFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF_OUTLINE shader failed to compile: " + this.shader.getLog());
            }
        } else {
            this.shader = null;
        }
        return this;
    }

    public int kerningPair(char first, char second) {
        return first << 16 | second & 0xFFFF;
    }

    public Font scale(float both) {
        this.scaleX *= both;
        this.scaleY *= both;
        this.cellWidth *= both;
        this.cellHeight *= both;
        return this;
    }

    public Font scale(float horizontal, float vertical) {
        this.scaleX *= horizontal;
        this.scaleY *= vertical;
        this.cellWidth *= horizontal;
        this.cellHeight *= vertical;
        return this;
    }

    public Font scaleTo(float width, float height) {
        this.scaleX = width / this.originalCellWidth;
        this.scaleY = height / this.originalCellHeight;
        this.cellWidth = width;
        this.cellHeight = height;
        return this;
    }

    public Font scaleHeightTo(float height) {
        return this.scaleTo(this.cellWidth * height / this.cellHeight, height);
    }

    public Font adjustLineHeight(float multiplier) {
        this.cellHeight *= multiplier;
        this.originalCellHeight *= multiplier;
        this.descent *= multiplier;
        return this;
    }

    public Font adjustCellWidth(float multiplier) {
        this.cellWidth *= multiplier;
        this.originalCellWidth *= multiplier;
        return this;
    }

    public Font fitCell(float width, float height, boolean center) {
        this.cellWidth = width;
        this.cellHeight = height;
        float wsx = width / this.scaleX;
        IntMap.Entries vs = this.mapping.entries();
        if (center) {
            while (vs.hasNext) {
                IntMap.Entry ent = vs.next();
                GlyphRegion g = (GlyphRegion)((Object)ent.value);
                if (ent.key >= 57344 && ent.key < 63488) continue;
                g.offsetX += (wsx - g.xAdvance) * 0.5f;
                g.xAdvance = wsx;
            }
        } else {
            while (vs.hasNext) {
                IntMap.Entry ent = vs.next();
                if (ent.key >= 57344 && ent.key < 63488) continue;
                ((GlyphRegion)((Object)ent.value)).xAdvance = wsx;
            }
        }
        this.isMono = true;
        this.kerning = null;
        return this;
    }

    public float getUnderlineX() {
        return this.underX;
    }

    public float getUnderlineY() {
        return this.underY;
    }

    public Font setUnderlinePosition(float underX, float underY) {
        this.underX = underX;
        this.underY = underY;
        return this;
    }

    public Font setUnderlineMetrics(float underX, float underY, float underLength, float underBreadth) {
        this.underX = underX;
        this.underY = underY;
        this.underLength = underLength;
        this.underBreadth = underBreadth;
        return this;
    }

    public float getStrikethroughX() {
        return this.strikeX;
    }

    public float getStrikethroughY() {
        return this.strikeY;
    }

    public Font setStrikethroughPosition(float strikeX, float strikeY) {
        this.strikeX = strikeX;
        this.strikeY = strikeY;
        return this;
    }

    public Font setStrikethroughMetrics(float strikeX, float strikeY, float strikeLength, float strikeBreadth) {
        this.strikeX = strikeX;
        this.strikeY = strikeY;
        this.strikeLength = strikeLength;
        this.strikeBreadth = strikeBreadth;
        return this;
    }

    public Font setLineMetrics(float x, float y, float length, float breadth) {
        this.underX = x;
        this.underY = y;
        this.underLength = length;
        this.underBreadth = breadth;
        this.strikeX = x;
        this.strikeY = y;
        this.strikeLength = length;
        this.strikeBreadth = breadth;
        return this;
    }

    public float getFancyLineX() {
        return this.fancyX;
    }

    public float getFancyLineY() {
        return this.fancyY;
    }

    public Font setFancyLinePosition(float x, float y) {
        this.fancyX = x;
        this.fancyY = y;
        return this;
    }

    public float getInlineImageOffsetX() {
        return this.inlineImageOffsetX;
    }

    public float getInlineImageOffsetY() {
        return this.inlineImageOffsetY;
    }

    public float getInlineImageXAdvance() {
        return this.inlineImageXAdvance;
    }

    public float getInlineImageStretch() {
        return this.inlineImageStretch;
    }

    public Font setInlineImageStretch(float inlineImageStretch) {
        this.inlineImageStretch = inlineImageStretch;
        return this;
    }

    public Font setInlineImageMetrics(float offsetX, float offsetY, float xAdvance) {
        this.inlineImageOffsetX = offsetX;
        this.inlineImageOffsetY = offsetY;
        this.inlineImageXAdvance = xAdvance;
        return this;
    }

    public Font setInlineImageMetrics(float offsetX, float offsetY, float xAdvance, float stretch) {
        this.inlineImageOffsetX = offsetX;
        this.inlineImageOffsetY = offsetY;
        this.inlineImageXAdvance = xAdvance;
        this.inlineImageStretch = stretch;
        return this;
    }

    public Font setTextureFilter() {
        return this.setTextureFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
    }

    public Font setTextureFilter(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        if (canUseTextures) {
            for (TextureRegion parent : this.parents) {
                parent.getTexture().setFilter(minFilter, magFilter);
            }
        }
        return this;
    }

    public Font useIntegerPositions(boolean integer) {
        this.integerPosition = integer;
        return this;
    }

    public float getDescent() {
        return this.descent;
    }

    public Font setDescent(float descent) {
        this.descent = descent;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Font setName(String name) {
        this.name = name;
        return this;
    }

    public float getObliqueStrength() {
        return this.obliqueStrength;
    }

    public Font setObliqueStrength(float obliqueStrength) {
        this.obliqueStrength = obliqueStrength;
        return this;
    }

    public float getBoldStrength() {
        return this.boldStrength;
    }

    public Font setBoldStrength(float boldStrength) {
        this.boldStrength = boldStrength;
        return this;
    }

    public float getOutlineStrength() {
        return this.outlineStrength;
    }

    public Font setOutlineStrength(float outlineStrength) {
        this.outlineStrength = outlineStrength;
        return this;
    }

    public float getBoxDrawingBreadth() {
        return this.boxDrawingBreadth;
    }

    public Font setBoxDrawingBreadth(float boxDrawingBreadth) {
        this.boxDrawingBreadth = boxDrawingBreadth;
        return this;
    }

    public FontFamily getFamily() {
        return this.family;
    }

    public Font setFamily(FontFamily family) {
        this.family = family;
        return this;
    }

    public float getCrispness() {
        return this.distanceFieldCrispness;
    }

    public Font setCrispness(float crispness) {
        this.distanceFieldCrispness = crispness;
        return this;
    }

    public Font multiplyCrispness(float multiplier) {
        this.distanceFieldCrispness *= multiplier;
        return this;
    }

    public Font addImage(String character, TextureRegion region, float offsetX, float offsetY, float xAdvance) {
        if (character != null && !character.isEmpty()) {
            this.mapping.put((int)character.charAt(character.length() - 1), (Object)new GlyphRegion(region, offsetX, offsetY, xAdvance));
        }
        return this;
    }

    public Font addImage(String character, TextureRegion region) {
        if (character != null && !character.isEmpty()) {
            this.mapping.put((int)character.charAt(character.length() - 1), (Object)new GlyphRegion(region));
        }
        return this;
    }

    public Font addAtlas(TextureAtlas atlas) {
        return this.addAtlas(atlas, "", "", 0.0f, 0.0f, 0.0f);
    }

    public Font addAtlas(TextureAtlas atlas, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        return this.addAtlas(atlas, "", "", offsetXChange, offsetYChange, xAdvanceChange);
    }

    public Font addAtlas(TextureAtlas atlas, String prepend, String append, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        Array regions = atlas.getRegions();
        if (this.nameLookup == null) {
            this.nameLookup = new CaseInsensitiveIntMap(regions.size, 0.5f);
        } else {
            this.nameLookup.ensureCapacity(regions.size);
        }
        if (this.namesByCharCode == null) {
            this.namesByCharCode = new IntMap(regions.size >> 1, 0.5f);
        } else {
            this.namesByCharCode.ensureCapacity(regions.size >> 1);
        }
        if (prepend == null) {
            prepend = "";
        }
        if (append == null) {
            append = "";
        }
        int start = 57344 + this.namesByCharCode.size;
        TextureAtlas.AtlasRegion previous = (TextureAtlas.AtlasRegion)regions.first();
        GlyphRegion gr = new GlyphRegion((TextureRegion)previous, previous.offsetX + (offsetXChange += this.inlineImageOffsetX), previous.offsetY - (offsetYChange += this.inlineImageOffsetY), (float)previous.originalWidth + (xAdvanceChange += this.inlineImageXAdvance));
        this.mapping.put(start, (Object)gr);
        String name = prepend + previous.name + append;
        this.nameLookup.put(name, start);
        this.namesByCharCode.put(start, (Object)name);
        int i = start;
        for (int a = 1; i < 63488 && a < regions.size; ++a) {
            TextureAtlas.AtlasRegion region = (TextureAtlas.AtlasRegion)regions.get(a);
            if (previous.getRegionX() == region.getRegionX() && previous.getRegionY() == region.getRegionY()) {
                name = prepend + region.name + append;
                this.nameLookup.put(name, i);
                char f = previous.name.charAt(0);
                if (f >= '\u2000') continue;
                this.namesByCharCode.put(i, (Object)name);
                continue;
            }
            previous = region;
            gr = new GlyphRegion((TextureRegion)region, region.offsetX + offsetXChange, region.offsetY - offsetYChange, (float)region.originalWidth + xAdvanceChange);
            this.mapping.put(++i, (Object)gr);
            name = prepend + region.name + append;
            this.nameLookup.put(name, i);
            this.namesByCharCode.put(i, (Object)name);
        }
        return this;
    }

    public int atlasLookup(String name) {
        if (this.nameLookup == null) {
            return -1;
        }
        return this.nameLookup.get(name, -1);
    }

    public Font addSpacingGlyph(char representation, float advance) {
        GlyphRegion space = (GlyphRegion)((Object)this.mapping.get(32, null));
        if (space == null || representation >= '\ue000' && representation < '\uf800') {
            return this;
        }
        GlyphRegion next = new GlyphRegion(space);
        next.xAdvance = advance;
        this.mapping.put((int)representation, (Object)next);
        return this;
    }

    public void enableShader(Batch batch) {
        if (batch.getShader() != this.shader) {
            if (this.distanceField == DistanceFieldType.MSDF) {
                batch.setShader(this.shader);
                float smoothing = 8.0f * this.actualCrispness * Math.max(this.cellHeight / this.originalCellHeight, this.cellWidth / this.originalCellWidth);
                batch.flush();
                this.shader.setUniformf("u_smoothing", smoothing);
                smoothingValues.put(batch, Float.valueOf(smoothing));
            } else if (this.distanceField == DistanceFieldType.SDF || this.getDistanceField() == DistanceFieldType.SDF_OUTLINE) {
                batch.setShader(this.shader);
                float smoothing = 4.0f * this.actualCrispness * Math.max(this.cellHeight / this.originalCellHeight, this.cellWidth / this.originalCellWidth);
                batch.flush();
                this.shader.setUniformf("u_smoothing", smoothing);
                smoothingValues.put(batch, Float.valueOf(smoothing));
            } else {
                batch.setShader(null);
                smoothingValues.put(batch, Float.valueOf(0.0f));
            }
        }
    }

    public void resumeDistanceFieldShader(Batch batch) {
        if (batch.getShader() == this.shader) {
            if (this.distanceField == DistanceFieldType.MSDF) {
                float smoothing = 8.0f * this.actualCrispness * Math.max(this.cellHeight / this.originalCellHeight, this.cellWidth / this.originalCellWidth);
                batch.flush();
                this.shader.setUniformf("u_smoothing", smoothing);
                smoothingValues.put(batch, Float.valueOf(smoothing));
            } else if (this.distanceField == DistanceFieldType.SDF || this.getDistanceField() == DistanceFieldType.SDF_OUTLINE) {
                float smoothing = 4.0f * this.actualCrispness * Math.max(this.cellHeight / this.originalCellHeight, this.cellWidth / this.originalCellWidth);
                batch.flush();
                this.shader.setUniformf("u_smoothing", smoothing);
                smoothingValues.put(batch, Float.valueOf(smoothing));
            }
        } else if (this.shader == null) {
            batch.flush();
            if (batch.getShader().hasUniform("u_smoothing")) {
                batch.getShader().setUniformf("u_smoothing", 0.0f);
            }
            smoothingValues.put(batch, Float.valueOf(0.0f));
        } else {
            batch.setShader(this.shader);
            if (this.distanceField == DistanceFieldType.MSDF) {
                float smoothing = 0.4f * this.actualCrispness * Math.max(this.cellHeight, this.cellWidth);
                batch.flush();
                this.shader.setUniformf("u_smoothing", smoothing);
                smoothingValues.put(batch, Float.valueOf(smoothing));
            } else if (this.distanceField == DistanceFieldType.SDF || this.getDistanceField() == DistanceFieldType.SDF_OUTLINE) {
                float smoothing = 0.2f * this.actualCrispness * Math.max(this.cellHeight, this.cellWidth);
                batch.flush();
                this.shader.setUniformf("u_smoothing", smoothing);
                smoothingValues.put(batch, Float.valueOf(smoothing));
            }
        }
    }

    public void pauseDistanceFieldShader(Batch batch) {
        if (batch.getShader() == this.shader) {
            Float smoothing = smoothingValues.get(batch);
            if (smoothing == null || smoothing.floatValue() == 0.0f) {
                return;
            }
            batch.flush();
            this.shader.setUniformf("u_smoothing", 0.0f);
            smoothingValues.put(batch, Float.valueOf(0.0f));
        }
    }

    public void drawText(Batch batch, CharSequence text, float x, float y) {
        this.drawText(batch, text, x, y, -2);
    }

    public void drawText(Batch batch, CharSequence text, float x, float y, int color) {
        batch.setPackedColor(NumberUtils.intToFloatColor((int)Integer.reverseBytes(color)));
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            GlyphRegion current = (GlyphRegion)((Object)this.mapping.get((int)text.charAt(i)));
            batch.draw((TextureRegion)current, x + current.offsetX * this.scaleX, y + current.offsetY * this.scaleY, (float)current.getRegionWidth() * this.scaleX, (float)current.getRegionHeight() * this.scaleY);
            x += (float)current.getRegionWidth() * this.scaleX;
        }
    }

    public void drawBlocks(Batch batch, int[][] colors, float x, float y) {
        this.drawBlocks(batch, this.solidBlock, colors, x, y);
    }

    public void drawBlocks(Batch batch, char blockChar, int[][] colors, float x, float y) {
        TextureRegion block = (TextureRegion)this.mapping.get((int)blockChar);
        if (block == null) {
            return;
        }
        Texture parent = block.getTexture();
        float ipw = 1.0f / (float)parent.getWidth();
        float iph = 1.0f / (float)parent.getHeight();
        float u = block.getU();
        float v = block.getV();
        float u2 = block.getU() + ipw;
        float v2 = block.getV() + iph;
        this.vertices[0] = x += 0.00390625f;
        this.vertices[1] = y += 0.00390625f;
        this.vertices[3] = u;
        this.vertices[4] = v;
        this.vertices[5] = x;
        this.vertices[6] = y + this.cellHeight;
        this.vertices[8] = u;
        this.vertices[9] = v2;
        this.vertices[10] = x + this.cellWidth;
        this.vertices[11] = y + this.cellHeight;
        this.vertices[13] = u2;
        this.vertices[14] = v2;
        this.vertices[15] = x + this.cellWidth;
        this.vertices[16] = y;
        this.vertices[18] = u2;
        this.vertices[19] = v;
        int xn = colors.length;
        int yn = colors[0].length;
        for (int xi = 0; xi < xn; ++xi) {
            for (int yi = 0; yi < yn; ++yi) {
                if ((colors[xi][yi] & 0xFE) != 0) {
                    this.vertices[12] = this.vertices[17] = NumberUtils.intBitsToFloat((int)Integer.reverseBytes(colors[xi][yi] & 0xFFFFFFFE));
                    this.vertices[7] = this.vertices[17];
                    this.vertices[2] = this.vertices[17];
                    this.drawVertices(batch, parent, this.vertices);
                }
                this.vertices[1] = this.vertices[16] = this.vertices[16] + this.cellHeight;
                this.vertices[6] = this.vertices[11] = this.vertices[11] + this.cellHeight;
            }
            this.vertices[0] = this.vertices[5] = this.vertices[5] + this.cellWidth;
            this.vertices[10] = this.vertices[15] = this.vertices[15] + this.cellWidth;
            this.vertices[1] = this.vertices[16] = y;
            this.vertices[6] = this.vertices[11] = y + this.cellHeight;
        }
    }

    protected void drawBlockSequence(Batch batch, float[] sequence, TextureRegion block, float color, float x, float y, float width, float height, float rotation) {
        this.drawBlockSequence(batch, sequence, block, color, x, y, width, height, rotation, 1.0f);
    }

    protected void drawBlockSequence(Batch batch, float[] sequence, TextureRegion block, float color, float x, float y, float width, float height, float rotation, float breadth) {
        Texture parent = block.getTexture();
        float ipw = 1.0f / (float)parent.getWidth();
        float iph = 1.0f / (float)parent.getHeight();
        float halfWidth = width * 0.5f;
        float halfHeight = height * 0.5f;
        float u = block.getU();
        float v = block.getV();
        float u2 = u + ipw;
        float v2 = v - iph;
        float sn = MathUtils.sinDeg((float)rotation);
        float cs = MathUtils.cosDeg((float)rotation);
        float adjustment = 0.0f;
        if (sequence.length == 8 && breadth != 1.0f && sequence[0] == 0.0f && sequence[5] == 0.0f) {
            adjustment = 0.1f - 0.1f * breadth;
        }
        for (int b = 0; b < sequence.length; b += 4) {
            float startX = sequence[b];
            float startY = sequence[b + 1];
            float sizeX = sequence[b + 2];
            float sizeY = sequence[b + 3];
            if (breadth != 1.0f) {
                float thinAcross = 0.1f * breadth;
                float wideAcross = 0.2f * breadth;
                if (sizeX == 0.1f) {
                    sizeX = thinAcross;
                } else if (sizeX == 0.2f) {
                    sizeX = wideAcross;
                } else if (startX == 0.0f) {
                    if (sizeX == 0.55f) {
                        sizeX -= thinAcross * 0.5f + adjustment;
                    } else if (sizeX == 0.6f) {
                        sizeX -= wideAcross * 0.5f + adjustment;
                    }
                } else if (startX > 0.0f) {
                    if (sizeX == 0.55f) {
                        sizeX += thinAcross * 0.5f;
                    } else if (sizeX == 0.6f) {
                        sizeX += wideAcross * 0.5f;
                    }
                }
                if (sizeY == 0.1f) {
                    sizeY = thinAcross;
                } else if (sizeY == 0.2f) {
                    sizeY = wideAcross;
                } else if (startY == 0.0f) {
                    if (sizeY == 0.55f) {
                        sizeY -= thinAcross * 0.5f + adjustment;
                    } else if (sizeY == 0.6f) {
                        sizeY -= wideAcross * 0.5f + adjustment;
                    }
                } else if (startY > 0.0f) {
                    if (sizeY == 0.55f) {
                        sizeY += thinAcross * 0.5f;
                    } else if (sizeY == 0.6f) {
                        sizeY += wideAcross * 0.5f;
                    }
                }
                if (startX == 0.45f) {
                    startX -= thinAcross * 0.5f;
                } else if (startX == 0.4f) {
                    startX -= wideAcross * 0.5f;
                }
                if (startY == 0.45f) {
                    startY -= thinAcross * 0.5f;
                } else if (startY == 0.4f) {
                    startY -= wideAcross * 0.5f;
                }
            }
            startX = startX * width - halfWidth;
            startY = startY * height - halfHeight;
            float p0x = startX;
            float p0y = startY + (sizeY *= height);
            float p1x = startX;
            float p1y = startY;
            float p2x = startX + (sizeX *= width);
            float p2y = startY;
            this.vertices[0] = x + cs * p0x - sn * p0y;
            this.vertices[5] = x + cs * p1x - sn * p1y;
            this.vertices[10] = x + cs * p2x - sn * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sn * p0x + cs * p0y;
            this.vertices[6] = y + sn * p1x + cs * p1y;
            this.vertices[11] = y + sn * p2x + cs * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[7] = color;
            this.vertices[8] = u;
            this.vertices[9] = v2;
            this.vertices[12] = color;
            this.vertices[13] = u2;
            this.vertices[14] = v2;
            this.vertices[17] = color;
            this.vertices[18] = u2;
            this.vertices[19] = v;
            this.drawVertices(batch, parent, this.vertices);
        }
    }

    protected void drawFancyLine(Batch batch, long mode, float x, float y, float width, float xPx, float yPx, float rotation) {
        TextureRegion block = (TextureRegion)this.mapping.get((int)this.solidBlock);
        Texture parent = block.getTexture();
        float ipw = 1.0f / (float)parent.getWidth();
        float iph = 1.0f / (float)parent.getHeight();
        float u = block.getU();
        float v = block.getV();
        float u2 = u + ipw;
        float v2 = v + iph;
        float sn = MathUtils.sinDeg((float)rotation);
        float cs = MathUtils.cosDeg((float)rotation);
        float color = mode == 0x1A00000L ? this.PACKED_ERROR_COLOR : (mode == 0x1C00000L ? this.PACKED_WARN_COLOR : this.PACKED_NOTE_COLOR);
        color = ColorUtils.multiplyAlpha(color, batch.getColor().a);
        int index = 0;
        float startX = 0.0f;
        float shiftY = 0.0f;
        while (startX <= width) {
            float p2y;
            float p2x;
            float p1y;
            float p1x;
            float p0y;
            float p0x;
            float shiftX = startX;
            if (mode == 0x1A00000L) {
                shiftY = (float)(index & true) * yPx;
                p0x = shiftX;
                p0y = shiftY + yPx;
                p1x = shiftX;
                p1y = shiftY;
                p2x = shiftX + xPx;
                p2y = shiftY;
            } else if (mode == 0x1C00000L) {
                shiftY = (float)(~index & 1) * yPx;
                p0x = shiftX += (float)(~index & 1) * xPx;
                p0y = shiftY + yPx;
                p1x = shiftX;
                p1y = shiftY;
                p2x = shiftX + xPx;
                p2y = shiftY;
            } else {
                shiftY = (float)(index >>> 1 & 1) * yPx;
                p0x = shiftX;
                p0y = shiftY + yPx;
                p1x = shiftX;
                p1y = shiftY;
                p2x = shiftX + xPx;
                p2y = shiftY;
            }
            this.vertices[0] = x + cs * p0x - sn * p0y;
            this.vertices[5] = x + cs * p1x - sn * p1y;
            this.vertices[10] = x + cs * p2x - sn * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sn * p0x + cs * p0y;
            this.vertices[6] = y + sn * p1x + cs * p1y;
            this.vertices[11] = y + sn * p2x + cs * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[7] = color;
            this.vertices[8] = u;
            this.vertices[9] = v2;
            this.vertices[12] = color;
            this.vertices[13] = u2;
            this.vertices[14] = v2;
            this.vertices[17] = color;
            this.vertices[18] = u2;
            this.vertices[19] = v;
            this.drawVertices(batch, parent, this.vertices);
            startX += xPx;
            ++index;
        }
    }

    public int drawMarkupText(Batch batch, String text, float x, float y) {
        Layout layout = this.tempLayout;
        layout.clear();
        this.markup(text, this.tempLayout);
        int lines = layout.lines();
        int drawn = 0;
        for (int ln = 0; ln < lines; ++ln) {
            Line line = layout.getLine(ln);
            int n = line.glyphs.size;
            drawn += n;
            if (this.kerning != null) {
                int kern = -1;
                for (int i = 0; i < n; ++i) {
                    long glyph = line.glyphs.get(i);
                    kern = kern << 16 | (int)(glyph & 0xFFFFL);
                    float amt = this.kerning.get(kern, 0.0f);
                    x += this.drawGlyph(batch, glyph, x + amt, y) + amt;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    x += this.drawGlyph(batch, line.glyphs.get(i), x, y);
                }
            }
            y -= this.cellHeight;
        }
        return drawn;
    }

    public float drawGlyphs(Batch batch, Layout glyphs, float x, float y) {
        return this.drawGlyphs(batch, glyphs, x, y, 8);
    }

    public float drawGlyphs(Batch batch, Layout glyphs, float x, float y, int align) {
        float drawn = 0.0f;
        int lines = glyphs.lines();
        for (int ln = 0; ln < lines; ++ln) {
            Line l = glyphs.getLine(ln);
            drawn += this.drawGlyphs(batch, l, x, y -= l.height, align);
        }
        return drawn;
    }

    public float drawGlyphs(Batch batch, Layout glyphs, float x, float y, int align, float rotation, float originX, float originY) {
        float drawn = 0.0f;
        float sn = MathUtils.sinDeg((float)rotation);
        float cs = MathUtils.cosDeg((float)rotation);
        int lines = glyphs.lines();
        for (int ln = 0; ln < lines; ++ln) {
            Line l = glyphs.getLine(ln);
            drawn += this.drawGlyphs(batch, l, x += sn * l.height, y -= cs * l.height, align, rotation, originX, originY);
        }
        return drawn;
    }

    public float drawGlyphs(Batch batch, Line glyphs, float x, float y) {
        if (glyphs == null) {
            return 0.0f;
        }
        return this.drawGlyphs(batch, glyphs, x, y, 8);
    }

    public float drawGlyphs(Batch batch, Line glyphs, float x, float y, int align) {
        float originX = x + (Align.isRight((int)align) ? glyphs.width : (Align.isCenterHorizontal((int)align) ? glyphs.width * 0.5f : 0.0f));
        float originY = y + (Align.isTop((int)align) ? glyphs.height : (Align.isCenterVertical((int)align) ? glyphs.height * 0.5f : 0.0f));
        return this.drawGlyphs(batch, glyphs, x, y, align, 0.0f, originX, originY);
    }

    public float drawGlyphs(Batch batch, Line glyphs, float x, float y, int align, float rotation, float originX, float originY) {
        if (glyphs == null || glyphs.glyphs.size == 0) {
            return 0.0f;
        }
        float drawn = 0.0f;
        float cs = MathUtils.cosDeg((float)rotation);
        float sn = MathUtils.sinDeg((float)rotation);
        float worldOriginX = x + originX;
        float worldOriginY = y + originY;
        float fx = -originX;
        float fy = -originY;
        x = cs * fx - sn * fy + worldOriginX;
        y = sn * fx + cs * fy + worldOriginY;
        if (Align.isCenterHorizontal((int)align)) {
            x -= cs * (glyphs.width * 0.5f);
            y -= sn * (glyphs.width * 0.5f);
        } else if (Align.isRight((int)align)) {
            x -= cs * glyphs.width;
            y -= sn * glyphs.width;
        }
        int kern = -1;
        float xChange = 0.0f;
        float yChange = 0.0f;
        boolean curly = false;
        boolean initial = true;
        int n = glyphs.glyphs.size;
        for (int i = 0; i < n; ++i) {
            long glyph = glyphs.glyphs.get(i);
            char ch = (char)glyph;
            if (this.omitCurlyBraces) {
                if (curly) {
                    if (ch == '}') {
                        curly = false;
                        continue;
                    }
                    if (ch != '{') continue;
                    curly = false;
                } else if (ch == '{') {
                    curly = true;
                    continue;
                }
            }
            Font font = null;
            if (this.family != null) {
                font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
            }
            if (font == null) {
                font = this;
            }
            if (font.kerning != null) {
                kern = kern << 16 | (int)(glyph & 0xFFFFL);
                float amt = font.kerning.get(kern, 0.0f) * font.scaleX * Font.extractScale(glyph);
                xChange += cs * amt;
                yChange += sn * amt;
            }
            if (initial) {
                xChange -= font.cellWidth * 0.5f;
                yChange += font.cellHeight * 0.5f;
                xChange += cs * font.cellWidth * 0.5f;
                yChange += sn * font.cellWidth * 0.5f;
                xChange += sn * font.descent * font.scaleY * 0.5f;
                yChange -= cs * font.descent * font.scaleY * 0.5f;
                xChange -= sn * glyphs.height * 0.5f;
                yChange += cs * glyphs.height * 0.5f;
                GlyphRegion reg = (GlyphRegion)((Object)font.mapping.get((int)(glyph & 0xFFFFL)));
                if (!(this.isMono || reg == null || ch >= '\ue000' && ch < '\uf800')) {
                    float ox = reg.offsetX;
                    ox = ox != ox ? 0.0f : (ox *= font.scaleX * Font.extractScale(glyph));
                    if (ox < 0.0f) {
                        xChange -= cs * ox;
                        yChange -= sn * ox;
                    }
                }
                initial = false;
            }
            float single = this.drawGlyph(batch, glyph, x + xChange, y + yChange, rotation);
            xChange += cs * single;
            yChange += sn * single;
            drawn += single;
        }
        return drawn;
    }

    public static float xAdvance(Font font, float scale, long glyph) {
        GlyphRegion tr;
        if (glyph >>> 32 == 0L) {
            return 0.0f;
        }
        char ch = (char)glyph;
        if ((glyph & 0x1100000L) == 0x1100000L) {
            ch = Category.caseUp((char)ch);
        }
        if ((tr = (GlyphRegion)((Object)font.mapping.get((int)ch))) == null) {
            return 0.0f;
        }
        float changedW = tr.xAdvance * scale;
        if (!font.isMono && (glyph & 0x6000000L) != 0L) {
            changedW *= 0.5f;
        }
        return changedW;
    }

    public float xAdvance(long glyph) {
        GlyphRegion tr;
        if (glyph >>> 32 == 0L) {
            return 0.0f;
        }
        char ch = (char)glyph;
        if ((glyph & 0x1100000L) == 0x1100000L) {
            ch = Category.caseUp((char)ch);
        }
        if ((tr = (GlyphRegion)((Object)this.mapping.get((int)ch))) == null) {
            return 0.0f;
        }
        float scale = ch >= '\ue000' && ch < '\uf800' ? Font.extractScale(glyph) * this.cellHeight / tr.getMaxDimension() * this.inlineImageStretch : this.scaleX * Font.extractScale(glyph);
        float changedW = tr.xAdvance * scale;
        if (!this.isMono) {
            changedW += tr.offsetX * scale;
            if ((glyph & 0x6000000L) != 0L) {
                changedW *= 0.5f;
            }
        }
        return changedW;
    }

    public float measureWidth(Line line) {
        float drawn = 0.0f;
        LongArray glyphs = line.glyphs;
        boolean curly = false;
        boolean initial = true;
        int kern = -1;
        int n = glyphs.size;
        for (int i = 0; i < n; ++i) {
            float ox;
            float changedW;
            float scaleX;
            float scale;
            GlyphRegion tr;
            long glyph = glyphs.get(i);
            char ch = (char)glyph;
            if ((glyph & 0x1100000L) == 0x1100000L) {
                ch = Category.caseUp((char)ch);
            }
            if (this.omitCurlyBraces) {
                if (curly) {
                    if (ch == '}') {
                        curly = false;
                        continue;
                    }
                    if (ch != '{') continue;
                    curly = false;
                } else if (ch == '{') {
                    curly = true;
                    continue;
                }
            }
            Font font = null;
            if (this.family != null) {
                font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
            }
            if (font == null) {
                font = this;
            }
            if ((tr = (GlyphRegion)((Object)font.mapping.get((int)ch))) == null) continue;
            if (font.kerning != null) {
                kern = kern << 16 | ch;
                scale = Font.extractScale(glyph);
                scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / tr.getMaxDimension() * font.inlineImageStretch : font.scaleX * scale * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63));
                float amt = font.kerning.get(kern, 0.0f) * scaleX;
                changedW = tr.xAdvance * scaleX;
                if (tr.offsetX != tr.offsetX) {
                    changedW = font.cellWidth * scale;
                } else if (initial && !this.isMono && (ch < '\ue000' || ch >= '\uf800') && (ox = tr.offsetX * scaleX) < 0.0f) {
                    changedW -= ox;
                }
                initial = false;
                drawn += changedW + amt;
                continue;
            }
            scale = Font.extractScale(glyph);
            scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / tr.getMaxDimension() * font.inlineImageStretch : font.scaleX * scale * ((glyph & 0x6000000L) != 0L && !font.isMono ? 0.5f : 1.0f);
            changedW = tr.xAdvance * scaleX;
            if (tr.offsetX != tr.offsetX) {
                changedW = font.cellWidth * scale;
            } else if (initial && !font.isMono && (ch < '\ue000' || ch >= '\uf800') && (ox = tr.offsetX * scaleX) < 0.0f) {
                changedW -= ox;
            }
            initial = false;
            drawn += changedW;
        }
        return drawn;
    }

    public float calculateSize(Line line) {
        float drawn = 0.0f;
        LongArray glyphs = line.glyphs;
        boolean curly = false;
        boolean initial = true;
        int kern = -1;
        line.height = 0.0f;
        int n = glyphs.size;
        for (int i = 0; i < n; ++i) {
            float ox;
            float changedW;
            float scaleX;
            float scale;
            GlyphRegion tr;
            long glyph = glyphs.get(i);
            char ch = (char)glyph;
            if ((glyph & 0x1100000L) == 0x1100000L) {
                ch = Category.caseUp((char)ch);
            }
            if (this.omitCurlyBraces) {
                if (curly) {
                    if (ch == '}') {
                        curly = false;
                        continue;
                    }
                    if (ch != '{') continue;
                    curly = false;
                } else if (ch == '{') {
                    curly = true;
                    continue;
                }
            }
            Font font = null;
            if (this.family != null) {
                font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
            }
            if (font == null) {
                font = this;
            }
            if ((tr = (GlyphRegion)((Object)font.mapping.get((int)ch))) == null) continue;
            float f = scale = font.isMono ? 1.0f : Font.extractScale(glyph);
            if (font.kerning != null) {
                kern = kern << 16 | ch;
                scaleX = ch >= '\ue000' && ch < '\uf800' ? scale * font.cellHeight / tr.getMaxDimension() * font.inlineImageStretch : font.scaleX * scale * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63));
                line.height = Math.max(line.height, font.cellHeight * scale);
                float amt = font.kerning.get(kern, 0.0f) * scaleX;
                changedW = tr.xAdvance * scaleX;
                if (tr.offsetX != tr.offsetX) {
                    changedW = font.cellWidth * scale;
                } else if (initial && !this.isMono && (ch < '\ue000' || ch >= '\uf800') && (ox = tr.offsetX * scaleX) < 0.0f) {
                    changedW -= ox;
                }
                initial = false;
                drawn += changedW + amt;
                continue;
            }
            line.height = Math.max(line.height, font.cellHeight * scale);
            scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / tr.getMaxDimension() * font.inlineImageStretch : font.scaleX * scale * ((glyph & 0x6000000L) != 0L && !font.isMono ? 0.5f : 1.0f);
            changedW = tr.xAdvance * scaleX;
            if (tr.offsetX != tr.offsetX) {
                changedW = font.cellWidth * scale;
            } else if (initial && !this.isMono && (ch < '\ue000' || ch >= '\uf800') && (ox = tr.offsetX * scaleX) < 0.0f) {
                changedW -= ox;
            }
            initial = false;
            drawn += changedW;
        }
        line.width = drawn;
        return drawn;
    }

    public float calculateSize(Layout layout) {
        float w = 0.0f;
        float currentHeight = 0.0f;
        for (int ln = 0; ln < layout.lines(); ++ln) {
            float drawn = 0.0f;
            Line line = layout.getLine(ln);
            LongArray glyphs = line.glyphs;
            boolean curly = false;
            boolean initial = true;
            int kern = -1;
            line.height = currentHeight;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                float ox;
                float changedW;
                float scaleX;
                float scale;
                GlyphRegion tr;
                long glyph = glyphs.get(i);
                char ch = (char)glyph;
                if ((glyph & 0x1100000L) == 0x1100000L) {
                    ch = Category.caseUp((char)ch);
                }
                if (this.omitCurlyBraces) {
                    if (curly) {
                        if (ch == '}') {
                            curly = false;
                            continue;
                        }
                        if (ch != '{') continue;
                        curly = false;
                    } else if (ch == '{') {
                        curly = true;
                        continue;
                    }
                }
                Font font = null;
                if (this.family != null) {
                    font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
                }
                if (font == null) {
                    font = this;
                }
                if ((tr = (GlyphRegion)((Object)font.mapping.get((int)ch))) == null) continue;
                float f = scale = font.isMono ? 1.0f : Font.extractScale(glyph);
                if (font.kerning != null) {
                    kern = kern << 16 | ch;
                    scaleX = ch >= '\ue000' && ch < '\uf800' ? scale * font.cellHeight / tr.getMaxDimension() * font.inlineImageStretch : font.scaleX * scale * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63));
                    currentHeight = font.cellHeight * scale;
                    line.height = Math.max(line.height, currentHeight);
                    float amt = font.kerning.get(kern, 0.0f) * scaleX;
                    changedW = tr.xAdvance * scaleX;
                    if (tr.offsetX != tr.offsetX) {
                        changedW = font.cellWidth * scale;
                    } else if (initial && !font.isMono && (ox = tr.offsetX * scaleX) < 0.0f) {
                        changedW -= ox;
                    }
                    initial = false;
                    drawn += changedW + amt;
                    continue;
                }
                currentHeight = font.cellHeight * scale;
                line.height = Math.max(line.height, currentHeight);
                scaleX = ch >= '\ue000' && ch < '\uf800' ? scale * font.cellHeight / tr.getMaxDimension() * font.inlineImageStretch : font.scaleX * scale * ((glyph & 0x6000000L) != 0L && !font.isMono ? 0.5f : 1.0f);
                changedW = tr.xAdvance * scaleX;
                if (tr.offsetX != tr.offsetX) {
                    changedW = font.cellWidth * scale;
                } else if (initial && !font.isMono && (ox = tr.offsetX * scaleX) < 0.0f) {
                    changedW -= ox;
                }
                initial = false;
                drawn += changedW;
            }
            line.width = drawn;
            w = Math.max(w, drawn);
        }
        return w;
    }

    /*
     * Unable to fully structure code
     */
    public float calculateXAdvances(Line line, FloatArray advances) {
        glyphs = line.glyphs;
        advances.ensureCapacity(line.glyphs.size + 1);
        curly = false;
        initial = true;
        kern = -1;
        total = 0.0f;
        line.height = 0.0f;
        n = glyphs.size;
        for (i = 0; i < n; ++i) {
            block15: {
                glyph = glyphs.get(i);
                ch = (char)glyph;
                if (!this.omitCurlyBraces) break block15;
                if (!curly) ** GOTO lbl24
                if (ch == '}') {
                    curly = false;
                    advances.add(0.0f);
                    continue;
                }
                if (ch == '{') {
                    curly = false;
                } else {
                    advances.add(0.0f);
                    continue;
lbl24:
                    // 1 sources

                    if (ch == '{') {
                        curly = true;
                        advances.add(0.0f);
                        continue;
                    }
                }
            }
            font = null;
            if (this.family != null) {
                font = this.family.connected[(int)(glyph >>> 16 & 15L)];
            }
            if (font == null) {
                font = this;
            }
            if ((tr = (GlyphRegion)font.mapping.get((int)ch)) == null) {
                advances.add(0.0f);
                continue;
            }
            if (font.kerning != null) {
                kern = kern << 16 | ch;
                scale = Font.extractScale(glyph);
                scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / tr.getMaxDimension() * font.inlineImageStretch : font.scaleX * scale * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63));
                line.height = Math.max(line.height, font.cellHeight * scale);
                amt = font.kerning.get(kern, 0.0f) * scaleX;
                changedW = Font.xAdvance(font, scaleX, glyph);
                if (initial) {
                    if ((ch < '\ue000' || ch >= '\uf800') && (ox = ((GlyphRegion)font.mapping.get((int)((int)(glyph & 65535L)), (Object)font.defaultValue)).offsetX * scaleX) < 0.0f) {
                        changedW -= ox;
                    }
                    initial = false;
                }
                advances.add(total);
                total += changedW + amt;
                continue;
            }
            scale = Font.extractScale(glyph);
            line.height = Math.max(line.height, font.cellHeight * scale);
            scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / tr.getMaxDimension() * font.inlineImageStretch : font.scaleX * scale * ((glyph & 0x6000000L) != 0L && font.isMono == false ? 0.5f : 1.0f);
            changedW = Font.xAdvance(font, scaleX, glyph);
            if (font.isMono) {
                changedW += tr.offsetX * scaleX;
            } else if (initial) {
                if ((ch < '\ue000' || ch >= '\uf800') && (ox = ((GlyphRegion)font.mapping.get((int)((int)(glyph & 65535L)), (Object)font.defaultValue)).offsetX * scaleX) < 0.0f) {
                    changedW -= ox;
                }
                initial = false;
            }
            advances.add(total);
            total += changedW;
        }
        return total;
    }

    public float calculateXAdvances(Layout layout, FloatArray advances) {
        float max = -1.0E30f;
        int len = layout.lines();
        for (int i = 0; i < len; ++i) {
            max = Math.max(max, this.calculateXAdvances(layout.getLine(i), advances));
        }
        return max;
    }

    protected float handleIntegerPosition(float p) {
        return p;
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y) {
        return this.drawGlyph(batch, glyph, x, y, 0.0f, 1.0f, 1.0f, 0);
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y, float rotation) {
        return this.drawGlyph(batch, glyph, x, y, rotation, 1.0f, 1.0f, 0);
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y, float rotation, float sizingX, float sizingY) {
        return this.drawGlyph(batch, glyph, x, y, rotation, sizingX, sizingY, 0);
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y, float rotation, float sizingX, float sizingY, int backgroundColor) {
        float xa;
        int xi;
        int widthAdj;
        long script;
        float scaleX;
        float scaleY;
        float fsy;
        float fsx;
        float sin = MathUtils.sinDeg((float)rotation);
        float cos = MathUtils.cosDeg((float)rotation);
        Font font = null;
        if (this.family != null) {
            font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
        }
        if (font == null) {
            font = this;
        }
        char c = (char)glyph;
        boolean squashed = false;
        boolean jostled = false;
        if ((glyph & 0x1100000L) == 0x1100000L) {
            squashed = c != (c = Category.caseUp((char)c));
            glyph = glyph & 0xFFFFFFFFFFFF0000L | (long)c;
        } else {
            jostled = (glyph & 0x1E00000L) == 0x1000000L;
        }
        GlyphRegion tr = (GlyphRegion)((Object)font.mapping.get((int)c));
        if (tr == null) {
            return 0.0f;
        }
        if (latestTexture != (latestTexture = tr.getTexture())) {
            boolean located = false;
            for (int p = 0; p < font.parents.size; ++p) {
                if (((TextureRegion)font.parents.get(p)).getTexture() != latestTexture) continue;
                font.resumeDistanceFieldShader(batch);
                located = true;
                break;
            }
            if (!located) {
                font.pauseDistanceFieldShader(batch);
            }
        }
        if (squashed) {
            sizingY *= 0.7f;
        }
        float color = NumberUtils.intBitsToFloat((int)((int)(batch.getColor().a * (float)(glyph >>> 33 & 0x7FL)) << 25 | (int)(batch.getColor().r * (float)(glyph >>> 56)) | (int)(batch.getColor().g * (float)(glyph >>> 48 & 0xFFL)) << 8 | (int)(batch.getColor().b * (float)(glyph >>> 40 & 0xFFL)) << 16));
        float scale = Font.extractScale(glyph);
        if (c >= '\ue000' && c < '\uf800') {
            fsy = fsx = font.cellHeight / tr.getMaxDimension() * font.inlineImageStretch;
            scaleX = scaleY = scale * fsx;
        } else {
            fsx = font.scaleX;
            scaleX = fsx * scale;
            fsy = font.scaleY;
            scaleY = fsy * scale;
        }
        float osx = fsx * (scale + 1.0f) * 0.5f;
        float osy = fsy * (scale + 1.0f) * 0.5f;
        float centerX = tr.xAdvance * scaleX * 0.5f;
        float centerY = font.originalCellHeight * scaleY * 0.5f;
        float oCenterX = tr.xAdvance * osx * 0.5f;
        float oCenterY = font.originalCellHeight * osy * 0.5f;
        float scaleCorrection = font.descent * font.scaleY * 2.0f;
        float ox = x;
        float oy = y += scaleCorrection * scale;
        float ix = font.handleIntegerPosition(x + centerX);
        float iy = font.handleIntegerPosition(y + centerY);
        float xShift = x + centerX - ix;
        float yShift = y + centerY - iy;
        x = font.handleIntegerPosition(ix - xShift);
        y = font.handleIntegerPosition(iy - yShift);
        centerX -= xShift * 0.5f;
        centerY -= yShift * 0.5f;
        if (tr.offsetX != tr.offsetX) {
            if (backgroundColor != 0) {
                this.drawBlockSequence(batch, BlockUtils.BOX_DRAWING[136], (TextureRegion)font.mapping.get((int)this.solidBlock, (Object)tr), NumberUtils.intToFloatColor((int)Integer.reverseBytes(backgroundColor)), x, y, font.cellWidth * sizingX, font.cellHeight * scale * sizingY, rotation);
            }
            float[] boxes = BlockUtils.BOX_DRAWING[c - 9472];
            this.drawBlockSequence(batch, boxes, (TextureRegion)font.mapping.get((int)this.solidBlock, (Object)tr), color, x, y, font.cellWidth * sizingX, font.cellHeight * scale * sizingY, rotation, c < '\u2580' ? this.boxDrawingBreadth : 1.0f);
            return font.cellWidth;
        }
        x += font.cellWidth * 0.5f;
        Texture tex = tr.getTexture();
        float scaledHeight = font.cellHeight * scale * sizingY;
        float x0 = 0.0f;
        float x1 = 0.0f;
        float x2 = 0.0f;
        float y0 = 0.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        float iw = 1.0f / (float)tex.getWidth();
        float w = (float)tr.getRegionWidth() * scaleX * sizingX;
        float xAdvance = tr.xAdvance;
        float changedW = xAdvance * scaleX;
        float xc = tr.offsetX * scaleX * sizingX - cos * centerX - font.cellWidth * 0.5f;
        float trrh = tr.getRegionHeight();
        float yt = (font.originalCellHeight - (trrh + tr.offsetY)) * scaleY * sizingY + sin * centerX - centerY;
        if (squashed) {
            yt -= font.descent * scaleY * sizingY * 0.42857143f;
        }
        float h = trrh * scaleY * sizingY;
        float xPx = 2.0f / ((float)Gdx.graphics.getBackBufferWidth() * batch.getProjectionMatrix().val[0]);
        float yPx = 2.0f / ((float)Gdx.graphics.getBackBufferHeight() * batch.getProjectionMatrix().val[5]);
        float xOutline = this.outlineStrength * this.cellHeight / 32.0f;
        float yOutline = this.outlineStrength * this.cellHeight / 32.0f;
        float u = tr.getU();
        float v = tr.getV();
        float u2 = tr.getU2();
        float v2 = tr.getV2();
        if (c >= '\ue000' && c < '\uf800') {
            float stretchShift = (trrh * font.inlineImageStretch - trrh) * scaleX * sizingX * 0.5f;
            float xch = tr.offsetX * scaleX * sizingX;
            xc -= xch + stretchShift;
            x += xch + stretchShift;
            float ych = tr.offsetY * scaleY * sizingY;
            yt = (sin * scaledHeight - scaledHeight) * 0.5f - ych - stretchShift;
            if (squashed) {
                yt -= font.descent * font.scaleY * scale * sizingY * 0.42857143f;
            }
            y = oy + scaledHeight * 0.5f - ych;
        }
        if ((glyph & 0x20000000L) != 0L) {
            float amount = h * this.obliqueStrength * 0.2f;
            x0 += amount;
            x1 -= amount;
            x2 -= amount;
        }
        if ((script = glyph & 0x6000000L) == 0x6000000L) {
            w *= 0.5f;
            h *= 0.5f;
            yt *= 0.625f;
            y1 += scaledHeight * 0.375f;
            y2 += scaledHeight * 0.375f;
            y0 += scaledHeight * 0.375f;
            if (!font.isMono) {
                changedW *= 0.5f;
            }
        } else if (script == 0x2000000L) {
            w *= 0.5f;
            h *= 0.5f;
            yt *= 0.625f;
            y1 -= scaledHeight * 0.375f;
            y2 -= scaledHeight * 0.375f;
            y0 -= scaledHeight * 0.375f;
            if (!font.isMono) {
                changedW *= 0.5f;
            }
        } else if (script == 0x4000000L) {
            w *= 0.5f;
            h *= 0.5f;
            yt *= 0.625f;
            if (!font.isMono) {
                changedW *= 0.5f;
            }
        }
        if (backgroundColor != 0) {
            this.drawBlockSequence(batch, BlockUtils.BOX_DRAWING[136], (TextureRegion)font.mapping.get((int)font.solidBlock, (Object)tr), NumberUtils.intToFloatColor((int)Integer.reverseBytes(backgroundColor)), x - font.cellWidth * scale * 0.5f, y + font.descent * scaleY * sizingY, xAdvance * scaleX * sizingX + 5.0f, font.cellHeight * scale * sizingY, rotation);
        }
        if (jostled) {
            int code = NumberUtils.floatToIntBits((float)(x * 1.8191725f + y * 1.6710436f + (float)c * 1.5497005f)) & 0xFFFFFF;
            xc += (float)(code % 5) - 2.0f;
            yt += (float)((code >>> 6) % 5) - 2.0f;
        }
        float p0x = xc + x0;
        float p0y = yt + y0 + h;
        float p1x = xc + x1;
        float p1y = yt + y1;
        float p2x = xc + x2 + w;
        float p2y = yt + y2;
        this.vertices[3] = u;
        this.vertices[4] = v;
        this.vertices[8] = u;
        this.vertices[9] = v2;
        this.vertices[13] = u2;
        this.vertices[14] = v2;
        this.vertices[18] = u2;
        this.vertices[19] = v;
        if ((glyph & 0x1E00000L) == 0x1600000L) {
            float shadow;
            this.vertices[2] = shadow = ColorUtils.multiplyAlpha(this.PACKED_SHADOW_COLOR, batch.getColor().a);
            this.vertices[7] = shadow;
            this.vertices[12] = shadow;
            this.vertices[17] = shadow;
            this.vertices[0] = x + cos * p0x - sin * p0y + 1.0f;
            this.vertices[5] = x + cos * p1x - sin * p1y + 1.0f;
            this.vertices[10] = x + cos * p2x - sin * p2y + 1.0f;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sin * p0x + cos * p0y - 2.0f;
            this.vertices[6] = y + sin * p1x + cos * p1y - 2.0f;
            this.vertices[11] = y + sin * p2x + cos * p2y - 2.0f;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            this.drawVertices(batch, tex, this.vertices);
        } else if ((glyph & 0x1E00000L) == 0x1200000L || (glyph & 0x1E00000L) == 0x1400000L) {
            float outline;
            this.vertices[2] = outline = ColorUtils.multiplyAlpha((glyph & 0x1E00000L) == 0x1200000L ? this.PACKED_BLACK : this.PACKED_WHITE, batch.getColor().a);
            this.vertices[7] = outline;
            this.vertices[12] = outline;
            this.vertices[17] = outline;
            widthAdj = (glyph & 0x40000000L) != 0L ? 2 : 1;
            for (xi = -widthAdj; xi <= widthAdj; ++xi) {
                xa = (float)xi * xOutline;
                if (widthAdj == 2 && (xi > 0 || this.boldStrength >= 1.0f)) {
                    xa *= this.boldStrength;
                }
                for (int yi = -1; yi <= 1; ++yi) {
                    if (xi == 0 && yi == 0) continue;
                    float ya = (float)yi * yOutline;
                    this.vertices[0] = font.handleIntegerPosition(x + cos * p0x - sin * p0y + xa);
                    this.vertices[5] = font.handleIntegerPosition(x + cos * p1x - sin * p1y + xa);
                    this.vertices[10] = font.handleIntegerPosition(x + cos * p2x - sin * p2y + xa);
                    this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                    this.vertices[1] = font.handleIntegerPosition(y + sin * p0x + cos * p0y + ya);
                    this.vertices[6] = font.handleIntegerPosition(y + sin * p1x + cos * p1y + ya);
                    this.vertices[11] = font.handleIntegerPosition(y + sin * p2x + cos * p2y + ya);
                    this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                    this.drawVertices(batch, tex, this.vertices);
                }
            }
        } else if ((glyph & 0x1E00000L) == 0x1800000L) {
            float shine;
            this.vertices[2] = shine = ColorUtils.multiplyAlpha(this.PACKED_WHITE, batch.getColor().a);
            this.vertices[7] = shine;
            this.vertices[12] = shine;
            this.vertices[17] = shine;
            widthAdj = (glyph & 0x40000000L) != 0L ? 1 : 0;
            for (xi = -widthAdj; xi <= widthAdj; ++xi) {
                xa = (float)xi * xOutline;
                if (widthAdj == 1 && (xi > 0 || this.boldStrength >= 1.0f)) {
                    xa *= this.boldStrength;
                }
                float ya = 1.5f * yOutline;
                this.vertices[0] = x + cos * p0x - sin * p0y + xa;
                this.vertices[5] = x + cos * p1x - sin * p1y + xa;
                this.vertices[10] = x + cos * p2x - sin * p2y + xa;
                this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                this.vertices[1] = y + sin * p0x + cos * p0y + ya;
                this.vertices[6] = y + sin * p1x + cos * p1y + ya;
                this.vertices[11] = y + sin * p2x + cos * p2y + ya;
                this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                this.drawVertices(batch, tex, this.vertices);
            }
        }
        this.vertices[2] = color;
        this.vertices[7] = color;
        this.vertices[12] = color;
        this.vertices[17] = color;
        this.vertices[0] = font.handleIntegerPosition(x + cos * p0x - sin * p0y);
        this.vertices[5] = font.handleIntegerPosition(x + cos * p1x - sin * p1y);
        this.vertices[10] = font.handleIntegerPosition(x + cos * p2x - sin * p2y);
        this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
        this.vertices[1] = font.handleIntegerPosition(y + sin * p0x + cos * p0y);
        this.vertices[6] = font.handleIntegerPosition(y + sin * p1x + cos * p1y);
        this.vertices[11] = font.handleIntegerPosition(y + sin * p2x + cos * p2y);
        this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
        this.drawVertices(batch, tex, this.vertices);
        if ((glyph & 0x40000000L) != 0L) {
            float rightStrength;
            float old0 = p0x;
            float old1 = p1x;
            float old2 = p2x;
            float leftStrength = this.boldStrength >= 1.0f ? this.boldStrength : 0.0f;
            float f = rightStrength = this.boldStrength >= 0.0f ? 1.0f : 0.0f;
            if (rightStrength != 0.0f) {
                p0x = old0 + rightStrength;
                p1x = old1 + rightStrength;
                p2x = old2 + rightStrength;
                this.vertices[0] = x + cos * p0x - sin * p0y;
                this.vertices[5] = x + cos * p1x - sin * p1y;
                this.vertices[10] = x + cos * p2x - sin * p2y;
                this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                this.vertices[1] = y + sin * p0x + cos * p0y;
                this.vertices[6] = y + sin * p1x + cos * p1y;
                this.vertices[11] = y + sin * p2x + cos * p2y;
                this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                this.drawVertices(batch, tex, this.vertices);
                p0x = old0 + rightStrength * 0.5f;
                p1x = old1 + rightStrength * 0.5f;
                p2x = old2 + rightStrength * 0.5f;
                this.vertices[0] = x + cos * p0x - sin * p0y;
                this.vertices[5] = x + cos * p1x - sin * p1y;
                this.vertices[10] = x + cos * p2x - sin * p2y;
                this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                this.vertices[1] = y + sin * p0x + cos * p0y;
                this.vertices[6] = y + sin * p1x + cos * p1y;
                this.vertices[11] = y + sin * p2x + cos * p2y;
                this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                this.drawVertices(batch, tex, this.vertices);
            }
            if (leftStrength != 0.0f) {
                p0x = old0 - leftStrength;
                p1x = old1 - leftStrength;
                p2x = old2 - leftStrength;
                this.vertices[0] = x + cos * p0x - sin * p0y;
                this.vertices[5] = x + cos * p1x - sin * p1y;
                this.vertices[10] = x + cos * p2x - sin * p2y;
                this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                this.vertices[1] = y + sin * p0x + cos * p0y;
                this.vertices[6] = y + sin * p1x + cos * p1y;
                this.vertices[11] = y + sin * p2x + cos * p2y;
                this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                this.drawVertices(batch, tex, this.vertices);
                p0x = old0 - leftStrength * 0.5f;
                p1x = old1 - leftStrength * 0.5f;
                p2x = old2 - leftStrength * 0.5f;
                this.vertices[0] = x + cos * p0x - sin * p0y;
                this.vertices[5] = x + cos * p1x - sin * p1y;
                this.vertices[10] = x + cos * p2x - sin * p2y;
                this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                this.vertices[1] = y + sin * p0x + cos * p0y;
                this.vertices[6] = y + sin * p1x + cos * p1y;
                this.vertices[11] = y + sin * p2x + cos * p2y;
                this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                this.drawVertices(batch, tex, this.vertices);
            }
            p0x = old0;
            p1x = old1;
            p2x = old2;
        }
        oy = y + (scaleCorrection * scale + scaledHeight) * -0.5f + centerY * 0.25f;
        oy += scaleCorrection;
        if ((glyph & 0x10000000L) != 0L && (c < '\ue000' || c >= '\uf800')) {
            ix = font.handleIntegerPosition(ox + oCenterX);
            iy = font.handleIntegerPosition(oy + oCenterY);
            xShift = ox + oCenterX - ix;
            yShift = oy + oCenterY - iy;
            x = font.handleIntegerPosition(ix + xShift);
            y = font.handleIntegerPosition(iy + yShift);
            centerX = oCenterX + xShift * 0.5f;
            centerY = oCenterY + yShift * 0.5f;
            x += font.cellWidth * 0.5f;
            GlyphRegion under = (GlyphRegion)((Object)font.mapping.get(9472));
            float oldX = p0x;
            float oldY = p0y;
            if (under != null && under.offsetX != under.offsetX) {
                p0x = font.cellWidth * -0.5f - scale * font.scaleX + xAdvance * font.underX * scale * font.scaleX;
                p0y = (font.underY - 0.8125f) * font.cellHeight * scale * sizingY + centerY + font.descent * font.scaleY;
                this.drawBlockSequence(batch, BlockUtils.BOX_DRAWING[0], (TextureRegion)font.mapping.get((int)font.solidBlock, (Object)tr), color, x + (cos * (p0x += xPx + centerX - cos * centerX) - sin * (p0y += sin * centerX)), y + (sin * p0x + cos * p0y), xAdvance * (font.underLength + 1.0f) * scaleX + xPx * 5.0f, font.cellHeight * scale * sizingY * (1.0f + font.underBreadth), rotation);
            } else {
                under = (GlyphRegion)((Object)font.mapping.get(95));
                if (under != null) {
                    trrh = under.getRegionHeight();
                    h = trrh * osy * sizingY + this.cellHeight * font.underBreadth * scale * sizingY;
                    yt = (centerY - (trrh + under.offsetY) * font.scaleY) * scale * sizingY + this.cellHeight * font.underY * scale * sizingY;
                    if (squashed) {
                        yt -= font.descent * scaleY * sizingY * 0.42857143f;
                    }
                    float underU = (under.getU() + under.getU2()) * 0.5f - iw;
                    float underV = under.getV();
                    float underU2 = underU + iw;
                    float underV2 = under.getV2();
                    xc = -0.5f * font.cellWidth + changedW * font.underX - scale * fsx;
                    x0 = -2.0f * xPx;
                    float addW = xPx * 2.0f;
                    x0 += xPx + centerX - cos * centerX;
                    yt += sin * centerX;
                    this.vertices[2] = color;
                    this.vertices[3] = underU;
                    this.vertices[4] = underV;
                    this.vertices[7] = color;
                    this.vertices[8] = underU;
                    this.vertices[9] = underV2;
                    this.vertices[12] = color;
                    this.vertices[13] = underU2;
                    this.vertices[14] = underV2;
                    this.vertices[17] = color;
                    this.vertices[18] = underU2;
                    this.vertices[19] = underV;
                    p0x = xc + x0 - addW;
                    p0y = yt + y0 + h;
                    p1x = xc + x0 - addW;
                    p1y = yt + y1;
                    p2x = xc + x0 + changedW * (font.underLength + 1.0f) + addW;
                    p2y = yt + y2;
                    this.vertices[0] = x + cos * p0x - sin * p0y;
                    this.vertices[5] = x + cos * p1x - sin * p1y;
                    this.vertices[10] = x + cos * p2x - sin * p2y;
                    this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                    this.vertices[1] = y + sin * p0x + cos * p0y;
                    this.vertices[6] = y + sin * p1x + cos * p1y;
                    this.vertices[11] = y + sin * p2x + cos * p2y;
                    this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                    this.drawVertices(batch, under.getTexture(), this.vertices);
                }
            }
        }
        if ((glyph & 0x8000000L) != 0L && (c < '\ue000' || c >= '\uf800')) {
            ix = font.handleIntegerPosition(ox + oCenterX);
            iy = font.handleIntegerPosition(oy + oCenterY);
            xShift = ox + oCenterX - ix;
            yShift = oy + oCenterY - iy;
            x = font.handleIntegerPosition(ix + xShift);
            y = font.handleIntegerPosition(iy + yShift);
            centerX = oCenterX + xShift * 0.5f;
            centerY = oCenterY + yShift * 0.5f;
            x += font.cellWidth * 0.5f;
            GlyphRegion dash = (GlyphRegion)((Object)font.mapping.get(9472));
            if (dash != null && dash.offsetX != dash.offsetX) {
                p0x = font.cellWidth * -0.5f - scale * font.scaleX + xAdvance * font.strikeX * scale * font.scaleX;
                p0y = centerY + (font.strikeY - 0.45f) * font.cellHeight * scale * sizingY + font.descent * font.scaleY;
                this.drawBlockSequence(batch, BlockUtils.BOX_DRAWING[0], (TextureRegion)font.mapping.get((int)font.solidBlock, (Object)tr), color, x + cos * (p0x += xPx + centerX - cos * centerX) - sin * (p0y += sin * centerX), y + (sin * p0x + cos * p0y), xAdvance * (font.strikeLength + 1.0f) * scaleX + xPx * 5.0f, (1.0f + font.strikeBreadth) * font.cellHeight * scale * sizingY, rotation);
            } else {
                dash = (GlyphRegion)((Object)font.mapping.get(45));
                if (dash != null) {
                    trrh = dash.getRegionHeight();
                    h = trrh * osy * sizingY * (1.0f + font.strikeBreadth);
                    yt = (centerY - (trrh + dash.offsetY) * font.scaleY) * scale * sizingY + font.cellHeight * font.strikeY * scale * sizingY;
                    if (squashed) {
                        yt -= font.descent * scaleY * sizingY * 0.42857143f;
                    }
                    float dashU = (dash.getU() + dash.getU2()) * 0.5f - iw;
                    float dashV = dash.getV();
                    float dashU2 = dashU + iw;
                    float dashV2 = dash.getV2();
                    xc = -this.cellWidth * 0.5f + changedW * font.strikeX - scale * fsx;
                    x0 = -2.0f * xPx;
                    float addW = xPx * 2.0f;
                    x0 += xPx + centerX - cos * centerX;
                    yt += sin * centerX;
                    this.vertices[2] = color;
                    this.vertices[3] = dashU;
                    this.vertices[4] = dashV;
                    this.vertices[7] = color;
                    this.vertices[8] = dashU;
                    this.vertices[9] = dashV2;
                    this.vertices[12] = color;
                    this.vertices[13] = dashU2;
                    this.vertices[14] = dashV2;
                    this.vertices[17] = color;
                    this.vertices[18] = dashU2;
                    this.vertices[19] = dashV;
                    p0x = xc + x0 - addW;
                    p0y = yt + y0 + h;
                    p1x = xc + x0 - addW;
                    p1y = yt + y1;
                    p2x = xc + x0 + changedW * (font.strikeLength + 1.0f) + addW;
                    p2y = yt + y2;
                    this.vertices[0] = x + cos * p0x - sin * p0y;
                    this.vertices[5] = x + cos * p1x - sin * p1y;
                    this.vertices[10] = x + cos * p2x - sin * p2y;
                    this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                    this.vertices[1] = y + sin * p0x + cos * p0y;
                    this.vertices[6] = y + sin * p1x + cos * p1y;
                    this.vertices[11] = y + sin * p2x + cos * p2y;
                    this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                    this.drawVertices(batch, dash.getTexture(), this.vertices);
                }
            }
        }
        if ((glyph & 0x1E00000L) >= 0x1A00000L && c < '\ue000' || c >= '\uf800') {
            ix = font.handleIntegerPosition(ox + oCenterX);
            iy = font.handleIntegerPosition(oy + oCenterY);
            xShift = ox + oCenterX - ix;
            yShift = oy + oCenterY - iy;
            x = font.handleIntegerPosition(ix + xShift);
            y = font.handleIntegerPosition(iy + yShift);
            centerX = oCenterX + xShift * 0.5f;
            centerY = oCenterY + yShift * 0.5f;
            p0x = -cos * centerX + changedW * font.fancyX;
            p0y = font.descent * font.scaleY * 0.5f * (scale * sizingY - font.fancyY) - centerY + sin * centerX;
            this.drawFancyLine(batch, glyph & 0x1E00000L, x + (cos * p0x - sin * p0y), y + (sin * p0x + cos * p0y), changedW * (1.0f + this.underLength), xPx, yPx, rotation);
        }
        return changedW;
    }

    public Layout markup(String text, Layout appendTo) {
        long baseColor;
        long color;
        boolean capitalize = false;
        boolean previousWasLetter = false;
        boolean capsLock = false;
        boolean lowerCase = false;
        boolean initial = true;
        int scale = 3;
        int fontIndex = -1;
        Font font = this;
        long COLOR_MASK = -4294967296L;
        long current = color = (baseColor = Long.reverseBytes(NumberUtils.floatToIntBits((float)appendTo.getBaseColor())) & 0xFFFFFFFE00000000L);
        if (appendTo.font == null || !appendTo.font.equals(this)) {
            appendTo.clear();
            appendTo.font(this);
        }
        appendTo.peekLine().height = 0.0f;
        float targetWidth = appendTo.getTargetWidth();
        int kern = -1;
        this.historyBuffer.clear();
        this.labeledStates.clear();
        this.labeledStates.putAll(this.storedStates);
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            float w;
            char showCh;
            float ox;
            int c;
            float scaleX = font.scaleX * (float)(scale + 1) * 0.25f;
            if (this.omitCurlyBraces && text.charAt(i) == '{' && i + 1 < n && text.charAt(i + 1) != '{') {
                char after;
                int start = i;
                int sizeChange = -1;
                int fontChange = -1;
                int innerSquareStart = -1;
                int innerSquareEnd = -1;
                int end = text.indexOf(125, i);
                if (end == -1) {
                    end = text.length();
                }
                int eq = end;
                while (i < n && i <= end) {
                    c = text.charAt(i);
                    if (this.enableSquareBrackets && c == 91 && i + 1 < end && text.charAt(i + 1) == '+') {
                        innerSquareStart = i;
                    } else if (innerSquareStart == -1) {
                        appendTo.add(current | (long)c);
                    }
                    if (this.enableSquareBrackets && c == 93) {
                        int len;
                        innerSquareEnd = i;
                        if (innerSquareStart != -1 && font.nameLookup != null && (len = innerSquareEnd - innerSquareStart) >= 2) {
                            c = font.nameLookup.get(StringUtils.safeSubstring(text, innerSquareStart + 2, innerSquareEnd), 43);
                            innerSquareStart = -1;
                            appendTo.add(current | (long)c);
                        }
                    }
                    if (c == 64) {
                        fontChange = i;
                    } else if (c == 37) {
                        sizeChange = i;
                    } else if (c == 63) {
                        sizeChange = -1;
                    } else if (c == 94) {
                        sizeChange = -1;
                    } else if (c == 61) {
                        eq = Math.min(eq, i);
                    }
                    ++i;
                }
                char c2 = after = eq + 1 >= end ? (char)'\u0000' : text.charAt(eq + 1);
                if (start + 1 == end || "RESET".equalsIgnoreCase(StringUtils.safeSubstring(text, start + 1, end))) {
                    this.historyBuffer.add(current);
                    scale = 3;
                    font = this;
                    fontIndex = 0;
                    current &= 0xFFFFFFFFF9FFFFFFL;
                } else if (after == '^' || after == '=' || after == '.') {
                    switch (after) {
                        case '^': {
                            if ((current & 0x6000000L) == 0x6000000L) {
                                current &= 0xFFFFFFFFF9FFFFFFL;
                                break;
                            }
                            current |= 0x6000000L;
                            break;
                        }
                        case '.': {
                            if ((current & 0x6000000L) == 0x2000000L) {
                                current &= 0xFFFFFFFFFDFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                            break;
                        }
                        case '=': {
                            if ((current & 0x6000000L) == 0x4000000L) {
                                current &= 0xFFFFFFFFFBFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                        }
                    }
                } else if (fontChange >= 0 && this.family != null) {
                    fontIndex = this.family.fontAliases.get(StringUtils.safeSubstring(text, fontChange + 1, end), -1);
                    if (fontIndex == -1) {
                        font = this;
                        fontIndex = 0;
                    } else {
                        font = this.family.connected[fontIndex];
                        if (font == null) {
                            font = this;
                            fontIndex = 0;
                        }
                    }
                } else if (sizeChange >= 0) {
                    scale = sizeChange + 1 == end ? (eq + 1 == sizeChange ? 3 : (StringUtils.intFromDec(text, eq + 1, sizeChange) - 24) / 25 & 0xF) : (StringUtils.intFromDec(text, sizeChange + 1, end) - 24) / 25 & 0xF;
                }
                long next = current & 0xFFFFFFFFFF00FFFFL | (long)((scale - 3 & 0xF) << 20) | (long)((fontIndex & 0xF) << 16);
                if (current != next) {
                    this.historyBuffer.add(current);
                }
                current = next;
                --i;
                continue;
            }
            if (this.enableSquareBrackets && text.charAt(i) == '[') {
                float w2;
                int len;
                c = 91;
                if (++i < n) {
                    char c3 = text.charAt(i);
                    c = c3;
                    if (c3 != '[' && c != 43) {
                        if (c == 93) {
                            if (this.historyBuffer.isEmpty()) {
                                color = baseColor;
                                current = color & 0xFFFFFFFFF9FFFFFFL;
                                scale = 3;
                                font = this;
                                capitalize = false;
                                capsLock = false;
                                lowerCase = false;
                                continue;
                            }
                            current = this.historyBuffer.pop();
                            scale = (int)((current & 0x1F00000L) >>> 20);
                            if (this.family == null) {
                                font = this;
                                fontIndex = 0;
                                continue;
                            }
                            fontIndex = (int)((current & 0xF0000L) >>> 16);
                            font = this.family.connected[fontIndex & 0xF];
                            if (font != null) continue;
                            font = this;
                            continue;
                        }
                        int len2 = text.indexOf(93, i) - i;
                        if (len2 < 0) break;
                        if (len2 != 1 || c != 32) {
                            this.historyBuffer.add(current);
                        }
                        switch (c) {
                            case 42: {
                                current ^= 0x40000000L;
                                break;
                            }
                            case 47: {
                                current ^= 0x20000000L;
                                break;
                            }
                            case 94: {
                                if ((current & 0x6000000L) == 0x6000000L) {
                                    current &= 0xFFFFFFFFF9FFFFFFL;
                                    break;
                                }
                                current |= 0x6000000L;
                                break;
                            }
                            case 46: {
                                if ((current & 0x6000000L) == 0x2000000L) {
                                    current &= 0xFFFFFFFFFDFFFFFFL;
                                    break;
                                }
                                current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                                break;
                            }
                            case 61: {
                                if ((current & 0x6000000L) == 0x4000000L) {
                                    current &= 0xFFFFFFFFFBFFFFFFL;
                                    break;
                                }
                                current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                                break;
                            }
                            case 95: {
                                current ^= 0x10000000L;
                                break;
                            }
                            case 126: {
                                current ^= 0x8000000L;
                                break;
                            }
                            case 59: {
                                capitalize = !capitalize;
                                capsLock = false;
                                lowerCase = false;
                                break;
                            }
                            case 33: {
                                capsLock = !capsLock;
                                capitalize = false;
                                lowerCase = false;
                                break;
                            }
                            case 44: {
                                lowerCase = !lowerCase;
                                capitalize = false;
                                capsLock = false;
                                break;
                            }
                            case 37: {
                                if (len2 >= 2) {
                                    if (text.charAt(i + 1) == '?' || text.charAt(i + 1) == '^') {
                                        long modes;
                                        long l = modes = text.charAt(i + 1) == '^' ? 0x1100000L : 0x1000000L;
                                        if (len2 >= 5) {
                                            char ch = Category.caseUp((char)text.charAt(i + 2));
                                            if (ch == 'B') {
                                                modes |= 0x1200000L;
                                            } else if (ch == 'W') {
                                                modes = Category.caseUp((char)text.charAt(i + 3)) == 'H' ? (modes |= 0x1400000L) : (modes |= 0x1C00000L);
                                            } else if (ch == 'S') {
                                                if (Category.caseUp((char)text.charAt(i + 4)) == 'I') {
                                                    modes |= 0x1800000L;
                                                } else if (Category.caseUp((char)text.charAt(i + 3)) == 'H') {
                                                    modes |= 0x1600000L;
                                                }
                                            } else if (ch == 'D') {
                                                modes |= 0x1600000L;
                                            } else if (ch == 'E') {
                                                modes |= 0x1A00000L;
                                            } else if (ch == 'N') {
                                                modes |= 0x1E00000L;
                                            }
                                        }
                                        current = current & (0xFFFFFFFFFE0FFFFFL ^ (current & 0x1000000L) >>> 4) ^ modes;
                                        scale = 3;
                                        break;
                                    }
                                    scale = (StringUtils.intFromDec(text, i + 1, i + len2) - 24) / 25 & 0xF;
                                    current = current & 0xFFFFFFFFFE0FFFFFL | (long)((scale - 3 & 0xF) << 20);
                                    break;
                                }
                                current &= 0xFFFFFFFFFE0FFFFFL;
                                scale = 3;
                                break;
                            }
                            case 35: {
                                if (len2 >= 4 && len2 < 7) {
                                    color = StringUtils.longFromHex(text, i + 1, i + 4);
                                    color = color << 52 & 0xF000000000000000L | color << 48 & 0xF00000000000000L | color << 48 & 0xF0000000000000L | color << 44 & 0xF000000000000L | color << 44 & 0xF00000000000L | color << 40 & 0xF0000000000L | 0xFE00000000L;
                                } else {
                                    color = len2 >= 7 && len2 < 9 ? StringUtils.longFromHex(text, i + 1, i + 7) << 40 | 0xFE00000000L : (len2 >= 9 ? StringUtils.longFromHex(text, i + 1, i + 9) << 32 & 0xFFFFFFFE00000000L : baseColor);
                                }
                                current = current & 0xFFFFFFFFL | color;
                                break;
                            }
                            case 64: {
                                if (this.family == null) {
                                    font = this;
                                    fontIndex = 0;
                                    break;
                                }
                                fontIndex = this.family.fontAliases.get(StringUtils.safeSubstring(text, i + 1, i + len2), 0);
                                current = current & 0xFFFFFFFFFFF0FFFFL | ((long)fontIndex & 0xFL) << 16;
                                font = this.family.connected[fontIndex & 0xF];
                                if (font != null) break;
                                font = this;
                                break;
                            }
                            case 40: {
                                if (len2 - 2 <= 0) break;
                                this.labeledStates.put((Object)StringUtils.safeSubstring(text, i + 1, i + len2 - 1), current & 0xFFFFFFFFFFFF0000L);
                                break;
                            }
                            case 124: {
                                int lookupColor = this.colorLookup.getRgba(text, i + 1, i + len2) & 0xFFFFFFFE;
                                color = lookupColor == 256 ? baseColor : (long)lookupColor << 32;
                                current = current & 0xFFFFFFFFL | color;
                                break;
                            }
                            case 32: {
                                capitalize = false;
                                capsLock = false;
                                lowerCase = false;
                                if (len2 > 1) {
                                    current = this.labeledStates.get((Object)StringUtils.safeSubstring(text, i + 1, i + len2), current);
                                    scale = (int)((current >>> 20 & 0xFL) + 3L);
                                    if (this.family == null || (font = this.family.connected[(int)(current >>> 16 & 0xFL)]) != null) break;
                                    font = this;
                                    break;
                                }
                                color = baseColor;
                                current = color & 0xFFFFFFFFF9FFFFFFL;
                                scale = 3;
                                font = this;
                                break;
                            }
                            default: {
                                int gdxColor = this.colorLookup.getRgba(text, i, i + len2) & 0xFFFFFFFE;
                                color = gdxColor == 256 ? baseColor : (long)gdxColor << 32;
                                current = current & 0xFFFFFFFFL | color;
                            }
                        }
                        i += len2;
                        continue;
                    }
                }
                if (c == 43 && font.nameLookup != null && (len = text.indexOf(93, i) - i) >= 0) {
                    c = font.nameLookup.get(StringUtils.safeSubstring(text, i + 1, i + len), 43);
                    i += len;
                    scaleX = (float)(scale + 1) * 0.25f * font.cellHeight / ((GlyphRegion)((Object)font.mapping.get(c, (Object)font.defaultValue))).getMaxDimension() * font.inlineImageStretch;
                }
                if (font.kerning == null) {
                    w2 = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)c);
                    if (initial && !this.isMono && (c < 57344 || c >= 63488)) {
                        float ox2 = ((GlyphRegion)((Object)font.mapping.get((int)c, (Object)((Object)font.defaultValue)))).offsetX;
                        ox2 = ox2 != ox2 ? 0.0f : (ox2 *= scaleX);
                        if (ox2 < 0.0f) {
                            w2 = appendTo.peekLine().width -= ox2;
                        }
                    }
                    initial = false;
                } else {
                    kern = kern << 16 | c;
                    w2 = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)c) + font.kerning.get(kern, 0.0f) * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                    if (initial && !this.isMono && (c < 57344 || c >= 63488)) {
                        float ox3 = ((GlyphRegion)((Object)font.mapping.get((int)c, (Object)((Object)font.defaultValue)))).offsetX;
                        ox3 = ox3 != ox3 ? 0.0f : (ox3 *= scaleX);
                        ox3 *= 1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63);
                        if (ox3 < 0.0f) {
                            w2 = appendTo.peekLine().width -= ox3;
                        }
                    }
                    initial = false;
                }
                if (c == 91) {
                    appendTo.add(current | 2L);
                } else {
                    appendTo.add(current | (long)c);
                }
                if (targetWidth > 0.0f && w2 > targetWidth) {
                    Line earlier = appendTo.peekLine();
                    Line later = appendTo.pushLine();
                    if (later == null) {
                        if (!this.handleEllipsis(appendTo)) continue;
                        return appendTo;
                    }
                    for (int j = earlier.glyphs.size - 2; j >= 0; --j) {
                        long curr = earlier.glyphs.get(j);
                        if (curr >>> 32 != 0L && Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)curr) < 0) continue;
                        int leading = 0;
                        boolean hyphenated = true;
                        while (j > 0 && ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0)) {
                            ++leading;
                            --j;
                            hyphenated = false;
                        }
                        this.glyphBuffer.clear();
                        float change = 0.0f;
                        float changeNext = 0.0f;
                        if (font.kerning == null) {
                            boolean curly = false;
                            for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                                curr = earlier.glyphs.get(k);
                                if (this.omitCurlyBraces && curly) {
                                    this.glyphBuffer.add(curr);
                                    if ((char)curr == '{') {
                                        curly = false;
                                    } else {
                                        if ((char)curr != '}') continue;
                                        curly = false;
                                        continue;
                                    }
                                }
                                if ((char)curr == '{') {
                                    this.glyphBuffer.add(curr);
                                    curly = this.omitCurlyBraces;
                                    continue;
                                }
                                float adv = Font.xAdvance(font, scaleX, curr);
                                change += adv;
                                if (--leading >= 0) continue;
                                this.glyphBuffer.add(curr);
                                changeNext += adv;
                                if (this.glyphBuffer.size != 1) continue;
                                if (!(this.isMono || c >= 57344 && c < 63488)) {
                                    float ox4 = ((GlyphRegion)((Object)font.mapping.get((int)((char)((int)curr)), (Object)((Object)font.defaultValue)))).offsetX;
                                    ox4 = ox4 != ox4 ? 0.0f : (ox4 *= scaleX);
                                    ox4 *= 1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63);
                                    if (ox4 < 0.0f) {
                                        changeNext -= ox4;
                                    }
                                }
                                initial = false;
                            }
                        } else {
                            int k2 = (int)earlier.glyphs.get(j);
                            int k3 = -1;
                            boolean curly = false;
                            for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                                curr = earlier.glyphs.get(k);
                                if (this.omitCurlyBraces && curly) {
                                    this.glyphBuffer.add(curr);
                                    if ((char)curr == '{') {
                                        curly = false;
                                    } else {
                                        if ((char)curr != '}') continue;
                                        curly = false;
                                        continue;
                                    }
                                }
                                if ((char)curr == '{') {
                                    this.glyphBuffer.add(curr);
                                    curly = this.omitCurlyBraces;
                                    continue;
                                }
                                k2 = k2 << 16 | (char)curr;
                                float adv = Font.xAdvance(font, scaleX, curr);
                                change += adv + font.kerning.get(k2, 0.0f) * scaleX * (1.0f + 0.5f * (float)(-(curr & 0x6000000L) >> 63));
                                if (--leading >= 0) continue;
                                k3 = k3 << 16 | (char)curr;
                                changeNext += adv + font.kerning.get(k3, 0.0f) * scaleX * (1.0f + 0.5f * (float)(-(curr & 0x6000000L) >> 63));
                                this.glyphBuffer.add(curr);
                                if (this.glyphBuffer.size != 1) continue;
                                if (!(this.isMono || c >= 57344 && c < 63488)) {
                                    ox = ((GlyphRegion)((Object)font.mapping.get((int)((char)((int)curr)), (Object)((Object)font.defaultValue)))).offsetX;
                                    ox = ox != ox ? 0.0f : (ox *= scaleX);
                                    ox *= 1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63);
                                    if (ox < 0.0f) {
                                        changeNext -= ox;
                                    }
                                }
                                initial = false;
                            }
                        }
                        if (earlier.width - change > targetWidth) continue;
                        earlier.glyphs.truncate(j + 1);
                        if (!hyphenated) {
                            earlier.glyphs.add(Font.applyChar(earlier.glyphs.isEmpty() ? 0L : earlier.glyphs.peek(), ' '));
                        }
                        later.width = changeNext;
                        earlier.width -= change;
                        later.glyphs.addAll(this.glyphBuffer);
                        later.height = Math.max(later.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                        break;
                    }
                    if (!later.glyphs.isEmpty()) continue;
                    appendTo.lines.pop();
                    continue;
                }
                appendTo.peekLine().height = Math.max(appendTo.peekLine().height, font.cellHeight * (float)(scale + 1) * 0.25f);
                continue;
            }
            char ch = text.charAt(i);
            if (StringUtils.isLowerCase(ch)) {
                if (capitalize && !previousWasLetter || capsLock) {
                    ch = Category.caseUp((char)ch);
                }
                previousWasLetter = true;
            } else if (StringUtils.isUpperCase(ch)) {
                if (capitalize && previousWasLetter || lowerCase) {
                    ch = Category.caseDown((char)ch);
                }
                previousWasLetter = true;
            } else {
                previousWasLetter = false;
            }
            char c4 = showCh = (current & 0x1100000L) == 0x1100000L ? Category.caseUp((char)ch) : ch;
            if (ch >= '\ue000' && ch < '\uf800') {
                scaleX = (float)(scale + 1) * 0.25f * font.cellHeight / ((GlyphRegion)((Object)font.mapping.get((int)ch, (Object)font.defaultValue))).getMaxDimension() * font.inlineImageStretch;
            }
            if (font.kerning == null) {
                w = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)showCh);
            } else {
                kern = kern << 16 | showCh;
                w = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)showCh) + font.kerning.get(kern, 0.0f) * scaleX * (1.0f + 0.5f * (float)(-((current | (long)showCh) & 0x6000000L) >> 63));
            }
            if (initial && !this.isMono && (showCh < '\ue000' || showCh >= '\uf800')) {
                float ox5 = ((GlyphRegion)((Object)font.mapping.get((int)showCh, (Object)((Object)font.defaultValue)))).offsetX;
                ox5 = ox5 != ox5 ? 0.0f : (ox5 *= scaleX);
                ox5 *= 1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63);
                if (ox5 < 0.0f) {
                    w = appendTo.peekLine().width -= ox5;
                }
            }
            initial = false;
            if (ch == '\n') {
                appendTo.peekLine().height = Math.max(appendTo.peekLine().height, font.cellHeight * (float)(scale + 1) * 0.25f);
                initial = true;
            }
            appendTo.add(current | (long)ch);
            if (targetWidth > 0.0f && w > targetWidth || appendTo.atLimit) {
                Line later;
                Line earlier = appendTo.peekLine();
                if (appendTo.lines.size >= appendTo.maxLines) {
                    later = null;
                } else {
                    later = new Line();
                    later.height = 0.0f;
                    appendTo.lines.add((Object)later);
                    initial = true;
                }
                if (later == null) {
                    if (!this.handleEllipsis(appendTo)) continue;
                    return appendTo;
                }
                for (int j = earlier.glyphs.size - 2; j >= 0; --j) {
                    long curr = earlier.glyphs.get(j);
                    if (curr >>> 32 != 0L && Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)curr) < 0) continue;
                    int leading = 0;
                    boolean hyphenated = true;
                    while (j > 0 && ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0)) {
                        ++leading;
                        --j;
                        hyphenated = false;
                    }
                    this.glyphBuffer.clear();
                    float change = 0.0f;
                    float changeNext = 0.0f;
                    if (font.kerning == null) {
                        boolean curly = false;
                        for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                            curr = earlier.glyphs.get(k);
                            char c5 = showCh = (curr & 0x1100000L) == 0x1100000L ? Category.caseUp((char)((char)curr)) : (char)curr;
                            if (this.omitCurlyBraces && curly) {
                                this.glyphBuffer.add(curr);
                                if ((char)curr == '{') {
                                    curly = false;
                                } else {
                                    if ((char)curr != '}') continue;
                                    curly = false;
                                    continue;
                                }
                            }
                            if (showCh == '{') {
                                this.glyphBuffer.add(curr);
                                curly = this.omitCurlyBraces;
                                continue;
                            }
                            float adv = Font.xAdvance(font, scaleX, curr);
                            change += adv;
                            if (--leading >= 0) continue;
                            this.glyphBuffer.add(curr);
                            changeNext += adv;
                            if (this.glyphBuffer.size != 1) continue;
                            if (!(this.isMono || showCh >= '\ue000' && showCh < '\uf800')) {
                                ox = ((GlyphRegion)((Object)font.mapping.get((int)showCh, (Object)((Object)font.defaultValue)))).offsetX;
                                ox = ox != ox ? 0.0f : (ox *= scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63)));
                                if (ox < 0.0f) {
                                    changeNext -= ox;
                                }
                            }
                            initial = false;
                        }
                    } else {
                        int k2 = (int)earlier.glyphs.get(j);
                        kern = -1;
                        boolean curly = false;
                        for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                            curr = earlier.glyphs.get(k);
                            char c6 = showCh = (curr & 0x1100000L) == 0x1100000L ? Category.caseUp((char)((char)curr)) : (char)curr;
                            if (this.omitCurlyBraces && curly) {
                                this.glyphBuffer.add(curr);
                                if ((char)curr == '{') {
                                    curly = false;
                                } else {
                                    if ((char)curr != '}') continue;
                                    curly = false;
                                    continue;
                                }
                            }
                            if (showCh == '{') {
                                this.glyphBuffer.add(curr);
                                curly = this.omitCurlyBraces;
                                continue;
                            }
                            k2 = k2 << 16 | showCh;
                            float adv = Font.xAdvance(font, scaleX, curr);
                            change += adv + font.kerning.get(k2, 0.0f) * scaleX * (this.isMono || (curr & 0x6000000L) == 0L ? 1.0f : 0.5f);
                            if (--leading >= 0) continue;
                            kern = kern << 16 | showCh;
                            changeNext += adv + font.kerning.get(kern, 0.0f) * scaleX * (this.isMono || (curr & 0x6000000L) == 0L ? 1.0f : 0.5f);
                            this.glyphBuffer.add(curr);
                            if (this.glyphBuffer.size != 1) continue;
                            if (!(this.isMono || showCh >= '\ue000' && showCh < '\uf800')) {
                                float ox6 = ((GlyphRegion)((Object)font.mapping.get((int)showCh, (Object)((Object)font.defaultValue)))).offsetX;
                                ox6 = ox6 != ox6 ? 0.0f : (ox6 *= scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63)));
                                if (ox6 < 0.0f) {
                                    changeNext -= ox6;
                                }
                            }
                            initial = false;
                        }
                    }
                    if (earlier.width - change > targetWidth) continue;
                    earlier.glyphs.truncate(j + 1);
                    if (!hyphenated) {
                        earlier.glyphs.add(Font.applyChar(earlier.glyphs.isEmpty() ? 0L : earlier.glyphs.peek(), ' '));
                    }
                    later.width = changeNext;
                    earlier.width -= change;
                    later.glyphs.addAll(this.glyphBuffer);
                    later.height = Math.max(later.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                    break;
                }
                if (!later.glyphs.isEmpty()) continue;
                appendTo.lines.pop();
                continue;
            }
            appendTo.peekLine().height = Math.max(appendTo.peekLine().height, font.cellHeight * (float)(scale + 1) * 0.25f);
        }
        return appendTo;
    }

    protected boolean handleEllipsis(Layout appendTo) {
        Font font = null;
        Line earlier = appendTo.peekLine();
        String ellipsis = appendTo.ellipsis == null ? "" : appendTo.ellipsis;
        for (int j = earlier.glyphs.size - 2; j >= 0; --j) {
            long curr = earlier.glyphs.get(j);
            if (curr >>> 32 != 0L && Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)curr) < 0) continue;
            while (j > 0 && ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0)) {
                --j;
            }
            if (this.family != null) {
                font = this.family.connected[(int)(curr >>> 16 & 0xFL)];
            }
            if (font == null) {
                font = this;
            }
            float change = 0.0f;
            if (font.kerning == null) {
                float adv;
                boolean curly = false;
                for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                    curr = earlier.glyphs.get(k);
                    if (this.family != null) {
                        font = this.family.connected[(int)(curr >>> 16 & 0xFL)];
                    }
                    if (font == null) {
                        font = this;
                    }
                    if (this.omitCurlyBraces && curly) {
                        if ((char)curr == '{') {
                            curly = false;
                        } else {
                            if ((char)curr != '}') continue;
                            curly = false;
                            continue;
                        }
                    }
                    if ((char)curr == '{') {
                        curly = this.omitCurlyBraces;
                        continue;
                    }
                    adv = Font.xAdvance(font, this.scaleX, curr);
                    change += adv;
                }
                for (int e = 0; e < ellipsis.length(); ++e) {
                    curr = curr & 0xFFFFFFFF81FF0000L | (long)ellipsis.charAt(e);
                    adv = Font.xAdvance(font, this.scaleX, curr);
                    change -= adv;
                }
            } else {
                float adv;
                int k2 = (int)earlier.glyphs.get(j);
                boolean curly = false;
                for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                    curr = earlier.glyphs.get(k);
                    if (this.family != null) {
                        font = this.family.connected[(int)(curr >>> 16 & 0xFL)];
                    }
                    if (font == null) {
                        font = this;
                    }
                    if (this.omitCurlyBraces && curly) {
                        if ((char)curr == '{') {
                            curly = false;
                        } else {
                            if ((char)curr != '}') continue;
                            curly = false;
                            continue;
                        }
                    }
                    if ((char)curr == '{') {
                        curly = this.omitCurlyBraces;
                        continue;
                    }
                    k2 = k2 << 16 | (char)curr;
                    adv = Font.xAdvance(font, this.scaleX, curr);
                    change += adv + font.kerning.get(k2, 0.0f) * this.scaleX * (this.isMono || (curr & 0x6000000L) == 0L ? 1.0f : 0.5f);
                }
                for (int e = 0; e < ellipsis.length(); ++e) {
                    curr = curr & 0xFFFFFFFF81FF0000L | (long)ellipsis.charAt(e);
                    k2 = k2 << 16 | (char)curr;
                    adv = Font.xAdvance(font, this.scaleX, curr);
                    change -= adv + font.kerning.get(k2, 0.0f) * this.scaleX * (this.isMono || (curr & 0x6000000L) == 0L ? 1.0f : 0.5f);
                }
            }
            if (earlier.width - change > appendTo.targetWidth) continue;
            earlier.glyphs.truncate(j + 1);
            for (int e = 0; e < ellipsis.length(); ++e) {
                earlier.glyphs.add(curr & 0xFFFFFFFF81FF0000L | (long)ellipsis.charAt(e));
            }
            earlier.width -= change;
            return true;
        }
        return false;
    }

    public long markupGlyph(int chr, String markup) {
        return this.markupGlyph(markup + (char)chr) & 0xFFFFFFFFFFFF0000L | (long)((char)chr);
    }

    public long markupGlyph(String markup) {
        long baseColor;
        long color;
        boolean capitalize = false;
        boolean capsLock = false;
        boolean lowerCase = false;
        int scale = 3;
        int fontIndex = -1;
        long COLOR_MASK = -4294967296L;
        long current = color = (baseColor = -8589934592L);
        Font font = this;
        int n = markup.length();
        for (int i = 0; i <= n; ++i) {
            int c;
            if (i == n) {
                return current | 0x20L;
            }
            if (this.omitCurlyBraces && markup.charAt(i) == '{' && i + 1 < n && markup.charAt(i + 1) != '{') {
                char after;
                int start = i;
                int sizeChange = -1;
                int fontChange = -1;
                int innerSquareStart = -1;
                int innerSquareEnd = -1;
                int end = markup.indexOf(125, i);
                if (end == -1) {
                    end = markup.length();
                }
                int eq = end;
                while (i < n && i <= end) {
                    c = markup.charAt(i);
                    if (this.enableSquareBrackets && c == 91 && i + 1 < end && markup.charAt(i + 1) == '+') {
                        innerSquareStart = i;
                    } else if (innerSquareStart == -1) {
                        current |= (long)c;
                    }
                    if (this.enableSquareBrackets && c == 93) {
                        int len;
                        innerSquareEnd = i;
                        if (innerSquareStart != -1 && font.nameLookup != null && (len = innerSquareEnd - innerSquareStart) >= 2) {
                            c = font.nameLookup.get(StringUtils.safeSubstring(markup, innerSquareStart + 2, innerSquareEnd), 43);
                            innerSquareStart = -1;
                            current |= (long)c;
                        }
                    }
                    if (c == 64) {
                        fontChange = i;
                    } else if (c == 37) {
                        sizeChange = i;
                    } else if (c == 63) {
                        sizeChange = -1;
                    } else if (c == 94) {
                        sizeChange = -1;
                    } else if (c == 61) {
                        eq = Math.min(eq, i);
                    }
                    ++i;
                }
                char c2 = after = eq + 1 >= end ? (char)'\u0000' : markup.charAt(eq + 1);
                if (start + 1 == end || "RESET".equalsIgnoreCase(StringUtils.safeSubstring(markup, start + 1, end))) {
                    scale = 3;
                    fontIndex = 0;
                    current &= 0xFFFFFFFFF9FFFFFFL;
                } else if (after == '^' || after == '=' || after == '.') {
                    switch (after) {
                        case '^': {
                            if ((current & 0x6000000L) == 0x6000000L) {
                                current &= 0xFFFFFFFFF9FFFFFFL;
                                break;
                            }
                            current |= 0x6000000L;
                            break;
                        }
                        case '.': {
                            if ((current & 0x6000000L) == 0x2000000L) {
                                current &= 0xFFFFFFFFFDFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                            break;
                        }
                        case '=': {
                            if ((current & 0x6000000L) == 0x4000000L) {
                                current &= 0xFFFFFFFFFBFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                        }
                    }
                } else if (fontChange >= 0 && this.family != null) {
                    fontIndex = this.family.fontAliases.get(StringUtils.safeSubstring(markup, fontChange + 1, end), -1);
                    if (fontIndex == -1) {
                        fontIndex = 0;
                    } else if (this.family.connected[fontIndex] == null) {
                        fontIndex = 0;
                    } else {
                        font = this.family.connected[fontIndex];
                    }
                } else if (sizeChange >= 0) {
                    scale = sizeChange + 1 == end ? (eq + 1 == sizeChange ? 3 : (StringUtils.intFromDec(markup, eq + 1, sizeChange) - 24) / 25 & 0xF) : (StringUtils.intFromDec(markup, sizeChange + 1, end) - 24) / 25 & 0xF;
                }
                current = current & 0xFFFFFFFFFF00FFFFL | (long)((scale - 3 & 0xF) << 20) | (long)((fontIndex & 0xF) << 16);
                --i;
                continue;
            }
            if (this.enableSquareBrackets && markup.charAt(i) == '[') {
                int len;
                c = 91;
                if (++i < n) {
                    char c3 = markup.charAt(i);
                    c = c3;
                    if (c3 != '[' && c != 43) {
                        if (c == 93) {
                            color = baseColor;
                            current = color & 0xFFFFFFFFF9FFFFFFL;
                            scale = 3;
                            capitalize = false;
                            capsLock = false;
                            lowerCase = false;
                            continue;
                        }
                        int len2 = markup.indexOf(93, i) - i;
                        if (len2 < 0) break;
                        switch (c) {
                            case 42: {
                                current ^= 0x40000000L;
                                break;
                            }
                            case 47: {
                                current ^= 0x20000000L;
                                break;
                            }
                            case 94: {
                                if ((current & 0x6000000L) == 0x6000000L) {
                                    current &= 0xFFFFFFFFF9FFFFFFL;
                                    break;
                                }
                                current |= 0x6000000L;
                                break;
                            }
                            case 46: {
                                if ((current & 0x6000000L) == 0x2000000L) {
                                    current &= 0xFFFFFFFFFDFFFFFFL;
                                    break;
                                }
                                current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                                break;
                            }
                            case 61: {
                                if ((current & 0x6000000L) == 0x4000000L) {
                                    current &= 0xFFFFFFFFFBFFFFFFL;
                                    break;
                                }
                                current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                                break;
                            }
                            case 95: {
                                current ^= 0x10000000L;
                                break;
                            }
                            case 126: {
                                current ^= 0x8000000L;
                                break;
                            }
                            case 59: {
                                capitalize = !capitalize;
                                capsLock = false;
                                lowerCase = false;
                                break;
                            }
                            case 33: {
                                capsLock = !capsLock;
                                capitalize = false;
                                lowerCase = false;
                                break;
                            }
                            case 44: {
                                lowerCase = !lowerCase;
                                capitalize = false;
                                capsLock = false;
                                break;
                            }
                            case 37: {
                                if (len2 >= 2) {
                                    if (markup.charAt(i + 1) == '?' || markup.charAt(i + 1) == '^') {
                                        long modes;
                                        long l = modes = markup.charAt(i + 1) == '^' ? 0x1100000L : 0x1000000L;
                                        if (len2 >= 5) {
                                            char ch = Category.caseUp((char)markup.charAt(i + 2));
                                            if (ch == 'B') {
                                                modes |= 0x1200000L;
                                            } else if (ch == 'W') {
                                                modes = Category.caseUp((char)markup.charAt(i + 3)) == 'H' ? (modes |= 0x1400000L) : (modes |= 0x1C00000L);
                                            } else if (ch == 'S') {
                                                if (Category.caseUp((char)markup.charAt(i + 4)) == 'I') {
                                                    modes |= 0x1800000L;
                                                } else if (Category.caseUp((char)markup.charAt(i + 3)) == 'H') {
                                                    modes |= 0x1600000L;
                                                }
                                            } else if (ch == 'D') {
                                                modes |= 0x1600000L;
                                            } else if (ch == 'E') {
                                                modes |= 0x1A00000L;
                                            } else if (ch == 'N') {
                                                modes |= 0x1E00000L;
                                            }
                                        }
                                        current = current & (0xFFFFFFFFFE0FFFFFL ^ (current & 0x1000000L) >>> 4) ^ modes;
                                        scale = 3;
                                        break;
                                    }
                                    scale = (StringUtils.intFromDec(markup, i + 1, i + len2) - 24) / 25 & 0xF;
                                    current = current & 0xFFFFFFFFFE0FFFFFL | (long)((scale - 3 & 0xF) << 20);
                                    break;
                                }
                                current &= 0xFFFFFFFFFE0FFFFFL;
                                scale = 3;
                                break;
                            }
                            case 35: {
                                if (len2 >= 4 && len2 < 7) {
                                    color = StringUtils.longFromHex(markup, i + 1, i + 4);
                                    color = color << 52 & 0xF000000000000000L | color << 48 & 0xF00000000000000L | color << 48 & 0xF0000000000000L | color << 44 & 0xF000000000000L | color << 44 & 0xF00000000000L | color << 40 & 0xF0000000000L | 0xFE00000000L;
                                } else {
                                    color = len2 >= 7 && len2 < 9 ? StringUtils.longFromHex(markup, i + 1, i + 7) << 40 | 0xFE00000000L : (len2 >= 9 ? StringUtils.longFromHex(markup, i + 1, i + 9) << 32 & 0xFFFFFFFE00000000L : baseColor);
                                }
                                current = current & 0xFFFFFFFFL | color;
                                break;
                            }
                            case 64: {
                                if (this.family == null) {
                                    fontIndex = 0;
                                    break;
                                }
                                fontIndex = this.family.fontAliases.get(StringUtils.safeSubstring(markup, i + 1, i + len2), 0);
                                font = this.family.connected[fontIndex];
                                current = current & 0xFFFFFFFFFFF0FFFFL | ((long)fontIndex & 0xFL) << 16;
                                break;
                            }
                            case 124: {
                                int lookupColor = this.colorLookup.getRgba(markup, i + 1, i + len2) & 0xFFFFFFFE;
                                color = lookupColor == 256 ? baseColor : (long)lookupColor << 32;
                                current = current & 0xFFFFFFFFL | color;
                                break;
                            }
                            default: {
                                int gdxColor = this.colorLookup.getRgba(markup, i, i + len2) & 0xFFFFFFFE;
                                color = gdxColor == 256 ? baseColor : (long)gdxColor << 32;
                                current = current & 0xFFFFFFFFL | color;
                            }
                        }
                        i += len2;
                        continue;
                    }
                }
                if (c == 43 && font.nameLookup != null && (len = markup.indexOf(93, i) - i) >= 0) {
                    c = font.nameLookup.get(StringUtils.safeSubstring(markup, i + 1, i + len), 43);
                }
                if (c == 91) {
                    return current | 2L;
                }
                return current | (long)c;
            }
            char ch = markup.charAt(i);
            if (StringUtils.isLowerCase(ch)) {
                if (capitalize || capsLock) {
                    ch = Category.caseUp((char)ch);
                }
            } else if (StringUtils.isUpperCase(ch) && lowerCase) {
                ch = Category.caseDown((char)ch);
            }
            return current | (long)ch;
        }
        return current | 0x20L;
    }

    public static long markupGlyph(char chr, String markup, ColorLookup colorLookup) {
        return Font.markupGlyph(chr, markup, colorLookup, null);
    }

    public static long markupGlyph(char chr, String markup, ColorLookup colorLookup, FontFamily family) {
        long baseColor;
        long color;
        boolean capsLock = false;
        boolean lowerCase = false;
        long COLOR_MASK = -4294967296L;
        long current = color = (baseColor = 0xFFFFFFFE00000000L | (long)chr);
        int n = markup.length();
        block15: for (int i = 0; i < n; ++i) {
            char c;
            if (markup.charAt(i) != '[' || ++i >= n || (c = markup.charAt(i)) == '[') continue;
            if (c == ']') {
                current = color = baseColor;
                capsLock = false;
                lowerCase = false;
                continue;
            }
            int len = markup.indexOf(93, i) - i;
            if (len < 0) break;
            switch (c) {
                case '*': {
                    current ^= 0x40000000L;
                    continue block15;
                }
                case '/': {
                    current ^= 0x20000000L;
                    continue block15;
                }
                case '^': {
                    if ((current & 0x6000000L) == 0x6000000L) {
                        current &= 0xFFFFFFFFF9FFFFFFL;
                        continue block15;
                    }
                    current |= 0x6000000L;
                    continue block15;
                }
                case '.': {
                    if ((current & 0x6000000L) == 0x2000000L) {
                        current &= 0xFFFFFFFFFDFFFFFFL;
                        continue block15;
                    }
                    current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                    continue block15;
                }
                case '=': {
                    if ((current & 0x6000000L) == 0x4000000L) {
                        current &= 0xFFFFFFFFFBFFFFFFL;
                        continue block15;
                    }
                    current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                    continue block15;
                }
                case '_': {
                    current ^= 0x10000000L;
                    continue block15;
                }
                case '~': {
                    current ^= 0x8000000L;
                    continue block15;
                }
                case '!': 
                case ';': {
                    capsLock = !capsLock;
                    lowerCase = false;
                    continue block15;
                }
                case ',': {
                    lowerCase = !lowerCase;
                    capsLock = false;
                    continue block15;
                }
                case '%': {
                    if (len >= 2) {
                        if (markup.charAt(i + 1) == '?' || markup.charAt(i + 1) == '^') {
                            long modes;
                            long l = modes = markup.charAt(i + 1) == '^' ? 0x1100000L : 0x1000000L;
                            if (len >= 5) {
                                char ch = Category.caseUp((char)markup.charAt(i + 2));
                                if (ch == 'B') {
                                    modes |= 0x1200000L;
                                } else if (ch == 'W') {
                                    modes = Category.caseUp((char)markup.charAt(i + 3)) == 'H' ? (modes |= 0x1400000L) : (modes |= 0x1C00000L);
                                } else if (ch == 'S') {
                                    if (Category.caseUp((char)markup.charAt(i + 4)) == 'I') {
                                        modes |= 0x1800000L;
                                    } else if (Category.caseUp((char)markup.charAt(i + 3)) == 'H') {
                                        modes |= 0x1600000L;
                                    }
                                } else if (ch == 'D') {
                                    modes |= 0x1600000L;
                                } else if (ch == 'E') {
                                    modes |= 0x1A00000L;
                                } else if (ch == 'N') {
                                    modes |= 0x1E00000L;
                                }
                            }
                            current = current & (0xFFFFFFFFFE0FFFFFL ^ (current & 0x1000000L) >>> 4) ^ modes;
                            continue block15;
                        }
                        current = current & 0xFFFFFFFFFE0FFFFFL | (long)((((StringUtils.intFromDec(markup, i + 1, i + len) - 24) / 25 & 0xF) - 3 & 0xF) << 20);
                        continue block15;
                    }
                    current &= 0xFFFFFFFFFE0FFFFFL;
                    continue block15;
                }
                case '@': {
                    if (family == null) continue block15;
                    int fontIndex = family.fontAliases.get(StringUtils.safeSubstring(markup, i + 1, i + len), 0);
                    current = current & 0xFFFFFFFFFFF0FFFFL | ((long)fontIndex & 0xFL) << 16;
                    continue block15;
                }
                case '#': {
                    if (len >= 4 && len < 7) {
                        color = StringUtils.longFromHex(markup, i + 1, i + 4);
                        color = color << 52 & 0xF000000000000000L | color << 48 & 0xF00000000000000L | color << 48 & 0xF0000000000000L | color << 44 & 0xF000000000000L | color << 44 & 0xF00000000000L | color << 40 & 0xF0000000000L | 0xFE00000000L;
                    } else {
                        color = len >= 7 && len < 9 ? StringUtils.longFromHex(markup, i + 1, i + 7) << 40 | 0xFE00000000L : (len >= 9 ? StringUtils.longFromHex(markup, i + 1, i + 9) << 32 & 0xFFFFFFFE00000000L : baseColor);
                    }
                    current = current & 0xFFFFFFFFL | color;
                    continue block15;
                }
                case '|': {
                    int lookupColor = colorLookup.getRgba(markup, i + 1, i + len) & 0xFFFFFFFE;
                    color = lookupColor == 256 ? baseColor : (long)lookupColor << 32;
                    current = current & 0xFFFFFFFFL | color;
                    continue block15;
                }
                default: {
                    int gdxColor = colorLookup.getRgba(markup, i, i + len) & 0xFFFFFFFE;
                    color = gdxColor == 256 ? baseColor : (long)gdxColor << 32;
                    current = current & 0xFFFFFFFFL | color;
                }
            }
        }
        return current;
    }

    public Layout regenerateLayout(Layout changing) {
        if (changing.font == null) {
            return changing;
        }
        if (!changing.font.equals(this)) {
            changing.font = this;
        }
        Font font = null;
        float targetWidth = changing.getTargetWidth();
        int oldLength = changing.lines.size;
        Line firstLine = changing.getLine(0);
        for (int i = 1; i < oldLength; ++i) {
            firstLine.glyphs.addAll(changing.getLine((int)i).glyphs);
        }
        changing.lines.truncate(1);
        boolean curly = false;
        block1: for (int ln = 0; ln < changing.lines(); ++ln) {
            Line line = changing.getLine(ln);
            line.height = 0.0f;
            float drawn = 0.0f;
            float visibleWidth = 0.0f;
            int breakPoint = -2;
            int spacingPoint = -2;
            LongArray glyphs = line.glyphs;
            int kern = -1;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                long[] arr;
                int nextSize;
                int cutoff;
                float ox;
                float changedW;
                GlyphRegion tr;
                Line next;
                float scaleX;
                int scale;
                long glyph = glyphs.get(i);
                char ch = (char)glyph;
                if (ch == '{' && !curly) {
                    curly = true;
                }
                if ((glyph & 0x1100000L) == 0x1100000L) {
                    ch = Category.caseUp((char)ch);
                }
                if (this.family != null) {
                    font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
                }
                if (font == null) {
                    font = this;
                }
                if (font.kerning == null) {
                    scale = Font.extractIntScale(glyph);
                    line.height = Math.max(line.height, font.cellHeight * (float)scale * 0.25f);
                    scaleX = ch >= '\ue000' && ch < '\uf800' ? (float)scale * 0.25f * font.cellHeight / ((GlyphRegion)((Object)font.mapping.get((int)ch, (Object)font.defaultValue))).getMaxDimension() * font.inlineImageStretch : font.scaleX * (float)scale * 0.25f;
                    if (ch == '\n') {
                        next = changing.pushLine();
                        glyphs.pop();
                        if (next == null) {
                            if (!this.handleEllipsis(changing)) continue block1;
                            this.calculateSize(changing);
                            return changing;
                        }
                        next.height = Math.max(next.height, font.cellHeight * (float)scale * 0.25f);
                        long[] arr2 = next.glyphs.setSize(glyphs.size - i - 1);
                        System.arraycopy(glyphs.items, i + 1, arr2, 0, glyphs.size - i - 1);
                        glyphs.truncate(i);
                        glyphs.add(Font.applyChar(glyphs.isEmpty() ? 0L : glyphs.peek(), '\n'));
                        continue block1;
                    }
                    tr = (GlyphRegion)((Object)font.mapping.get((int)ch));
                    if (tr == null) continue;
                    changedW = Font.xAdvance(font, scaleX, glyph);
                    if (!(i != 0 || this.isMono || ch >= '\ue000' && ch < '\uf800')) {
                        ox = tr.offsetX;
                        ox = ox != ox ? 0.0f : (ox *= scaleX * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63)));
                        if (ox < 0.0f) {
                            changedW -= ox;
                        }
                    }
                    if (curly) {
                        changedW = 0.0f;
                        if (ch == '}') {
                            curly = false;
                        }
                    }
                    if (breakPoint >= 0) {
                        float f = breakPoint == spacingPoint ? 0.0f : changedW;
                        if (visibleWidth + f > targetWidth + 1.0f) {
                            Line next2;
                            cutoff = breakPoint + 1;
                            if (changing.lines() == ln + 1) {
                                next2 = changing.pushLine();
                                glyphs.pop();
                            } else {
                                next2 = changing.getLine(ln + 1);
                            }
                            if (next2 == null) {
                                glyphs.truncate(cutoff);
                                if (!this.handleEllipsis(changing)) continue block1;
                                this.calculateSize(changing);
                                return changing;
                            }
                            next2.height = Math.max(next2.height, font.cellHeight * (float)scale * 0.25f);
                            nextSize = next2.glyphs.size;
                            arr = next2.glyphs.setSize(nextSize + glyphs.size - cutoff);
                            System.arraycopy(arr, 0, arr, glyphs.size - cutoff, nextSize);
                            System.arraycopy(glyphs.items, cutoff, arr, 0, glyphs.size - cutoff);
                            glyphs.truncate(cutoff);
                            continue block1;
                        }
                    }
                    if (glyph >>> 32 == 0L) {
                        breakPoint = i;
                        spacingPoint = i;
                        visibleWidth -= changedW;
                    } else if (Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)glyph) >= 0) {
                        breakPoint = i;
                        if (Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)glyph) >= 0) {
                            spacingPoint = i;
                            visibleWidth -= changedW;
                        } else {
                            visibleWidth = drawn;
                        }
                    } else {
                        visibleWidth = drawn;
                    }
                    drawn += changedW;
                    visibleWidth += changedW;
                    continue;
                }
                scale = Font.extractIntScale(glyph);
                line.height = Math.max(line.height, font.cellHeight * (float)scale * 0.25f);
                scaleX = ch >= '\ue000' && ch < '\uf800' ? (float)scale * 0.25f * font.cellHeight / ((GlyphRegion)((Object)font.mapping.get((int)ch, (Object)font.defaultValue))).getMaxDimension() * font.inlineImageStretch : font.scaleX * (float)scale * 0.25f;
                kern = kern << 16 | ch;
                float amt = font.kerning.get(kern, 0.0f) * scaleX;
                if (ch == '\n') {
                    next = changing.pushLine();
                    glyphs.pop();
                    if (next == null) {
                        if (!this.handleEllipsis(changing)) continue block1;
                        this.calculateSize(changing);
                        return changing;
                    }
                    next.height = Math.max(next.height, font.cellHeight * (float)scale * 0.25f);
                    long[] arr3 = next.glyphs.setSize(glyphs.size - i - 1);
                    System.arraycopy(glyphs.items, i + 1, arr3, 0, glyphs.size - i - 1);
                    glyphs.truncate(i);
                    glyphs.add(Font.applyChar(glyphs.isEmpty() ? 0L : glyphs.peek(), '\n'));
                    continue block1;
                }
                tr = (GlyphRegion)((Object)font.mapping.get((int)ch));
                if (tr == null) continue;
                changedW = Font.xAdvance(font, scaleX, glyph);
                if (!(i != 0 || this.isMono || ch >= '\ue000' && ch < '\uf800')) {
                    ox = tr.offsetX;
                    ox = ox != ox ? 0.0f : (ox *= scaleX * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63)));
                    if (ox < 0.0f) {
                        changedW -= ox;
                    }
                }
                if (curly) {
                    changedW = 0.0f;
                    if (ch == '}') {
                        curly = false;
                    }
                }
                if (breakPoint >= 0) {
                    float f = breakPoint == spacingPoint ? 0.0f : changedW + amt;
                    if (visibleWidth + f > targetWidth + 1.0f) {
                        Line next3;
                        cutoff = breakPoint + 1;
                        if (changing.lines() == ln + 1) {
                            next3 = changing.pushLine();
                            glyphs.pop();
                        } else {
                            next3 = changing.getLine(ln + 1);
                        }
                        if (next3 == null) {
                            glyphs.truncate(cutoff);
                            if (!this.handleEllipsis(changing)) continue block1;
                            this.calculateSize(changing);
                            return changing;
                        }
                        next3.height = Math.max(next3.height, font.cellHeight * (float)scale * 0.25f);
                        nextSize = next3.glyphs.size;
                        arr = next3.glyphs.setSize(nextSize + glyphs.size - cutoff);
                        System.arraycopy(arr, 0, arr, glyphs.size - cutoff, nextSize);
                        System.arraycopy(glyphs.items, cutoff, arr, 0, glyphs.size - cutoff);
                        glyphs.truncate(cutoff);
                        continue block1;
                    }
                }
                if (glyph >>> 32 == 0L) {
                    breakPoint = i;
                    spacingPoint = i;
                    visibleWidth -= changedW + amt;
                } else if (Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)glyph) >= 0) {
                    breakPoint = i;
                    if (Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)glyph) >= 0) {
                        spacingPoint = i;
                        visibleWidth -= changedW + amt;
                    } else {
                        visibleWidth = drawn;
                    }
                } else {
                    visibleWidth = drawn;
                }
                drawn += changedW + amt;
                visibleWidth += changedW + amt;
            }
        }
        this.calculateSize(changing);
        return changing;
    }

    public void storeState(String name, String markup) {
        this.storedStates.put((Object)name, this.markupGlyph(0, markup));
    }

    public void storeState(String name, long formatted) {
        this.storedStates.put((Object)name, formatted & 0xFFFFFFFFFFFF0000L);
    }

    public long getStoredState(String name, long fallback) {
        return this.storedStates.get((Object)name, fallback);
    }

    public void removeStoredState(String name) {
        this.storedStates.remove((Object)name, 0L);
    }

    public void resizeDistanceField(float width, float height) {
        if (this.getDistanceField() != DistanceFieldType.STANDARD) {
            this.actualCrispness = Gdx.graphics.getBackBufferWidth() == 0 || Gdx.graphics.getBackBufferHeight() == 0 ? this.distanceFieldCrispness : this.distanceFieldCrispness * Math.max(width / (float)Gdx.graphics.getBackBufferWidth(), height / (float)Gdx.graphics.getBackBufferHeight());
        }
    }

    public void resizeDistanceField(float width, float height, Viewport viewport) {
        if (this.getDistanceField() != DistanceFieldType.STANDARD) {
            this.actualCrispness = Gdx.graphics.getBackBufferWidth() == 0 || Gdx.graphics.getBackBufferHeight() == 0 ? this.distanceFieldCrispness : this.distanceFieldCrispness * Math.max(width * (float)viewport.getScreenWidth() / (viewport.getWorldWidth() * (float)Gdx.graphics.getBackBufferWidth()), height * (float)viewport.getScreenHeight() / (viewport.getWorldHeight() * (float)Gdx.graphics.getBackBufferHeight()));
        }
    }

    public static int extractColor(long glyph) {
        return (int)(glyph >>> 32);
    }

    public static long applyColor(long glyph, int color) {
        return glyph & 0xFFFFFFFFL | (long)color << 32 & 0xFFFFFFFE00000000L;
    }

    public static long extractStyle(long glyph) {
        return glyph & 0x7E000000L;
    }

    public static long applyStyle(long glyph, long style) {
        return glyph & 0xFFFFFFFF81FFFFFFL | style & 0x7E000000L;
    }

    public static float extractScale(long glyph) {
        return (glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
    }

    public static int extractIntScale(long glyph) {
        return (int)((glyph & 0x1000000L) != 0L ? 4L : (glyph + 0x300000L >>> 20 & 0xFL) + 1L);
    }

    public static long applyScale(long glyph, float scale) {
        return glyph & 0xFFFFFFFFFE0FFFFFL | ((long)Math.floor((double)scale * 4.0 - 4.0) & 0xFL) << 20;
    }

    public static long extractMode(long glyph) {
        return (glyph & 0x1000000L) == 0L ? 0L : glyph & 0x1F00000L;
    }

    public static long applyMode(long glyph, long modeFlags) {
        return glyph & 0xFFFFFFFFFE0FFFFFL | 0x1F00000L & modeFlags;
    }

    public static char extractChar(long glyph) {
        char c = (char)glyph;
        return c == '\u0002' ? (char)'[' : (char)c;
    }

    public static long applyChar(long glyph, char c) {
        return glyph & 0xFFFFFFFFFFFF0000L | (long)c;
    }

    public void dispose() {
        if (this.shader != null) {
            this.shader.dispose();
        }
        if (this.whiteBlock != null) {
            this.whiteBlock.dispose();
        }
    }

    public static void clearStatic() {
        TypingConfig.GLOBAL_VARS.clear();
        TypingConfig.initializeGlobalVars();
    }

    public String toString() {
        return "Font '" + this.name + "' at scale " + this.scaleX + " by " + this.scaleY;
    }

    public String debugString() {
        return "Font{distanceField=" + (Object)((Object)this.getDistanceField()) + ", isMono=" + this.isMono + ", kerning=" + (this.kerning == null ? "null" : this.kerning.size + " pairs") + ", actualCrispness=" + this.actualCrispness + ", distanceFieldCrispness=" + this.distanceFieldCrispness + ", cellWidth=" + this.cellWidth + ", cellHeight=" + this.cellHeight + ", originalCellWidth=" + this.originalCellWidth + ", originalCellHeight=" + this.originalCellHeight + ", scaleX=" + this.scaleX + ", scaleY=" + this.scaleY + ", descent=" + this.descent + ", solidBlock=" + this.solidBlock + ", family=" + this.family + ", integerPosition=" + this.integerPosition + ", obliqueStrength=" + this.obliqueStrength + ", boldStrength=" + this.boldStrength + ", outlineStrength=" + this.outlineStrength + ", name='" + this.name + '\'' + ", PACKED_BLACK=" + this.PACKED_BLACK + ", PACKED_WHITE=" + this.PACKED_WHITE + ", PACKED_ERROR_COLOR=" + this.PACKED_ERROR_COLOR + ", PACKED_WARN_COLOR=" + this.PACKED_WARN_COLOR + ", PACKED_NOTE_COLOR=" + this.PACKED_NOTE_COLOR + ", xAdjust=" + this.xAdjust + ", yAdjust=" + this.yAdjust + ", widthAdjust=" + this.widthAdjust + ", heightAdjust=" + this.heightAdjust + ", underX=" + this.underX + ", underY=" + this.underY + ", underLength=" + this.underLength + ", underBreadth=" + this.underBreadth + ", strikeX=" + this.strikeX + ", strikeY=" + this.strikeY + ", strikeLength=" + this.strikeLength + ", strikeBreadth=" + this.strikeBreadth + ", fancyX=" + this.fancyX + ", fancyY=" + this.fancyY + ", inlineImageOffsetX=" + this.inlineImageOffsetX + ", inlineImageOffsetY=" + this.inlineImageOffsetY + ", inlineImageXAdvance=" + this.inlineImageXAdvance + ", inlineImageStretch=" + this.inlineImageStretch + '}';
    }

    protected void drawVertices(Batch batch, Texture texture, float[] vertices) {
        batch.draw(texture, vertices, 0, 20);
    }

    public static enum DistanceFieldType {
        STANDARD("-standard", ""),
        SDF("-sdf", " (SDF)"),
        MSDF("-msdf", " (MSDF)"),
        SDF_OUTLINE("-sdf", " (SDF Outline)");

        public static final DistanceFieldType[] ALL;
        public final String filePart;
        public final String namePart;

        private DistanceFieldType(String filePart, String namePart) {
            this.filePart = filePart;
            this.namePart = namePart;
        }

        static {
            ALL = DistanceFieldType.values();
        }
    }

    public static class GlyphRegion
    extends TextureRegion {
        public float offsetX;
        public float offsetY;
        public float xAdvance;

        public GlyphRegion(TextureRegion textureRegion) {
            this(textureRegion, 0.0f, 0.0f, textureRegion.getRegionWidth());
        }

        public GlyphRegion(TextureAtlas.AtlasRegion atlasRegion) {
            this((TextureRegion)atlasRegion, atlasRegion.offsetX, atlasRegion.offsetY, atlasRegion.originalWidth);
        }

        public GlyphRegion(TextureRegion textureRegion, float offsetX, float offsetY, float xAdvance) {
            if (textureRegion.getTexture() != null) {
                this.setRegion(textureRegion);
            }
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.xAdvance = xAdvance;
        }

        public GlyphRegion(TextureRegion textureRegion, float x, float y, float width, float height) {
            if (textureRegion.getTexture() != null) {
                this.setRegion(textureRegion, Math.round(x), Math.round(y), Math.round(width), Math.round(height));
            }
            this.offsetX = 0.0f;
            this.offsetY = 0.0f;
            this.xAdvance = width;
        }

        public GlyphRegion(GlyphRegion other) {
            if (other.getTexture() != null) {
                this.setRegion(other);
            }
            this.offsetX = other.offsetX;
            this.offsetY = other.offsetY;
            this.xAdvance = other.xAdvance;
        }

        public void flip(boolean x, boolean y) {
            super.flip(x, y);
            if (x) {
                this.offsetX = -this.offsetX;
                this.xAdvance = -this.xAdvance;
            }
            if (y) {
                this.offsetY = -this.offsetY;
            }
        }

        public float getMaxDimension() {
            return Math.max(this.getRegionWidth(), this.getRegionHeight());
        }
    }

    public static class FontFamily {
        public final Font[] connected = new Font[16];
        public final CaseInsensitiveIntMap fontAliases = new CaseInsensitiveIntMap(48);

        public FontFamily() {
        }

        public FontFamily(Font[] fonts) {
            this(fonts, 0, fonts.length);
        }

        public FontFamily(Font[] fonts, int offset, int length) {
            if (fonts == null || fonts.length == 0) {
                return;
            }
            int i = offset;
            int a = 0;
            while (i < length && i < fonts.length) {
                if (fonts[i] != null) {
                    this.connected[a & 0xF] = fonts[i];
                    if (fonts[i].name != null) {
                        this.fontAliases.put(fonts[i].name, a & 0xF);
                    }
                    this.fontAliases.put(String.valueOf(a & 0xF), a & 0xF);
                }
                ++i;
                ++a;
            }
        }

        public FontFamily(String[] aliases, Font[] fonts) {
            this(aliases, fonts, 0, Math.min(aliases.length, fonts.length));
        }

        public FontFamily(String[] aliases, Font[] fonts, int offset, int length) {
            if (aliases == null || fonts == null || (aliases.length & fonts.length) == 0) {
                return;
            }
            int i = offset;
            int a = 0;
            while (i < length && i < aliases.length && i < fonts.length) {
                if (fonts[i] != null) {
                    this.connected[a & 0xF] = fonts[i];
                    this.fontAliases.put(aliases[i], a & 0xF);
                    if (fonts[i].name != null) {
                        this.fontAliases.put(fonts[i].name, a & 0xF);
                    }
                    this.fontAliases.put(String.valueOf(a & 0xF), a & 0xF);
                }
                ++i;
                ++a;
            }
        }

        public FontFamily(OrderedMap<String, Font> map) {
            Array ks = map.orderedKeys();
            for (int i = 0; i < map.size && i < 16; ++i) {
                String name = (String)ks.get(i);
                this.connected[i] = (Font)map.get((Object)name);
                if (this.connected[i] == null) continue;
                this.fontAliases.put(name, i);
                if (this.connected[i].name != null) {
                    this.fontAliases.put(this.connected[i].name, i);
                }
                this.fontAliases.put(String.valueOf(i), i);
            }
        }

        public FontFamily(Skin skin) {
            this.initBitmapFonts(skin);
        }

        private void initBitmapFonts(Skin skin) {
            ObjectMap map = skin.getAll(BitmapFont.class);
            Array keys = map.keys().toArray();
            for (int i = 0; i < map.size && i < 16; ++i) {
                String name = (String)keys.get(i);
                BitmapFont bmf = (BitmapFont)map.get((Object)name);
                if (bmf == null) continue;
                Font font = new Font(bmf);
                font.name = name;
                font.family = this;
                this.connected[i] = font;
                this.fontAliases.put(name, i);
                if (bmf.getData().name != null) {
                    this.fontAliases.put(bmf.getData().name, i);
                }
                this.fontAliases.put(String.valueOf(i), i);
            }
        }

        public FontFamily(FWSkin skin) {
            ObjectMap map = skin.getAll(Font.class);
            if (map.isEmpty()) {
                this.initBitmapFonts(skin);
                return;
            }
            Array keys = map.keys().toArray();
            for (int i = 0; i < map.size && i < 16; ++i) {
                String name = (String)keys.get(i);
                Font font = (Font)map.get((Object)name);
                if (font == null) continue;
                font.name = name;
                font.family = this;
                this.connected[i] = font;
                this.fontAliases.put(name, i);
                if (font.name != null) {
                    this.fontAliases.put(font.name, i);
                }
                this.fontAliases.put(String.valueOf(i), i);
            }
        }

        public FontFamily(FontFamily other) {
            System.arraycopy(other.connected, 0, this.connected, 0, 16);
            this.fontAliases.putAll(other.fontAliases);
        }

        public Font get(String name) {
            if (name == null) {
                return null;
            }
            return this.connected[this.fontAliases.get(name, 0) & 0xF];
        }

        public void resizeDistanceFields(float width, float height) {
            for (Font f : this.connected) {
                if (f == null) continue;
                f.resizeDistanceField(width, height);
            }
        }

        public void resizeDistanceFields(float width, float height, Viewport viewport) {
            for (Font f : this.connected) {
                if (f == null) continue;
                f.resizeDistanceField(width, height, viewport);
            }
        }
    }

    public static class TexturelessRegion
    extends TextureRegion {
        public int x;
        public int y;
        public int width;
        public int height;

        public TexturelessRegion() {
        }

        public TexturelessRegion(Texture texture) {
            this.setRegion(0, 0, 0, 0);
        }

        public TexturelessRegion(Texture texture, int width, int height) {
            this.setRegion(0, 0, width, height);
        }

        public TexturelessRegion(Texture texture, int x, int y, int width, int height) {
            this.setRegion(x, y, width, height);
        }

        public TexturelessRegion(Texture texture, float u, float v, float u2, float v2) {
            this(texture);
        }

        public TexturelessRegion(TextureRegion region) {
            super(region);
        }

        public TexturelessRegion(TextureRegion region, int x, int y, int width, int height) {
            this.setRegion(x, y, width, height);
        }

        public void setRegion(Texture texture) {
        }

        public void setRegion(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void setRegion(float u, float v, float u2, float v2) {
        }

        public void setRegion(TextureRegion region) {
        }

        public void setRegion(TextureRegion region, int x, int y, int width, int height) {
            this.setRegion(x, y, width, height);
        }

        public int getRegionX() {
            return this.x;
        }

        public void setRegionX(int x) {
            this.x = x;
        }

        public int getRegionY() {
            return this.y;
        }

        public void setRegionY(int y) {
            this.y = y;
        }

        public int getRegionWidth() {
            return this.width;
        }

        public void setRegionWidth(int width) {
            this.width = width;
        }

        public int getRegionHeight() {
            return this.height;
        }

        public void setRegionHeight(int height) {
            this.height = height;
        }

        public void flip(boolean x, boolean y) {
            if (x) {
                this.width = -this.width;
            }
            if (y) {
                this.height = -this.height;
            }
        }

        public boolean isFlipX() {
            return this.width < 0;
        }

        public boolean isFlipY() {
            return this.height < 0;
        }
    }

    public static class TexturelessAtlasRegion
    extends TextureAtlas.AtlasRegion {
        public int x;
        public int y;
        public int width;
        public int height;

        protected TexturelessAtlasRegion(Texture texture, int x, int y, int width, int height) throws NullPointerException {
            super(null, x, y, width, height);
        }

        public static TexturelessAtlasRegion make(int x, int y, int width, int height) {
            TexturelessAtlasRegion tar = null;
            try {
                tar = new TexturelessAtlasRegion(null, x, y, width, height);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            tar.setRegion(x, y, width, height);
            return tar;
        }

        public void setRegion(Texture texture) {
        }

        public void setRegion(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void setRegion(float u, float v, float u2, float v2) {
        }

        public void setRegion(TextureRegion region) {
        }

        public void setRegion(TextureRegion region, int x, int y, int width, int height) {
            this.setRegion(x, y, width, height);
        }

        public int getRegionX() {
            return this.x;
        }

        public void setRegionX(int x) {
            this.x = x;
        }

        public int getRegionY() {
            return this.y;
        }

        public void setRegionY(int y) {
            this.y = y;
        }

        public int getRegionWidth() {
            return this.width;
        }

        public void setRegionWidth(int width) {
            this.width = width;
        }

        public int getRegionHeight() {
            return this.height;
        }

        public void setRegionHeight(int height) {
            this.height = height;
        }

        public void flip(boolean x, boolean y) {
            if (x) {
                this.width = -this.width;
            }
            if (y) {
                this.height = -this.height;
            }
        }

        public boolean isFlipX() {
            return this.width < 0;
        }

        public boolean isFlipY() {
            return this.height < 0;
        }
    }
}

