/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.LongArray;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Line;

public class Layout {
    protected Font font;
    protected final Array<Line> lines = new Array(true, 8);
    protected int maxLines = Integer.MAX_VALUE;
    protected boolean atLimit = false;
    protected String ellipsis = null;
    protected float targetWidth = 0.0f;
    protected float baseColor = Color.WHITE_FLOAT_BITS;

    public Layout() {
        this.lines.add((Object)new Line());
    }

    public Layout(Font font) {
        this.font = font;
        this.lines.add((Object)new Line());
    }

    public Layout(Layout other) {
        this.font = other.font;
        this.maxLines = other.maxLines;
        this.atLimit = other.atLimit;
        this.ellipsis = other.ellipsis;
        this.targetWidth = other.targetWidth;
        this.baseColor = other.baseColor;
        for (int i = 0; i < other.lines(); ++i) {
            Line ln = new Line();
            Line o = (Line)other.lines.get(i);
            ln.glyphs.addAll(o.glyphs);
            this.lines.add((Object)ln.size(o.width, o.height));
        }
    }

    public Layout font(Font font) {
        if (this.font == null || !this.font.equals(font)) {
            this.font = font;
            this.lines.clear();
            this.lines.add((Object)new Line());
        }
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font(font);
    }

    public Layout add(long glyph) {
        if (!this.atLimit) {
            if ((glyph & 0xFFFFL) == 10L) {
                this.pushLine();
            } else {
                ((Line)this.lines.peek()).glyphs.add(glyph);
            }
        }
        return this;
    }

    public Layout clear() {
        this.lines.clear();
        this.lines.add((Object)new Line());
        this.atLimit = false;
        return this;
    }

    public float getWidth() {
        float w = 0.0f;
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            w = Math.max(w, ((Line)this.lines.get((int)i)).width);
        }
        return w;
    }

    public float getHeight() {
        float h = 0.0f;
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            h += ((Line)this.lines.get((int)i)).height;
        }
        return h;
    }

    public int lines() {
        return this.lines.size;
    }

    public Line getLine(int i) {
        if (i >= this.lines.size) {
            return null;
        }
        return (Line)this.lines.get(i);
    }

    public Line peekLine() {
        return (Line)this.lines.peek();
    }

    public Line pushLine() {
        if (this.lines.size >= this.maxLines) {
            this.atLimit = true;
            return null;
        }
        Line line = new Line();
        Line prev = (Line)this.lines.peek();
        prev.glyphs.add(10L);
        line.height = 0.0f;
        this.lines.add((Object)line);
        return line;
    }

    public Line insertLine(int index) {
        if (this.lines.size >= this.maxLines) {
            this.atLimit = true;
            return null;
        }
        if (index < 0 || index >= this.maxLines) {
            return null;
        }
        Line line = new Line();
        Line prev = (Line)this.lines.get(index);
        prev.glyphs.add(10L);
        line.height = 0.0f;
        this.lines.insert(index + 1, (Object)line);
        return line;
    }

    public float getTargetWidth() {
        return this.targetWidth;
    }

    public Layout setTargetWidth(float targetWidth) {
        this.targetWidth = targetWidth;
        return this;
    }

    public float getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(float baseColor) {
        this.baseColor = baseColor;
    }

    public void setBaseColor(Color baseColor) {
        this.baseColor = baseColor == null ? Color.WHITE_FLOAT_BITS : baseColor.toFloatBits();
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = Math.max(1, maxLines);
    }

    public String getEllipsis() {
        return this.ellipsis;
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
    }

    public int countGlyphs() {
        int layoutSize = 0;
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            layoutSize += ((Line)this.lines.get((int)i)).glyphs.size;
        }
        return layoutSize;
    }

    public void reset() {
        this.targetWidth = 0.0f;
        this.baseColor = Color.WHITE_FLOAT_BITS;
        this.maxLines = Integer.MAX_VALUE;
        this.atLimit = false;
        this.ellipsis = null;
        this.font = null;
    }

    public StringBuilder appendIntoDirect(StringBuilder sb) {
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            Line line = (Line)this.lines.get(i);
            int ln = line.glyphs.size;
            for (int j = 0; j < ln; ++j) {
                long gl = line.glyphs.get(j);
                sb.append((char)gl);
            }
        }
        return sb;
    }

    public StringBuilder appendSubstringInto(StringBuilder sb, int start, int end) {
        start = Math.max(0, start);
        end = Math.min(Math.max(this.countGlyphs(), start), end);
        int index = start;
        sb.ensureCapacity(end - start);
        int glyphCount = 0;
        int n = this.lines.size;
        for (int i = 0; i < n && index >= 0; ++i) {
            LongArray glyphs = ((Line)this.lines.get((int)i)).glyphs;
            if (index < glyphs.size) {
                int fin = index - start - glyphCount + end;
                while (index < fin && index < glyphs.size) {
                    char c = (char)glyphs.get(index);
                    if (c >= '\ue000' && c <= '\uf800') {
                        String name = (String)this.font.namesByCharCode.get((int)c);
                        if (name != null) {
                            sb.append(name);
                        } else {
                            sb.append(c);
                        }
                    } else if (c == '\u0002') {
                        sb.append('[');
                    } else {
                        sb.append(c);
                    }
                    ++glyphCount;
                    ++index;
                }
                if (glyphCount == end - start) {
                    return sb;
                }
                index = 0;
                continue;
            }
            index -= glyphs.size;
        }
        return sb;
    }

    public StringBuilder appendInto(StringBuilder sb) {
        return this.appendSubstringInto(sb, 0, Integer.MAX_VALUE);
    }

    public String toString() {
        return this.appendInto(new StringBuilder()).toString();
    }
}

