/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class SlamEffect
extends Effect {
    private static final float DEFAULT_HANG_TIME = 1.0f;
    private static final float DEFAULT_EXTENT = 1.5f;
    private static final float DEFAULT_HEIGHT = 1.0f;
    private static final float DEFAULT_POWER = 1.0f;
    private float hangTime = 0.25f;
    private float extent = 1.0f;
    private float height = 1.0f;
    private float shakeDuration = 2.0f;
    private float shakePower = 1.0f;
    private final FloatArray lastOffsets = new FloatArray();
    private final IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public SlamEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.hangTime = this.paramAsFloat(params[0], 0.25f);
        }
        if (params.length > 1) {
            this.extent = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.height = this.paramAsFloat(params[2], 1.0f);
        }
        if (params.length > 3) {
            this.shakeDuration = this.paramAsFloat(params[3], 2.0f);
        }
        if (params.length > 4) {
            this.shakePower = this.paramAsFloat(params[4], 1.0f);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float shakeProgress;
        float realExtent = this.extent * 1.5f;
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, -this.hangTime * 1.0f + 1.0f, delta);
        float progress = MathUtils.clamp((float)(timePassed / realExtent), (float)0.0f, (float)1.0f);
        float f = shakeProgress = (progress *= progress * progress) >= 0.9f && this.shakeDuration != 0.0f ? MathUtils.clamp((float)((timePassed / realExtent - 1.0f) / this.shakeDuration), (float)0.0f, (float)1.0f) : 0.0f;
        if (shakeProgress == 0.0f) {
            Interpolation.ExpIn interpolation = Interpolation.exp10In;
            float yMove = interpolation.apply(this.label.getLineHeight(globalIndex) * this.height * 1.0f, 0.0f, progress * progress);
            this.label.offsets.incr(globalIndex << 1 | 1, yMove);
        } else {
            if (localIndex >= this.lastOffsets.size / 2) {
                this.lastOffsets.setSize(this.lastOffsets.size + 16);
            }
            float lastX = this.lastOffsets.get(localIndex * 2);
            float lastY = this.lastOffsets.get(localIndex * 2 + 1);
            float x = this.label.getLineHeight(globalIndex) * MathUtils.random((float)-0.125f, (float)0.125f);
            float y = this.label.getLineHeight(globalIndex) * MathUtils.random((float)-0.125f, (float)0.125f);
            float normalIntensity = MathUtils.clamp((float)(this.shakePower * 1.0f), (float)0.0f, (float)1.0f);
            x = Interpolation.linear.apply(lastX, x, normalIntensity);
            y = Interpolation.linear.apply(lastY, y, normalIntensity);
            float fadeout = 1.0f - Interpolation.sineOut.apply(shakeProgress);
            x *= fadeout;
            y *= fadeout;
            x = MathUtils.round((float)x);
            y = MathUtils.round((float)y);
            this.lastOffsets.set(localIndex * 2, x);
            this.lastOffsets.set(localIndex * 2 + 1, y);
            this.label.offsets.incr(globalIndex << 1, x);
            this.label.offsets.incr(globalIndex << 1 | 1, y);
        }
    }
}

