/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.utils.TimeUtils;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.NoiseUtils;

public class SputterEffect
extends Effect {
    private static final float DEFAULT_WIDEN = 5.0f;
    private static final float DEFAULT_HEIGHTEN = 5.0f;
    private static final float DEFAULT_SPEED = 0.001f;
    private float widen = 0.25f;
    private float heighten = 0.25f;
    private float speed = 1.0f;

    public SputterEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.widen = this.paramAsFloat(params[0], 0.25f);
        }
        if (params.length > 1) {
            this.heighten = this.paramAsFloat(params[1], 0.25f);
        }
        if (params.length > 2) {
            this.speed = this.paramAsFloat(params[2], 1.0f);
        }
        if (params.length > 3) {
            this.duration = this.paramAsFloat(params[3], Float.POSITIVE_INFINITY);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float h = NoiseUtils.octaveNoise1D((float)(TimeUtils.millis() & 0xFFFFFFL) * this.speed * 0.001f + (float)globalIndex * 0.1f, globalIndex);
        float v = NoiseUtils.octaveNoise1D((float)(TimeUtils.millis() & 0xFFFFFFL) * this.speed * 0.001f + (float)globalIndex * 0.1f, ~globalIndex);
        float hSharp = h * h * h * this.widen * 5.0f - v * 0.25f;
        float vSharp = v * v * v * this.heighten * 5.0f - h * 0.25f;
        float fadeout = this.calculateFadeout();
        this.label.sizing.incr(globalIndex << 1, hSharp *= fadeout);
        this.label.sizing.incr(globalIndex << 1 | 1, vSharp *= fadeout);
    }
}

