/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.utils.LongArray;

public class Line {
    public final LongArray glyphs;
    public float width;
    public float height;

    public Line() {
        this.glyphs = new LongArray(16);
    }

    public Line(int capacity) {
        this.glyphs = new LongArray(capacity);
    }

    public Line size(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public void reset() {
        this.glyphs.clear();
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public StringBuilder appendTo(StringBuilder sb) {
        sb.append("(\"");
        int n = this.glyphs.size;
        for (int i = 0; i < n; ++i) {
            sb.append((char)this.glyphs.get(i));
        }
        sb.append("\" w=").append(this.width).append(" h=").append(this.height).append(')');
        return sb;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(this.glyphs.size + 20)).toString();
    }
}

