/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.LongArray;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.Timer;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Layout;
import com.github.tommyettinger.textra.Line;
import com.github.tommyettinger.textra.Styles;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.StringUtils;
import java.util.Arrays;

public class TextraField
extends Widget
implements Disableable {
    protected static final char BACKSPACE = '\b';
    protected static final char CARRIAGE_RETURN = '\r';
    protected static final char NEWLINE = '\n';
    protected static final char TAB = '\t';
    protected static final char DELETE = '\u007f';
    public static final char BULLET = '\u2022';
    private static final Vector2 tmp1 = new Vector2();
    private static final Vector2 tmp2 = new Vector2();
    private static final Vector2 tmp3 = new Vector2();
    public static float keyRepeatInitialTime = 0.4f;
    public static float keyRepeatTime = 0.1f;
    protected String text;
    protected int cursor;
    protected boolean writeEnters;
    protected TypingLabel label;
    protected final FloatArray glyphPositions = new FloatArray();
    protected Styles.TextFieldStyle style;
    protected String messageText;
    protected boolean showingMessage = false;
    protected Clipboard clipboard;
    protected InputListener inputListener;
    @Null
    protected TextFieldListener listener;
    @Null
    protected TextFieldFilter filter;
    protected OnscreenKeyboard keyboard = new DefaultOnscreenKeyboard();
    protected boolean focusTraversal = true;
    protected boolean onlyFontChars = true;
    protected boolean disabled;
    protected int textHAlign = 8;
    protected String undoText = "";
    protected long lastChangeTime;
    protected boolean passwordMode;
    protected char passwordCharacter = (char)8226;
    protected float fontOffset;
    protected float textOffset;
    protected float renderOffset;
    protected int visibleTextStart;
    protected int visibleTextEnd;
    protected int maxLength;
    protected boolean focused;
    protected boolean cursorOn;
    protected boolean blinkEnabled = true;
    protected float blinkTime = 0.32f;
    protected final Timer.Task blinkTask = new Timer.Task(){

        public void run() {
            if (TextraField.this.getStage() == null) {
                this.cancel();
                return;
            }
            TextraField.this.cursorOn = !TextraField.this.cursorOn;
            Gdx.graphics.requestRendering();
        }
    };
    protected final KeyRepeatTask keyRepeatTask = new KeyRepeatTask();
    protected boolean programmaticChangeEvents;

    protected TextraField() {
    }

    public TextraField(@Null String text, Skin skin) {
        this(text, (Styles.TextFieldStyle)skin.get(Styles.TextFieldStyle.class));
    }

    public TextraField(@Null String text, Skin skin, Font replacementFont) {
        this(text, (Styles.TextFieldStyle)skin.get(Styles.TextFieldStyle.class), replacementFont);
    }

    public TextraField(@Null String text, Skin skin, String styleName) {
        this(text, (Styles.TextFieldStyle)skin.get(styleName, Styles.TextFieldStyle.class));
    }

    public TextraField(@Null String text, Styles.TextFieldStyle style) {
        Styles.TextFieldStyle s = new Styles.TextFieldStyle(style);
        s.font.enableSquareBrackets = false;
        s.font.omitCurlyBraces = false;
        this.setStyle(s);
        this.style.font.enableSquareBrackets = false;
        this.style.font.omitCurlyBraces = false;
        this.label = new TypingLabel("", new Styles.LabelStyle(this.style.font, style.fontColor));
        this.label.workingLayout.targetWidth = Float.MAX_VALUE;
        this.label.workingLayout.setMaxLines(1);
        this.label.setWrap(false);
        this.label.setSelectable(true);
        if (style.selection != null) {
            this.label.selectionDrawable = style.selection;
        }
        this.initialize();
        this.setText(text);
        this.label.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.label.skipToTheEnd(true, true);
        this.updateDisplayText();
    }

    public TextraField(@Null String text, Styles.TextFieldStyle style, Font replacementFont) {
        this.setStyle(style);
        replacementFont = new Font(replacementFont);
        replacementFont.enableSquareBrackets = false;
        replacementFont.omitCurlyBraces = false;
        this.label = new TypingLabel("", new Styles.LabelStyle(replacementFont, style.fontColor));
        this.label.workingLayout.targetWidth = Float.MAX_VALUE;
        this.label.workingLayout.setMaxLines(1);
        this.label.setWrap(false);
        this.label.setSelectable(true);
        if (style.selection != null) {
            this.label.selectionDrawable = style.selection;
        }
        this.initialize();
        this.setText(text);
        this.label.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.label.skipToTheEnd(true, true);
        this.updateDisplayText();
    }

    protected void setStage(Stage stage) {
        super.setStage(stage);
        this.label.setStage(stage);
    }

    protected void setParent(Group parent) {
        super.setParent(parent);
        this.label.setParent(parent);
    }

    protected void initialize() {
        this.clipboard = Gdx.app.getClipboard();
        this.inputListener = this.createInputListener();
        this.addListener((EventListener)this.inputListener);
    }

    protected InputListener createInputListener() {
        return new TextFieldClickListener();
    }

    protected boolean isWordCharacter(char c) {
        return StringUtils.WORD_CHARS.get(c);
    }

    protected boolean isWordCharacter(long glyph) {
        return StringUtils.WORD_CHARS.get((char)glyph);
    }

    protected boolean isSpaceCharacter(char c) {
        return StringUtils.SPACE_CHARS.get(c);
    }

    protected boolean isSpaceCharacter(long glyph) {
        return StringUtils.SPACE_CHARS.get((char)glyph);
    }

    protected long wordUnderCursor() {
        TypingLabel lb = this.label;
        if (this.label.overIndex == -1) {
            return lb.length();
        }
        int start = this.label.overIndex;
        int right = lb.length();
        int left = 0;
        if (start >= lb.length()) {
            left = lb.length();
            right = 0;
        } else {
            int index;
            for (index = start; index < right; ++index) {
                if (!this.isSpaceCharacter(lb.getInWorkingLayout(index))) continue;
                right = index - 1;
                break;
            }
            for (index = start - 1; index > -1; --index) {
                if (!this.isSpaceCharacter(lb.getInWorkingLayout(index))) continue;
                left = index + 1;
                break;
            }
        }
        return (long)left << 32 | (long)right & 0xFFFFFFFFL;
    }

    boolean withinMaxLength(int size) {
        return this.maxLength <= 0 || size < this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setOnlyFontChars(boolean onlyFontChars) {
        this.onlyFontChars = onlyFontChars;
    }

    public void setStyle(Styles.TextFieldStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        if (this.text != null) {
            this.updateDisplayText();
        }
        this.invalidateHierarchy();
    }

    public Styles.TextFieldStyle getStyle() {
        return this.style;
    }

    protected void calculateOffsets() {
        int end;
        float x;
        float visibleWidth = this.getWidth();
        Drawable background = this.getBackgroundDrawable();
        if (background != null) {
            visibleWidth -= background.getLeftWidth() + background.getRightWidth();
        }
        int glyphCount = this.glyphPositions.size;
        float[] glyphPositions = this.glyphPositions.items;
        this.cursor = MathUtils.clamp((int)this.cursor, (int)0, (int)(glyphCount - 1));
        float distance = glyphPositions[Math.max(0, this.cursor - 1)] + this.renderOffset;
        if (distance <= 0.0f) {
            this.renderOffset -= distance;
        } else {
            int index = Math.min(glyphCount - 1, this.cursor + 1);
            float minX = glyphPositions[index] - visibleWidth;
            if (-this.renderOffset < minX) {
                this.renderOffset = -minX;
            }
        }
        float maxOffset = 0.0f;
        float width = glyphPositions[glyphCount - 1];
        for (int i = glyphCount - 2; i >= 0 && !(width - (x = glyphPositions[i]) > visibleWidth); --i) {
            maxOffset = x;
        }
        if (-this.renderOffset > maxOffset) {
            this.renderOffset = -maxOffset;
        }
        this.visibleTextStart = 0;
        float startX = 0.0f;
        for (int i = 0; i < glyphCount; ++i) {
            if (!(glyphPositions[i] >= -this.renderOffset)) continue;
            this.visibleTextStart = i;
            startX = glyphPositions[i];
            break;
        }
        float endX = visibleWidth - this.renderOffset;
        int n = Math.min(this.label.length(), glyphCount);
        for (end = this.visibleTextStart + 1; end <= n && !(glyphPositions[end] > endX); ++end) {
        }
        this.visibleTextEnd = Math.max(0, end - 1);
        if ((this.textHAlign & 8) == 0) {
            this.textOffset = visibleWidth - glyphPositions[this.visibleTextEnd] - this.fontOffset + startX;
            if ((this.textHAlign & 1) != 0) {
                this.textOffset = Math.round(this.textOffset * 0.5f);
            }
        } else {
            this.textOffset = startX + this.renderOffset;
        }
    }

    @Null
    protected Drawable getBackgroundDrawable() {
        if (this.disabled && this.style.disabledBackground != null) {
            return this.style.disabledBackground;
        }
        if (this.style.focusedBackground != null && this.hasKeyboardFocus()) {
            return this.style.focusedBackground;
        }
        return this.style.background;
    }

    public void draw(Batch batch, float parentAlpha) {
        boolean focused = this.hasKeyboardFocus();
        if (focused != this.focused || focused && this.blinkEnabled && !this.blinkTask.isScheduled()) {
            this.focused = focused;
            this.blinkTask.cancel();
            this.cursorOn = focused;
            if (focused && this.blinkEnabled) {
                Timer.schedule((Timer.Task)this.blinkTask, (float)this.blinkTime, (float)this.blinkTime);
            } else {
                this.keyRepeatTask.cancel();
            }
        } else if (!focused) {
            this.cursorOn = false;
        }
        Font font = this.label.font;
        Color fontColor = this.disabled && this.style.disabledFontColor != null ? this.style.disabledFontColor : (focused && this.style.focusedFontColor != null ? this.style.focusedFontColor : this.style.fontColor);
        Drawable cursorPatch = this.style.cursor;
        Drawable background = this.getBackgroundDrawable();
        Color color = this.getColor();
        float x = this.getX();
        float y = this.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        float bgLeftWidth = 0.0f;
        if (background != null) {
            background.draw(batch, x, y, width, height);
            bgLeftWidth = background.getLeftWidth();
        }
        float textY = this.getTextY(font, background);
        if (this.label.length() == 0) {
            if ((!focused || this.disabled) && this.messageText != null) {
                if (this.style.messageFontColor != null) {
                    this.label.setColor(this.style.messageFontColor.r, this.style.messageFontColor.g, this.style.messageFontColor.b, this.style.messageFontColor.a * color.a);
                } else {
                    this.label.setColor(0.7f, 0.7f, 0.7f, color.a);
                }
                this.label.restart(this.messageText);
                this.label.skipToTheEnd(false, false);
                this.showingMessage = true;
                this.updateDisplayText();
                this.calculateOffsets();
                this.label.setPosition(x + bgLeftWidth + this.textOffset, y + textY);
                this.label.drawSection(batch, parentAlpha, this.visibleTextStart, this.visibleTextEnd);
            } else if (focused && !this.disabled) {
                if (this.showingMessage) {
                    this.clearMessage();
                }
                this.calculateOffsets();
            } else {
                this.calculateOffsets();
            }
        } else {
            if (fontColor != null) {
                this.label.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * color.a);
            }
            this.calculateOffsets();
            this.label.setPosition(x + bgLeftWidth + this.textOffset, y + textY);
            this.label.drawSection(batch, parentAlpha, this.visibleTextStart, this.visibleTextEnd);
        }
        if (!this.disabled && this.cursorOn && cursorPatch != null) {
            this.drawCursor(cursorPatch, batch, font, x + bgLeftWidth, y + textY);
        }
    }

    protected float getTextY(Font font, @Null Drawable background) {
        float textY = 0.0f;
        if (background != null) {
            float bottom = background.getBottomHeight();
            textY = (-background.getTopHeight() - bottom) * 0.5f + bottom;
        }
        if (font.integerPosition) {
            textY = (int)textY;
        }
        return textY;
    }

    protected void drawCursor(Drawable cursorPatch, Batch batch, Font font, float x, float y) {
        float lineHeight = this.label.getLineHeight(this.cursor);
        cursorPatch.draw(batch, x + this.textOffset + this.glyphPositions.get(this.cursor) - this.glyphPositions.get(this.visibleTextStart) + this.fontOffset, y + lineHeight, cursorPatch.getMinWidth(), lineHeight);
    }

    void updateDisplayText() {
        Font font = this.label.font;
        this.label.font.defaultValue = (Font.GlyphRegion)((Object)this.label.font.mapping.get(32));
        String newText = this.text.replace('\r', ' ').replace('\n', ' ');
        if (newText.isEmpty() && this.messageText != null) {
            newText = this.messageText;
            this.showingMessage = true;
        } else if (this.showingMessage) {
            this.showingMessage = false;
        }
        this.label.restart(newText);
        if (this.passwordMode && font.mapping.containsKey((int)this.passwordCharacter)) {
            long passwordGlyph = (long)Integer.reverseBytes(NumberUtils.floatToIntBits((float)this.label.workingLayout.baseColor)) << 32 | (long)this.passwordCharacter;
            for (int ln = 0; ln < this.label.workingLayout.lines(); ++ln) {
                Line line = this.label.workingLayout.getLine(ln);
                Arrays.fill(line.glyphs.items, 0, line.glyphs.size, passwordGlyph);
            }
        }
        this.label.skipToTheEnd(true, true);
        float end = 0.0f;
        if (this.label.workingLayout.lines.notEmpty()) {
            this.glyphPositions.clear();
            end = font.calculateXAdvances(this.label.workingLayout, this.glyphPositions);
        } else {
            this.fontOffset = 0.0f;
        }
        this.glyphPositions.add(end);
        this.visibleTextStart = Math.min(this.visibleTextStart, this.glyphPositions.size - 1);
        this.visibleTextEnd = MathUtils.clamp((int)this.visibleTextEnd, (int)this.visibleTextStart, (int)(this.glyphPositions.size - 1));
        this.label.selectionStart = Math.min(this.label.selectionStart, this.label.length());
    }

    public void copy() {
        if (this.label.hasSelection() && !this.passwordMode) {
            String toCopy = this.label.substring(Math.min(this.cursor, this.label.selectionStart), Math.max(this.cursor, this.label.selectionEnd) + 1);
            this.clipboard.setContents(toCopy);
        }
    }

    public void cut() {
        this.cut(this.programmaticChangeEvents);
    }

    protected void cut(boolean fireChangeEvent) {
        if (this.label.hasSelection() && !this.passwordMode) {
            this.copy();
            this.cursor = this.delete(fireChangeEvent);
            this.updateDisplayText();
        }
    }

    protected void paste(@Null String content, boolean fireChangeEvent) {
        if (content == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        int textLength = this.label.length();
        if (this.label.hasSelection()) {
            textLength -= Math.abs(this.cursor - this.label.selectionStart);
        }
        IntMap<Font.GlyphRegion> mapping = this.label.font.mapping;
        int n = content.length();
        for (int i = 0; i < n && this.withinMaxLength(textLength + buffer.length()); ++i) {
            char c = content.charAt(i);
            if (!this.writeEnters || c != '\n' && c != '\r') {
                if (c == '\r' || c == '\n') continue;
                if (this.onlyFontChars && !mapping.containsKey((int)c)) {
                    c = '\u200b';
                }
                if (this.filter != null && !this.filter.acceptChar(this, c)) continue;
            }
            buffer.append(c);
        }
        if (this.label.hasSelection()) {
            this.cursor = this.delete(fireChangeEvent);
        }
        if (fireChangeEvent) {
            this.changeText(this.cursor, buffer);
        } else {
            this.insert(this.cursor, buffer);
        }
        this.text = this.label.layout.toString();
        this.updateDisplayText();
        this.cursor += buffer.length();
    }

    protected boolean insert(int position, CharSequence inserting) {
        if (inserting.length() == 0) {
            return false;
        }
        if (this.showingMessage) {
            this.showingMessage = false;
            this.label.layout.clear();
        }
        this.label.insertInLayout(this.label.layout, position, inserting);
        return true;
    }

    protected String insert(int position, CharSequence text, String to) {
        if (to.isEmpty()) {
            return text.toString();
        }
        return to.substring(0, position) + text + to.substring(position);
    }

    protected int delete(boolean fireChangeEvent) {
        int from = this.label.selectionStart;
        int to = this.cursor;
        int minIndex = Math.min(from, to);
        if (this.showingMessage) {
            return minIndex;
        }
        int maxIndex = Math.max(from, to) - 1;
        LongArray glyphs = this.label.layout.getLine((int)0).glyphs;
        if (glyphs.size > 0 && minIndex <= maxIndex) {
            glyphs.removeRange(minIndex, Math.max(Math.min(glyphs.size - 1, maxIndex), 0));
        }
        if (fireChangeEvent) {
            this.changeText(this.text, this.label.layout.toString());
        } else {
            this.text = this.label.layout.toString();
        }
        this.clearSelection();
        return minIndex;
    }

    public void next(boolean up) {
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        TextraField current = this;
        Vector2 currentCoords = current.getParent().localToStageCoordinates(tmp2.set(current.getX(), current.getY()));
        Vector2 bestCoords = tmp1;
        while (true) {
            TextraField textraField;
            if ((textraField = current.findNextTextField((Array<Actor>)stage.getActors(), null, bestCoords, currentCoords, up)) == null) {
                if (up) {
                    currentCoords.set(-3.4028235E38f, -3.4028235E38f);
                } else {
                    currentCoords.set(Float.MAX_VALUE, Float.MAX_VALUE);
                }
                textraField = current.findNextTextField((Array<Actor>)stage.getActors(), null, bestCoords, currentCoords, up);
            }
            if (textraField == null) {
                Gdx.input.setOnscreenKeyboardVisible(false);
                break;
            }
            if (stage.setKeyboardFocus((Actor)textraField)) {
                textraField.selectAll();
                break;
            }
            current = textraField;
            currentCoords.set(bestCoords);
        }
    }

    @Null
    private TextraField findNextTextField(Array<Actor> actors, @Null TextraField best, Vector2 bestCoords, Vector2 currentCoords, boolean up) {
        int n = actors.size;
        for (int i = 0; i < n; ++i) {
            Actor actor = (Actor)actors.get(i);
            if (actor instanceof TextraField) {
                boolean better;
                boolean right;
                boolean below;
                TextraField textField;
                if (actor == this || (textField = (TextraField)actor).isDisabled() || !textField.focusTraversal || !textField.ascendantsVisible()) continue;
                Vector2 actorCoords = actor.getParent().localToStageCoordinates(tmp3.set(actor.getX(), actor.getY()));
                boolean bl = actorCoords.y != currentCoords.y && actorCoords.y < currentCoords.y ^ up ? true : (below = false);
                boolean bl2 = actorCoords.y == currentCoords.y && actorCoords.x > currentCoords.x ^ up ? true : (right = false);
                if (!below && !right) continue;
                boolean bl3 = best == null || actorCoords.y != bestCoords.y && actorCoords.y > bestCoords.y ^ up ? true : (better = false);
                if (!better) {
                    boolean bl4 = actorCoords.y == bestCoords.y && actorCoords.x < bestCoords.x ^ up ? true : (better = false);
                }
                if (!better) continue;
                best = (TextraField)actor;
                bestCoords.set(actorCoords);
                continue;
            }
            if (!(actor instanceof Group)) continue;
            best = this.findNextTextField((Array<Actor>)((Group)actor).getChildren(), best, bestCoords, currentCoords, up);
        }
        return best;
    }

    public InputListener getDefaultInputListener() {
        return this.inputListener;
    }

    public void setTextFieldListener(@Null TextFieldListener listener) {
        this.listener = listener;
    }

    public void setTextFieldFilter(@Null TextFieldFilter filter) {
        this.filter = filter;
    }

    @Null
    public TextFieldFilter getTextFieldFilter() {
        return this.filter;
    }

    public void setFocusTraversal(boolean focusTraversal) {
        this.focusTraversal = focusTraversal;
    }

    @Null
    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(@Null String messageText) {
        this.messageText = messageText;
    }

    public void appendText(@Null String str) {
        if (str == null) {
            str = "";
        }
        this.clearSelection();
        this.cursor = this.text.length();
        this.paste(str, this.programmaticChangeEvents);
    }

    public void setText(@Null String str) {
        if (str == null) {
            str = "";
        }
        if (str.equals(this.text)) {
            return;
        }
        this.clearSelection();
        String oldText = this.text;
        this.text = "";
        this.label.layout.getLine((int)0).glyphs.clear();
        this.cursor = 0;
        this.paste(str, false);
        if (this.programmaticChangeEvents) {
            this.changeText(oldText, this.text);
        }
        this.cursor = 0;
    }

    public String getText() {
        return this.text;
    }

    boolean changeText(String oldText, String newText) {
        if (newText.equals(oldText)) {
            return false;
        }
        this.text = newText;
        ChangeListener.ChangeEvent changeEvent = (ChangeListener.ChangeEvent)Pools.obtain(ChangeListener.ChangeEvent.class);
        boolean cancelled = this.fire((Event)changeEvent);
        if (cancelled) {
            this.text = oldText;
        }
        Pools.free((Object)changeEvent);
        return !cancelled;
    }

    boolean changeText(int position, CharSequence inserting) {
        Layout oldText = new Layout(this.label.layout);
        if (this.insert(position, inserting)) {
            return false;
        }
        ChangeListener.ChangeEvent changeEvent = (ChangeListener.ChangeEvent)Pools.obtain(ChangeListener.ChangeEvent.class);
        boolean cancelled = this.fire((Event)changeEvent);
        if (cancelled) {
            this.label.layout = oldText;
        }
        Pools.free((Object)changeEvent);
        return !cancelled;
    }

    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
    }

    public boolean getProgrammaticChangeEvents() {
        return this.programmaticChangeEvents;
    }

    public int getSelectionStart() {
        return this.label.selectionStart;
    }

    public int getSelectionEnd() {
        return this.label.selectionStart;
    }

    public String getSelection() {
        return this.label.getSelectedText();
    }

    public void setSelection(int selectionStart, int selectionEnd) {
        if (selectionStart < 0 || selectionEnd < 0) {
            this.label.selectionEnd = -1;
            this.label.selectionStart = -1;
            this.cursor = 0;
            return;
        }
        selectionStart = Math.min(this.text.length(), selectionStart);
        selectionEnd = Math.min(this.text.length(), selectionEnd);
        if (selectionEnd == selectionStart) {
            this.clearSelection();
            return;
        }
        if (selectionEnd < selectionStart) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
        }
        this.label.selectionStart = selectionStart;
        this.cursor = this.label.selectionEnd = selectionEnd;
    }

    public void selectAll() {
        this.setSelection(0, Math.max(0, this.text.length() - 1));
    }

    public void clearSelection() {
        this.label.selectionEnd = -1;
        this.label.selectionStart = -1;
    }

    public void setCursorPosition(int cursorPosition) {
        if (cursorPosition < 0) {
            throw new IllegalArgumentException("cursorPosition must be >= 0");
        }
        this.clearSelection();
        this.cursor = Math.min(cursorPosition, this.text.length());
    }

    public int getCursorPosition() {
        return this.cursor;
    }

    private void clearMessage() {
        this.showingMessage = false;
        this.text = "";
        this.label.restart("");
        this.label.skipToTheEnd(true, true);
        float end = 0.0f;
        if (this.label.workingLayout.lines.notEmpty()) {
            this.glyphPositions.clear();
            end = this.label.font.calculateXAdvances(this.label.workingLayout, this.glyphPositions);
        } else {
            this.fontOffset = 0.0f;
        }
        this.glyphPositions.add(end);
        this.visibleTextStart = 0;
        this.visibleTextEnd = 0;
        this.clearSelection();
    }

    public OnscreenKeyboard getOnscreenKeyboard() {
        return this.keyboard;
    }

    public void setOnscreenKeyboard(OnscreenKeyboard keyboard) {
        this.keyboard = keyboard;
    }

    public void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public float getPrefWidth() {
        return 150.0f;
    }

    public float getPrefHeight() {
        float topAndBottom = 0.0f;
        float minHeight = 0.0f;
        if (this.style.background != null) {
            topAndBottom = Math.max(topAndBottom, this.style.background.getBottomHeight() + this.style.background.getTopHeight());
            minHeight = Math.max(minHeight, this.style.background.getMinHeight());
        }
        if (this.style.focusedBackground != null) {
            topAndBottom = Math.max(topAndBottom, this.style.focusedBackground.getBottomHeight() + this.style.focusedBackground.getTopHeight());
            minHeight = Math.max(minHeight, this.style.focusedBackground.getMinHeight());
        }
        if (this.style.disabledBackground != null) {
            topAndBottom = Math.max(topAndBottom, this.style.disabledBackground.getBottomHeight() + this.style.disabledBackground.getTopHeight());
            minHeight = Math.max(minHeight, this.style.disabledBackground.getMinHeight());
        }
        return Math.max(topAndBottom + this.label.font.cellHeight, minHeight);
    }

    public void setAlignment(int alignment) {
        this.textHAlign = alignment;
    }

    public int getAlignment() {
        return this.textHAlign;
    }

    protected void positionChanged() {
        super.positionChanged();
        this.label.setPosition(this.getX(), this.getY());
    }

    protected void sizeChanged() {
        super.sizeChanged();
        this.label.setSize(this.getWidth(), this.getHeight());
        this.updateDisplayText();
    }

    public void act(float delta) {
        super.act(delta);
        this.label.act(delta);
    }

    public void setPasswordMode(boolean passwordMode) {
        this.passwordMode = passwordMode;
        if (this.passwordMode != this.passwordMode) {
            this.updateDisplayText();
        }
    }

    public boolean isPasswordMode() {
        return this.passwordMode;
    }

    public char getPasswordCharacter() {
        return this.passwordCharacter;
    }

    public void setPasswordCharacter(char passwordCharacter) {
        if (this.label.font.mapping.containsKey((int)passwordCharacter) && (this.passwordCharacter = passwordCharacter) != this.passwordCharacter && this.passwordMode) {
            this.updateDisplayText();
        }
    }

    public float getBlinkTime() {
        return this.blinkTime;
    }

    public void setBlinkTime(float blinkTime) {
        this.blinkTime = blinkTime;
    }

    public boolean isCursorBlinking() {
        return this.blinkEnabled;
    }

    public void setCursorBlinking(boolean blinkEnabled) {
        this.blinkEnabled = blinkEnabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    protected void moveCursor(boolean forward, boolean jump) {
        int charOffset;
        int limit = forward ? this.text.length() : 0;
        int n = charOffset = forward ? 0 : -1;
        while ((forward ? ++this.cursor < limit : --this.cursor > limit) && jump && this.continueCursor(this.cursor, charOffset)) {
        }
    }

    protected boolean continueCursor(int index, int offset) {
        char c = this.text.charAt(index + offset);
        return this.isWordCharacter(c);
    }

    public static class DefaultOnscreenKeyboard
    implements OnscreenKeyboard {
        @Override
        public void show(boolean visible) {
            Gdx.input.setOnscreenKeyboardVisible(visible);
        }
    }

    public static interface OnscreenKeyboard {
        public void show(boolean var1);
    }

    protected class KeyRepeatTask
    extends Timer.Task {
        int keycode;

        protected KeyRepeatTask() {
        }

        public void run() {
            if (TextraField.this.getStage() == null) {
                this.cancel();
                return;
            }
            TextraField.this.inputListener.keyDown(null, this.keycode);
        }
    }

    public class TextFieldClickListener
    extends ClickListener {
        public void clicked(InputEvent event, float x, float y) {
            int count;
            if (TextraField.this.showingMessage) {
                TextraField.this.clearMessage();
            }
            if ((count = this.getTapCount() & 3) == 0) {
                TextraField.this.clearSelection();
            }
            if (count == 2) {
                long pair = TextraField.this.wordUnderCursor();
                TextraField.this.setSelection((int)(pair >>> 32), (int)pair);
            }
            if (count == 3) {
                TextraField.this.selectAll();
            }
        }

        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            if (!super.touchDown(event, x, y, pointer, button)) {
                return false;
            }
            if (pointer == 0 && button != 0) {
                return false;
            }
            if (TextraField.this.disabled) {
                return true;
            }
            this.setCursorPosition(x, y);
            Stage stage = TextraField.this.getStage();
            if (stage != null) {
                stage.setKeyboardFocus((Actor)TextraField.this);
            }
            TextraField.this.keyboard.show(true);
            if (TextraField.this.showingMessage) {
                TextraField.this.clearMessage();
            }
            return true;
        }

        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            super.touchDragged(event, x, y, pointer);
            this.setCursorPosition(x, y);
        }

        protected void setCursorPosition(float x, float y) {
            TextraField.this.cursor = TextraField.this.label.overIndex == -1 ? (x < TextraField.this.label.getX() + TextraField.this.label.workingLayout.getWidth() * 0.5f ? 0 : TextraField.this.label.length()) : TextraField.this.label.overIndex;
            TextraField.this.cursorOn = TextraField.this.focused;
            if (TextraField.this.blinkEnabled) {
                TextraField.this.blinkTask.cancel();
                if (TextraField.this.focused) {
                    Timer.schedule((Timer.Task)TextraField.this.blinkTask, (float)TextraField.this.blinkTime, (float)TextraField.this.blinkTime);
                }
            }
        }

        protected void goHome(boolean jump) {
            TextraField.this.cursor = 0;
        }

        protected void goEnd(boolean jump) {
            TextraField.this.cursor = TextraField.this.text.length();
        }

        public boolean keyDown(InputEvent event, int keycode) {
            boolean handled;
            boolean repeat;
            block31: {
                boolean jump;
                block30: {
                    if (TextraField.this.disabled) {
                        return false;
                    }
                    TextraField.this.cursorOn = TextraField.this.focused;
                    if (TextraField.this.blinkEnabled) {
                        TextraField.this.blinkTask.cancel();
                        if (TextraField.this.focused) {
                            Timer.schedule((Timer.Task)TextraField.this.blinkTask, (float)TextraField.this.blinkTime, (float)TextraField.this.blinkTime);
                        }
                    }
                    if (!TextraField.this.hasKeyboardFocus()) {
                        return false;
                    }
                    repeat = false;
                    boolean ctrl = UIUtils.ctrl();
                    jump = ctrl && !TextraField.this.passwordMode;
                    handled = true;
                    if (ctrl) {
                        switch (keycode) {
                            case 50: {
                                TextraField.this.paste(TextraField.this.clipboard.getContents(), true);
                                repeat = true;
                                break;
                            }
                            case 31: 
                            case 124: {
                                TextraField.this.copy();
                                return true;
                            }
                            case 52: {
                                TextraField.this.cut(true);
                                return true;
                            }
                            case 29: {
                                TextraField.this.selectAll();
                                return true;
                            }
                            case 54: {
                                String oldText = TextraField.this.text;
                                TextraField.this.setText(TextraField.this.undoText);
                                TextraField.this.undoText = oldText;
                                TextraField.this.updateDisplayText();
                                return true;
                            }
                            default: {
                                handled = false;
                            }
                        }
                    }
                    if (!UIUtils.shift()) break block30;
                    switch (keycode) {
                        case 124: {
                            TextraField.this.paste(TextraField.this.clipboard.getContents(), true);
                            break;
                        }
                        case 112: {
                            TextraField.this.cut(true);
                        }
                    }
                    int temp = TextraField.this.cursor;
                    switch (keycode) {
                        case 21: {
                            TextraField.this.moveCursor(false, jump);
                            repeat = true;
                            handled = true;
                            break;
                        }
                        case 22: {
                            TextraField.this.moveCursor(true, jump);
                            repeat = true;
                            handled = true;
                            break;
                        }
                        case 3: {
                            this.goHome(jump);
                            handled = true;
                            break;
                        }
                        case 123: {
                            this.goEnd(jump);
                            handled = true;
                            break;
                        }
                        default: {
                            break block31;
                        }
                    }
                    if (!TextraField.this.label.hasSelection()) {
                        TextraField.this.label.selectionStart = temp;
                        TextraField.this.label.selectionEnd = TextraField.this.cursor;
                    }
                    break block31;
                }
                switch (keycode) {
                    case 21: {
                        TextraField.this.moveCursor(false, jump);
                        TextraField.this.clearSelection();
                        repeat = true;
                        handled = true;
                        break;
                    }
                    case 22: {
                        TextraField.this.moveCursor(true, jump);
                        TextraField.this.clearSelection();
                        repeat = true;
                        handled = true;
                        break;
                    }
                    case 3: {
                        this.goHome(jump);
                        TextraField.this.clearSelection();
                        handled = true;
                        break;
                    }
                    case 123: {
                        this.goEnd(jump);
                        TextraField.this.clearSelection();
                        handled = true;
                    }
                }
            }
            TextraField.this.cursor = MathUtils.clamp((int)TextraField.this.cursor, (int)0, (int)TextraField.this.text.length());
            if (repeat) {
                this.scheduleKeyRepeatTask(keycode);
            }
            return handled;
        }

        protected void scheduleKeyRepeatTask(int keycode) {
            if (!TextraField.this.keyRepeatTask.isScheduled() || TextraField.this.keyRepeatTask.keycode != keycode) {
                TextraField.this.keyRepeatTask.keycode = keycode;
                TextraField.this.keyRepeatTask.cancel();
                Timer.schedule((Timer.Task)TextraField.this.keyRepeatTask, (float)keyRepeatInitialTime, (float)keyRepeatTime);
            }
        }

        public boolean keyUp(InputEvent event, int keycode) {
            if (TextraField.this.disabled) {
                return false;
            }
            TextraField.this.keyRepeatTask.cancel();
            return true;
        }

        protected boolean checkFocusTraversal(char character) {
            return !(!TextraField.this.focusTraversal || character != '\t' && (character != '\r' && character != '\n' || !UIUtils.isAndroid && !UIUtils.isIos));
        }

        public boolean keyTyped(InputEvent event, char character) {
            if (TextraField.this.disabled) {
                return false;
            }
            switch (character) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (character >= ' ') break;
                    return false;
                }
            }
            if (!TextraField.this.hasKeyboardFocus()) {
                return false;
            }
            if (UIUtils.isMac && Gdx.input.isKeyPressed(63)) {
                return true;
            }
            if (this.checkFocusTraversal(character)) {
                TextraField.this.next(UIUtils.shift());
            } else {
                boolean remove;
                boolean backspace;
                boolean enter = character == '\r' || character == '\n';
                boolean delete = character == '\u007f';
                boolean bl = backspace = character == '\b';
                if (character == '[') {
                    character = (char)(UIUtils.shift() ? 123 : 2);
                }
                boolean add = enter ? TextraField.this.writeEnters : !TextraField.this.onlyFontChars || TextraField.this.label.font.mapping.containsKey((int)character);
                boolean bl2 = remove = backspace || delete;
                if (add || remove) {
                    String oldText = TextraField.this.text;
                    int oldCursor = TextraField.this.cursor;
                    if (remove) {
                        if (TextraField.this.label.hasSelection()) {
                            TextraField.this.cursor = TextraField.this.delete(false);
                        } else {
                            if (backspace && TextraField.this.cursor > 0) {
                                TextraField.this.text = TextraField.this.text.substring(0, TextraField.this.cursor - 1) + TextraField.this.text.substring(TextraField.this.cursor--);
                                TextraField.this.renderOffset = 0.0f;
                            }
                            if (delete && TextraField.this.cursor < TextraField.this.text.length()) {
                                TextraField.this.text = TextraField.this.text.substring(0, TextraField.this.cursor) + TextraField.this.text.substring(TextraField.this.cursor + 1);
                            }
                        }
                    }
                    if (add && !remove) {
                        if (!enter && TextraField.this.filter != null && !TextraField.this.filter.acceptChar(TextraField.this, character)) {
                            return true;
                        }
                        if (!TextraField.this.withinMaxLength(TextraField.this.text.length() - (TextraField.this.label.hasSelection() ? Math.abs(TextraField.this.cursor - TextraField.this.label.selectionStart) : 0))) {
                            return true;
                        }
                        if (TextraField.this.label.hasSelection()) {
                            TextraField.this.cursor = TextraField.this.delete(false);
                        }
                        String insertion = enter ? "\n" : String.valueOf(character);
                        TextraField.this.insert(TextraField.this.cursor++, insertion);
                        TextraField.this.text = TextraField.this.label.layout.toString();
                    }
                    if (TextraField.this.changeText(oldText, TextraField.this.text)) {
                        long time = System.currentTimeMillis();
                        if (time - 750L > TextraField.this.lastChangeTime) {
                            TextraField.this.undoText = oldText;
                        }
                        TextraField.this.lastChangeTime = time;
                        TextraField.this.updateDisplayText();
                    } else if (!TextraField.this.text.equals(oldText)) {
                        TextraField.this.cursor = oldCursor;
                    }
                }
            }
            if (TextraField.this.listener != null) {
                TextraField.this.listener.keyTyped(TextraField.this, character);
            }
            return true;
        }
    }

    public static interface TextFieldFilter {
        public boolean acceptChar(TextraField var1, char var2);

        public static class WordOnlyFilter
        implements TextFieldFilter {
            @Override
            public boolean acceptChar(TextraField textField, char c) {
                return StringUtils.WORD_CHARS.get(c);
            }
        }

        public static class LetterOnlyFilter
        implements TextFieldFilter {
            @Override
            public boolean acceptChar(TextraField textField, char c) {
                return StringUtils.LETTERS.get(c);
            }
        }

        public static class DigitsOnlyFilter
        implements TextFieldFilter {
            @Override
            public boolean acceptChar(TextraField textField, char c) {
                return c >= '0' && c <= '9';
            }
        }
    }

    public static interface TextFieldListener {
        public void keyTyped(TextraField var1, char var2);
    }
}

