/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import com.badlogic.gdx.utils.Null;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Styles;
import com.github.tommyettinger.textra.TextraLabel;

public class TextraTooltip
extends Tooltip<TextraLabel> {
    public TextraTooltip(@Null String text, Skin skin) {
        this(text, TooltipManager.getInstance(), (Styles.TextTooltipStyle)skin.get(Styles.TextTooltipStyle.class));
    }

    public TextraTooltip(@Null String text, Skin skin, String styleName) {
        this(text, TooltipManager.getInstance(), (Styles.TextTooltipStyle)skin.get(styleName, Styles.TextTooltipStyle.class));
    }

    public TextraTooltip(@Null String text, Styles.TextTooltipStyle style) {
        this(text, TooltipManager.getInstance(), style);
    }

    public TextraTooltip(@Null String text, TooltipManager manager, Skin skin) {
        this(text, manager, (Styles.TextTooltipStyle)skin.get(Styles.TextTooltipStyle.class));
    }

    public TextraTooltip(@Null String text, TooltipManager manager, Skin skin, String styleName) {
        this(text, manager, (Styles.TextTooltipStyle)skin.get(styleName, Styles.TextTooltipStyle.class));
    }

    public TextraTooltip(@Null String text, TooltipManager manager, Styles.TextTooltipStyle style) {
        this(text, manager, style, style.label.font);
    }

    public TextraTooltip(@Null String text, Skin skin, Font replacementFont) {
        this(text, TooltipManager.getInstance(), (Styles.TextTooltipStyle)skin.get(Styles.TextTooltipStyle.class), replacementFont);
    }

    public TextraTooltip(@Null String text, Skin skin, String styleName, Font replacementFont) {
        this(text, TooltipManager.getInstance(), (Styles.TextTooltipStyle)skin.get(styleName, Styles.TextTooltipStyle.class), replacementFont);
    }

    public TextraTooltip(@Null String text, Styles.TextTooltipStyle style, Font replacementFont) {
        this(text, TooltipManager.getInstance(), style, replacementFont);
    }

    public TextraTooltip(@Null String text, TooltipManager manager, Skin skin, Font replacementFont) {
        this(text, manager, (Styles.TextTooltipStyle)skin.get(Styles.TextTooltipStyle.class), replacementFont);
    }

    public TextraTooltip(@Null String text, TooltipManager manager, Skin skin, String styleName, Font replacementFont) {
        this(text, manager, (Styles.TextTooltipStyle)skin.get(styleName, Styles.TextTooltipStyle.class), replacementFont);
    }

    public TextraTooltip(@Null String text, TooltipManager manager, Styles.TextTooltipStyle style, Font replacementFont) {
        super(null, manager);
        this.setActor((Actor)this.newLabel(text, style.label, replacementFont));
        ((TextraLabel)this.getActor()).setAlignment(1);
        ((TextraLabel)this.getActor()).setWrap(true);
        this.getContainer().width(style.wrapWidth).background(style.background);
    }

    protected TextraLabel newLabel(String text, Styles.LabelStyle style) {
        return new TextraLabel(text, style);
    }

    protected TextraLabel newLabel(String text, Styles.LabelStyle style, Font font) {
        return new TextraLabel(text, style, font);
    }

    protected TextraLabel newLabel(String text, Font font) {
        return new TextraLabel(text, font);
    }

    protected TextraLabel newLabel(String text, Font font, Color color) {
        return color == null ? new TextraLabel(text, font) : new TextraLabel(text, font, color);
    }

    public void setStyle(Styles.TextTooltipStyle style) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        Container container = this.getContainer();
        ((TextraLabel)this.getActor()).setFont(style.label.font, false);
        if (style.label.fontColor != null) {
            ((TextraLabel)this.getActor()).setColor(style.label.fontColor);
        }
        ((TextraLabel)this.getActor()).getFont().regenerateLayout(((TextraLabel)this.getActor()).layout);
        ((TextraLabel)this.getActor()).setSize(((TextraLabel)this.getActor()).layout.getWidth(), ((TextraLabel)this.getActor()).layout.getHeight());
        container.setBackground(style.background);
        container.width(style.wrapWidth);
    }

    public void setStyle(Styles.TextTooltipStyle style, Font font) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        Container container = this.getContainer();
        ((TextraLabel)this.getActor()).setFont(font, false);
        ((TextraLabel)this.getActor()).layout.targetWidth = style.wrapWidth;
        if (style.label.fontColor != null) {
            ((TextraLabel)this.getActor()).setColor(style.label.fontColor);
        }
        font.regenerateLayout(((TextraLabel)this.getActor()).layout);
        ((TextraLabel)this.getActor()).setSize(((TextraLabel)this.getActor()).layout.getWidth(), ((TextraLabel)this.getActor()).layout.getHeight());
        container.setBackground(style.background);
        container.maxWidth(style.wrapWidth);
    }

    public void skipToTheEnd() {
        ((TextraLabel)this.getContainer().getActor()).skipToTheEnd();
    }
}

