/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class MeetEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 1.0f;
    private static final float DEFAULT_EXTEND = 1.0f;
    private float distance = 2.0f;
    private float extent = 1.0f;
    private boolean elastic = false;
    private boolean inside = false;
    private final IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public MeetEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 2.0f);
        }
        if (params.length > 1) {
            this.extent = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.elastic = this.paramAsBoolean(params[2]);
        }
        if (params.length > 3) {
            this.inside = this.paramAsBoolean(params[3]);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float realExtent = this.extent * (this.elastic ? 3.0f : 1.0f) * 1.0f;
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, 0.0f, delta);
        float progress = MathUtils.clamp((float)(timePassed / realExtent), (float)0.0f, (float)1.0f);
        Interpolation.SwingOut interpolation = this.elastic ? Interpolation.swingOut : Interpolation.sine;
        float interpolatedValue = interpolation.apply(1.0f, 0.0f, progress);
        int random = ((globalIndex ^ 0xDE82EF95) * 856899 ^ 0xDE82EF95) * 856899;
        float angle = (float)(random >>> 9) * 1.1920929E-7f * ((float)Math.PI * 2);
        float dist = this.label.getLineHeight(globalIndex) * this.distance * 1.0f * (this.inside ? (float)Math.sqrt((float)(((random ^ 0xDE82EF95) * 856899 ^ 0xDE82EF95) * 856899 >>> 9) * 1.1920929E-7f) : 1.0f);
        float x = MathUtils.cos((float)angle) * dist;
        float y = MathUtils.sin((float)angle) * dist;
        this.label.offsets.incr(globalIndex << 1, x * interpolatedValue);
        this.label.offsets.incr(globalIndex << 1 | 1, y * interpolatedValue);
    }
}

