/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TypingLabel;

public class SquashEffect
extends Effect {
    private static final float DEFAULT_SPEED = 0.125f;
    private float speed = 4.0f;
    private boolean elastic = false;
    private final IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public SquashEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.speed = 1.0f / this.paramAsFloat(params[0], 0.25f);
        }
        if (params.length > 1) {
            this.elastic = this.paramAsBoolean(params[1]);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float realSpeed = this.speed * (this.elastic ? 3.0f : 1.0f) * 0.125f;
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, 0.0f, delta);
        float progress = MathUtils.clamp((float)(timePassed / realSpeed), (float)0.0f, (float)1.0f);
        Font font = this.label.getFont();
        float lineHeight = this.label.getLineHeight(globalIndex);
        if (progress < 0.4f) {
            float interpolatedValue = 1.0f - Interpolation.sine.apply(progress * 2.5f) * 0.5f;
            float xOff = lineHeight * (-0.25f * (1.0f - interpolatedValue));
            this.label.offsets.incr(globalIndex << 1, xOff);
            this.label.offsets.incr(globalIndex << 1 | 1, (interpolatedValue - 1.0f) * 0.5f * lineHeight);
            this.label.sizing.incr(globalIndex << 1, 1.0f - interpolatedValue);
            this.label.sizing.incr(globalIndex << 1 | 1, interpolatedValue - 1.0f);
        } else {
            Interpolation.SwingOut interpolation = this.elastic ? Interpolation.swingOut : Interpolation.sine;
            float interpolatedValue = interpolation.apply((progress - 0.4f) * 1.666f) * 0.5f + 0.5f;
            float xOff = lineHeight * (-0.25f * (1.0f - interpolatedValue));
            this.label.offsets.incr(globalIndex << 1, xOff);
            this.label.offsets.incr(globalIndex << 1 | 1, (interpolatedValue - 1.0f) * 0.5f * lineHeight);
            this.label.sizing.incr(globalIndex << 1, 1.0f - interpolatedValue);
            this.label.sizing.incr(globalIndex << 1 | 1, interpolatedValue - 1.0f);
        }
    }
}

