/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.utils;

import com.badlogic.gdx.utils.ByteArray;
import java.util.HashMap;
import java.util.HashSet;

public final class LZBCompression {
    private LZBCompression() {
    }

    public static byte[] compressToBytes(String uncompressedStr) {
        return LZBCompression.compressToByteArray(uncompressedStr).shrink();
    }

    public static ByteArray compressToByteArray(String uncompressedStr) {
        int i;
        int value;
        if (uncompressedStr == null) {
            return null;
        }
        if (uncompressedStr.isEmpty()) {
            return new ByteArray(0);
        }
        int bitsPerChar = 8;
        HashMap<String, Integer> context_dictionary = new HashMap<String, Integer>(1024, 0.5f);
        HashSet<String> context_dictionaryToCreate = new HashSet<String>(1024, 0.5f);
        String context_w = "";
        int context_enlargeIn = 2;
        int context_dictSize = 3;
        int context_numBits = 2;
        ByteArray context_data = new ByteArray(uncompressedStr.length() >>> 1);
        byte context_data_val = 0;
        int context_data_position = 0;
        int ucl = uncompressedStr.length();
        for (int ii = 0; ii < ucl; ++ii) {
            String context_wc;
            String context_c = String.valueOf(uncompressedStr.charAt(ii));
            if (!context_dictionary.containsKey(context_c)) {
                context_dictionary.put(context_c, context_dictSize++);
                context_dictionaryToCreate.add(context_c);
            }
            if (context_dictionary.containsKey(context_wc = context_w + context_c)) {
                context_w = context_wc;
                continue;
            }
            if (context_dictionaryToCreate.contains(context_w)) {
                char c = context_w.charAt(0);
                value = c;
                if (c < '\u0100') {
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = (byte)(context_data_val << 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                            continue;
                        }
                        ++context_data_position;
                    }
                    for (i = 0; i < 8; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value & 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>>= 1;
                    }
                } else {
                    value = 1;
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value = 0;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 16; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value & 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>>= 1;
                    }
                }
                if (--context_enlargeIn == 0) {
                    context_enlargeIn = 1 << context_numBits++;
                }
                context_dictionaryToCreate.remove(context_w);
            } else {
                value = (Integer)context_dictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = (byte)(context_data_val << 1 | value & 1);
                    if (context_data_position == 7) {
                        context_data_position = 0;
                        context_data.add(context_data_val);
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>>= 1;
                }
            }
            if (--context_enlargeIn == 0) {
                context_enlargeIn = 1 << context_numBits++;
            }
            context_dictionary.put(context_wc, context_dictSize++);
            context_w = context_c;
        }
        if (!context_w.isEmpty()) {
            if (context_dictionaryToCreate.contains(context_w)) {
                if (context_w.charAt(0) < '\u0100') {
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = (byte)(context_data_val << 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                            continue;
                        }
                        ++context_data_position;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 8; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value & 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>>= 1;
                    }
                } else {
                    value = 1;
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value = 0;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 16; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value & 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>>= 1;
                    }
                }
                context_dictionaryToCreate.remove(context_w);
            } else {
                value = (Integer)context_dictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = (byte)(context_data_val << 1 | value & 1);
                    if (context_data_position == 7) {
                        context_data_position = 0;
                        context_data.add(context_data_val);
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>>= 1;
                }
            }
        }
        value = 2;
        for (i = 0; i < context_numBits; ++i) {
            context_data_val = (byte)(context_data_val << 1 | value & 1);
            if (context_data_position == 7) {
                context_data_position = 0;
                context_data.add(context_data_val);
                context_data_val = 0;
            } else {
                ++context_data_position;
            }
            value >>>= 1;
        }
        while (true) {
            context_data_val = (byte)(context_data_val << 1);
            if (context_data_position == 7) break;
            ++context_data_position;
        }
        context_data.add(context_data_val);
        return context_data;
    }
}

