/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import com.badlogic.gdx.utils.Null;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Styles;
import com.github.tommyettinger.textra.TypingLabel;

public class TypingTooltip
extends Tooltip<TypingLabel> {
    public TypingTooltip(@Null String text, Skin skin) {
        this(text, TooltipManager.getInstance(), (Styles.TextTooltipStyle)skin.get(Styles.TextTooltipStyle.class));
    }

    public TypingTooltip(@Null String text, Skin skin, String styleName) {
        this(text, TooltipManager.getInstance(), (Styles.TextTooltipStyle)skin.get(styleName, Styles.TextTooltipStyle.class));
    }

    public TypingTooltip(@Null String text, Styles.TextTooltipStyle style) {
        this(text, TooltipManager.getInstance(), style);
    }

    public TypingTooltip(@Null String text, TooltipManager manager, Skin skin) {
        this(text, manager, (Styles.TextTooltipStyle)skin.get(Styles.TextTooltipStyle.class));
    }

    public TypingTooltip(@Null String text, TooltipManager manager, Skin skin, String styleName) {
        this(text, manager, (Styles.TextTooltipStyle)skin.get(styleName, Styles.TextTooltipStyle.class));
    }

    public TypingTooltip(@Null String text, TooltipManager manager, Styles.TextTooltipStyle style) {
        this(text, manager, style, style.label.font);
    }

    public TypingTooltip(@Null String text, Skin skin, Font replacementFont) {
        this(text, TooltipManager.getInstance(), (Styles.TextTooltipStyle)skin.get(Styles.TextTooltipStyle.class), replacementFont);
    }

    public TypingTooltip(@Null String text, Skin skin, String styleName, Font replacementFont) {
        this(text, TooltipManager.getInstance(), (Styles.TextTooltipStyle)skin.get(styleName, Styles.TextTooltipStyle.class), replacementFont);
    }

    public TypingTooltip(@Null String text, Styles.TextTooltipStyle style, Font replacementFont) {
        this(text, TooltipManager.getInstance(), style, replacementFont);
    }

    public TypingTooltip(@Null String text, TooltipManager manager, Skin skin, Font replacementFont) {
        this(text, manager, (Styles.TextTooltipStyle)skin.get(Styles.TextTooltipStyle.class), replacementFont);
    }

    public TypingTooltip(@Null String text, TooltipManager manager, Skin skin, String styleName, Font replacementFont) {
        this(text, manager, (Styles.TextTooltipStyle)skin.get(styleName, Styles.TextTooltipStyle.class), replacementFont);
    }

    public TypingTooltip(@Null String text, TooltipManager manager, Styles.TextTooltipStyle style, Font replacementFont) {
        super(null, manager);
        this.setActor((Actor)this.newLabel(text, style.label, replacementFont));
        ((TypingLabel)this.getActor()).setAlignment(1);
        ((TypingLabel)this.getActor()).setWrap(true);
        this.getContainer().width(style.wrapWidth).background(style.background);
        ((TypingLabel)this.getActor()).restart();
    }

    protected TypingLabel newLabel(String text, Styles.LabelStyle style) {
        return new TypingLabel(text, style);
    }

    protected TypingLabel newLabel(String text, Styles.LabelStyle style, Font font) {
        return new TypingLabel(text, style, font);
    }

    protected TypingLabel newLabel(String text, Font font) {
        return new TypingLabel(text, font);
    }

    protected TypingLabel newLabel(String text, Font font, Color color) {
        return new TypingLabel(text, font, color);
    }

    public void setStyle(Styles.TextTooltipStyle style) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        if (style.label == null) {
            throw new NullPointerException("style.label cannot be null");
        }
        if (style.label.font == null) {
            throw new NullPointerException("style.label.font cannot be null");
        }
        this.setStyle(style, style.label.font);
    }

    public void setStyle(Styles.TextTooltipStyle style, Font font) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        Container container = this.getContainer();
        container.setBackground(style.background);
        container.maxWidth(style.wrapWidth);
        boolean wrap = style.wrapWidth != 0.0f;
        container.fill(wrap);
        ((TypingLabel)this.getActor()).setFont(font, false);
        ((TypingLabel)this.getActor()).layout.targetWidth = style.wrapWidth;
        ((TypingLabel)this.getActor()).wrap = true;
        if (style.label.fontColor != null) {
            ((TypingLabel)this.getActor()).setColor(style.label.fontColor);
        }
        font.regenerateLayout(((TypingLabel)this.getActor()).layout);
        ((TypingLabel)this.getActor()).setSize(((TypingLabel)this.getActor()).layout.getWidth(), ((TypingLabel)this.getActor()).layout.getHeight());
    }

    public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
        super.enter(event, x, y, pointer, fromActor);
        ((TypingLabel)this.getContainer().getActor()).restart();
    }
}

