/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;
import com.github.tommyettinger.textra.Font;

public final class Styles {
    private Styles() {
    }

    public static class TextFieldStyle {
        public Font font;
        public Color fontColor;
        @Null
        public Color focusedFontColor;
        @Null
        public Color disabledFontColor;
        @Null
        public Drawable background;
        @Null
        public Drawable focusedBackground;
        @Null
        public Drawable disabledBackground;
        @Null
        public Drawable cursor;
        @Null
        public Drawable selection;
        @Null
        public Color messageFontColor;

        public TextFieldStyle() {
        }

        public TextFieldStyle(Font font, Color fontColor, @Null Drawable cursor, @Null Drawable selection, @Null Drawable background) {
            this.font = new Font(font);
            this.fontColor = fontColor;
            this.cursor = cursor;
            this.selection = selection;
            this.background = background;
        }

        @Deprecated
        public TextFieldStyle(BitmapFont font, Color fontColor, @Null Drawable cursor, @Null Drawable selection, @Null Drawable background) {
            this.font = new Font(font);
            this.fontColor = fontColor;
            this.cursor = cursor;
            this.selection = selection;
            this.background = background;
        }

        public TextFieldStyle(TextFieldStyle style) {
            this.font = new Font(style.font);
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            if (style.focusedFontColor != null) {
                this.focusedFontColor = new Color(style.focusedFontColor);
            }
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
            this.background = style.background;
            this.focusedBackground = style.focusedBackground;
            this.disabledBackground = style.disabledBackground;
            this.cursor = style.cursor;
            this.selection = style.selection;
            if (style.messageFontColor != null) {
                this.messageFontColor = new Color(style.messageFontColor);
            }
        }

        @Deprecated
        public TextFieldStyle(TextField.TextFieldStyle style) {
            this.font = new Font(style.font);
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            if (style.focusedFontColor != null) {
                this.focusedFontColor = new Color(style.focusedFontColor);
            }
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
            this.background = style.background;
            this.focusedBackground = style.focusedBackground;
            this.disabledBackground = style.disabledBackground;
            this.cursor = style.cursor;
            this.selection = style.selection;
            if (style.messageFontColor != null) {
                this.messageFontColor = new Color(style.messageFontColor);
            }
        }
    }

    public static class TextTooltipStyle {
        public LabelStyle label;
        @Null
        public Drawable background;
        public float wrapWidth;

        public TextTooltipStyle() {
        }

        public TextTooltipStyle(LabelStyle style, @Null Drawable background) {
            this.label = style;
            this.background = background;
        }

        @Deprecated
        public TextTooltipStyle(Label.LabelStyle style, @Null Drawable background) {
            this.label = new LabelStyle(style);
            this.background = background;
        }

        public TextTooltipStyle(TextTooltipStyle style) {
            this.label = new LabelStyle(style.label);
            this.background = style.background;
            this.wrapWidth = style.wrapWidth;
        }

        @Deprecated
        public TextTooltipStyle(TextTooltip.TextTooltipStyle style) {
            this.label = new LabelStyle(style.label);
            this.background = style.background;
            this.wrapWidth = style.wrapWidth;
        }
    }

    public static class SelectBoxStyle {
        public Font font;
        public Color fontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        @Null
        public Color overFontColor;
        @Null
        public Color disabledFontColor;
        @Null
        public Drawable background;
        public ScrollPane.ScrollPaneStyle scrollStyle;
        public ListStyle listStyle;
        @Null
        public Drawable backgroundOver;
        @Null
        public Drawable backgroundOpen;
        @Null
        public Drawable backgroundDisabled;

        public SelectBoxStyle() {
        }

        public SelectBoxStyle(Font font, Color fontColor, @Null Drawable background, ScrollPane.ScrollPaneStyle scrollStyle, ListStyle listStyle) {
            this.font = font;
            this.fontColor.set(fontColor);
            this.background = background;
            this.scrollStyle = scrollStyle;
            this.listStyle = listStyle;
        }

        @Deprecated
        public SelectBoxStyle(BitmapFont font, Color fontColor, @Null Drawable background, ScrollPane.ScrollPaneStyle scrollStyle, List.ListStyle listStyle) {
            this.font = new Font(font);
            this.fontColor.set(fontColor);
            this.background = background;
            this.scrollStyle = scrollStyle;
            this.listStyle = new ListStyle(listStyle);
        }

        public SelectBoxStyle(SelectBoxStyle style) {
            this.font = new Font(style.font);
            this.fontColor.set(style.fontColor);
            if (style.overFontColor != null) {
                this.overFontColor = new Color(style.overFontColor);
            }
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
            this.background = style.background;
            this.scrollStyle = new ScrollPane.ScrollPaneStyle(style.scrollStyle);
            this.listStyle = new ListStyle(style.listStyle);
            this.backgroundOver = style.backgroundOver;
            this.backgroundOpen = style.backgroundOpen;
            this.backgroundDisabled = style.backgroundDisabled;
        }

        @Deprecated
        public SelectBoxStyle(SelectBox.SelectBoxStyle style) {
            this.font = new Font(style.font);
            this.fontColor.set(style.fontColor);
            if (style.overFontColor != null) {
                this.overFontColor = new Color(style.overFontColor);
            }
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
            this.background = style.background;
            this.scrollStyle = new ScrollPane.ScrollPaneStyle(style.scrollStyle);
            this.listStyle = new ListStyle(style.listStyle);
            this.backgroundOver = style.backgroundOver;
            this.backgroundOpen = style.backgroundOpen;
            this.backgroundDisabled = style.backgroundDisabled;
        }
    }

    public static class ListStyle {
        public Font font;
        public Color fontColorSelected = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Color fontColorUnselected = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Drawable selection;
        @Null
        public Drawable down;
        @Null
        public Drawable over;
        @Null
        public Drawable background;

        public ListStyle() {
        }

        public ListStyle(Font font, Color fontColorSelected, Color fontColorUnselected, Drawable selection) {
            this.font = font;
            this.fontColorSelected.set(fontColorSelected);
            this.fontColorUnselected.set(fontColorUnselected);
            this.selection = selection;
        }

        @Deprecated
        public ListStyle(BitmapFont font, Color fontColorSelected, Color fontColorUnselected, Drawable selection) {
            this.font = new Font(font);
            this.fontColorSelected.set(fontColorSelected);
            this.fontColorUnselected.set(fontColorUnselected);
            this.selection = selection;
        }

        public ListStyle(Font font, Color fontColorSelected, Color fontColorUnselected, Drawable selection, @Null Drawable down, @Null Drawable over, @Null Drawable background) {
            this.font = font;
            this.fontColorSelected.set(fontColorSelected);
            this.fontColorUnselected.set(fontColorUnselected);
            this.selection = selection;
            this.down = down;
            this.over = over;
            this.background = background;
        }

        public ListStyle(ListStyle style) {
            this.font = style.font;
            this.fontColorSelected.set(style.fontColorSelected);
            this.fontColorUnselected.set(style.fontColorUnselected);
            this.selection = style.selection;
            this.down = style.down;
            this.over = style.over;
            this.background = style.background;
        }

        @Deprecated
        public ListStyle(List.ListStyle style) {
            this.font = new Font(style.font);
            this.fontColorSelected.set(style.fontColorSelected);
            this.fontColorUnselected.set(style.fontColorUnselected);
            this.selection = style.selection;
            this.down = style.down;
            this.over = style.over;
            this.background = style.background;
        }
    }

    public static class WindowStyle {
        @Null
        public Drawable background;
        public Font titleFont;
        @Null
        public Color titleFontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        @Null
        public Drawable stageBackground;

        public WindowStyle() {
        }

        public WindowStyle(Font titleFont, Color titleFontColor, @Null Drawable background) {
            this.titleFont = titleFont;
            this.titleFontColor.set(titleFontColor);
            this.background = background;
        }

        public WindowStyle(Font titleFont, Color titleFontColor, @Null Drawable background, @Null Drawable stageBackground) {
            this.titleFont = titleFont;
            this.titleFontColor.set(titleFontColor);
            this.background = background;
            this.stageBackground = stageBackground;
        }

        @Deprecated
        public WindowStyle(BitmapFont titleFont, Color titleFontColor, @Null Drawable background) {
            this.titleFont = new Font(titleFont);
            this.titleFontColor.set(titleFontColor);
            this.background = background;
        }

        public WindowStyle(WindowStyle style) {
            this.titleFont = style.titleFont;
            if (style.titleFontColor != null) {
                this.titleFontColor = new Color(style.titleFontColor);
            }
            this.background = style.background;
            this.stageBackground = style.stageBackground;
        }

        @Deprecated
        public WindowStyle(Window.WindowStyle style) {
            this.titleFont = new Font(style.titleFont);
            if (style.titleFontColor != null) {
                this.titleFontColor = new Color(style.titleFontColor);
            }
            this.background = style.background;
            this.stageBackground = style.stageBackground;
        }
    }

    public static class CheckBoxStyle
    extends TextButtonStyle {
        public Drawable checkboxOn;
        public Drawable checkboxOff;
        @Null
        public Drawable checkboxOnOver;
        @Null
        public Drawable checkboxOver;
        @Null
        public Drawable checkboxOnDisabled;
        @Null
        public Drawable checkboxOffDisabled;

        public CheckBoxStyle() {
        }

        public CheckBoxStyle(Drawable checkboxOff, Drawable checkboxOn, Font font, @Null Color fontColor) {
            this.checkboxOff = checkboxOff;
            this.checkboxOn = checkboxOn;
            this.font = font;
            this.fontColor = fontColor;
        }

        @Deprecated
        public CheckBoxStyle(Drawable checkboxOff, Drawable checkboxOn, BitmapFont font, @Null Color fontColor) {
            this.checkboxOff = checkboxOff;
            this.checkboxOn = checkboxOn;
            this.font = new Font(font);
            this.fontColor = fontColor;
        }

        public CheckBoxStyle(CheckBoxStyle style) {
            super(style);
            this.checkboxOff = style.checkboxOff;
            this.checkboxOn = style.checkboxOn;
            this.checkboxOnOver = style.checkboxOnOver;
            this.checkboxOver = style.checkboxOver;
            this.checkboxOnDisabled = style.checkboxOnDisabled;
            this.checkboxOffDisabled = style.checkboxOffDisabled;
        }

        @Deprecated
        public CheckBoxStyle(CheckBox.CheckBoxStyle style) {
            super((TextButton.TextButtonStyle)style);
            this.checkboxOff = style.checkboxOff;
            this.checkboxOn = style.checkboxOn;
            this.checkboxOnOver = style.checkboxOnOver;
            this.checkboxOver = style.checkboxOver;
            this.checkboxOnDisabled = style.checkboxOnDisabled;
            this.checkboxOffDisabled = style.checkboxOffDisabled;
        }
    }

    public static class ImageTextButtonStyle
    extends TextButtonStyle {
        @Null
        public Drawable imageUp;
        @Null
        public Drawable imageDown;
        @Null
        public Drawable imageOver;
        @Null
        public Drawable imageDisabled;
        @Null
        public Drawable imageChecked;
        @Null
        public Drawable imageCheckedDown;
        @Null
        public Drawable imageCheckedOver;

        public ImageTextButtonStyle() {
        }

        public ImageTextButtonStyle(@Null Drawable up, @Null Drawable down, @Null Drawable checked, Font font) {
            super(up, down, checked, font);
        }

        public ImageTextButtonStyle(@Null Drawable up, @Null Drawable down, @Null Drawable checked, BitmapFont font) {
            super(up, down, checked, font);
        }

        public ImageTextButtonStyle(ImageTextButtonStyle style) {
            super(style);
            this.imageUp = style.imageUp;
            this.imageDown = style.imageDown;
            this.imageOver = style.imageOver;
            this.imageDisabled = style.imageDisabled;
            this.imageChecked = style.imageChecked;
            this.imageCheckedDown = style.imageCheckedDown;
            this.imageCheckedOver = style.imageCheckedOver;
        }

        @Deprecated
        public ImageTextButtonStyle(ImageTextButton.ImageTextButtonStyle style) {
            super((TextButton.TextButtonStyle)style);
            this.imageUp = style.imageUp;
            this.imageDown = style.imageDown;
            this.imageOver = style.imageOver;
            this.imageDisabled = style.imageDisabled;
            this.imageChecked = style.imageChecked;
            this.imageCheckedDown = style.imageCheckedDown;
            this.imageCheckedOver = style.imageCheckedOver;
        }

        public ImageTextButtonStyle(TextButtonStyle style) {
            super(style);
        }

        @Deprecated
        public ImageTextButtonStyle(TextButton.TextButtonStyle style) {
            super(style);
        }
    }

    public static class TextButtonStyle
    extends Button.ButtonStyle {
        @Null
        public Font font;
        @Null
        public Color fontColor;
        @Null
        public Color downFontColor;
        @Null
        public Color overFontColor;
        @Null
        public Color focusedFontColor;
        @Null
        public Color disabledFontColor;
        @Null
        public Color checkedFontColor;
        @Null
        public Color checkedDownFontColor;
        @Null
        public Color checkedOverFontColor;
        @Null
        public Color checkedFocusedFontColor;

        public TextButtonStyle() {
        }

        public TextButtonStyle(@Null Drawable up, @Null Drawable down, @Null Drawable checked, @Null Font font) {
            super(up, down, checked);
            this.font = font;
        }

        @Deprecated
        public TextButtonStyle(@Null Drawable up, @Null Drawable down, @Null Drawable checked, @Null BitmapFont font) {
            super(up, down, checked);
            this.font = new Font(font);
        }

        public TextButtonStyle(TextButtonStyle style) {
            super((Button.ButtonStyle)style);
            this.font = style.font;
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            if (style.downFontColor != null) {
                this.downFontColor = new Color(style.downFontColor);
            }
            if (style.overFontColor != null) {
                this.overFontColor = new Color(style.overFontColor);
            }
            if (style.focusedFontColor != null) {
                this.focusedFontColor = new Color(style.focusedFontColor);
            }
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
            if (style.checkedFontColor != null) {
                this.checkedFontColor = new Color(style.checkedFontColor);
            }
            if (style.checkedDownFontColor != null) {
                this.checkedDownFontColor = new Color(style.checkedDownFontColor);
            }
            if (style.checkedOverFontColor != null) {
                this.checkedOverFontColor = new Color(style.checkedOverFontColor);
            }
            if (style.checkedFocusedFontColor != null) {
                this.checkedFocusedFontColor = new Color(style.checkedFocusedFontColor);
            }
        }

        @Deprecated
        public TextButtonStyle(TextButton.TextButtonStyle style) {
            super((Button.ButtonStyle)style);
            this.font = new Font(style.font);
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            if (style.downFontColor != null) {
                this.downFontColor = new Color(style.downFontColor);
            }
            if (style.overFontColor != null) {
                this.overFontColor = new Color(style.overFontColor);
            }
            if (style.focusedFontColor != null) {
                this.focusedFontColor = new Color(style.focusedFontColor);
            }
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
            if (style.checkedFontColor != null) {
                this.checkedFontColor = new Color(style.checkedFontColor);
            }
            if (style.checkedDownFontColor != null) {
                this.checkedDownFontColor = new Color(style.checkedDownFontColor);
            }
            if (style.checkedOverFontColor != null) {
                this.checkedOverFontColor = new Color(style.checkedOverFontColor);
            }
            if (style.checkedFocusedFontColor != null) {
                this.checkedFocusedFontColor = new Color(style.checkedFocusedFontColor);
            }
        }
    }

    public static class LabelStyle {
        public Font font;
        @Null
        public Color fontColor;
        @Null
        public Drawable background;

        public LabelStyle() {
        }

        public LabelStyle(Font font, @Null Color fontColor) {
            this.font = font;
            this.fontColor = fontColor;
        }

        public LabelStyle(Font font, @Null Color fontColor, @Null Drawable background) {
            this.font = font;
            this.fontColor = fontColor;
            this.background = background;
        }

        @Deprecated
        public LabelStyle(BitmapFont font, @Null Color fontColor) {
            this.font = new Font(font);
            this.fontColor = fontColor;
        }

        public LabelStyle(LabelStyle style) {
            this.font = style.font;
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            this.background = style.background;
        }

        @Deprecated
        public LabelStyle(Label.LabelStyle style) {
            this.font = new Font(style.font);
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            this.background = style.background;
        }
    }
}

