/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ArraySelection;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.OrderedSet;
import com.github.tommyettinger.textra.Styles;
import com.github.tommyettinger.textra.TextraLabel;
import regexodus.Category;

public class TextraListBox<T extends TextraLabel>
extends Widget
implements Cullable {
    protected Styles.ListStyle style;
    protected final Array<T> items = new Array();
    private ArraySelection<T> selection = new ArraySelection(this.items);
    private Rectangle cullingArea;
    private float prefWidth;
    private float prefHeight;
    private int alignment = 8;
    public int pressedIndex = -1;
    public int overIndex = -1;
    private final InputListener keyListener;
    public boolean typeToSelect;

    public TextraListBox(Skin skin) {
        this((Styles.ListStyle)skin.get(Styles.ListStyle.class));
    }

    public TextraListBox(Skin skin, String styleName) {
        this((Styles.ListStyle)skin.get(styleName, Styles.ListStyle.class));
    }

    public TextraListBox(Styles.ListStyle style) {
        this.selection.setActor((Actor)this);
        this.selection.setRequired(true);
        this.setStyle(style);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.keyListener = new InputListener(){
            long typeTimeout;
            String prefix;

            public boolean keyDown(InputEvent event, int keycode) {
                if (TextraListBox.this.items.isEmpty()) {
                    return false;
                }
                switch (keycode) {
                    case 29: {
                        if (!UIUtils.ctrl() || !TextraListBox.this.selection.getMultiple()) break;
                        TextraListBox.this.selection.clear();
                        TextraListBox.this.selection.addAll(TextraListBox.this.items);
                        return true;
                    }
                    case 3: {
                        TextraListBox.this.setSelectedIndex(0);
                        return true;
                    }
                    case 123: {
                        TextraListBox.this.setSelectedIndex(TextraListBox.this.items.size - 1);
                        return true;
                    }
                    case 20: {
                        int index = TextraListBox.this.items.indexOf(TextraListBox.this.getSelected(), false) + 1;
                        if (index >= TextraListBox.this.items.size) {
                            index = 0;
                        }
                        TextraListBox.this.setSelectedIndex(index);
                        return true;
                    }
                    case 19: {
                        int index = TextraListBox.this.items.indexOf(TextraListBox.this.getSelected(), false) - 1;
                        if (index < 0) {
                            index = TextraListBox.this.items.size - 1;
                        }
                        TextraListBox.this.setSelectedIndex(index);
                        return true;
                    }
                    case 111: {
                        if (TextraListBox.this.getStage() != null) {
                            TextraListBox.this.getStage().setKeyboardFocus(null);
                        }
                        return true;
                    }
                }
                return false;
            }

            public boolean keyTyped(InputEvent event, char character) {
                if (!TextraListBox.this.typeToSelect) {
                    return false;
                }
                long time = System.currentTimeMillis();
                if (time > this.typeTimeout) {
                    this.prefix = "";
                }
                this.typeTimeout = time + 300L;
                this.prefix = this.prefix + Category.caseDown((char)character);
                int n = TextraListBox.this.items.size;
                for (int i = 0; i < n; ++i) {
                    if (!((TextraLabel)((Object)TextraListBox.this.items.get(i))).toString().toLowerCase().startsWith(this.prefix)) continue;
                    TextraListBox.this.setSelectedIndex(i);
                    break;
                }
                return false;
            }
        };
        this.addListener((EventListener)this.keyListener);
        this.addListener((EventListener)new InputListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer != 0 || button != 0) {
                    return true;
                }
                if (TextraListBox.this.selection.isDisabled()) {
                    return true;
                }
                if (TextraListBox.this.getStage() != null) {
                    TextraListBox.this.getStage().setKeyboardFocus((Actor)TextraListBox.this);
                }
                if (TextraListBox.this.items.size == 0) {
                    return true;
                }
                int index = TextraListBox.this.getItemIndexAt(y);
                if (index == -1) {
                    return true;
                }
                TextraListBox.this.selection.choose((Object)((TextraLabel)((Object)TextraListBox.this.items.get(index))));
                TextraListBox.this.pressedIndex = index;
                return true;
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer != 0 || button != 0) {
                    return;
                }
                TextraListBox.this.pressedIndex = -1;
            }

            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                TextraListBox.this.overIndex = TextraListBox.this.getItemIndexAt(y);
            }

            public boolean mouseMoved(InputEvent event, float x, float y) {
                TextraListBox.this.overIndex = TextraListBox.this.getItemIndexAt(y);
                return false;
            }

            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                if (pointer == 0) {
                    TextraListBox.this.pressedIndex = -1;
                }
                if (pointer == -1) {
                    TextraListBox.this.overIndex = -1;
                }
            }
        });
    }

    public void setStyle(Styles.ListStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.invalidateHierarchy();
    }

    public Styles.ListStyle getStyle() {
        return this.style;
    }

    public void layout() {
        Drawable selectedDrawable = this.style.selection;
        this.prefHeight = selectedDrawable.getTopHeight() + selectedDrawable.getBottomHeight();
        this.prefWidth = 0.0f;
        for (int i = 0; i < this.items.size; ++i) {
            this.prefWidth = Math.max(((TextraLabel)((Object)this.items.get(i))).getPrefWidth(), this.prefWidth);
            this.prefHeight += ((TextraLabel)((Object)this.items.get(i))).getPrefHeight();
        }
        this.prefWidth += selectedDrawable.getLeftWidth() + selectedDrawable.getRightWidth();
        Drawable background = this.style.background;
        if (background != null) {
            this.prefWidth = Math.max(this.prefWidth + background.getLeftWidth() + background.getRightWidth(), background.getMinWidth());
            this.prefHeight = Math.max(this.prefHeight + background.getTopHeight() + background.getBottomHeight(), background.getMinHeight());
        }
    }

    public void act(float delta) {
        super.act(delta);
        for (int i = 0; i < this.items.size; ++i) {
            ((TextraLabel)((Object)this.items.get(i))).act(delta);
        }
    }

    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        this.drawBackground(batch, parentAlpha);
        Drawable selectedDrawable = this.style.selection;
        Color fontColorSelected = this.style.fontColorSelected;
        Color fontColorUnselected = this.style.fontColorUnselected;
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        float x = this.getX();
        float y = this.getY();
        float width = this.getWidth();
        float itemY = this.getHeight();
        Drawable background = this.style.background;
        if (background != null) {
            float leftWidth = background.getLeftWidth();
            x += leftWidth;
            itemY -= background.getTopHeight();
            width -= leftWidth + background.getRightWidth();
        }
        float textOffsetX = selectedDrawable.getLeftWidth();
        float textOffsetY = selectedDrawable.getTopHeight();
        for (int i = 0; i < this.items.size; ++i) {
            TextraLabel item = (TextraLabel)((Object)this.items.get(i));
            float itemHeight = item.getPrefHeight();
            if (this.cullingArea == null || itemY - itemHeight <= this.cullingArea.y + this.cullingArea.height && itemY >= this.cullingArea.y) {
                item.setColor(fontColorUnselected.r, fontColorUnselected.g, fontColorUnselected.b, fontColorUnselected.a * parentAlpha);
                boolean selected = this.selection.contains((Object)item);
                Drawable drawable = null;
                if (this.pressedIndex == i && this.style.down != null) {
                    drawable = this.style.down;
                } else if (selected) {
                    drawable = selectedDrawable;
                    item.setColor(fontColorSelected.r, fontColorSelected.g, fontColorSelected.b, fontColorSelected.a * parentAlpha);
                } else if (this.overIndex == i && this.style.over != null) {
                    drawable = this.style.over;
                }
                this.drawSelection(batch, drawable, x, y + itemY - textOffsetY - itemHeight, width, itemHeight);
                item.setPosition(x + textOffsetX, y + itemY - textOffsetY - itemHeight);
                item.draw(batch, 1.0f);
                if (selected) {
                    item.setColor(fontColorUnselected.r, fontColorUnselected.g, fontColorUnselected.b, fontColorUnselected.a * parentAlpha);
                }
            } else if (itemY < this.cullingArea.y) break;
            itemY -= item.getPrefHeight();
        }
    }

    protected void drawSelection(Batch batch, @Null Drawable drawable, float x, float y, float width, float height) {
        if (drawable != null) {
            drawable.draw(batch, x, y, width, height);
        }
    }

    protected void drawBackground(Batch batch, float parentAlpha) {
        if (this.style.background != null) {
            Color color = this.getColor();
            batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
            this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public ArraySelection<T> getSelection() {
        return this.selection;
    }

    public void setSelection(ArraySelection<T> selection) {
        this.selection = selection;
    }

    @Null
    public T getSelected() {
        return (T)((Object)((TextraLabel)((Object)this.selection.first())));
    }

    public void setSelected(@Null T item) {
        if (this.items.contains(item, false)) {
            this.selection.set(item);
        } else if (this.selection.getRequired() && this.items.size > 0) {
            this.selection.set((Object)((TextraLabel)((Object)this.items.first())));
        } else {
            this.selection.clear();
        }
    }

    public int getSelectedIndex() {
        OrderedSet selected = this.selection.items();
        return selected.size == 0 ? -1 : this.items.indexOf((Object)((TextraLabel)((Object)selected.first())), false);
    }

    public void setSelectedIndex(int index) {
        if (index < -1 || index >= this.items.size) {
            throw new IllegalArgumentException("index must be >= -1 and < " + this.items.size + ": " + index);
        }
        if (index == -1) {
            this.selection.clear();
        } else {
            this.selection.set((Object)((TextraLabel)((Object)this.items.get(index))));
        }
    }

    public T getOverItem() {
        return (T)((Object)(this.overIndex == -1 ? null : (TextraLabel)((Object)this.items.get(this.overIndex))));
    }

    public T getPressedItem() {
        return (T)((Object)(this.pressedIndex == -1 ? null : (TextraLabel)((Object)this.items.get(this.pressedIndex))));
    }

    @Null
    public T getItemAt(float y) {
        int index = this.getItemIndexAt(y);
        if (index == -1) {
            return null;
        }
        return (T)((Object)((TextraLabel)((Object)this.items.get(index))));
    }

    public int getItemIndexAt(float y) {
        float h;
        float height = this.getHeight();
        Drawable background = this.style.background;
        if (background != null) {
            height -= background.getTopHeight() + background.getBottomHeight();
            y -= background.getBottomHeight();
        }
        if ((h = height - y) < 0.0f) {
            return -1;
        }
        for (int i = 0; i < this.items.size; ++i) {
            TextraLabel item = (TextraLabel)((Object)this.items.get(i));
            if (!((h -= item.getPrefHeight()) <= 0.0f)) continue;
            return i;
        }
        return -1;
    }

    public float getCumulativeHeight(int index) {
        if (index < 0 || index >= this.items.size) {
            return -3.4028235E38f;
        }
        float h = 0.0f;
        Drawable background = this.style.background;
        if (background != null) {
            h += background.getBottomHeight();
        }
        for (int i = 0; i < this.items.size; ++i) {
            TextraLabel item = (TextraLabel)((Object)this.items.get(i));
            item.font.calculateSize(item.layout);
            h += item.layout.getHeight();
            if (i < index) continue;
            return h;
        }
        return -3.4028235E38f;
    }

    @SafeVarargs
    public final void setItems(T ... newItems) {
        if (newItems == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float oldPrefWidth = this.getPrefWidth();
        float oldPrefHeight = this.getPrefHeight();
        this.items.clear();
        this.items.addAll((Object[])newItems);
        this.overIndex = -1;
        this.pressedIndex = -1;
        this.selection.validate();
        this.invalidate();
        if (oldPrefWidth != this.getPrefWidth() || oldPrefHeight != this.getPrefHeight()) {
            this.invalidateHierarchy();
        }
    }

    public void setItems(Array<? extends T> newItems) {
        if (newItems == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float oldPrefWidth = this.getPrefWidth();
        float oldPrefHeight = this.getPrefHeight();
        if (newItems != this.items) {
            this.items.clear();
            this.items.addAll(newItems);
        }
        this.overIndex = -1;
        this.pressedIndex = -1;
        this.selection.validate();
        this.invalidate();
        if (oldPrefWidth != this.getPrefWidth() || oldPrefHeight != this.getPrefHeight()) {
            this.invalidateHierarchy();
        }
    }

    public void clearItems() {
        if (this.items.size == 0) {
            return;
        }
        this.items.clear();
        this.overIndex = -1;
        this.pressedIndex = -1;
        this.selection.clear();
        this.invalidateHierarchy();
    }

    public Array<T> getItems() {
        return this.items;
    }

    public float getPrefWidth() {
        this.validate();
        return this.prefWidth;
    }

    public float getPrefHeight() {
        this.validate();
        return this.prefHeight;
    }

    public void setCullingArea(@Null Rectangle cullingArea) {
        this.cullingArea = cullingArea;
    }

    public Rectangle getCullingArea() {
        return this.cullingArea;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public boolean getTypeToSelect() {
        return this.typeToSelect;
    }

    public void setTypeToSelect(boolean typeToSelect) {
        this.typeToSelect = typeToSelect;
    }

    public InputListener getKeyListener() {
        return this.keyListener;
    }
}

