/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.compression.Lzma;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class LzmaUtils {
    private LzmaUtils() {
    }

    public static void decompress(FileHandle input, FileHandle output) {
        try (BufferedInputStream is = input.read(4096);
             OutputStream os = output.write(false);){
            Lzma.decompress((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            System.out.println("Decompression failed! " + input + " could not be decompressed to " + output + " because of the IOException: " + e.getMessage());
            throw new GdxRuntimeException("Decompression failed! " + input + " could not be decompressed to " + output, (Throwable)e);
        }
    }

    public static void compress(FileHandle input, FileHandle output) {
        try (BufferedInputStream is = input.read(4096);
             OutputStream os = output.write(false);){
            Lzma.compress((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            System.out.println("Compression failed! " + input + " could not be compressed to " + output + " because of the IOException: " + e.getMessage());
            throw new GdxRuntimeException("Compression failed! " + input + " could not be compressed to " + output, (Throwable)e);
        }
    }
}

