/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import regexodus.Category;

public class CaseInsensitiveIntMap
implements Iterable<Entry> {
    public int size;
    protected String[] keyTable;
    protected int[] valueTable;
    protected float loadFactor;
    protected int threshold;
    protected int shift;
    protected int mask;
    protected int hashSeed;
    protected transient Entries entries1;
    protected transient Entries entries2;
    protected transient Values values1;
    protected transient Values values2;
    protected transient Keys keys1;
    protected transient Keys keys2;
    private static final int[] GOOD_MULTIPLIERS = new int[]{1115175, 1327191, 1768239, 2037587, 1266181, 1535045, 1980949, 2048109, 1961757, 1621321, 1959849, 1145161, 1825821, 1641015, 1353785, 1085113, 1698711, 1353399, 1782403, 2066703, 1377005, 1670577, 1713223, 2068825, 1871705, 1135449, 1455747, 0x121771, 2082873, 1931309, 1093959, 1549441, 1335941, 1892093, 1594303, 2038049, 1894887, 1719543, 1928707, 1647721, 1525487, 1288207, 1068155, 1226059, 1205073, 1094517, 1365405, 1194551, 1438595, 1262615, 1564683, 1297861, 1446939, 2089655, 1676183, 1608697, 1096193, 1335111, 1668937, 2053599, 1215401, 1601971, 1488351, 1328503, 1310427, 2008315, 1435513, 2007891, 1899397, 1795817, 1957209, 1348525, 1567729, 1069177, 1921481, 1359355, 1917357, 1803737, 1433971, 1664275, 2061097, 1531577, 0x199109, 1633885, 1295087, 1277859, 1171003, 1473283, 1600431, 1524755, 1135911, 1399611, 1650207, 1204977, 1426455, 1490029, 1225057, 1490819, 2085551, 1461277, 2083277, 1770321, 1426397, 1680693, 1869777, 1728253, 1545933, 2068477, 1399495, 1794467, 1484999, 1333647, 1844089, 1297129, 1511843, 1716305, 1181659, 1537049, 1402925, 1670749, 1995171, 2094839, 1917433, 1246389, 1945491, 1095827, 1920863, 1136411, 1337385, 1211875, 1964723, 1431291, 1361955, 1150517, 0x11FFF3, 1457287, 2026177, 1537241, 1544005, 1708885, 1454165, 1312429, 2065277, 1931153, 1253769, 1748833, 1727905, 1659705, 1837401, 0x118555, 2052233, 1374637, 1551619, 1350433, 1419133, 1661327, 1284585, 1439001, 1552409, 1499087, 1980199, 1369877, 1966247, 1911075, 1694299, 2005405, 1479373, 1140575, 1393233, 1974225, 1876195, 1068175, 1518319, 2076957, 1165357, 1402425, 1688903, 0x1313B1, 0x111491, 1777683, 1872225, 1524309, 1810077, 1273581, 1575861, 1427997, 0x1011B1, 1920787, 1471857, 1361725, 1297939, 1617659, 1746445, 1094903, 0x1177A1, 1880145, 1759549, 0x11EE1D, 1354479, 1404313, 1149593, 1919669, 1652847, 1730161, 1816089, 1485905, 1743689, 1312199, 2065047, 2075299, 1464977, 1674141, 2076301, 0x1A1161, 1821793, 1214959, 1455515, 1353997, 0x116F1F, 1905447, 1661191, 1102341, 1442565, 1064185, 1987251, 1389031, 1581391, 1620549, 1189059, 1515543, 1501591, 1970601, 1619489, 1836053, 2080097, 1634867, 1964839, 1350817, 1405565, 2022651, 1276567, 1066767, 1654523, 1600777, 1922135, 2095417, 1708635, 2081465, 1965783, 1106291, 1936453, 1728291, 1126583, 1996327, 2095995, 1146875, 1894597, 0x194911, 1865055, 2072581, 1751011, 1778279, 1435993, 1172871, 1286279, 1303295, 1961601, 2006097, 1529899, 1742975, 1249549, 1285431, 1304297, 1336691, 1379549, 1731875, 1520437, 1382825, 1224497, 1162349, 1187979, 1435511, 1940827, 1095075, 1906371, 1930363, 1813255, 1117005, 1482647, 1939555, 1681559, 1143425, 1143213, 1899549, 1550499, 1975013, 1572641, 1818323, 1512343, 1316613, 1533177, 2086477, 1988447, 1754443, 1590565, 1473669, 1901671, 1344671, 1322317, 1984111, 1897971, 0x12BB2B, 1538669, 2061213, 1973435, 1117007, 1886871, 1735307, 2024059, 2035949, 1435879, 1208851, 2073469, 1727695, 1526509, 1297843, 1901189, 1445495, 1213341, 1692815, 1531211, 2022787, 1911017, 1690965, 1615289, 1609951, 0x11AA71, 2054969, 1449561, 1207155, 1702219, 2030341, 1626331, 1449137, 1517625, 1484807, 1498547, 1845747, 1247527, 1116467, 1919149, 1931039, 1438827, 1241129, 1904561, 2040323, 1689635, 1912963, 1366003, 1087503, 1242013, 1087291, 2091159, 1459909, 1489027, 1255235, 1820637, 1538649, 1201701, 1057113, 1674199, 1923369, 1235733, 1307921, 1180561, 1285355, 1953913, 1840293, 1678689, 1486117, 1609777, 1083745, 1238373, 1843145, 1463127, 1062605, 1884153, 1906295, 1122055, 1503499, 1269707, 1063395, 1157937, 1632285, 1859101, 1434375, 2040997, 1260457, 1882669, 1617909, 1117295, 1658705, 2036873, 1096579, 1165279, 1617273, 1950733, 1584243, 1135313, 1613149, 1269225, 1697227, 1234769, 1079929, 1899627, 1541963, 1471413, 1833991, 1263251, 1887101, 1244173, 1082569, 1085845, 1558555, 1324763, 0x117511, 1786797, 1351819, 1117815, 1672965, 1831081, 1421733, 1342569, 1156761, 1213359, 1649975, 1713549, 1997175, 1498623, 1795989, 1584551, 2076127, 1536143, 1101165, 1926201, 1649127, 1549247, 2068303, 1236291, 1483823, 1691773, 1375329, 1064011, 1653617, 1381881, 2084895, 1747947, 1919803, 1457345, 2096573, 1453433, 2013709, 2087535, 1081605, 0x11F17F, 1083031, 1060465, 1794447, 2096939, 1271479, 1692505, 1707883, 1544429, 1886503, 1992935, 1160923, 1435935, 1399629, 1274119, 1172601, 1987385, 1155373, 1241301, 1165625, 2066337, 1896119, 1945529, 1678919, 1451891, 1281673, 1848925, 1448403, 1922751, 1312217, 1915351, 1597269, 1580041, 1098717, 1103843, 1086615, 1619199, 1125561, 2079713, 1902073, 1635697, 1169751, 1889993, 1905371, 2005039, 2042771, 1437575, 1614557};

    public static int tableSize(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity must be >= 0: " + capacity);
        }
        int tableSize = 1 << -Integer.numberOfLeadingZeros(Math.max(2, (int)Math.ceil((float)capacity / loadFactor)) - 1);
        if (tableSize > 0x40000000 || tableSize < 0) {
            throw new IllegalArgumentException("The required capacity is too large: " + capacity);
        }
        return tableSize;
    }

    public CaseInsensitiveIntMap() {
        this(51, 0.6f);
    }

    public CaseInsensitiveIntMap(int initialCapacity) {
        this(initialCapacity, 0.6f);
    }

    public CaseInsensitiveIntMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = CaseInsensitiveIntMap.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Integer.numberOfLeadingZeros(this.mask) + 32;
        this.hashSeed = GOOD_MULTIPLIERS[this.shift] * GOOD_MULTIPLIERS[256 - this.shift] ^ 0x9E3779B9;
        this.keyTable = new String[tableSize];
        this.valueTable = new int[tableSize];
    }

    public CaseInsensitiveIntMap(String[] keys, int[] values) {
        this.loadFactor = 0.6f;
        int len = Math.min(keys.length, values.length);
        int tableSize = CaseInsensitiveIntMap.tableSize(len, this.loadFactor);
        this.threshold = (int)((float)tableSize * this.loadFactor);
        this.mask = tableSize - 1;
        this.shift = Integer.numberOfLeadingZeros(this.mask) + 32;
        this.hashSeed = GOOD_MULTIPLIERS[this.shift] * GOOD_MULTIPLIERS[256 - this.shift] ^ 0x9E3779B9;
        this.keyTable = new String[tableSize];
        this.valueTable = new int[tableSize];
        for (int i = 0; i < len; ++i) {
            String key = keys[i];
            if (key == null) continue;
            this.put(key, values[i]);
        }
    }

    public CaseInsensitiveIntMap(CaseInsensitiveIntMap map) {
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        this.hashSeed = map.hashSeed;
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.size = map.size;
    }

    protected int place(String item) {
        return CaseInsensitiveIntMap.hashCodeIgnoreCase(item, this.hashSeed) & this.mask;
    }

    int locateKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        String[] keyTable = this.keyTable;
        int i = this.place(key);
        String other;
        while ((other = keyTable[i]) != null) {
            if (other.equalsIgnoreCase(key)) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return ~i;
    }

    public void put(String key, int value) {
        int i = this.locateKey(key);
        if (i >= 0) {
            this.valueTable[i] = value;
            return;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
    }

    public int put(String key, int value, int defaultValue) {
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public void putAll(String[] keys, int[] values) {
        int len = Math.min(keys.length, values.length);
        this.ensureCapacity(len);
        for (int i = 0; i < len; ++i) {
            String key = keys[i];
            if (key == null) continue;
            this.put(key, values[i]);
        }
    }

    public void putAll(CaseInsensitiveIntMap map) {
        this.ensureCapacity(map.size);
        String[] keyTable = map.keyTable;
        int[] valueTable = map.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            String key = keyTable[i];
            if (key == null) continue;
            this.put(key, valueTable[i]);
        }
    }

    private void putResize(String key, int value) {
        String[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == null) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    public int get(String key, int defaultValue) {
        int i = this.locateKey(key);
        return i < 0 ? defaultValue : this.valueTable[i];
    }

    public int getAndIncrement(String key, int defaultValue, int increment) {
        int i = this.locateKey(key);
        if (i >= 0) {
            int oldValue = this.valueTable[i];
            int n = i;
            this.valueTable[n] = this.valueTable[n] + increment;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = defaultValue + increment;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public int remove(String key, int defaultValue) {
        int i = this.locateKey(key);
        if (i < 0) {
            return defaultValue;
        }
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((key = keyTable[next]) != null) {
            int placement = this.place(key);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = key;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = null;
        --this.size;
        return oldValue;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = CaseInsensitiveIntMap.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = CaseInsensitiveIntMap.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
    }

    public boolean containsValue(int value) {
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            if (keyTable[i] == null || valueTable[i] != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String key) {
        return this.locateKey(key) >= 0;
    }

    public String findKey(int value) {
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            String key = keyTable[i];
            if (key == null || valueTable[i] != value) continue;
            return key;
        }
        return null;
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = CaseInsensitiveIntMap.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Integer.numberOfLeadingZeros(this.mask) + 32;
        this.hashSeed = GOOD_MULTIPLIERS[this.shift] * GOOD_MULTIPLIERS[256 - this.shift] ^ 0x9E3779B9;
        String[] oldKeyTable = this.keyTable;
        int[] oldValueTable = this.valueTable;
        this.keyTable = new String[newSize];
        this.valueTable = new int[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                String key = oldKeyTable[i];
                if (key == null) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    public int hashCode() {
        int h = this.size;
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            String key = keyTable[i];
            if (key == null) continue;
            h += CaseInsensitiveIntMap.hashCodeIgnoreCase(key) + valueTable[i];
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CaseInsensitiveIntMap)) {
            return false;
        }
        CaseInsensitiveIntMap other = (CaseInsensitiveIntMap)obj;
        if (other.size != this.size) {
            return false;
        }
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            String key = keyTable[i];
            if (key == null) continue;
            int otherValue = other.get(key, -1);
            if (otherValue == -1 && !other.containsKey(key)) {
                return false;
            }
            if (otherValue == valueTable[i]) continue;
            return false;
        }
        return true;
    }

    public String toString(String separator) {
        return this.toString(separator, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    private String toString(String separator, boolean braces) {
        String key;
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        String[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int i = keyTable.length;
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
            break;
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            buffer.append(separator);
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    public Entries iterator() {
        return this.entries();
    }

    public Entries entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values values() {
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    public static int hashCodeIgnoreCase(CharSequence data) {
        return CaseInsensitiveIntMap.hashCodeIgnoreCase(data, 908697017);
    }

    public static int hashCodeIgnoreCase(CharSequence data, int seed) {
        int b;
        int a;
        if (data == null) {
            return 0;
        }
        int len = data.length();
        int b0 = GOOD_MULTIPLIERS[seed & 0x7F];
        int b1 = GOOD_MULTIPLIERS[(seed >>> 8 & 0x7F) + 128];
        int b2 = GOOD_MULTIPLIERS[(seed >>> 16 & 0x7F) + 256];
        int b3 = GOOD_MULTIPLIERS[(seed >>> 24 & 0x7F) + 384];
        int p = 0;
        if (len <= 2) {
            if (len == 2) {
                a = Category.caseUp((char)data.charAt(0));
                b = Category.caseUp((char)data.charAt(1));
            } else if (len == 1) {
                a = Category.caseUp((char)data.charAt(0));
                b = 0;
            } else {
                b = 0;
                a = 0;
            }
        } else {
            int i = len;
            if (i >= 6) {
                int see1 = seed;
                int see2 = seed;
                do {
                    seed = (Category.caseUp((char)data.charAt(p)) ^ b1) * (Category.caseUp((char)data.charAt(p + 1)) ^ seed);
                    seed ^= (seed << 3 | seed >>> 29) ^ (seed << 24 | seed >>> 8);
                    see1 = (Category.caseUp((char)data.charAt(p + 2)) ^ b2) * (Category.caseUp((char)data.charAt(p + 3)) ^ see1);
                    see1 ^= (see1 << 21 | see1 >>> 11) ^ (see1 << 15 | see1 >>> 19);
                    see2 = (Category.caseUp((char)data.charAt(p + 4)) ^ b3) * (Category.caseUp((char)data.charAt(p + 5)) ^ see2);
                    see2 ^= (see2 << 26 | see2 >>> 6) ^ (see2 << 7 | see2 >>> 25);
                    p += 6;
                } while ((i -= 6) >= 6);
                seed ^= see1 ^ see2;
            }
            while (i > 2) {
                seed = (Category.caseUp((char)data.charAt(p)) ^ b1) * (Category.caseUp((char)data.charAt(p + 1)) ^ seed);
                seed ^= (seed << 3 | seed >>> 29) ^ (seed << 24 | seed >>> 8);
                i -= 2;
                p += 2;
            }
            a = Category.caseUp((char)data.charAt(len - 2));
            b = Category.caseUp((char)data.charAt(len - 1));
        }
        a *= b2;
        a = (a << 24 | a >>> 8) + (b ^= seed + len) ^ b0;
        b = (b << 3 | b >>> 29) ^ a + (a << 7 | a >>> 25);
        b = (b << 29 | b >>> 3) + a ^ b1;
        a = (a << 14 | a >>> 18) ^ b + (b << 11 | b >>> 21);
        return a ^ (a << 27 | a >>> 5) ^ (a << 9 | a >>> 23);
    }

    public static class Entries
    extends MapIterator
    implements Iterable<Entry>,
    Iterator<Entry> {
        Entry entry = new Entry();

        public Entries(CaseInsensitiveIntMap map) {
            super(map);
        }

        @Override
        public Entry next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            String[] keyTable = this.map.keyTable;
            this.entry.key = keyTable[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public Entries iterator() {
            return this;
        }
    }

    public static class Values
    extends MapIterator {
        public Values(CaseInsensitiveIntMap map) {
            super(map);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return value;
        }

        public Values iterator() {
            return this;
        }

        public IntArray toArray() {
            IntArray array = new IntArray(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public IntArray toArray(IntArray array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }

    public static class Keys
    extends MapIterator
    implements Iterable<String>,
    Iterator<String> {
        public Keys(CaseInsensitiveIntMap map) {
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public String next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            String key = this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        public Keys iterator() {
            return this;
        }

        public Array<String> toArray() {
            return this.toArray((Array<String>)new Array(true, this.map.size, String.class));
        }

        public Array<String> toArray(Array<String> array) {
            while (this.hasNext) {
                array.add((Object)this.next());
            }
            return array;
        }
    }

    private static class MapIterator {
        public boolean hasNext;
        final CaseInsensitiveIntMap map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(CaseInsensitiveIntMap map) {
            this.map = map;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            String[] keyTable = this.map.keyTable;
            int n = keyTable.length;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == null) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        public void remove() {
            String key;
            int i = this.currentIndex;
            if (i < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            String[] keyTable = this.map.keyTable;
            int[] valueTable = this.map.valueTable;
            int mask = this.map.mask;
            int next = i + 1 & mask;
            while ((key = keyTable[next]) != null) {
                int placement = this.map.place(key);
                if ((next - placement & mask) > (i - placement & mask)) {
                    keyTable[i] = key;
                    valueTable[i] = valueTable[next];
                    i = next;
                }
                next = next + 1 & mask;
            }
            keyTable[i] = null;
            --this.map.size;
            if (i != this.currentIndex) {
                --this.nextIndex;
            }
            this.currentIndex = -1;
        }
    }

    public static class Entry {
        public String key;
        public int value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

