/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.IntFloatMap;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.effects.AttentionEffect;
import com.github.tommyettinger.textra.effects.BlinkEffect;
import com.github.tommyettinger.textra.effects.CannonEffect;
import com.github.tommyettinger.textra.effects.CarouselEffect;
import com.github.tommyettinger.textra.effects.CrowdEffect;
import com.github.tommyettinger.textra.effects.EaseEffect;
import com.github.tommyettinger.textra.effects.EmergeEffect;
import com.github.tommyettinger.textra.effects.FadeEffect;
import com.github.tommyettinger.textra.effects.GradientEffect;
import com.github.tommyettinger.textra.effects.HangEffect;
import com.github.tommyettinger.textra.effects.HeartbeatEffect;
import com.github.tommyettinger.textra.effects.HighlightEffect;
import com.github.tommyettinger.textra.effects.InstantEffect;
import com.github.tommyettinger.textra.effects.JoltEffect;
import com.github.tommyettinger.textra.effects.JumpEffect;
import com.github.tommyettinger.textra.effects.LinkEffect;
import com.github.tommyettinger.textra.effects.MeetEffect;
import com.github.tommyettinger.textra.effects.OceanEffect;
import com.github.tommyettinger.textra.effects.RainbowEffect;
import com.github.tommyettinger.textra.effects.RotateEffect;
import com.github.tommyettinger.textra.effects.ScaleEffect;
import com.github.tommyettinger.textra.effects.ShakeEffect;
import com.github.tommyettinger.textra.effects.ShrinkEffect;
import com.github.tommyettinger.textra.effects.SickEffect;
import com.github.tommyettinger.textra.effects.SlamEffect;
import com.github.tommyettinger.textra.effects.SlideEffect;
import com.github.tommyettinger.textra.effects.SlipEffect;
import com.github.tommyettinger.textra.effects.SpinEffect;
import com.github.tommyettinger.textra.effects.SpiralEffect;
import com.github.tommyettinger.textra.effects.SputterEffect;
import com.github.tommyettinger.textra.effects.SquashEffect;
import com.github.tommyettinger.textra.effects.StylistEffect;
import com.github.tommyettinger.textra.effects.ThinkingEffect;
import com.github.tommyettinger.textra.effects.TriggerEffect;
import com.github.tommyettinger.textra.effects.WaveEffect;
import com.github.tommyettinger.textra.effects.WindEffect;
import com.github.tommyettinger.textra.effects.ZipperEffect;

public class TypingConfig {
    public static float DEFAULT_WAIT_VALUE = 0.25f;
    public static float DEFAULT_SPEED_PER_CHAR = 0.05f;
    public static float MIN_SPEED_MODIFIER = 0.001f;
    public static float MAX_SPEED_MODIFIER = 100.0f;
    public static int CHAR_LIMIT_PER_FRAME = -1;
    public static Color DEFAULT_CLEAR_COLOR = new Color(Color.WHITE);
    public static IntFloatMap INTERVAL_MULTIPLIERS_BY_CHAR = new IntFloatMap();
    public static final ObjectMap<String, String> GLOBAL_VARS = new ObjectMap();
    static final OrderedMap<String, Effect.EffectBuilder> EFFECT_START_TOKENS = new OrderedMap();
    static final OrderedMap<String, Effect.EffectBuilder> EFFECT_END_TOKENS = new OrderedMap();
    static boolean dirtyEffectMaps = true;

    public static void initializeGlobalVars() {
        GLOBAL_VARS.put((Object)"FIRE", (Object)"{OCEAN=0.7;1.25;0.11;1.0;0.65}");
        GLOBAL_VARS.put((Object)"ENDFIRE", (Object)"{ENDOCEAN}");
        GLOBAL_VARS.put((Object)"SPUTTERINGFIRE", (Object)"{OCEAN=0.7;1.25;0.11;1.0;0.65}{SPUTTER=0.2;0.25;4;inf}");
        GLOBAL_VARS.put((Object)"ENDSPUTTERINGFIRE", (Object)"{ENDOCEAN}{ENDSPUTTER}");
        GLOBAL_VARS.put((Object)"BLIZZARD", (Object)"{GRADIENT=88ccff;eef8ff;-0.5;5}{WIND=2;4;0.25;0.1}");
        GLOBAL_VARS.put((Object)"ENDBLIZZARD", (Object)"{ENDGRADIENT}{ENDWIND}");
        GLOBAL_VARS.put((Object)"SHIVERINGBLIZZARD", (Object)"{GRADIENT=88ccff;eef8ff;-0.5;5}{WIND=2;4;0.25;0.1}{JOLT=1;0.6;inf;0.1;;}");
        GLOBAL_VARS.put((Object)"ENDSHIVERINGBLIZZARD", (Object)"{ENDGRADIENT}{ENDWIND}{ENDJOLT}");
        GLOBAL_VARS.put((Object)"ELECTRIFY", (Object)"{JOLT=1;1.2;inf;0.3;dull lavender;light butter}");
        GLOBAL_VARS.put((Object)"ENDELECTRIFY", (Object)"{ENDJOLT}");
        GLOBAL_VARS.put((Object)"ZOMBIE", (Object)"{SICK=0.4}{CROWD}{EMERGE=0.1}[dark olive sage]");
        GLOBAL_VARS.put((Object)"ENDZOMBIE", (Object)"{ENDSICK}{ENDCROWD}{ENDEMERGE}{CLEARCOLOR}");
    }

    public static void registerEffect(String startTokenName, Effect.EffectBuilder builder) {
        String name = startTokenName.toUpperCase();
        Effect.EffectBuilder b = (label, params) -> builder.produce(label, params).assignTokenName(name);
        EFFECT_START_TOKENS.put((Object)name, (Object)b);
        EFFECT_END_TOKENS.put((Object)("END" + name), (Object)b);
        dirtyEffectMaps = true;
    }

    public static void unregisterEffect(String startTokenName) {
        String name = startTokenName.toUpperCase();
        EFFECT_START_TOKENS.remove((Object)name);
        EFFECT_END_TOKENS.remove((Object)("END" + name));
        dirtyEffectMaps = true;
    }

    static {
        INTERVAL_MULTIPLIERS_BY_CHAR.put(32, 0.0f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(44, 2.0f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(59, 2.5f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(58, 2.5f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(46, 3.0f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(33, 5.0f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(63, 5.0f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put(10, 2.5f);
        TypingConfig.registerEffect("EASE", EaseEffect::new);
        TypingConfig.registerEffect("HANG", HangEffect::new);
        TypingConfig.registerEffect("JUMP", JumpEffect::new);
        TypingConfig.registerEffect("SHAKE", ShakeEffect::new);
        TypingConfig.registerEffect("SICK", SickEffect::new);
        TypingConfig.registerEffect("SLIDE", SlideEffect::new);
        TypingConfig.registerEffect("WAVE", WaveEffect::new);
        TypingConfig.registerEffect("WIND", WindEffect::new);
        TypingConfig.registerEffect("RAINBOW", RainbowEffect::new);
        TypingConfig.registerEffect("GRADIENT", GradientEffect::new);
        TypingConfig.registerEffect("FADE", FadeEffect::new);
        TypingConfig.registerEffect("BLINK", BlinkEffect::new);
        TypingConfig.registerEffect("JOLT", JoltEffect::new);
        TypingConfig.registerEffect("SPIRAL", SpiralEffect::new);
        TypingConfig.registerEffect("SPIN", SpinEffect::new);
        TypingConfig.registerEffect("CROWD", CrowdEffect::new);
        TypingConfig.registerEffect("SHRINK", ShrinkEffect::new);
        TypingConfig.registerEffect("EMERGE", EmergeEffect::new);
        TypingConfig.registerEffect("HEARTBEAT", HeartbeatEffect::new);
        TypingConfig.registerEffect("CAROUSEL", CarouselEffect::new);
        TypingConfig.registerEffect("SQUASH", SquashEffect::new);
        TypingConfig.registerEffect("SCALE", ScaleEffect::new);
        TypingConfig.registerEffect("ROTATE", RotateEffect::new);
        TypingConfig.registerEffect("HIGHLIGHT", HighlightEffect::new);
        TypingConfig.registerEffect("LINK", LinkEffect::new);
        TypingConfig.registerEffect("TRIGGER", TriggerEffect::new);
        TypingConfig.registerEffect("ATTENTION", AttentionEffect::new);
        TypingConfig.registerEffect("STYLIST", StylistEffect::new);
        TypingConfig.registerEffect("CANNON", CannonEffect::new);
        TypingConfig.registerEffect("OCEAN", OceanEffect::new);
        TypingConfig.registerEffect("SPUTTER", SputterEffect::new);
        TypingConfig.registerEffect("INSTANT", InstantEffect::new);
        TypingConfig.registerEffect("SLAM", SlamEffect::new);
        TypingConfig.registerEffect("MEET", MeetEffect::new);
        TypingConfig.registerEffect("ZIPPER", ZipperEffect::new);
        TypingConfig.registerEffect("SLIP", SlipEffect::new);
        TypingConfig.registerEffect("THINKING", ThinkingEffect::new);
        TypingConfig.initializeGlobalVars();
    }
}

