/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.github.tommyettinger.textra.BitmapFontSupport;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Styles;

public class FWSkin
extends Skin {
    public FWSkin() {
    }

    public FWSkin(FileHandle skinFile) {
        super(skinFile);
    }

    public FWSkin(FileHandle skinFile, TextureAtlas atlas) {
        super(skinFile, atlas);
    }

    public FWSkin(TextureAtlas atlas) {
        super(atlas);
    }

    protected Json getJsonLoader(final FileHandle skinFile) {
        Json json = super.getJsonLoader(skinFile);
        final FWSkin skin = this;
        json.setSerializer(Font.class, (Json.Serializer)new Json.ReadOnlySerializer<Font>(){

            public Font read(Json json, JsonValue jsonData, Class type) {
                String path = (String)json.readValue("file", String.class, jsonData);
                FileHandle fontFile = skinFile.sibling(path);
                if (!fontFile.exists()) {
                    fontFile = Gdx.files.internal(path);
                }
                if (!fontFile.exists()) {
                    throw new SerializationException("Font file not found: " + fontFile);
                }
                path = fontFile.path();
                boolean lzb = "dat".equalsIgnoreCase(fontFile.extension());
                boolean js = "json".equalsIgnoreCase(fontFile.extension());
                boolean ubj = "ubj".equalsIgnoreCase(fontFile.extension());
                boolean jslzma = fontFile.name().length() > 10 && ".json.lzma".equalsIgnoreCase(fontFile.name().substring(fontFile.name().length() - 10));
                boolean ublzma = fontFile.name().length() > 9 && ".ubj.lzma".equalsIgnoreCase(fontFile.name().substring(fontFile.name().length() - 9));
                boolean fw = lzb || js || ubj || jslzma || ublzma;
                float scaledSize = ((Float)json.readValue("scaledSize", Float.TYPE, (Object)Float.valueOf(-1.0f), jsonData)).floatValue();
                float xAdjust = ((Float)json.readValue("xAdjust", Float.TYPE, (Object)Float.valueOf(0.0f), jsonData)).floatValue();
                float yAdjust = ((Float)json.readValue("yAdjust", Float.TYPE, (Object)Float.valueOf(0.0f), jsonData)).floatValue();
                float widthAdjust = ((Float)json.readValue("widthAdjust", Float.TYPE, (Object)Float.valueOf(0.0f), jsonData)).floatValue();
                float heightAdjust = ((Float)json.readValue("heightAdjust", Float.TYPE, (Object)Float.valueOf(0.0f), jsonData)).floatValue();
                Boolean useIntegerPositions = (Boolean)json.readValue("useIntegerPositions", Boolean.class, (Object)false, jsonData);
                Boolean makeGridGlyphs = (Boolean)json.readValue("makeGridGlyphs", Boolean.class, (Object)true, jsonData);
                int nameStart = Math.max(path.lastIndexOf(47), path.lastIndexOf(92)) + 1;
                String regionName = path.substring(nameStart, Math.max(0, path.indexOf(46, nameStart)));
                try {
                    Font font;
                    Array regions = skin.getRegions(regionName);
                    if (regions != null && regions.notEmpty()) {
                        font = fw ? new Font(fontFile, (TextureRegion)regions.first(), xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs, true) : new Font(path, (Array<TextureRegion>)regions, Font.DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs);
                    } else {
                        TextureRegion region = (TextureRegion)skin.optional(regionName, TextureRegion.class);
                        if (region != null) {
                            font = fw ? new Font(fontFile, region, xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs, true) : new Font(path, region, Font.DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs);
                        } else {
                            FileHandle imageFile = Gdx.files.internal(path).sibling(regionName + ".png");
                            if (imageFile.exists()) {
                                font = fw ? new Font(fontFile, new TextureRegion(new Texture(imageFile)), xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs, true) : new Font(path, new TextureRegion(new Texture(imageFile)), Font.DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs);
                            } else {
                                if (fw) {
                                    throw new RuntimeException("Missing image file or TextureRegion.");
                                }
                                font = new Font(path);
                            }
                        }
                    }
                    font.useIntegerPositions(useIntegerPositions);
                    if (scaledSize != -1.0f) {
                        font.scaleHeightTo(scaledSize);
                    }
                    return font;
                }
                catch (RuntimeException ex) {
                    throw new SerializationException("Error loading Font: " + path, (Throwable)ex);
                }
            }
        });
        json.setSerializer(BitmapFont.class, (Json.Serializer)new Json.ReadOnlySerializer<BitmapFont>(){

            public BitmapFont read(Json json, JsonValue jsonData, Class type) {
                String path = (String)json.readValue("file", String.class, jsonData);
                FileHandle fontFile = skinFile.sibling(path);
                if (!fontFile.exists()) {
                    fontFile = Gdx.files.internal(path);
                }
                if (!fontFile.exists()) {
                    throw new SerializationException("Font file not found: " + fontFile);
                }
                boolean lzb = "dat".equalsIgnoreCase(fontFile.extension());
                boolean js = "json".equalsIgnoreCase(fontFile.extension());
                boolean ubj = "ubj".equalsIgnoreCase(fontFile.extension());
                boolean jslzma = fontFile.name().length() > 10 && ".json.lzma".equalsIgnoreCase(fontFile.name().substring(fontFile.name().length() - 10));
                boolean ublzma = fontFile.name().length() > 9 && ".ubj.lzma".equalsIgnoreCase(fontFile.name().substring(fontFile.name().length() - 9));
                boolean fw = lzb || js || ubj || jslzma || ublzma;
                float scaledSize = ((Float)json.readValue("scaledSize", Float.TYPE, (Object)Float.valueOf(-1.0f), jsonData)).floatValue();
                Boolean flip = (Boolean)json.readValue("flip", Boolean.class, (Object)false, jsonData);
                Boolean markupEnabled = (Boolean)json.readValue("markupEnabled", Boolean.class, (Object)true, jsonData);
                Boolean useIntegerPositions = (Boolean)json.readValue("useIntegerPositions", Boolean.class, (Object)false, jsonData);
                float xAdjust = ((Float)json.readValue("xAdjust", Float.TYPE, (Object)Float.valueOf(0.0f), jsonData)).floatValue();
                float yAdjust = ((Float)json.readValue("yAdjust", Float.TYPE, (Object)Float.valueOf(0.0f), jsonData)).floatValue();
                float widthAdjust = ((Float)json.readValue("widthAdjust", Float.TYPE, (Object)Float.valueOf(0.0f), jsonData)).floatValue();
                float heightAdjust = ((Float)json.readValue("heightAdjust", Float.TYPE, (Object)Float.valueOf(0.0f), jsonData)).floatValue();
                Boolean makeGridGlyphs = (Boolean)json.readValue("makeGridGlyphs", Boolean.class, (Object)true, jsonData);
                int nameStart = Math.max(path.lastIndexOf(47), path.lastIndexOf(92)) + 1;
                String regionName = path.substring(nameStart, Math.max(0, path.indexOf(46, nameStart)));
                try {
                    Font font;
                    BitmapFont bitmapFont;
                    Array regions = skin.getRegions(regionName);
                    if (regions != null && regions.notEmpty()) {
                        if (fw) {
                            bitmapFont = BitmapFontSupport.loadStructuredJson(fontFile, (TextureRegion)regions.first(), (boolean)flip);
                            font = new Font(fontFile, (TextureRegion)regions.first(), xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs, true);
                        } else {
                            bitmapFont = new BitmapFont(new BitmapFont.BitmapFontData(fontFile, flip.booleanValue()), regions, true);
                            font = new Font(fontFile, (Array<TextureRegion>)regions, Font.DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs);
                        }
                    } else {
                        TextureRegion region = (TextureRegion)skin.optional(regionName, TextureRegion.class);
                        if (region != null) {
                            if (fw) {
                                bitmapFont = BitmapFontSupport.loadStructuredJson(fontFile, region, (boolean)flip);
                                font = new Font(fontFile, region, xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs, true);
                            } else {
                                bitmapFont = new BitmapFont(fontFile, region, flip.booleanValue());
                                font = new Font(fontFile, region, Font.DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs);
                            }
                        } else {
                            FileHandle imageFile = fontFile.sibling(regionName + ".png");
                            if (imageFile.exists()) {
                                region = new TextureRegion(new Texture(imageFile));
                                if (fw) {
                                    bitmapFont = BitmapFontSupport.loadStructuredJson(fontFile, region, (boolean)flip);
                                    font = new Font(fontFile, region, xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs, true);
                                } else {
                                    bitmapFont = new BitmapFont(fontFile, region, flip.booleanValue());
                                    font = new Font(path, region, Font.DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust, (boolean)makeGridGlyphs);
                                }
                            } else {
                                if (fw) {
                                    throw new RuntimeException("Missing image file or TextureRegion.");
                                }
                                bitmapFont = new BitmapFont(fontFile, flip.booleanValue());
                                font = new Font(path);
                            }
                        }
                    }
                    bitmapFont.getData().markupEnabled = markupEnabled;
                    bitmapFont.setUseIntegerPositions(useIntegerPositions.booleanValue());
                    font.useIntegerPositions(useIntegerPositions);
                    if (scaledSize != -1.0f) {
                        bitmapFont.getData().setScale(scaledSize / bitmapFont.getCapHeight());
                        font.scaleHeightTo(scaledSize * bitmapFont.getLineHeight() / bitmapFont.getCapHeight());
                    }
                    skin.add(jsonData.name, (Object)font, Font.class);
                    return bitmapFont;
                }
                catch (RuntimeException ex) {
                    throw new SerializationException("Error loading BitmapFont: " + fontFile, (Throwable)ex);
                }
            }
        });
        json.setSerializer(Label.LabelStyle.class, (Json.Serializer)new Json.ReadOnlySerializer<Label.LabelStyle>(){

            public Label.LabelStyle read(Json json, JsonValue jsonData, Class type) {
                Label.LabelStyle s2d = new Label.LabelStyle();
                json.readFields((Object)s2d, jsonData);
                Styles.LabelStyle stt = new Styles.LabelStyle((Font)skin.get((String)json.readValue("font", String.class, (Object)"default-font", jsonData), Font.class), s2d.fontColor);
                stt.background = s2d.background;
                skin.add(jsonData.name, (Object)stt, Styles.LabelStyle.class);
                return s2d;
            }
        });
        json.setSerializer(TextButton.TextButtonStyle.class, (Json.Serializer)new Json.ReadOnlySerializer<TextButton.TextButtonStyle>(){

            public TextButton.TextButtonStyle read(Json json, JsonValue jsonData, Class type) {
                TextButton.TextButtonStyle s2d = new TextButton.TextButtonStyle();
                json.readFields((Object)s2d, jsonData);
                Styles.TextButtonStyle stt = new Styles.TextButtonStyle(s2d.up, s2d.down, s2d.checked, (Font)skin.get((String)json.readValue("font", String.class, (Object)"default-font", jsonData), Font.class));
                if (s2d.fontColor != null) {
                    stt.fontColor = new Color(s2d.fontColor);
                }
                if (s2d.downFontColor != null) {
                    stt.downFontColor = new Color(s2d.downFontColor);
                }
                if (s2d.overFontColor != null) {
                    stt.overFontColor = new Color(s2d.overFontColor);
                }
                if (s2d.focusedFontColor != null) {
                    stt.focusedFontColor = new Color(s2d.focusedFontColor);
                }
                if (s2d.disabledFontColor != null) {
                    stt.disabledFontColor = new Color(s2d.disabledFontColor);
                }
                if (s2d.checkedFontColor != null) {
                    stt.checkedFontColor = new Color(s2d.checkedFontColor);
                }
                if (s2d.checkedDownFontColor != null) {
                    stt.checkedDownFontColor = new Color(s2d.checkedDownFontColor);
                }
                if (s2d.checkedOverFontColor != null) {
                    stt.checkedOverFontColor = new Color(s2d.checkedOverFontColor);
                }
                if (s2d.checkedFocusedFontColor != null) {
                    stt.checkedFocusedFontColor = new Color(s2d.checkedFocusedFontColor);
                }
                skin.add(jsonData.name, (Object)stt, Styles.TextButtonStyle.class);
                return s2d;
            }
        });
        json.setSerializer(ImageTextButton.ImageTextButtonStyle.class, (Json.Serializer)new Json.ReadOnlySerializer<ImageTextButton.ImageTextButtonStyle>(){

            public ImageTextButton.ImageTextButtonStyle read(Json json, JsonValue jsonData, Class type) {
                ImageTextButton.ImageTextButtonStyle s2d = new ImageTextButton.ImageTextButtonStyle();
                json.readFields((Object)s2d, jsonData);
                Styles.ImageTextButtonStyle stt = new Styles.ImageTextButtonStyle(s2d.up, s2d.down, s2d.checked, (Font)skin.get((String)json.readValue("font", String.class, (Object)"default-font", jsonData), Font.class));
                if (s2d.fontColor != null) {
                    stt.fontColor = new Color(s2d.fontColor);
                }
                if (s2d.downFontColor != null) {
                    stt.downFontColor = new Color(s2d.downFontColor);
                }
                if (s2d.overFontColor != null) {
                    stt.overFontColor = new Color(s2d.overFontColor);
                }
                if (s2d.focusedFontColor != null) {
                    stt.focusedFontColor = new Color(s2d.focusedFontColor);
                }
                if (s2d.disabledFontColor != null) {
                    stt.disabledFontColor = new Color(s2d.disabledFontColor);
                }
                if (s2d.checkedFontColor != null) {
                    stt.checkedFontColor = new Color(s2d.checkedFontColor);
                }
                if (s2d.checkedDownFontColor != null) {
                    stt.checkedDownFontColor = new Color(s2d.checkedDownFontColor);
                }
                if (s2d.checkedOverFontColor != null) {
                    stt.checkedOverFontColor = new Color(s2d.checkedOverFontColor);
                }
                if (s2d.checkedFocusedFontColor != null) {
                    stt.checkedFocusedFontColor = new Color(s2d.checkedFocusedFontColor);
                }
                stt.imageUp = s2d.imageUp;
                stt.imageDown = s2d.imageDown;
                stt.imageOver = s2d.imageOver;
                stt.imageDisabled = s2d.imageDisabled;
                stt.imageChecked = s2d.imageChecked;
                stt.imageCheckedDown = s2d.imageCheckedDown;
                stt.imageCheckedOver = s2d.imageCheckedOver;
                skin.add(jsonData.name, (Object)stt, Styles.ImageTextButtonStyle.class);
                return s2d;
            }
        });
        json.setSerializer(CheckBox.CheckBoxStyle.class, (Json.Serializer)new Json.ReadOnlySerializer<CheckBox.CheckBoxStyle>(){

            public CheckBox.CheckBoxStyle read(Json json, JsonValue jsonData, Class type) {
                CheckBox.CheckBoxStyle s2d = new CheckBox.CheckBoxStyle();
                json.readFields((Object)s2d, jsonData);
                Styles.CheckBoxStyle stt = new Styles.CheckBoxStyle(s2d.checkboxOff, s2d.checkboxOn, (Font)skin.get((String)json.readValue("font", String.class, (Object)"default-font", jsonData), Font.class), s2d.fontColor);
                if (s2d.fontColor != null) {
                    stt.fontColor = new Color(s2d.fontColor);
                }
                if (s2d.downFontColor != null) {
                    stt.downFontColor = new Color(s2d.downFontColor);
                }
                if (s2d.overFontColor != null) {
                    stt.overFontColor = new Color(s2d.overFontColor);
                }
                if (s2d.focusedFontColor != null) {
                    stt.focusedFontColor = new Color(s2d.focusedFontColor);
                }
                if (s2d.disabledFontColor != null) {
                    stt.disabledFontColor = new Color(s2d.disabledFontColor);
                }
                if (s2d.checkedFontColor != null) {
                    stt.checkedFontColor = new Color(s2d.checkedFontColor);
                }
                if (s2d.checkedDownFontColor != null) {
                    stt.checkedDownFontColor = new Color(s2d.checkedDownFontColor);
                }
                if (s2d.checkedOverFontColor != null) {
                    stt.checkedOverFontColor = new Color(s2d.checkedOverFontColor);
                }
                if (s2d.checkedFocusedFontColor != null) {
                    stt.checkedFocusedFontColor = new Color(s2d.checkedFocusedFontColor);
                }
                stt.checkboxOnOver = s2d.checkboxOnOver;
                stt.checkboxOver = s2d.checkboxOver;
                stt.checkboxOnDisabled = s2d.checkboxOnDisabled;
                stt.checkboxOffDisabled = s2d.checkboxOffDisabled;
                skin.add(jsonData.name, (Object)stt, Styles.CheckBoxStyle.class);
                return s2d;
            }
        });
        json.setSerializer(Window.WindowStyle.class, (Json.Serializer)new Json.ReadOnlySerializer<Window.WindowStyle>(){

            public Window.WindowStyle read(Json json, JsonValue jsonData, Class type) {
                Window.WindowStyle s2d = new Window.WindowStyle();
                json.readFields((Object)s2d, jsonData);
                Styles.WindowStyle stt = new Styles.WindowStyle((Font)skin.get((String)json.readValue("titleFont", String.class, (Object)"default-font", jsonData), Font.class), s2d.titleFontColor, s2d.background);
                stt.stageBackground = s2d.stageBackground;
                skin.add(jsonData.name, (Object)stt, Styles.WindowStyle.class);
                return s2d;
            }
        });
        json.setSerializer(TextTooltip.TextTooltipStyle.class, (Json.Serializer)new Json.ReadOnlySerializer<TextTooltip.TextTooltipStyle>(){

            public TextTooltip.TextTooltipStyle read(Json json, JsonValue jsonData, Class type) {
                TextTooltip.TextTooltipStyle s2d = new TextTooltip.TextTooltipStyle();
                json.readFields((Object)s2d, jsonData);
                String labelStyleName = (String)json.readValue("label", String.class, (Object)"default", jsonData);
                if (labelStyleName == null) {
                    Styles.LabelStyle style = (Styles.LabelStyle)json.readValue("label", Styles.LabelStyle.class, jsonData);
                    Styles.TextTooltipStyle tt = new Styles.TextTooltipStyle(style, s2d.background);
                    tt.wrapWidth = s2d.wrapWidth;
                    skin.add(jsonData.name, (Object)tt, Styles.TextTooltipStyle.class);
                } else {
                    Styles.TextTooltipStyle tt = new Styles.TextTooltipStyle((Styles.LabelStyle)skin.get(labelStyleName, Styles.LabelStyle.class), s2d.background);
                    tt.wrapWidth = s2d.wrapWidth;
                    skin.add(jsonData.name, (Object)tt, Styles.TextTooltipStyle.class);
                }
                return s2d;
            }
        });
        json.setSerializer(List.ListStyle.class, (Json.Serializer)new Json.ReadOnlySerializer<List.ListStyle>(){

            public List.ListStyle read(Json json, JsonValue jsonData, Class type) {
                List.ListStyle s2d = new List.ListStyle();
                json.readFields((Object)s2d, jsonData);
                Styles.ListStyle stt = new Styles.ListStyle((Font)skin.get((String)json.readValue("font", String.class, (Object)"default-font", jsonData), Font.class), s2d.fontColorSelected, s2d.fontColorUnselected, s2d.selection);
                stt.background = s2d.background;
                stt.down = s2d.down;
                stt.over = s2d.over;
                skin.add(jsonData.name, (Object)stt, Styles.ListStyle.class);
                return s2d;
            }
        });
        json.setSerializer(SelectBox.SelectBoxStyle.class, (Json.Serializer)new Json.ReadOnlySerializer<SelectBox.SelectBoxStyle>(){

            public SelectBox.SelectBoxStyle read(Json json, JsonValue jsonData, Class type) {
                Styles.ListStyle ls;
                SelectBox.SelectBoxStyle s2d = new SelectBox.SelectBoxStyle();
                json.readFields((Object)s2d, jsonData);
                String scrollStyleName = (String)json.readValue("scrollStyle", String.class, (Object)"default", jsonData);
                ScrollPane.ScrollPaneStyle sps = scrollStyleName == null ? (ScrollPane.ScrollPaneStyle)json.readValue("scrollStyle", ScrollPane.ScrollPaneStyle.class, jsonData) : (ScrollPane.ScrollPaneStyle)skin.get(scrollStyleName, ScrollPane.ScrollPaneStyle.class);
                String listStyleName = (String)json.readValue("listStyle", String.class, (Object)"default", jsonData);
                if (listStyleName == null) {
                    List.ListStyle ls2d = new List.ListStyle();
                    json.readFields((Object)ls2d, jsonData.get("listStyle"));
                    ls = new Styles.ListStyle((Font)skin.get((String)json.readValue("font", String.class, (Object)"default-font", jsonData), Font.class), ls2d.fontColorSelected, ls2d.fontColorUnselected, ls2d.selection);
                    ls.background = ls2d.background;
                    ls.down = ls2d.down;
                    ls.over = ls2d.over;
                } else {
                    ls = (Styles.ListStyle)skin.get(listStyleName, Styles.ListStyle.class);
                }
                Styles.SelectBoxStyle stt = new Styles.SelectBoxStyle((Font)skin.get((String)json.readValue("font", String.class, (Object)"default-font", jsonData), Font.class), s2d.fontColor, s2d.background, sps, ls);
                stt.background = s2d.background;
                stt.backgroundDisabled = s2d.backgroundDisabled;
                stt.backgroundOpen = s2d.backgroundOpen;
                stt.backgroundOver = s2d.backgroundOver;
                stt.disabledFontColor = s2d.disabledFontColor;
                stt.overFontColor = s2d.overFontColor;
                skin.add(jsonData.name, (Object)stt, Styles.SelectBoxStyle.class);
                return s2d;
            }
        });
        json.setSerializer(TextField.TextFieldStyle.class, (Json.Serializer)new Json.ReadOnlySerializer<TextField.TextFieldStyle>(){

            public TextField.TextFieldStyle read(Json json, JsonValue jsonData, Class type) {
                TextField.TextFieldStyle s2d = new TextField.TextFieldStyle();
                json.readFields((Object)s2d, jsonData);
                Styles.TextFieldStyle stt = new Styles.TextFieldStyle((Font)skin.get((String)json.readValue("font", String.class, (Object)"default-font", jsonData), Font.class), s2d.fontColor, s2d.cursor, s2d.selection, s2d.background);
                stt.messageFontColor = s2d.messageFontColor;
                stt.focusedFontColor = s2d.focusedFontColor;
                stt.disabledFontColor = s2d.disabledFontColor;
                stt.focusedBackground = s2d.focusedBackground;
                stt.disabledBackground = s2d.disabledBackground;
                skin.add(jsonData.name, (Object)stt, Styles.TextFieldStyle.class);
                return s2d;
            }
        });
        return json;
    }

    public void resizeDistanceFields(float width, float height) {
        for (Font font : this.getAll(Font.class).values()) {
            font.resizeDistanceField(width, height);
        }
    }

    public void resizeDistanceFields(float width, float height, Viewport viewport) {
        for (Font font : this.getAll(Font.class).values()) {
            font.resizeDistanceField(width, height, viewport);
        }
    }
}

