/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.ColorUtils;

public class RainbowEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 0.975f;
    private static final float DEFAULT_FREQUENCY = 2.0f;
    private float distance = 1.0f;
    private float frequency = 1.0f;
    private float saturation = 1.0f;
    private float lightness = 0.5f;

    public RainbowEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.frequency = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.saturation = this.paramAsFloat(params[2], 1.0f);
        }
        if (params.length > 3) {
            this.lightness = this.paramAsFloat(params[3], 0.5f);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float distanceMod = 1.0f / this.distance * 0.024999976f;
        float frequencyMod = 1.0f / this.frequency * 2.0f;
        float progress = this.calculateProgress(frequencyMod, distanceMod * (float)localIndex, false);
        this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)ColorUtils.hsl2rgb(progress, this.saturation, this.lightness, 1.0f) << 32);
    }
}

