/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.LongArray;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Justify;
import com.github.tommyettinger.textra.Layout;
import com.github.tommyettinger.textra.Line;
import com.github.tommyettinger.textra.Styles;

public class TextraLabel
extends Widget {
    public Layout layout;
    protected Font font;
    public int align = 8;
    public boolean wrap = false;
    public String storedText;
    public Styles.LabelStyle style;
    protected boolean prefSizeInvalid = true;

    public TextraLabel() {
        this.layout = new Layout();
        this.font = new Font();
        this.style = new Styles.LabelStyle(this.font, null);
    }

    public TextraLabel(String text, Skin skin) {
        this(text, (Styles.LabelStyle)skin.get(Styles.LabelStyle.class));
    }

    public TextraLabel(String text, Skin skin, boolean makeGridGlyphs) {
        this(text, (Styles.LabelStyle)skin.get(Styles.LabelStyle.class), makeGridGlyphs);
    }

    public TextraLabel(String text, Skin skin, String styleName) {
        this(text, (Styles.LabelStyle)skin.get(styleName, Styles.LabelStyle.class));
    }

    public TextraLabel(String text, Skin skin, String styleName, boolean makeGridGlyphs) {
        this(text, (Styles.LabelStyle)skin.get(styleName, Styles.LabelStyle.class), makeGridGlyphs);
    }

    public TextraLabel(String text, Skin skin, String styleName, Color color) {
        this(text, (Styles.LabelStyle)skin.get(styleName, Styles.LabelStyle.class));
        if (color != null) {
            this.layout.setBaseColor(color);
        }
    }

    public TextraLabel(String text, Skin skin, String styleName, String colorName) {
        this(text, (Styles.LabelStyle)skin.get(styleName, Styles.LabelStyle.class));
        if (colorName == null) {
            return;
        }
        Color color = (Color)skin.get(colorName, Color.class);
        if (color != null) {
            this.layout.setBaseColor(color);
        }
    }

    public TextraLabel(String text, Styles.LabelStyle style) {
        this(text, style, false);
    }

    public TextraLabel(String text, Styles.LabelStyle style, boolean makeGridGlyphs) {
        this(text, style, style.font);
    }

    public TextraLabel(String text, Skin skin, Font replacementFont) {
        this(text, (Styles.LabelStyle)skin.get(Styles.LabelStyle.class), replacementFont);
    }

    public TextraLabel(String text, Skin skin, String styleName, Font replacementFont) {
        this(text, (Styles.LabelStyle)skin.get(styleName, Styles.LabelStyle.class), replacementFont);
    }

    public TextraLabel(String text, Skin skin, String styleName, Font replacementFont, Color color) {
        this(text, (Styles.LabelStyle)skin.get(styleName, Styles.LabelStyle.class), replacementFont);
        if (color != null) {
            this.layout.setBaseColor(color);
        }
    }

    public TextraLabel(String text, Styles.LabelStyle style, Font replacementFont) {
        this.font = replacementFont;
        this.layout = new Layout();
        if (style.fontColor != null) {
            this.layout.setBaseColor(style.fontColor);
        }
        this.style = style;
        this.storedText = text;
        this.font.markup(text, this.layout);
        this.invalidateHierarchy();
        this.setSize(this.layout.getWidth(), this.layout.getHeight());
    }

    public TextraLabel(String text, Font font) {
        this(text, font, null);
    }

    public TextraLabel(String text, Font font, Color color) {
        this(text, font, color, Justify.NONE);
    }

    public TextraLabel(String text, Font font, Color color, Justify justify) {
        this.font = font;
        this.layout = new Layout();
        this.style = new Styles.LabelStyle();
        if (color != null) {
            this.layout.setBaseColor(color);
        }
        this.storedText = text;
        font.markup(text, this.layout);
        this.layout.setJustification(justify);
    }

    public void draw(Batch batch, float parentAlpha) {
        boolean resetShader;
        super.validate();
        float rot = this.getRotation();
        float originX = this.getOriginX();
        float originY = this.getOriginY();
        float sn = MathUtils.sinDeg((float)rot);
        float cs = MathUtils.cosDeg((float)rot);
        int lines = this.layout.lines();
        float baseX = this.getX();
        float baseY = this.getY();
        float layoutHeight = this.layout.getHeight();
        if (Align.isBottom((int)this.align)) {
            baseX -= sn * layoutHeight;
            baseY += cs * layoutHeight;
        } else if (Align.isCenterVertical((int)this.align)) {
            baseX -= sn * layoutHeight * 0.5f;
            baseY += cs * layoutHeight * 0.5f;
        }
        float widgetHeight = this.getHeight();
        if (Align.isTop((int)this.align)) {
            baseX -= sn * widgetHeight;
            baseY += cs * widgetHeight;
        } else if (Align.isCenterVertical((int)this.align)) {
            baseX -= sn * widgetHeight * 0.5f;
            baseY += cs * widgetHeight * 0.5f;
        }
        float widgetWidth = this.getWidth();
        if (Align.isRight((int)this.align)) {
            baseX += cs * widgetWidth;
            baseY += sn * widgetWidth;
        } else if (Align.isCenterHorizontal((int)this.align)) {
            baseX += cs * widgetWidth * 0.5f;
            baseY += sn * widgetWidth * 0.5f;
        }
        if (this.style != null && this.style.background != null) {
            Drawable background = this.style.background;
            if (Align.isLeft((int)this.align)) {
                baseX += cs * background.getLeftWidth();
                baseY += sn * background.getLeftWidth();
            } else if (Align.isRight((int)this.align)) {
                baseX -= cs * background.getRightWidth();
                baseY -= sn * background.getRightWidth();
            } else {
                baseX += cs * (background.getLeftWidth() - background.getRightWidth()) * 0.5f;
                baseY += sn * (background.getLeftWidth() - background.getRightWidth()) * 0.5f;
            }
            if (Align.isBottom((int)this.align)) {
                baseX -= sn * background.getBottomHeight();
                baseY += cs * background.getBottomHeight();
            } else if (Align.isTop((int)this.align)) {
                baseX += sn * background.getTopHeight();
                baseY -= cs * background.getTopHeight();
            } else {
                baseX -= sn * (background.getBottomHeight() - background.getTopHeight()) * 0.5f;
                baseY += cs * (background.getBottomHeight() - background.getTopHeight()) * 0.5f;
            }
            try {
                ((TransformDrawable)background).draw(batch, this.getX(), this.getY(), originX, originY, this.getWidth(), this.getHeight(), 1.0f, 1.0f, rot);
            }
            catch (ClassCastException | UnsupportedOperationException itIsJustADrawable) {
                background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        }
        if (this.layout.lines.isEmpty() || parentAlpha <= 0.0f) {
            return;
        }
        boolean bl = resetShader = this.font.getDistanceField() != Font.DistanceFieldType.STANDARD && batch.getShader() != this.font.shader;
        if (resetShader) {
            this.font.enableShader(batch);
        }
        batch.getColor().set((Color)this.getColor()).a *= parentAlpha;
        batch.setColor(batch.getColor());
        for (int ln = 0; ln < lines; ++ln) {
            Line line = this.layout.getLine(ln);
            if (line.glyphs.size == 0) continue;
            float x = baseX += sn * line.height;
            float y = baseY -= cs * line.height;
            float worldOriginX = x + originX;
            float worldOriginY = y + originY;
            float fx = -originX;
            float fy = -originY;
            x = cs * fx - sn * fy + worldOriginX;
            y = sn * fx + cs * fy + worldOriginY;
            if (Align.isCenterHorizontal((int)this.align)) {
                x -= cs * (line.width * 0.5f);
                y -= sn * (line.width * 0.5f);
            } else if (Align.isRight((int)this.align)) {
                x -= cs * line.width;
                y -= sn * line.width;
            }
            x -= sn * (0.5f * line.height);
            y += cs * (0.5f * line.height);
            float xChange = 0.0f;
            float yChange = 0.0f;
            Font f = null;
            int kern = -1;
            boolean curly = false;
            int start = this.layout.countGlyphsBeforeLine(ln);
            int n = line.glyphs.size;
            for (int i = 0; i < n; ++i) {
                long glyph = line.glyphs.get(i);
                char ch = (char)glyph;
                if (this.font.omitCurlyBraces) {
                    if (curly) {
                        if (ch == '}') {
                            curly = false;
                            continue;
                        }
                        if (ch != '{') continue;
                        curly = false;
                    } else if (ch == '{') {
                        curly = true;
                        continue;
                    }
                }
                if (this.font.family != null) {
                    f = this.font.family.connected[(int)(glyph >>> 16 & 0xFL)];
                }
                if (f == null) {
                    f = this.font;
                }
                if (i == 0) {
                    Font.GlyphRegion reg;
                    x -= 0.5f * f.cellWidth;
                    x += cs * 0.5f * f.cellWidth;
                    y += sn * 0.5f * f.cellWidth;
                    if (this.font.integerPosition) {
                        x = (int)x;
                        y = (int)y;
                    }
                    if ((reg = (Font.GlyphRegion)((Object)this.font.mapping.get((int)((char)glyph)))) != null && reg.offsetX < 0.0f) {
                        float ox = reg.offsetX * f.scaleX * ((glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f);
                        xChange -= cs * ox;
                        yChange -= sn * ox;
                    }
                }
                if (f.kerning != null) {
                    glyph = line.glyphs.get(i);
                    kern = kern << 16 | (int)(glyph & 0xFFFFL);
                    float amt = f.kerning.get(kern, 0.0f) * f.scaleX * ((glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f);
                    xChange += cs * amt;
                    yChange += sn * amt;
                } else {
                    kern = -1;
                }
                int bgc = 0;
                int even = start + i << 1;
                int odd = even | 1;
                float xx = x + xChange + this.getOffsets().get(even);
                float yy = y + yChange + this.getOffsets().get(odd);
                if (this.font.integerPosition) {
                    xx = (int)xx;
                    yy = (int)yy;
                }
                float a = this.getAdvances().get(start + i);
                float single = f.drawGlyph(batch, glyph, xx, yy, this.getRotations().get(start + i) + rot, this.getSizing().get(even), this.getSizing().get(odd), bgc, a);
                xChange += cs * single;
                yChange += sn * single;
            }
        }
        if (resetShader) {
            batch.setShader(null);
        }
    }

    public float getPrefWidth() {
        if (this.wrap) {
            return 0.0f;
        }
        if (this.prefSizeInvalid) {
            this.validate();
        }
        float width = this.layout.getWidth();
        if (this.style != null && this.style.background != null) {
            width = Math.max(width + this.style.background.getLeftWidth() + this.style.background.getRightWidth(), this.style.background.getMinWidth());
        }
        return width;
    }

    public float getPrefHeight() {
        if (this.prefSizeInvalid) {
            this.validate();
        }
        float height = this.layout.getHeight();
        if (this.style != null && this.style.background != null) {
            height = Math.max(height + this.style.background.getBottomHeight() + this.style.background.getTopHeight(), this.style.background.getMinHeight());
        }
        return height;
    }

    public TextraLabel useIntegerPositions(boolean integer) {
        this.font.integerPosition = integer;
        return this;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public TextraLabel setWrap(boolean wrap) {
        this.wrap = wrap;
        if (this.wrap != this.wrap) {
            this.invalidateHierarchy();
            if (this.wrap) {
                this.layout();
            }
        }
        return this;
    }

    public void setWidth(float width) {
        if (Gdx.graphics.getWidth() <= 0 || Gdx.graphics.getHeight() <= 0) {
            return;
        }
        super.setWidth(width);
        if (this.wrap) {
            this.layout.setTargetWidth(width);
        }
        this.font.calculateSize(this.layout);
        this.invalidateHierarchy();
    }

    public void setHeight(float height) {
        if (Gdx.graphics.getWidth() <= 0 || Gdx.graphics.getHeight() <= 0) {
            return;
        }
        super.setHeight(height);
        this.font.calculateSize(this.layout);
        this.invalidateHierarchy();
    }

    public void setSize(float width, float height) {
        if (Gdx.graphics.getWidth() <= 0 || Gdx.graphics.getHeight() <= 0) {
            return;
        }
        super.setSize(width, height);
        if (this.wrap) {
            this.layout.setTargetWidth(width);
        }
        this.font.calculateSize(this.layout);
        this.invalidateHierarchy();
    }

    public void setSuperWidth(float width) {
        super.setWidth(width);
    }

    public void setSuperHeight(float height) {
        super.setHeight(height);
    }

    public void layout() {
        if (Gdx.graphics.getWidth() <= 0 || Gdx.graphics.getHeight() <= 0) {
            return;
        }
        float width = this.getWidth();
        if (this.style != null && this.style.background != null) {
            width -= this.style.background.getLeftWidth() + this.style.background.getRightWidth();
        }
        float actualWidth = this.font.calculateSize(this.layout);
        if (this.wrap && (width == 0.0f || this.layout.getTargetWidth() != width || actualWidth > width)) {
            if (width != 0.0f) {
                this.layout.setTargetWidth(width);
            }
            this.font.regenerateLayout(this.layout);
            this.invalidateHierarchy();
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int alignment) {
        this.align = alignment;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        if (!this.font.equals(this.font)) {
            font.regenerateLayout(this.layout);
        }
    }

    public void setFont(Font font, boolean regenerate) {
        this.font = font;
        if (!this.font.equals(this.font) && regenerate) {
            font.regenerateLayout(this.layout);
        }
    }

    public void setText(String markupText) {
        this.storedText = markupText;
        if (this.wrap) {
            this.layout.setTargetWidth(this.getWidth());
        }
        this.font.markup(markupText, this.layout.clear());
        this.invalidateHierarchy();
    }

    public TextraLabel skipToTheEnd() {
        return this;
    }

    public void invalidate() {
        super.invalidate();
        this.prefSizeInvalid = true;
    }

    public void validate() {
        this.prefSizeInvalid = false;
        super.validate();
    }

    public void setStage(Stage stage) {
        super.setStage(stage);
    }

    protected void setParent(Group parent) {
        super.setParent(parent);
    }

    public String toString() {
        return this.substring(0, Integer.MAX_VALUE);
    }

    public long getGlyph(int index) {
        LongArray glyphs;
        int n = this.layout.lines();
        for (int i = 0; i < n && index >= 0; index -= glyphs.size, ++i) {
            glyphs = this.layout.getLine((int)i).glyphs;
            if (index >= glyphs.size) continue;
            return glyphs.get(index);
        }
        return 0xFFFFFFL;
    }

    public int getMaxLines() {
        return this.layout.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.layout.setMaxLines(maxLines);
    }

    public String getEllipsis() {
        return this.layout.ellipsis;
    }

    public void setEllipsis(String ellipsis) {
        this.layout.setEllipsis(ellipsis);
    }

    public String substring(int start, int end) {
        start = Math.max(0, start);
        end = Math.min(this.layout.countGlyphs(), end);
        int index = start;
        StringBuilder sb = new StringBuilder(end - start);
        int glyphCount = 0;
        int n = this.layout.lines();
        for (int i = 0; i < n && index >= 0; ++i) {
            LongArray glyphs = this.layout.getLine((int)i).glyphs;
            if (index < glyphs.size) {
                int fin = index - start - glyphCount + end;
                while (index < fin && index < glyphs.size) {
                    char c = (char)glyphs.get(index);
                    if (c >= '\ue000' && c <= '\uf800') {
                        String name = (String)this.font.namesByCharCode.get((int)c);
                        if (name != null) {
                            sb.append(name);
                        } else {
                            sb.append(c);
                        }
                    } else if (c == '\u0002') {
                        sb.append('[');
                    } else if (c != '\u200b') {
                        sb.append(c);
                    }
                    ++glyphCount;
                    ++index;
                }
                if (glyphCount == end - start) {
                    return sb.toString();
                }
                index = 0;
                continue;
            }
            index -= glyphs.size;
        }
        return "";
    }

    public float getLineHeight(int index) {
        LongArray glyphs;
        int n = this.layout.lines();
        for (int i = 0; i < n && index >= 0; index -= glyphs.size, ++i) {
            glyphs = this.layout.getLine((int)i).glyphs;
            if (index >= glyphs.size) continue;
            return this.layout.getLine((int)i).height;
        }
        return this.font.cellHeight;
    }

    public FloatArray getRotations() {
        return this.layout.rotations;
    }

    public FloatArray getOffsets() {
        return this.layout.offsets;
    }

    public FloatArray getSizing() {
        return this.layout.sizing;
    }

    public FloatArray getAdvances() {
        return this.layout.advances;
    }
}

