/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.ColorUtils;

public class HighlightEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 0.975f;
    private static final float DEFAULT_FREQUENCY = 2.0f;
    private static final int DEFAULT_COLOR = -2;
    private int baseColor = -2;
    private float distance = 1.0f;
    private float frequency = 1.0f;
    private float saturation = 1.0f;
    private float lightness = 0.5f;
    private boolean all = false;

    public HighlightEffect(TypingLabel label, String[] params) {
        super(label);
        label.trackingInput = true;
        if (params.length > 0) {
            this.baseColor = this.paramAsColor(params[0]);
            if (this.baseColor == 256) {
                this.baseColor = -2;
            }
        }
        if (params.length > 1) {
            this.distance = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.frequency = this.paramAsFloat(params[2], 1.0f);
        }
        if (params.length > 3) {
            this.saturation = this.paramAsFloat(params[3], 1.0f);
        }
        if (params.length > 4) {
            this.lightness = this.paramAsFloat(params[4], 0.5f);
        }
        if (params.length > 5) {
            this.all = this.paramAsBoolean(params[5]);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        if (this.all) {
            if (this.label.overIndex < this.indexStart || this.label.overIndex > this.indexEnd) {
                this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)this.baseColor << 32);
                return;
            }
        } else if (this.label.overIndex != globalIndex) {
            this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)this.baseColor << 32);
            return;
        }
        float distanceMod = 1.0f / this.distance * 0.024999976f;
        float frequencyMod = 1.0f / this.frequency * 2.0f;
        float progress = this.calculateProgress(frequencyMod, distanceMod * (float)localIndex, false);
        this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)ColorUtils.hsl2rgb(progress, this.saturation, this.lightness, 1.0f) << 32);
    }
}

