/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Null;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Styles;
import com.github.tommyettinger.textra.TextraLabel;

public class TextraButton
extends Button {
    private TextraLabel label;
    private Styles.TextButtonStyle style;

    public TextraButton(@Null String text, Skin skin) {
        this(text, (Styles.TextButtonStyle)((Object)skin.get(Styles.TextButtonStyle.class)));
        this.setSkin(skin);
    }

    public TextraButton(@Null String text, Skin skin, String styleName) {
        this(text, (Styles.TextButtonStyle)((Object)skin.get(styleName, Styles.TextButtonStyle.class)));
        this.setSkin(skin);
    }

    public TextraButton(@Null String text, Styles.TextButtonStyle style) {
        this(text, style, new Font(style.font));
    }

    public TextraButton(@Null String text, Skin skin, Font replacementFont) {
        this(text, (Styles.TextButtonStyle)((Object)skin.get(Styles.TextButtonStyle.class)), replacementFont);
        this.setSkin(skin);
    }

    public TextraButton(@Null String text, Skin skin, String styleName, Font replacementFont) {
        this(text, (Styles.TextButtonStyle)((Object)skin.get(styleName, Styles.TextButtonStyle.class)), replacementFont);
        this.setSkin(skin);
    }

    public TextraButton(@Null String text, Styles.TextButtonStyle style, Font replacementFont) {
        this.label = this.newLabel(text, replacementFont, style.fontColor);
        this.label.setAlignment(1);
        this.setStyle((Button.ButtonStyle)style, replacementFont);
        this.add((Actor)this.label).expand().fill();
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    protected TextraLabel newLabel(String text, Styles.LabelStyle style) {
        return new TextraLabel(text, style);
    }

    protected TextraLabel newLabel(String text, Font font, Color color) {
        return new TextraLabel(text, font, color);
    }

    public void setStyle(Button.ButtonStyle style) {
        this.setStyle(style, false);
    }

    public void setStyle(Button.ButtonStyle style, boolean makeGridGlyphs) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        if (!(style instanceof Styles.TextButtonStyle)) {
            throw new IllegalArgumentException("style must be a TextButtonStyle.");
        }
        this.style = (Styles.TextButtonStyle)style;
        super.setStyle(style);
        if (this.label != null) {
            Styles.TextButtonStyle textButtonStyle = (Styles.TextButtonStyle)style;
            this.label.setFont(textButtonStyle.font);
            if (textButtonStyle.fontColor != null) {
                this.label.setColor(textButtonStyle.fontColor);
            }
        }
    }

    public void setStyle(Button.ButtonStyle style, Font font) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        if (!(style instanceof Styles.TextButtonStyle)) {
            throw new IllegalArgumentException("style must be a TextButtonStyle.");
        }
        this.style = (Styles.TextButtonStyle)style;
        super.setStyle(style);
        if (this.label != null) {
            Styles.TextButtonStyle textButtonStyle = (Styles.TextButtonStyle)style;
            this.label.setFont(font);
            if (textButtonStyle.fontColor != null) {
                this.label.setColor(textButtonStyle.fontColor);
            }
        }
    }

    public Styles.TextButtonStyle getStyle() {
        return this.style;
    }

    @Null
    protected Color getFontColor() {
        if (this.isDisabled() && this.style.disabledFontColor != null) {
            return this.style.disabledFontColor;
        }
        if (this.isPressed()) {
            if (this.isChecked() && this.style.checkedDownFontColor != null) {
                return this.style.checkedDownFontColor;
            }
            if (this.style.downFontColor != null) {
                return this.style.downFontColor;
            }
        }
        if (this.isOver()) {
            if (this.isChecked()) {
                if (this.style.checkedOverFontColor != null) {
                    return this.style.checkedOverFontColor;
                }
            } else if (this.style.overFontColor != null) {
                return this.style.overFontColor;
            }
        }
        boolean focused = this.hasKeyboardFocus();
        if (this.isChecked()) {
            if (focused && this.style.checkedFocusedFontColor != null) {
                return this.style.checkedFocusedFontColor;
            }
            if (this.style.checkedFontColor != null) {
                return this.style.checkedFontColor;
            }
            if (this.isOver() && this.style.overFontColor != null) {
                return this.style.overFontColor;
            }
        }
        if (focused && this.style.focusedFontColor != null) {
            return this.style.focusedFontColor;
        }
        return this.style.fontColor;
    }

    public void draw(Batch batch, float parentAlpha) {
        Color c = this.getFontColor();
        if (c != null) {
            this.label.setColor(c);
        }
        super.draw(batch, parentAlpha);
    }

    public void setTextraLabel(TextraLabel label) {
        if (label == null) {
            throw new IllegalArgumentException("label cannot be null.");
        }
        if (this.label == label) {
            return;
        }
        this.getTextraLabelCell().setActor((Actor)label);
        this.label = label;
    }

    public TextraLabel getTextraLabel() {
        return this.label;
    }

    public Cell<TextraLabel> getTextraLabelCell() {
        return this.getCell((Actor)this.label);
    }

    public TextraButton useIntegerPositions(boolean integer) {
        this.label.getFont().integerPosition = integer;
        return this;
    }

    public void setText(@Null String text) {
        this.label.setText(text);
    }

    public String getText() {
        return this.label.toString();
    }

    public String toString() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        String className = ((Object)((Object)this)).getClass().getName();
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex != -1) {
            className = className.substring(dotIndex + 1);
        }
        return (className.indexOf(36) != -1 ? "TextraButton " : "") + className + ": " + this.label.toString();
    }

    public void skipToTheEnd() {
        this.label.skipToTheEnd();
    }
}

