/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class ThinkingEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 1.0f;
    private static final float DEFAULT_DRIFT = 1.0f;
    private float distance = 2.0f;
    private float extent = 1.0f;
    private float drift = 1.0f;
    private boolean inside = false;
    private final IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public ThinkingEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 2.0f);
        }
        if (params.length > 1) {
            this.extent = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.drift = this.paramAsFloat(params[2], 1.0f);
        }
        if (params.length > 3) {
            this.inside = this.paramAsBoolean(params[3]);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float realExtent = this.extent;
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, 0.0f, delta);
        float progress = MathUtils.clamp((float)(timePassed / realExtent), (float)0.0f, (float)1.0f);
        int random = ((globalIndex ^ 0xDE82EF95) * 856899 ^ 0xDE82EF95) * 856899;
        float angle = (float)(random >>> 9) * 1.1920929E-7f * ((float)Math.PI * 2);
        float driftAngle = (float)(random & 0x7FFFFF) * 1.1920929E-7f * ((float)Math.PI * 2);
        int random2 = ((random ^ 0xDE82EF95) * 856899 ^ 0xDE82EF95) * 856899;
        float randomizedProgress = (float)Math.pow(progress, (float)(((random2 ^ 0xDE82EF95) * 856899 ^ 0xDE82EF95) * 856899 >>> 9) * 1.1920929E-7f + 1.25f);
        float alpha = Math.max(0.0f, MathUtils.cos((float)(randomizedProgress * ((float)Math.PI * 2))));
        float lineHeight = this.label.getLineHeight(globalIndex);
        float dist = randomizedProgress > 0.5f ? 0.0f : lineHeight * this.distance * 1.0f * (this.inside ? (float)Math.sqrt((float)(random2 >>> 9) * 1.1920929E-7f) : 1.0f);
        float driftAmount = randomizedProgress > 0.5f || this.drift == 0.0f ? 0.0f : lineHeight * this.drift * 1.0f * ((float)(random2 & 0x7FFFFF) * 1.1920929E-7f) * progress;
        float x = MathUtils.cos((float)angle) * dist + MathUtils.cos((float)driftAngle) * driftAmount;
        float y = MathUtils.sin((float)angle) * dist + MathUtils.sin((float)driftAngle) * driftAmount;
        this.label.getOffsets().incr(globalIndex << 1, x);
        this.label.getOffsets().incr(globalIndex << 1 | 1, y);
        this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFF00FFFFFFFFL | (long)(255.0f * alpha) << 32);
    }
}

