/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.github.tommyettinger.textra.ColorLookup;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.InternalToken;
import com.github.tommyettinger.textra.TokenCategory;
import com.github.tommyettinger.textra.TokenEntry;
import com.github.tommyettinger.textra.TypingConfig;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.CaseInsensitiveIntMap;
import com.github.tommyettinger.textra.utils.Palette;
import com.github.tommyettinger.textra.utils.StringUtils;
import java.util.Collections;
import regexodus.Matcher;
import regexodus.Pattern;
import regexodus.Replacer;

public class Parser {
    private static final Pattern PATTERN_MARKUP_STRIP = Pattern.compile((String)"((?<!\\[)\\[[^\\[\\]]*(\\]))");
    private static final Matcher MATCHER_MARKUP_STRIP = PATTERN_MARKUP_STRIP.matcher();
    private static final Replacer RESET_TAG = new Replacer(Pattern.compile((String)"((?<!\\[)\\[ (?:\\]))"), "{RESET}");
    private static final Replacer UNDO_TAG = new Replacer(Pattern.compile((String)"((?<!\\[)\\[(?:\\]))"), "{UNDO}");
    private static final Replacer COLOR_MARKUP_TO_TAG = new Replacer(Pattern.compile((String)"(?<!\\[)\\[(?:(?:#({=m}[A-Fa-f0-9]{3,8}))|(?:\\|?({=m}[\\pL\\pN][^\\[\\]]*)))(\\])"), "{COLOR=${\\m}}");
    private static final Replacer MARKUP_TO_TAG = new Replacer(Pattern.compile((String)"(?<!\\[)\\[([^\\[\\]\\+][^\\[\\]]*)(\\])"), "{STYLE=$1}");
    private static final Pattern PATTERN_COLOR_HEX_NO_HASH = Pattern.compile((String)"[A-Fa-f0-9]{3,8}");
    private static final Matcher MATCHER_COLOR_HEX_NO_HASH = PATTERN_COLOR_HEX_NO_HASH.matcher();
    private static final Replacer BRACKET_MINUS_TO_TAG = new Replacer(Pattern.compile((String)"((?<!\\[)\\[-({=t}[^\\[\\]]*)(?:\\]))"), "{${\\t}}");
    private static final CaseInsensitiveIntMap BOOLEAN_TRUE = new CaseInsensitiveIntMap(new String[]{"true", "yes", "t", "y", "on", "1"}, new int[6]);
    private static final int INDEX_TOKEN = 1;
    private static final int INDEX_PARAM = 2;
    private static Pattern PATTERN_TOKEN_STRIP;
    private static Matcher MATCHER_TOKEN_STRIP;
    private static Matcher MATCHER_TOKEN_STRIP_2;
    private static String RESET_REPLACEMENT;

    public static String handleBracketMinusMarkup(String text) {
        if (text.contains("[-")) {
            return BRACKET_MINUS_TO_TAG.replace((CharSequence)text);
        }
        return text;
    }

    public static String preprocess(String text) {
        text = RESET_TAG.replace((CharSequence)text);
        text = UNDO_TAG.replace((CharSequence)text);
        text = COLOR_MARKUP_TO_TAG.replace((CharSequence)text);
        text = MARKUP_TO_TAG.replace((CharSequence)text);
        return text;
    }

    public static void parseTokens(TypingLabel label) {
        if (PATTERN_TOKEN_STRIP == null || TypingConfig.dirtyEffectMaps) {
            PATTERN_TOKEN_STRIP = Parser.compileTokenPattern();
            MATCHER_TOKEN_STRIP = PATTERN_TOKEN_STRIP.matcher();
            MATCHER_TOKEN_STRIP_2 = PATTERN_TOKEN_STRIP.matcher();
        }
        if (RESET_REPLACEMENT == null || TypingConfig.dirtyEffectMaps) {
            RESET_REPLACEMENT = Parser.getResetReplacement();
        }
        label.tokenEntries.clear();
        Parser.parseReplacements(label);
        Parser.parseRegularTokens(label);
        label.setText(label.getIntermediateText().toString(), false, false);
        Collections.sort(label.tokenEntries);
    }

    private static void parseReplacements(TypingLabel label) {
        CharSequence text = label.layout.appendIntoDirect(new StringBuilder());
        if (label.font.omitCurlyBraces || label.font.enableSquareBrackets) {
            MATCHER_TOKEN_STRIP.setTarget(text);
            Matcher m = MATCHER_TOKEN_STRIP;
            int matcherIndexOffset = 0;
            block12: while (true) {
                String replacement;
                m.setTarget(text);
                m.setPosition(matcherIndexOffset);
                if (!m.find()) break;
                InternalToken internalToken = InternalToken.fromName(m.group(1));
                String param = m.group(2);
                if (internalToken == null) {
                    ++matcherIndexOffset;
                    continue;
                }
                switch (internalToken) {
                    case COLOR: {
                        replacement = Parser.stringToColorMarkup(param);
                        break;
                    }
                    case STYLE: 
                    case SIZE: {
                        replacement = Parser.stringToStyleMarkup(param);
                        break;
                    }
                    case FONT: {
                        replacement = "[@" + param + ']';
                        break;
                    }
                    case ENDCOLOR: 
                    case CLEARCOLOR: {
                        replacement = "[#" + label.getClearColor().toString() + ']';
                        break;
                    }
                    case CLEARSIZE: {
                        replacement = "[%]";
                        break;
                    }
                    case CLEARFONT: {
                        replacement = "[@]";
                        break;
                    }
                    case VAR: {
                        replacement = null;
                        if (label.getTypingListener() != null) {
                            replacement = label.getTypingListener().replaceVariable(param);
                        }
                        if (replacement == null) {
                            replacement = (String)label.getVariables().get((Object)param.toUpperCase());
                        }
                        if (replacement == null) {
                            replacement = (String)TypingConfig.GLOBAL_VARS.get((Object)param.toUpperCase());
                        }
                        if (replacement != null) break;
                        replacement = param.toUpperCase();
                        break;
                    }
                    case IF: {
                        replacement = Parser.processIfToken(label, param);
                        if (replacement != null) break;
                        replacement = param.toUpperCase();
                        break;
                    }
                    case RESET: {
                        replacement = RESET_REPLACEMENT + label.getDefaultToken();
                        break;
                    }
                    case UNDO: {
                        replacement = "[]";
                        break;
                    }
                    default: {
                        ++matcherIndexOffset;
                        continue block12;
                    }
                }
                m.setPosition(m.start());
                text = m.replaceFirst(replacement);
            }
        }
        label.setIntermediateText(text, false, false);
    }

    private static String processIfToken(TypingLabel label, String paramsString) {
        String variable;
        String[] params = paramsString == null ? new String[]{} : paramsString.split(";");
        String string = variable = params.length > 0 ? params[0] : null;
        if (params.length <= 1 || variable == null) {
            return null;
        }
        String variableValue = null;
        if (label.getTypingListener() != null) {
            variableValue = label.getTypingListener().replaceVariable(variable);
        }
        if (variableValue == null) {
            variableValue = (String)label.getVariables().get((Object)variable.toUpperCase());
        }
        if (variableValue == null) {
            variableValue = (String)TypingConfig.GLOBAL_VARS.get((Object)variable.toUpperCase());
        }
        if (variableValue == null) {
            variableValue = "";
        }
        String defaultValue = null;
        int n = params.length;
        for (int i = 1; i < n; ++i) {
            boolean isKeyValid;
            String[] subParams = params[i].split("=", 2);
            String key = subParams[0];
            String value = subParams[subParams.length - 1];
            boolean bl = isKeyValid = subParams.length > 1 && !key.isEmpty();
            if (!isKeyValid) {
                defaultValue = value;
                break;
            }
            if (!variableValue.equalsIgnoreCase(key)) continue;
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return variable;
    }

    private static void parseRegularTokens(TypingLabel label) {
        MATCHER_MARKUP_STRIP.setTarget((CharSequence)label.getIntermediateText());
        String text = MATCHER_MARKUP_STRIP.replaceAll("");
        CharSequence text2 = label.getIntermediateText();
        if (label.font.omitCurlyBraces || label.font.enableSquareBrackets) {
            MATCHER_TOKEN_STRIP.setTarget((CharSequence)text);
            MATCHER_TOKEN_STRIP_2.setTarget(text2);
            Matcher m = MATCHER_TOKEN_STRIP;
            Matcher m2 = MATCHER_TOKEN_STRIP_2;
            int matcherIndexOffset = 0;
            int m2IndexOffset = 0;
            while (true) {
                m.setTarget((CharSequence)text);
                m2.setTarget(text2);
                m2.setPosition(m2IndexOffset);
                m.setPosition(matcherIndexOffset);
                if (!m.find()) break;
                m2.find();
                String tokenName = m.group(1).toUpperCase();
                TokenCategory tokenCategory = null;
                InternalToken tmpToken = InternalToken.fromName(tokenName);
                if (tmpToken == null) {
                    if (TypingConfig.EFFECT_START_TOKENS.containsKey((Object)tokenName)) {
                        tokenCategory = TokenCategory.EFFECT_START;
                    } else if (TypingConfig.EFFECT_END_TOKENS.containsKey((Object)tokenName)) {
                        tokenCategory = TokenCategory.EFFECT_END;
                    }
                } else {
                    tokenCategory = tmpToken.category;
                }
                int groupCount = m.groupCount();
                String paramsString = groupCount == 2 ? m.group(2) : null;
                String[] params = paramsString == null ? new String[]{} : paramsString.split(";");
                String firstParam = params.length > 0 ? params[0] : null;
                int index = m.start(0);
                int indexOffset = 0;
                if (tokenCategory == null) {
                    ++matcherIndexOffset;
                    continue;
                }
                float floatValue = 0.0f;
                String stringValue = null;
                Effect effect = null;
                block0 : switch (tokenCategory) {
                    case WAIT: {
                        floatValue = Parser.stringToFloat(firstParam, TypingConfig.DEFAULT_WAIT_VALUE);
                        break;
                    }
                    case EVENT: {
                        stringValue = paramsString;
                        break;
                    }
                    case SPEED: {
                        switch (tokenName) {
                            case "SPEED": {
                                float minModifier = TypingConfig.MIN_SPEED_MODIFIER;
                                float maxModifier = TypingConfig.MAX_SPEED_MODIFIER;
                                float modifier = MathUtils.clamp((float)Parser.stringToFloat(firstParam, 1.0f), (float)minModifier, (float)maxModifier);
                                floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR / modifier;
                                break block0;
                            }
                            case "SLOWER": {
                                floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR * 2.0f;
                                break block0;
                            }
                            case "SLOW": {
                                floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR * 1.5f;
                                break block0;
                            }
                            case "NORMAL": {
                                floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR;
                                break block0;
                            }
                            case "FAST": {
                                floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR * 0.5f;
                                break block0;
                            }
                            case "FASTER": {
                                floatValue = TypingConfig.DEFAULT_SPEED_PER_CHAR * 0.25f;
                                break block0;
                            }
                            case "NATURAL": {
                                float minModifier = TypingConfig.MIN_SPEED_MODIFIER;
                                float maxModifier = TypingConfig.MAX_SPEED_MODIFIER;
                                float modifier = MathUtils.clamp((float)Parser.stringToFloat(firstParam, 1.0f), (float)minModifier, (float)maxModifier);
                                floatValue = -TypingConfig.DEFAULT_SPEED_PER_CHAR / modifier;
                                break block0;
                            }
                        }
                        break;
                    }
                    case EFFECT_START: {
                        Effect.EffectBuilder eb = (Effect.EffectBuilder)TypingConfig.EFFECT_START_TOKENS.get((Object)tokenName.toUpperCase());
                        if (eb == null) break;
                        effect = eb.produce(label, params);
                        break;
                    }
                }
                TokenEntry entry = new TokenEntry(tokenName, tokenCategory, index + indexOffset, m.end(0), floatValue, stringValue);
                entry.effect = effect;
                label.tokenEntries.add(entry);
                matcherIndexOffset = m.end();
                m2.setPosition(0);
                text2 = m2.replaceFirst("");
            }
        }
        label.setIntermediateText(text2, false, false);
    }

    private static void parseColorMarkups(TypingLabel label) {
        StringBuilder text = label.getOriginalText();
        MATCHER_MARKUP_STRIP.setTarget((CharSequence)text);
        Matcher m = MATCHER_MARKUP_STRIP;
        while (m.find()) {
            String tag = m.group(0);
            int index = m.start(0);
            label.tokenEntries.add(new TokenEntry("SKIP", TokenCategory.SKIP, index, m.end(0), 0.0f, tag));
        }
    }

    public static float stringToFloat(String str, float defaultValue) {
        if (str != null) {
            try {
                return Float.parseFloat(str.replaceAll("[^\\d.\\-+]", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean stringToBoolean(String str) {
        if (str != null) {
            return BOOLEAN_TRUE.containsKey(str);
        }
        return false;
    }

    public static int stringToColor(TypingLabel label, String str) {
        if (str != null) {
            int namedColor;
            ColorLookup lookup = label.getFont().getColorLookup();
            if (lookup != null && (namedColor = lookup.getRgba(str)) != 256) {
                return namedColor;
            }
            if (str.length() >= 3) {
                int rgb;
                if (str.startsWith("#")) {
                    if (str.length() >= 9) {
                        return StringUtils.intFromHex(str, 1, 9);
                    }
                    if (str.length() >= 7) {
                        return StringUtils.intFromHex(str, 1, 7) << 8 | 0xFF;
                    }
                    if (str.length() >= 4) {
                        rgb = StringUtils.intFromHex(str, 1, 4);
                        return rgb << 20 & 0xF0000000 | rgb << 16 & 0xF000000 | rgb << 16 & 0xF00000 | rgb << 12 & 0xF0000 | rgb << 12 & 0xF000 | rgb << 8 & 0xF00 | 0xFF;
                    }
                } else {
                    if (str.length() >= 8) {
                        return StringUtils.intFromHex(str, 0, 8);
                    }
                    if (str.length() >= 6) {
                        return StringUtils.intFromHex(str, 0, 6) << 8 | 0xFF;
                    }
                    rgb = StringUtils.intFromHex(str, 0, 3);
                    return rgb << 20 & 0xF0000000 | rgb << 16 & 0xF000000 | rgb << 16 & 0xF00000 | rgb << 12 & 0xF0000 | rgb << 12 & 0xF000 | rgb << 8 & 0xF00 | 0xFF;
                }
            }
        }
        return 256;
    }

    public static String stringToColorMarkup(String str) {
        if (str != null && str.length() >= 3 && !Palette.NAMED.containsKey((Object)str) && MATCHER_COLOR_HEX_NO_HASH.matches(str)) {
            return "[#" + str + "]";
        }
        return "[" + str + "]";
    }

    public static String stringToStyleMarkup(String str) {
        if (str != null) {
            if (str.isEmpty() || str.equalsIgnoreCase("UNDO")) {
                return "[]";
            }
            if (str.equals(" ")) {
                return "[ ]";
            }
            if (str.equals("*") || str.equalsIgnoreCase("B") || str.equalsIgnoreCase("BOLD") || str.equalsIgnoreCase("STRONG")) {
                return "[*]";
            }
            if (str.equals("/") || str.equalsIgnoreCase("I") || str.equalsIgnoreCase("OBLIQUE") || str.equalsIgnoreCase("ITALIC") || str.equalsIgnoreCase("EM")) {
                return "[/]";
            }
            if (str.equals("_") || str.equalsIgnoreCase("U") || str.equalsIgnoreCase("UNDER") || str.equalsIgnoreCase("UNDERLINE")) {
                return "[_]";
            }
            if (str.equals("~") || str.equalsIgnoreCase("STRIKE") || str.equalsIgnoreCase("STRIKETHROUGH") || str.equalsIgnoreCase("CROSSED")) {
                return "[~]";
            }
            if (str.equals(".") || str.equalsIgnoreCase("SUB") || str.equalsIgnoreCase("SUBSCRIPT")) {
                return "[.]";
            }
            if (str.equals("=") || str.equalsIgnoreCase("MID") || str.equalsIgnoreCase("MIDSCRIPT")) {
                return "[=]";
            }
            if (str.equals("^") || str.equalsIgnoreCase("SUPER") || str.equalsIgnoreCase("SUPERSCRIPT")) {
                return "[^]";
            }
            if (str.equals("!") || str.equalsIgnoreCase("UP") || str.equalsIgnoreCase("UPPER")) {
                return "[!]";
            }
            if (str.equals(",") || str.equalsIgnoreCase("LOW") || str.equalsIgnoreCase("LOWER")) {
                return "[,]";
            }
            if (str.equals(";") || str.equalsIgnoreCase("EACH") || str.equalsIgnoreCase("TITLE")) {
                return "[;]";
            }
            if (str.equals("@") || str.equalsIgnoreCase("NOFONT") || str.equalsIgnoreCase("ENDFONT")) {
                return "[@]";
            }
            if (str.equals("#") || str.equalsIgnoreCase("OUTLINE") || str.equalsIgnoreCase("BLACK OUTLINE") || str.equalsIgnoreCase("BLACKEN")) {
                return "[#]";
            }
            if (str.equalsIgnoreCase("JOSTLE") || str.equalsIgnoreCase("WOBBLE") || str.equalsIgnoreCase("SCATTER")) {
                return "[?jostle]";
            }
            if (str.equalsIgnoreCase("SMALLCAPS") || str.equalsIgnoreCase("SMALL CAPS")) {
                return "[?small caps]";
            }
            if (str.equalsIgnoreCase("BLUE OUTLINE") || str.equalsIgnoreCase("BLUEN")) {
                return "[?blue outline]";
            }
            if (str.equalsIgnoreCase("RED OUTLINE") || str.equalsIgnoreCase("REDDEN")) {
                return "[?red outline]";
            }
            if (str.equalsIgnoreCase("YELLOW OUTLINE") || str.equalsIgnoreCase("YELLOWEN")) {
                return "[?yellow outline]";
            }
            if (str.equalsIgnoreCase("WHITE OUTLINE") || str.equalsIgnoreCase("WHITEN")) {
                return "[?white outline]";
            }
            if (str.equalsIgnoreCase("SHINY") || str.equalsIgnoreCase("SHINE") || str.equalsIgnoreCase("GLOSSY")) {
                return "[?shiny]";
            }
            if (str.equalsIgnoreCase("NEON") || str.equalsIgnoreCase("GLOW")) {
                return "[?neon]";
            }
            if (str.equalsIgnoreCase("HALO") || str.equalsIgnoreCase("SURROUND") || str.equalsIgnoreCase("CLOAK")) {
                return "[?halo]";
            }
            if (str.equalsIgnoreCase("SHADOW") || str.equalsIgnoreCase("DROPSHADOW") || str.equalsIgnoreCase("DROP SHADOW")) {
                return "[shadow]";
            }
            if (str.equalsIgnoreCase("ERROR") || str.equalsIgnoreCase("REDLINE") || str.equalsIgnoreCase("RED LINE")) {
                return "[?error]";
            }
            if (str.equalsIgnoreCase("CONTEXT") || str.equalsIgnoreCase("GRAMMAR") || str.equalsIgnoreCase("GREENLINE") || str.equalsIgnoreCase("GREEN LINE")) {
                return "[?context]";
            }
            if (str.equalsIgnoreCase("WARN") || str.equalsIgnoreCase("YELLOWLINE") || str.equalsIgnoreCase("YELLOW LINE")) {
                return "[?warn]";
            }
            if (str.equalsIgnoreCase("SUGGEST") || str.equalsIgnoreCase("GRAYLINE") || str.equalsIgnoreCase("GRAY LINE") || str.equalsIgnoreCase("GREYLINE") || str.equalsIgnoreCase("GREY LINE")) {
                return "[?suggest]";
            }
            if (str.equalsIgnoreCase("NOTE") || str.equalsIgnoreCase("INFO") || str.equalsIgnoreCase("BLUELINE") || str.equalsIgnoreCase("BLUE LINE")) {
                return "[?note]";
            }
            if (str.equals("?") || str.equals("%?") || str.equals("%^") || str.equalsIgnoreCase("NOMODE") || str.equalsIgnoreCase("ENDMODE")) {
                return "[?]";
            }
            if (str.equals("%") || str.equalsIgnoreCase("NOSCALE") || str.equalsIgnoreCase("ENDSCALE")) {
                return "[%]";
            }
            if (str.startsWith("@")) {
                return "[" + str + "]";
            }
            if (str.endsWith("%")) {
                return "[%" + str.substring(0, str.length() - 1) + "]";
            }
            if (str.startsWith("%")) {
                return "[" + str + "]";
            }
            if (str.startsWith("?")) {
                return "[" + str + "]";
            }
            if (str.startsWith("(")) {
                return "[" + str + "]";
            }
            if (str.startsWith(" ")) {
                return "[" + str + "]";
            }
            if (Palette.NAMED.containsKey((Object)str)) {
                return "[" + str + "]";
            }
            if (str.length() >= 3 && MATCHER_COLOR_HEX_NO_HASH.matches(str)) {
                return "[#" + str + "]";
            }
        }
        return "";
    }

    private static Pattern compileTokenPattern() {
        StringBuilder sb = new StringBuilder();
        sb.append("(?<!\\{)\\{(");
        Array tokens = new Array();
        TypingConfig.EFFECT_START_TOKENS.keys().toArray(tokens);
        TypingConfig.EFFECT_END_TOKENS.keys().toArray(tokens);
        for (InternalToken token : InternalToken.values()) {
            tokens.add((Object)token.name);
        }
        for (int i = 0; i < tokens.size; ++i) {
            sb.append((String)tokens.get(i));
            if (i + 1 >= tokens.size) continue;
            sb.append('|');
        }
        sb.append(")(?:\\=([^\\{\\}]+))?\\}");
        return Pattern.compile((String)sb.toString(), (int)1);
    }

    private static String getResetReplacement() {
        Array tokens = new Array();
        TypingConfig.EFFECT_END_TOKENS.keys().toArray(tokens);
        tokens.add((Object)"NORMAL");
        StringBuilder sb = new StringBuilder("[ ]");
        for (String token : tokens) {
            sb.append('{').append(token).append('}');
        }
        TypingConfig.dirtyEffectMaps = false;
        return sb.toString();
    }
}

