/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ArraySelection;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.OrderedSet;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Styles;
import com.github.tommyettinger.textra.TextraLabel;
import com.github.tommyettinger.textra.TextraListBox;

public class TextraSelectBox
extends Widget
implements Disableable {
    static final Vector2 temp = new Vector2();
    Styles.SelectBoxStyle style;
    final Array<TextraLabel> items = new Array();
    SelectBoxScrollPane scrollPane;
    private float prefWidth;
    private float prefHeight;
    private ClickListener clickListener;
    boolean disabled;
    private int alignment = 8;
    boolean selectedPrefWidth;
    final ArraySelection<TextraLabel> selection = new ArraySelection<TextraLabel>(this.items){

        public boolean fireChangeEvent() {
            if (TextraSelectBox.this.selectedPrefWidth) {
                TextraSelectBox.this.invalidateHierarchy();
            }
            return super.fireChangeEvent();
        }
    };

    public TextraSelectBox(Skin skin) {
        this((Styles.SelectBoxStyle)skin.get(Styles.SelectBoxStyle.class));
    }

    public TextraSelectBox(Skin skin, String styleName) {
        this((Styles.SelectBoxStyle)skin.get(styleName, Styles.SelectBoxStyle.class));
    }

    public TextraSelectBox(Styles.SelectBoxStyle style) {
        this.setStyle(style);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.selection.setActor((Actor)this);
        this.selection.setRequired(true);
        this.scrollPane = this.newScrollPane();
        this.clickListener = new ClickListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer == 0 && button != 0) {
                    return false;
                }
                if (TextraSelectBox.this.isDisabled()) {
                    return false;
                }
                if (TextraSelectBox.this.scrollPane.hasParent()) {
                    TextraSelectBox.this.hideScrollPane();
                } else {
                    TextraSelectBox.this.showScrollPane();
                }
                return true;
            }
        };
        this.addListener((EventListener)this.clickListener);
    }

    protected SelectBoxScrollPane newScrollPane() {
        return new SelectBoxScrollPane(this);
    }

    public void setMaxListCount(int maxListCount) {
        this.scrollPane.maxListCount = maxListCount;
    }

    public int getMaxListCount() {
        return this.scrollPane.maxListCount;
    }

    protected void setStage(Stage stage) {
        if (stage == null) {
            this.scrollPane.hide();
        }
        super.setStage(stage);
    }

    public void setStyle(Styles.SelectBoxStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        if (this.scrollPane != null) {
            this.scrollPane.setStyle(style.scrollStyle);
            this.scrollPane.list.setStyle(style.listStyle);
        }
        this.invalidateHierarchy();
    }

    public Styles.SelectBoxStyle getStyle() {
        return this.style;
    }

    public void setItemTexts(String ... newMarkupTexts) {
        if (newMarkupTexts == null) {
            throw new IllegalArgumentException("newMarkupTexts cannot be null.");
        }
        float oldPrefWidth = this.getPrefWidth();
        this.items.clear();
        for (int i = 0; i < newMarkupTexts.length; ++i) {
            this.items.add((Object)this.newLabel(newMarkupTexts[i], this.style.font, this.style.fontColor));
        }
        this.selection.validate();
        this.scrollPane.list.setItems(this.items);
        this.invalidate();
        if (oldPrefWidth != this.getPrefWidth()) {
            this.invalidateHierarchy();
        }
    }

    public void setItems(TextraLabel ... newItems) {
        if (newItems == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float oldPrefWidth = this.getPrefWidth();
        this.items.clear();
        this.items.addAll((Object[])newItems);
        this.selection.validate();
        this.scrollPane.list.setItems(this.items);
        this.invalidate();
        if (oldPrefWidth != this.getPrefWidth()) {
            this.invalidateHierarchy();
        }
    }

    public void setItems(Array<? extends TextraLabel> newItems) {
        if (newItems == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        float oldPrefWidth = this.getPrefWidth();
        if (newItems != this.items) {
            this.items.clear();
            this.items.addAll(newItems);
        }
        this.selection.validate();
        this.scrollPane.list.setItems(this.items);
        this.invalidate();
        if (oldPrefWidth != this.getPrefWidth()) {
            this.invalidateHierarchy();
        }
    }

    public void clearItems() {
        if (this.items.size == 0) {
            return;
        }
        this.items.clear();
        this.selection.clear();
        this.scrollPane.list.clearItems();
        this.invalidateHierarchy();
    }

    public Array<TextraLabel> getItems() {
        return this.items;
    }

    public void layout() {
        Drawable bg = this.style.background;
        Font font = this.style.font;
        this.prefHeight = bg != null ? Math.max(bg.getTopHeight() + bg.getBottomHeight() + font.cellHeight - font.descent * font.scaleY, bg.getMinHeight()) : font.cellHeight - font.descent * font.scaleY;
        if (this.selectedPrefWidth) {
            TextraLabel selected;
            this.prefWidth = 0.0f;
            if (bg != null) {
                this.prefWidth = bg.getLeftWidth() + bg.getRightWidth();
            }
            if ((selected = this.getSelected()) != null) {
                this.prefWidth += selected.font.calculateSize(selected.layout);
            }
            this.prefWidth = Math.min(Math.max(this.prefWidth, this.getMaxWidth()), this.getMinWidth());
        } else {
            float maxItemWidth = 0.0f;
            for (int i = 0; i < this.items.size; ++i) {
                TextraLabel item = (TextraLabel)((Object)this.items.get(i));
                maxItemWidth = Math.max(item.font.calculateSize(item.layout), maxItemWidth);
            }
            this.prefWidth = maxItemWidth;
            if (bg != null) {
                this.prefWidth = Math.max(this.prefWidth + bg.getLeftWidth() + bg.getRightWidth(), bg.getMinWidth());
            }
            Styles.ListStyle listStyle = this.style.listStyle;
            ScrollPane.ScrollPaneStyle scrollStyle = this.style.scrollStyle;
            float scrollWidth = maxItemWidth + listStyle.selection.getLeftWidth() + listStyle.selection.getRightWidth();
            bg = scrollStyle.background;
            if (bg != null) {
                scrollWidth = Math.max(scrollWidth + bg.getLeftWidth() + bg.getRightWidth(), bg.getMinWidth());
            }
            if (this.scrollPane == null || !this.scrollPane.isScrollingDisabledY()) {
                scrollWidth += Math.max(this.style.scrollStyle.vScroll != null ? this.style.scrollStyle.vScroll.getMinWidth() : 0.0f, this.style.scrollStyle.vScrollKnob != null ? this.style.scrollStyle.vScrollKnob.getMinWidth() : 0.0f);
            }
            this.prefWidth = Math.max(this.prefWidth, scrollWidth);
            this.prefWidth = Math.min(Math.max(this.prefWidth, this.getMaxWidth()), this.getMinWidth());
        }
    }

    @Null
    protected Drawable getBackgroundDrawable() {
        if (this.isDisabled() && this.style.backgroundDisabled != null) {
            return this.style.backgroundDisabled;
        }
        if (this.scrollPane.hasParent() && this.style.backgroundOpen != null) {
            return this.style.backgroundOpen;
        }
        if (this.isOver() && this.style.backgroundOver != null) {
            return this.style.backgroundOver;
        }
        return this.style.background;
    }

    protected Color getFontColor() {
        if (this.isDisabled() && this.style.disabledFontColor != null) {
            return this.style.disabledFontColor;
        }
        if (this.style.overFontColor != null && (this.isOver() || this.scrollPane.hasParent())) {
            return this.style.overFontColor;
        }
        return this.style.fontColor;
    }

    public void draw(Batch batch, float parentAlpha) {
        TextraLabel selected;
        this.validate();
        Drawable background = this.getBackgroundDrawable();
        Color fontColor = this.getFontColor();
        Color color = this.getColor();
        float x = this.getX();
        float y = this.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        if (background != null) {
            background.draw(batch, x, y, width, height);
        }
        if ((selected = (TextraLabel)((Object)this.selection.first())) != null) {
            if (background != null) {
                width -= background.getLeftWidth() + background.getRightWidth();
                x += background.getLeftWidth();
                y += (float)((int)((height -= background.getBottomHeight() + background.getTopHeight()) * 0.5f + background.getBottomHeight()));
            } else {
                y += (float)((int)(height * 0.5f));
            }
            selected.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * parentAlpha);
            this.drawItem(batch, selected, x, y, width);
        }
    }

    public void act(float delta) {
        super.act(delta);
        TextraLabel selected = (TextraLabel)((Object)this.selection.first());
        if (selected != null) {
            selected.act(delta);
        }
    }

    protected void drawItem(Batch batch, TextraLabel item, float x, float y, float width) {
        item.setEllipsis("...");
        item.setWrap(false);
        item.layout.setTargetWidth(width);
        item.setBounds(x, y, width, item.getHeight());
        item.draw(batch, 1.0f);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public ArraySelection<TextraLabel> getSelection() {
        return this.selection;
    }

    @Null
    public TextraLabel getSelected() {
        return (TextraLabel)((Object)this.selection.first());
    }

    public void setSelected(@Null TextraLabel item) {
        if (this.items.contains((Object)item, false)) {
            this.selection.set((Object)item);
        } else if (this.items.size > 0) {
            this.selection.set((Object)((TextraLabel)((Object)this.items.first())));
        } else {
            this.selection.clear();
        }
    }

    public int getSelectedIndex() {
        OrderedSet selected = this.selection.items();
        return selected.size == 0 ? -1 : this.items.indexOf((Object)((TextraLabel)((Object)selected.first())), false);
    }

    public void setSelectedIndex(int index) {
        this.selection.set((Object)((TextraLabel)((Object)this.items.get(index))));
    }

    public void setSelectedPrefWidth(boolean selectedPrefWidth) {
        this.selectedPrefWidth = selectedPrefWidth;
    }

    public boolean getSelectedPrefWidth() {
        return this.selectedPrefWidth;
    }

    public float getMaxPrefWidth() {
        float width = 0.0f;
        for (int i = 0; i < this.items.size; ++i) {
            TextraLabel item = (TextraLabel)((Object)this.items.get(i));
            width = Math.max(item.font.calculateSize(item.layout), width);
        }
        Drawable bg = this.style.background;
        if (bg != null) {
            width = Math.max(width + bg.getLeftWidth() + bg.getRightWidth(), bg.getMinWidth());
        }
        return width;
    }

    public void setDisabled(boolean disabled) {
        if (disabled && !this.disabled) {
            this.hideScrollPane();
        }
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public float getPrefWidth() {
        this.validate();
        return this.prefWidth;
    }

    public float getPrefHeight() {
        this.validate();
        return this.prefHeight;
    }

    protected String toString(TextraLabel item) {
        return item.toString();
    }

    @Deprecated
    public void showList() {
        this.showScrollPane();
    }

    public void showScrollPane() {
        if (this.items.size == 0) {
            return;
        }
        if (this.getStage() != null) {
            this.scrollPane.show(this.getStage());
        }
    }

    @Deprecated
    public void hideList() {
        this.hideScrollPane();
    }

    public void hideScrollPane() {
        this.scrollPane.hide();
    }

    public TextraListBox<TextraLabel> getList() {
        return this.scrollPane.list;
    }

    public void setScrollingDisabled(boolean y) {
        this.scrollPane.setScrollingDisabled(true, y);
        this.invalidateHierarchy();
    }

    public SelectBoxScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public boolean isOver() {
        return this.clickListener.isOver();
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    protected void onShow(Actor scrollPane, boolean below) {
        scrollPane.getColor().a = 0.0f;
        scrollPane.addAction((Action)Actions.fadeIn((float)0.3f, (Interpolation)Interpolation.fade));
    }

    protected void onHide(Actor scrollPane) {
        scrollPane.getColor().a = 1.0f;
        scrollPane.addAction((Action)Actions.sequence((Action)Actions.fadeOut((float)0.15f, (Interpolation)Interpolation.fade), (Action)Actions.removeActor()));
    }

    protected TextraLabel newLabel(String markupText, Font font, Color color) {
        return new TextraLabel(markupText, font, color);
    }

    public static class SelectBoxScrollPane
    extends ScrollPane {
        final TextraSelectBox selectBox;
        int maxListCount;
        private final Vector2 stagePosition = new Vector2();
        final TextraListBox<TextraLabel> list;
        private InputListener hideListener;
        private Actor previousScrollFocus;

        public SelectBoxScrollPane(final TextraSelectBox selectBox) {
            super(null, selectBox.style.scrollStyle);
            this.selectBox = selectBox;
            this.setOverscroll(false, false);
            this.setFadeScrollBars(false);
            this.setScrollingDisabled(true, false);
            this.list = this.newList();
            this.list.setTouchable(Touchable.disabled);
            this.list.setTypeToSelect(true);
            this.setActor((Actor)this.list);
            this.list.addListener((EventListener)new ClickListener(){

                public void clicked(InputEvent event, float x, float y) {
                    TextraLabel selected = list.getSelected();
                    if (selected != null) {
                        selectBox.selection.items().clear(51);
                    }
                    selectBox.selection.choose((Object)selected);
                    this.hide();
                }

                public boolean mouseMoved(InputEvent event, float x, float y) {
                    int index = list.getItemIndexAt(y);
                    if (index != -1) {
                        list.setSelectedIndex(index);
                    }
                    return true;
                }
            });
            this.addListener((EventListener)new InputListener(){

                public void exit(InputEvent event, float x, float y, int pointer, @Null Actor toActor) {
                    TextraLabel selected;
                    if (!(toActor != null && this.isAscendantOf(toActor) || (selected = selectBox.getSelected()) == null)) {
                        list.getSelection().set((Object)selected);
                    }
                }
            });
            this.hideListener = new InputListener(){

                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    Actor target = event.getTarget();
                    if (this.isAscendantOf(target)) {
                        return false;
                    }
                    list.getSelection().set((Object)selectBox.getSelected());
                    this.hide();
                    return false;
                }

                public boolean keyDown(InputEvent event, int keycode) {
                    switch (keycode) {
                        case 66: 
                        case 160: {
                            selectBox.selection.choose((Object)list.getSelected());
                        }
                        case 111: {
                            this.hide();
                            event.stop();
                            return true;
                        }
                    }
                    return false;
                }
            };
        }

        protected TextraListBox<TextraLabel> newList() {
            return new TextraListBox<TextraLabel>(this.selectBox.style.listStyle);
        }

        public void show(Stage stage) {
            Drawable listBackground;
            if (this.list.isTouchable()) {
                return;
            }
            stage.addActor((Actor)this);
            stage.addCaptureListener((EventListener)this.hideListener);
            stage.addListener((EventListener)this.list.getKeyListener());
            this.selectBox.localToStageCoordinates(this.stagePosition.set(0.0f, 0.0f));
            float height = this.list.getCumulativeHeight(this.maxListCount <= 0 ? this.selectBox.items.size - 1 : Math.min(this.maxListCount, this.selectBox.items.size) - 1);
            Drawable scrollPaneBackground = this.getStyle().background;
            if (scrollPaneBackground != null) {
                height += scrollPaneBackground.getTopHeight() + scrollPaneBackground.getBottomHeight();
            }
            if ((listBackground = this.list.getStyle().background) != null) {
                height += listBackground.getTopHeight() + listBackground.getBottomHeight();
            }
            float heightBelow = this.stagePosition.y;
            float heightAbove = stage.getHeight() - heightBelow - this.selectBox.getHeight();
            boolean below = true;
            if (height > heightBelow) {
                if (heightAbove > heightBelow) {
                    below = false;
                    height = Math.min(height, heightAbove);
                } else {
                    height = heightBelow;
                }
            }
            if (below) {
                this.setY(this.stagePosition.y - height);
            } else {
                this.setY(this.stagePosition.y + this.selectBox.getHeight());
            }
            this.setX(this.stagePosition.x);
            this.setHeight(height);
            this.validate();
            float width = Math.max(this.getPrefWidth(), this.selectBox.getWidth());
            this.setWidth(width);
            this.validate();
            this.scrollTo(0.0f, this.list.getHeight() - this.list.getCumulativeHeight(this.selectBox.getSelectedIndex()) - this.selectBox.getSelected().getPrefHeight() * 0.5f, 0.0f, 0.0f, true, true);
            this.updateVisualScroll();
            this.previousScrollFocus = null;
            Actor actor = stage.getScrollFocus();
            if (actor != null && !actor.isDescendantOf((Actor)this)) {
                this.previousScrollFocus = actor;
            }
            stage.setScrollFocus((Actor)this);
            this.list.getSelection().set((Object)this.selectBox.getSelected());
            this.list.setTouchable(Touchable.enabled);
            this.clearActions();
            this.selectBox.onShow((Actor)this, below);
        }

        public void hide() {
            if (!this.list.isTouchable() || !this.hasParent()) {
                return;
            }
            this.list.setTouchable(Touchable.disabled);
            Stage stage = this.getStage();
            if (stage != null) {
                Actor actor;
                stage.removeCaptureListener((EventListener)this.hideListener);
                stage.removeListener((EventListener)this.list.getKeyListener());
                if (this.previousScrollFocus != null && this.previousScrollFocus.getStage() == null) {
                    this.previousScrollFocus = null;
                }
                if ((actor = stage.getScrollFocus()) == null || this.isAscendantOf(actor)) {
                    stage.setScrollFocus(this.previousScrollFocus);
                }
            }
            this.clearActions();
            this.selectBox.onHide((Actor)this);
        }

        public void draw(Batch batch, float parentAlpha) {
            this.selectBox.localToStageCoordinates(temp.set(0.0f, 0.0f));
            if (!temp.equals((Object)this.stagePosition)) {
                this.hide();
            }
            super.draw(batch, parentAlpha);
        }

        public void act(float delta) {
            super.act(delta);
            this.toFront();
        }

        protected void setStage(Stage stage) {
            Stage oldStage = this.getStage();
            if (oldStage != null) {
                oldStage.removeCaptureListener((EventListener)this.hideListener);
                oldStage.removeListener((EventListener)this.list.getKeyListener());
            }
            super.setStage(stage);
        }

        public TextraListBox<TextraLabel> getList() {
            return this.list;
        }

        public TextraSelectBox getSelectBox() {
            return this.selectBox;
        }
    }
}

