/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.FloatArray;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class ShakeEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 0.12f;
    private static final float DEFAULT_SPEED = 0.5f;
    private final FloatArray lastOffsets = new FloatArray();
    private float distance = 1.0f;
    private float speed = 1.0f;

    public ShakeEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.speed = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.duration = this.paramAsFloat(params[2], Float.POSITIVE_INFINITY);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        if (localIndex >= this.lastOffsets.size / 2) {
            this.lastOffsets.setSize(this.lastOffsets.size + 16);
        }
        float lastX = this.lastOffsets.get(localIndex * 2);
        float lastY = this.lastOffsets.get(localIndex * 2 + 1);
        float x = this.label.getLineHeight(globalIndex) * this.distance * MathUtils.random((float)-1.0f, (float)1.0f) * 0.12f;
        float y = this.label.getLineHeight(globalIndex) * this.distance * MathUtils.random((float)-1.0f, (float)1.0f) * 0.12f;
        float normalSpeed = MathUtils.clamp((float)(this.speed * 0.5f), (float)0.0f, (float)1.0f);
        x = Interpolation.linear.apply(lastX, x, normalSpeed);
        y = Interpolation.linear.apply(lastY, y, normalSpeed);
        float fadeout = this.calculateFadeout();
        x *= fadeout;
        y *= fadeout;
        x = MathUtils.round((float)x);
        y = MathUtils.round((float)y);
        this.lastOffsets.set(localIndex * 2, x);
        this.lastOffsets.set(localIndex * 2 + 1, y);
        this.label.getOffsets().incr(globalIndex << 1, x);
        this.label.getOffsets().incr(globalIndex << 1 | 1, y);
    }
}

