/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.utils.TimeUtils;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.NoiseUtils;

public class SlipEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 0.5f;
    private static final float DEFAULT_SPEED = 0.001f;
    private float distance = 5.0f;
    private float speed = 1.0f;

    public SlipEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 5.0f);
        }
        if (params.length > 1) {
            this.speed = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.duration = this.paramAsFloat(params[2], Float.POSITIVE_INFINITY);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float slip = (1.0f + NoiseUtils.octaveNoise1D((float)(TimeUtils.millis() & 0xFFFFFFL) * this.speed * 0.001f + (float)globalIndex * 0.2357f, 305419896)) * this.distance * 0.5f;
        float fadeout = this.calculateFadeout();
        this.label.getOffsets().incr(globalIndex << 1, slip *= fadeout);
    }
}

