/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.CaseInsensitiveIntMap;

public class StylistEffect
extends Effect {
    private long effects = 0L;
    private boolean all = false;

    public StylistEffect(TypingLabel label, String[] params) {
        super(label);
        label.trackingInput = true;
        if (params.length > 0) {
            if (this.paramAsBoolean(params[0])) {
                this.effects |= 0x40000000L;
            } else if (params.length == 1) {
                int[] matching;
                String[] split = params[0].split("[\\s\t,]+");
                CaseInsensitiveIntMap set = new CaseInsensitiveIntMap(split, matching = new int[split.length]);
                if (set.containsKey("bold") || set.containsKey("b") || set.containsKey("*")) {
                    this.effects |= 0x40000000L;
                }
                if (set.containsKey("italic") || set.containsKey("i") || set.containsKey("/") || set.containsKey("oblique") || set.containsKey("o")) {
                    this.effects |= 0x20000000L;
                }
                if (set.containsKey("underline") || set.containsKey("u") || set.containsKey("_")) {
                    this.effects |= 0x10000000L;
                }
                if (set.containsKey("strikethrough") || set.containsKey("s") || set.containsKey("~") || set.containsKey("strike")) {
                    this.effects |= 0x8000000L;
                }
                if (set.containsKey("superscript") || set.containsKey("^") || set.containsKey("super")) {
                    this.effects |= 0x6000000L;
                } else if (set.containsKey("midscript") || set.containsKey("=") || set.containsKey("mid")) {
                    this.effects |= 0x4000000L;
                } else if (set.containsKey("subscript") || set.containsKey(".") || set.containsKey("sub")) {
                    this.effects |= 0x2000000L;
                }
                if (set.containsKey("all") || set.containsKey("a")) {
                    this.all = true;
                }
                return;
            }
        } else {
            this.effects |= 0x50000000L;
            this.all = true;
            return;
        }
        if (params.length > 1 && this.paramAsBoolean(params[1])) {
            this.effects |= 0x20000000L;
        }
        if (params.length > 2 && this.paramAsBoolean(params[2])) {
            this.effects |= 0x10000000L;
        }
        if (params.length > 3 && this.paramAsBoolean(params[3])) {
            this.effects |= 0x8000000L;
        }
        if (params.length > 4) {
            this.effects |= ((long)this.paramAsFloat(params[4], 0.0f) & 3L) << 25;
        }
        if (params.length > 5) {
            this.all = this.paramAsBoolean(params[5]);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        if (this.all) {
            if (this.label.overIndex < this.indexStart || this.label.overIndex > this.indexEnd) {
                this.label.setInWorkingLayout(globalIndex, glyph & (this.effects ^ 0xFFFFFFFFFFFFFFFFL));
                return;
            }
        } else if (this.label.overIndex != globalIndex) {
            this.label.setInWorkingLayout(globalIndex, glyph & (this.effects ^ 0xFFFFFFFFFFFFFFFFL));
            return;
        }
        this.label.setInWorkingLayout(globalIndex, glyph & (this.effects ^ 0xFFFFFFFFFFFFFFFFL) | this.effects);
    }
}

