/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.UBJsonReader;
import com.badlogic.gdx.utils.compression.Lzma;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public final class BitmapFontSupport {
    private BitmapFontSupport() {
    }

    public static BitmapFont loadStructuredJson(FileHandle jsonFont, TextureRegion region) {
        JsonFontData data = new JsonFontData(jsonFont);
        return new BitmapFont((BitmapFont.BitmapFontData)data, region, false);
    }

    public static BitmapFont loadStructuredJson(FileHandle jsonFont, TextureRegion region, boolean flip) {
        JsonFontData data = new JsonFontData(jsonFont, null, flip);
        return new BitmapFont((BitmapFont.BitmapFontData)data, region, false);
    }

    public static BitmapFont loadStructuredJson(FileHandle jsonFont, String imagePath) {
        JsonFontData data = new JsonFontData(jsonFont, imagePath);
        return new BitmapFont((BitmapFont.BitmapFontData)data, (TextureRegion)null, false);
    }

    public static BitmapFont loadStructuredJson(FileHandle jsonFont, String imagePath, boolean flip) {
        JsonFontData data = new JsonFontData(jsonFont, imagePath, flip);
        return new BitmapFont((BitmapFont.BitmapFontData)data, (TextureRegion)null, false);
    }

    private static String decompressFromBytes(byte[] compressedBytes) {
        String c;
        int resb;
        if (compressedBytes == null) {
            return null;
        }
        int length = compressedBytes.length;
        if (length == 0) {
            return "";
        }
        int resetValue = 128;
        ArrayList<String> dictionary = new ArrayList<String>(256);
        int enlargeIn = 4;
        int dictSize = 4;
        int numBits = 3;
        int position = 128;
        int index = 1;
        StringBuilder res = new StringBuilder(length);
        byte val = compressedBytes[0];
        for (char i = '\u0000'; i < '\u0003'; i = (char)(i + '\u0001')) {
            dictionary.add(String.valueOf(i));
        }
        char bits = '\u0000';
        int maxpower = 2;
        int power = 0;
        while (power != maxpower) {
            resb = val & position;
            if ((position >>>= 1) == 0) {
                position = 128;
                val = compressedBytes[index++];
            }
            bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
        }
        switch (bits) {
            case '\u0000': {
                bits = '\u0000';
                maxpower = 8;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>>= 1) == 0) {
                        position = 128;
                        val = compressedBytes[index++];
                    }
                    bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                }
                c = String.valueOf(bits);
                break;
            }
            case '\u0001': {
                bits = '\u0000';
                maxpower = 16;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>>= 1) == 0) {
                        position = 128;
                        val = compressedBytes[index++];
                    }
                    bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                }
                c = String.valueOf(bits);
                break;
            }
            default: {
                return "";
            }
        }
        dictionary.add(c);
        String w = c;
        res.append(w);
        while (index <= length) {
            String entry;
            int cc = 0;
            maxpower = numBits;
            power = 0;
            while (power != maxpower) {
                resb = val & position;
                if ((position >>>= 1) == 0) {
                    position = 128;
                    val = compressedBytes[index++];
                }
                cc |= (resb != 0 ? 1 : 0) << power++;
            }
            switch (cc) {
                case 0: {
                    bits = '\u0000';
                    maxpower = 8;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>>= 1) == 0) {
                            position = 128;
                            val = compressedBytes[index++];
                        }
                        bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                    }
                    dictionary.add(String.valueOf(bits));
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 1: {
                    bits = '\u0000';
                    maxpower = 16;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>>= 1) == 0) {
                            position = 128;
                            val = compressedBytes[index++];
                        }
                        bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                    }
                    dictionary.add(String.valueOf(bits));
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 2: {
                    return res.toString();
                }
            }
            if (enlargeIn == 0) {
                enlargeIn = 1 << numBits;
                ++numBits;
            }
            if (cc < dictionary.size() && dictionary.get(cc) != null) {
                entry = (String)dictionary.get(cc);
            } else if (cc == dictSize) {
                entry = w + w.charAt(0);
            } else {
                return "";
            }
            res.append(entry);
            dictionary.add(w + entry.charAt(0));
            ++dictSize;
            w = entry;
            if (--enlargeIn != 0) continue;
            enlargeIn = 1 << numBits;
            ++numBits;
        }
        return "";
    }

    public static class JsonFontData
    extends BitmapFont.BitmapFontData {
        public String path = null;

        public JsonFontData() {
        }

        public JsonFontData(FileHandle jsonFont) {
            this(jsonFont, null);
        }

        public JsonFontData(FileHandle jsonFont, String imagePath) {
            this(jsonFont, imagePath, false);
        }

        public JsonFontData(FileHandle jsonFont, String imagePath, boolean flip) {
            this.path = imagePath;
            this.flipped = flip;
            this.load(jsonFont, flip);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void load(FileHandle jsonFont, boolean flip) {
            if (this.imagePaths != null) {
                throw new IllegalStateException("Already loaded.");
            }
            try {
                char capChar;
                char xChar;
                int n;
                BitmapFont.Glyph spaceGlyph;
                JsonValue fnt;
                this.name = jsonFont.nameWithoutExtension();
                if (!jsonFont.exists()) throw new GdxRuntimeException("Missing font file: " + jsonFont.path());
                String ext = jsonFont.extension();
                if ("json".equalsIgnoreCase(ext)) {
                    fnt = new JsonReader().parse(jsonFont);
                } else if ("dat".equalsIgnoreCase(ext)) {
                    fnt = new JsonReader().parse(BitmapFontSupport.decompressFromBytes(jsonFont.readBytes()));
                } else if ("ubj".equalsIgnoreCase(ext)) {
                    fnt = new UBJsonReader().parse(jsonFont);
                } else {
                    if (!"lzma".equalsIgnoreCase(ext)) throw new GdxRuntimeException("Not a .json, .dat, .ubj, .json.lzma, or .ubj.lzma font file: " + jsonFont.path());
                    BufferedInputStream bais = jsonFont.read(4096);
                    StreamUtils.OptimizedByteArrayOutputStream baos = new StreamUtils.OptimizedByteArrayOutputStream(4096);
                    try {
                        Lzma.decompress((InputStream)bais, (OutputStream)baos);
                        if (jsonFont.name().length() > 10 && ".json.lzma".equalsIgnoreCase(jsonFont.name().substring(jsonFont.name().length() - 10))) {
                            fnt = new JsonReader().parse(baos.toString("UTF-8"));
                        } else {
                            if (jsonFont.name().length() <= 9 || !".ubj.lzma".equalsIgnoreCase(jsonFont.name().substring(jsonFont.name().length() - 9))) throw new GdxRuntimeException("Unsupported file type inside compressed file: " + jsonFont.path());
                            StreamUtils.closeQuietly((Closeable)bais);
                            bais = new BufferedInputStream(new ByteArrayInputStream(baos.toByteArray()));
                            fnt = new UBJsonReader().parse((InputStream)bais);
                        }
                    }
                    catch (IOException e) {
                        throw new GdxRuntimeException("Error reading compressed file: " + jsonFont.path() + "\n" + e);
                    }
                    finally {
                        StreamUtils.closeQuietly((Closeable)bais);
                        StreamUtils.closeQuietly((Closeable)baos);
                    }
                }
                if (fnt.isEmpty()) {
                    throw new GdxRuntimeException("File is empty: " + jsonFont.path());
                }
                JsonValue atlas = fnt.get("atlas");
                float size = atlas.getFloat("size", 16.0f);
                int width = atlas.getInt("width", 2048);
                int height = atlas.getInt("height", 2048);
                this.padTop = 1.0f;
                this.padRight = 1.0f;
                this.padBottom = 1.0f;
                this.padLeft = 1.0f;
                float padY = this.padTop + this.padBottom;
                this.descent = size * -0.25f;
                this.lineHeight = size - this.descent;
                if (this.path != null) {
                    this.imagePaths = new String[]{jsonFont.sibling(this.path).path().replaceAll("\\\\", "/")};
                }
                JsonValue glyphs = fnt.get("glyphs");
                for (JsonValue current : glyphs) {
                    BitmapFont.Glyph glyph = new BitmapFont.Glyph();
                    int ch = current.getInt("unicode", -1);
                    if (ch <= 0) {
                        this.missingGlyph = glyph;
                    } else {
                        if (ch > 65535) continue;
                        this.setGlyph(ch, glyph);
                    }
                    glyph.id = ch;
                    glyph.xadvance = MathUtils.round((float)(current.getFloat("advance", 1.0f) * size));
                    JsonValue planeBounds = current.get("planeBounds");
                    JsonValue atlasBounds = current.get("atlasBounds");
                    if (atlasBounds != null) {
                        float f = atlasBounds.getFloat("left", 0.0f);
                        glyph.srcX = (int)f;
                        glyph.width = (int)(atlasBounds.getFloat("right", 0.0f) - f);
                        float y = (float)height - atlasBounds.getFloat("top", 0.0f);
                        glyph.srcY = (int)y;
                        glyph.height = (int)((float)height - atlasBounds.getFloat("bottom", 0.0f) - y);
                    } else {
                        glyph.height = 0;
                        glyph.width = 0;
                        glyph.srcY = 0;
                        glyph.srcX = 0;
                    }
                    if (planeBounds != null) {
                        glyph.xoffset = MathUtils.round((float)(planeBounds.getFloat("left", 0.0f) * size));
                        glyph.yoffset = flip ? MathUtils.round((float)(-size - planeBounds.getFloat("top", 0.0f) * size)) : MathUtils.round((float)(-size + planeBounds.getFloat("bottom", 0.0f) * size));
                        continue;
                    }
                    glyph.yoffset = 0;
                    glyph.xoffset = 0;
                }
                JsonValue kern = fnt.get("kerning");
                if (kern != null && !kern.isEmpty()) {
                    for (JsonValue current : kern) {
                        int first = current.getInt("unicode1", -1);
                        int n2 = current.getInt("unicode2", -1);
                        if (first < 0 || first > 65535 || n2 < 0 || n2 > 65535) continue;
                        BitmapFont.Glyph glyph = this.getGlyph((char)first);
                        float amount = current.getFloat("advance", 0.0f);
                        if (glyph == null) continue;
                        glyph.setKerning(n2, MathUtils.round((float)amount));
                    }
                }
                if ((spaceGlyph = this.getGlyph(' ')) == null) {
                    spaceGlyph = new BitmapFont.Glyph();
                    spaceGlyph.id = 32;
                    BitmapFont.Glyph xadvanceGlyph = this.getGlyph('l');
                    if (xadvanceGlyph == null) {
                        xadvanceGlyph = this.getFirstGlyph();
                    }
                    spaceGlyph.xadvance = xadvanceGlyph.xadvance;
                    this.setGlyph(32, spaceGlyph);
                }
                if (spaceGlyph.width == 0) {
                    spaceGlyph.width = (int)(this.padLeft + (float)spaceGlyph.xadvance + this.padRight);
                    spaceGlyph.xoffset = (int)(-this.padLeft);
                }
                this.spaceXadvance = spaceGlyph.xadvance;
                BitmapFont.Glyph xGlyph = null;
                char[] first = this.xChars;
                int n3 = first.length;
                for (n = 0; n < n3 && (xGlyph = this.getGlyph(xChar = first[n])) == null; ++n) {
                }
                if (xGlyph == null) {
                    xGlyph = this.getFirstGlyph();
                }
                this.xHeight = (float)xGlyph.height - padY;
                BitmapFont.Glyph capGlyph = null;
                char[] cArray = this.capChars;
                n = cArray.length;
                for (int i = 0; i < n && (capGlyph = this.getGlyph(capChar = cArray[i])) == null; ++i) {
                }
                if (capGlyph == null) {
                    for (BitmapFont.Glyph[] page : this.glyphs) {
                        if (page == null) continue;
                        for (BitmapFont.Glyph glyph : page) {
                            if (glyph == null || glyph.height == 0 || glyph.width == 0) continue;
                            this.capHeight = Math.max(this.capHeight, (float)glyph.height);
                        }
                    }
                } else {
                    this.capHeight = capGlyph.height;
                }
                this.capHeight -= padY;
                this.ascent = this.lineHeight + this.descent - this.capHeight;
                this.down = -this.lineHeight;
                if (!flip) return;
                this.ascent = -this.ascent;
                this.down = -this.down;
                return;
            }
            catch (Exception ex) {
                throw new GdxRuntimeException("Error loading font file: " + jsonFont, (Throwable)ex);
            }
        }
    }
}

